/*
 * Decompiled with CFR 0.152.
 */
package com.sap.ip.me.smartsync.delta;

import com.sap.ip.me.api.persist.app.PackagePersistenceMaster;
import com.sap.ip.me.api.persist.meta.AttributeDescriptor;
import com.sap.ip.me.api.persist.meta.AttributeType;
import com.sap.ip.me.api.persist.meta.ClassDescriptor;
import com.sap.ip.me.api.persist.meta.DescriptorException;
import com.sap.ip.me.api.persist.meta.DescriptorRuntime;
import com.sap.ip.me.api.persist.meta.LinkDescriptor;
import com.sap.ip.me.api.persist.meta.MultiplicityType;
import com.sap.ip.me.smartsync.ipi.PersistenceConstants;

final class DeltaPackagePersistenceMaster
implements PackagePersistenceMaster {
    private static final int ROW_ACTION_LENGTH = 1;
    private static final int ROW_DESCRIPTOR_LENGTH = 15;
    private static final String ROW_ACTION_NAME = "action";
    private static final String ROW_DESCRIPTOR_NAME = "descriptor";
    private static final int SYNCBO_TIMESTAMP_LENGTH = 21;
    private static final int SYNCBO_ACTION_LENGTH = 1;
    private static final int SYNCBO_DESCRIPTOR_LENGTH = 11;
    private static final int SYNCBO_STATEID_LENGTH = 36;
    private static final String SYNCBO_TIMESTAMP_NAME = "timestamp";
    private static final String SYNCBO_ACTION_NAME = "action";
    private static final String SYNCBO_DESCRIPTOR_NAME = "descriptor";
    private static final String SYNCBO_STATEID_NAME = "stateId";
    private static final String SYNCBO_ROW_DELTA_LINK_NAME = "rowDelta";
    private final DescriptorRuntime descriptorRuntime;
    private final ClassDescriptor rowDeltaClassDescriptor;
    private final ClassDescriptor syncBoDeltaClassDescriptor;

    DeltaPackagePersistenceMaster(DescriptorRuntime descriptorRuntime) throws DescriptorException {
        if (descriptorRuntime == null) {
            throw new NullPointerException("descriptorRuntime");
        }
        this.descriptorRuntime = descriptorRuntime;
        this.rowDeltaClassDescriptor = this.createRowDeltaClassDescriptor();
        this.syncBoDeltaClassDescriptor = this.createSyncBoDeltaClassDescriptor();
    }

    public String[] getClasstypes() {
        return new String[]{PersistenceConstants.SYNC_BO_DELTA_MERGED_CLASSTYPE, PersistenceConstants.ROW_DELTA_MERGED_CLASSTYPE};
    }

    public ClassDescriptor getClassDescriptor(String classtype) {
        if (classtype.equals(PersistenceConstants.SYNC_BO_DELTA_MERGED_CLASSTYPE)) {
            return this.getSyncBoDeltaClassDescriptor();
        }
        if (classtype.equals(PersistenceConstants.ROW_DELTA_MERGED_CLASSTYPE)) {
            return this.getRowDeltaClassDescriptor();
        }
        throw new IllegalArgumentException("No SyncBoDelta or RowDelta Classtype");
    }

    ClassDescriptor getRowDeltaClassDescriptor() {
        return this.rowDeltaClassDescriptor;
    }

    private ClassDescriptor createRowDeltaClassDescriptor() throws DescriptorException {
        AttributeDescriptor action = this.descriptorRuntime.createAttributeDescriptor("action", AttributeType.STRING, 1, 1);
        AttributeDescriptor descriptor = this.descriptorRuntime.createAttributeDescriptor("descriptor", AttributeType.STRING, 1, 15);
        AttributeDescriptor[] attDescriptors = new AttributeDescriptor[]{action, descriptor};
        LinkDescriptor[] linkDescriptors = new LinkDescriptor[]{};
        ClassDescriptor cdes = this.descriptorRuntime.createClassDescriptor(PersistenceConstants.ROW_DELTA_MERGED_CLASSTYPE, attDescriptors, linkDescriptors, PersistenceConstants.SYNC_KEY_LENGTH);
        return cdes;
    }

    ClassDescriptor getSyncBoDeltaClassDescriptor() {
        return this.syncBoDeltaClassDescriptor;
    }

    private ClassDescriptor createSyncBoDeltaClassDescriptor() throws DescriptorException {
        AttributeDescriptor timestamp = this.descriptorRuntime.createAttributeDescriptor(SYNCBO_TIMESTAMP_NAME, AttributeType.STRING, 1, 21);
        AttributeDescriptor action = this.descriptorRuntime.createAttributeDescriptor("action", AttributeType.STRING, 1, 1);
        AttributeDescriptor descriptor = this.descriptorRuntime.createAttributeDescriptor("descriptor", AttributeType.STRING, 1, 11);
        AttributeDescriptor stateid = this.descriptorRuntime.createAttributeDescriptor(SYNCBO_STATEID_NAME, AttributeType.STRING, 1, 36);
        AttributeDescriptor[] attDescriptors = new AttributeDescriptor[]{timestamp, action, descriptor, stateid};
        LinkDescriptor rowDelta = this.descriptorRuntime.createLinkDescriptor(SYNCBO_ROW_DELTA_LINK_NAME, PersistenceConstants.ROW_DELTA_MERGED_CLASSTYPE, MultiplicityType.MULTIPLE_VECTOR, true);
        LinkDescriptor[] linkDescriptors = new LinkDescriptor[]{rowDelta};
        ClassDescriptor cdes = this.descriptorRuntime.createClassDescriptor(PersistenceConstants.SYNC_BO_DELTA_MERGED_CLASSTYPE, attDescriptors, linkDescriptors, PersistenceConstants.SYNC_KEY_LENGTH);
        return cdes;
    }
}

