/*
 * Decompiled with CFR 0.152.
 */
package com.sap.ip.me.smartsync.delta;

import com.sap.ip.me.api.logging.Trace;
import com.sap.ip.me.api.persist.app.EntityFactory;
import com.sap.ip.me.api.persist.core.PersistenceException;
import com.sap.ip.me.api.persist.meta.DescriptorException;
import com.sap.ip.me.api.persist.meta.DescriptorRuntime;
import com.sap.ip.me.api.smartsync.SyncBoDeltaRequestFacade;
import com.sap.ip.me.api.smartsync.SyncBoDescriptorFacade;
import com.sap.ip.me.api.smartsync.SyncBoOutDeltaFacade;
import com.sap.ip.me.core.ConversationId;
import com.sap.ip.me.core.ConversationIdHandler;
import com.sap.ip.me.core.NestableRuntimeException;
import com.sap.ip.me.smartsync.delta.DeltaEntityFactory;
import com.sap.ip.me.smartsync.delta.DeltaPackagePersistenceMaster;
import com.sap.ip.me.smartsync.delta.DeltaRequestFacadeImpl;
import com.sap.ip.me.smartsync.delta.OutDeltaManagerMerged;
import com.sap.ip.me.smartsync.ipi.InterDataPackageManager;
import com.sap.ip.me.smartsync.ipi.InterDeltaPackageManager;
import com.sap.ip.me.smartsync.ipi.InterMetaPackageManager;
import com.sap.ip.me.smartsync.ipi.InternalOutDeltaFacade;
import com.sap.ip.me.smartsync.ipi.PersistenceAdapter;
import com.sap.ip.me.smartsync.ipi.PersistenceConstants;
import java.util.Hashtable;

public class DeltaPackageManager
implements InterDeltaPackageManager {
    private final DeltaPackagePersistenceMaster deltaPackagePersistenceMaster;
    private final InterMetaPackageManager interMetaPackageManager;
    private final PersistenceAdapter dataPersistenceAdapter;
    private InternalOutDeltaFacade deltaFacade;
    private DeltaEntityFactory entityFactory;
    private DeltaEntityFactory deltaEntityFactory;
    private FacadePool facadePool;
    private static Trace trace = Trace.getInstance("MI/Smartsync");

    public DeltaPackageManager(PersistenceAdapter dataPersistenceAdapter, InterMetaPackageManager interMetaPackageManager) {
        if (dataPersistenceAdapter == null) {
            throw new NullPointerException("dataPersistenceAdapter");
        }
        if (interMetaPackageManager == null) {
            throw new NullPointerException("interMetaPackageManager");
        }
        this.dataPersistenceAdapter = dataPersistenceAdapter;
        this.interMetaPackageManager = interMetaPackageManager;
        try {
            this.deltaPackagePersistenceMaster = new DeltaPackagePersistenceMaster(DescriptorRuntime.getInstance());
            this.facadePool = new FacadePool();
        }
        catch (DescriptorException e) {
            throw new NestableRuntimeException(e);
        }
    }

    public void setInterDataPackageManager(InterDataPackageManager interDataPackageManager) {
        this.deltaEntityFactory = new DeltaEntityFactory(interDataPackageManager, this.interMetaPackageManager);
        this.deltaFacade = new OutDeltaManagerMerged(this.dataPersistenceAdapter, interDataPackageManager, this.deltaPackagePersistenceMaster, this.interMetaPackageManager);
        this.entityFactory = new DeltaEntityFactory(interDataPackageManager, this.interMetaPackageManager);
    }

    public SyncBoOutDeltaFacade getSyncBoOutDeltaFacade() {
        return this.deltaFacade;
    }

    public InternalOutDeltaFacade getInternalOutDeltaFacade() {
        return (InternalOutDeltaFacade)this.getSyncBoOutDeltaFacade();
    }

    public SyncBoDeltaRequestFacade getSyncBoDeltaRequestFacade() {
        return this.facadePool.getCurrentFacade();
    }

    public boolean registerPersistenceMaster() {
        try {
            this.dataPersistenceAdapter.registerPersistenceMaster(this.deltaPackagePersistenceMaster);
        }
        catch (PersistenceException e) {
            if (trace.isLogging(50)) {
                trace.logException(50, "DeltaPackageManager.registerPersistenceMaster", e, true);
            }
            throw new RuntimeException(e.toString());
        }
        return true;
    }

    public void registerEntityFactory() {
        char[] prefixes = new char[]{PersistenceConstants.SYNC_BO_DELTA_MERGED_CLASSTYPE_PREFIX, PersistenceConstants.ROW_DELTA_MERGED_CLASSTYPE_PREFIX};
        this.dataPersistenceAdapter.getSmartSyncEntityFactory().registerMember(prefixes, (EntityFactory)this.deltaEntityFactory);
    }

    public void deleteAllPersistedData() {
        if (this.deltaFacade == null) {
            throw new IllegalStateException("InterDeltaPackageManager.setInterDataPackageManager(InterDataPackageManager) must be called first");
        }
        try {
            this.deltaFacade.deleteAllDelta();
        }
        catch (PersistenceException e) {
            throw new NestableRuntimeException(e);
        }
    }

    public void onSwitchConversationId() {
        ConversationId convId = ConversationIdHandler.getInstance().getCurrentConversationId();
        if (this.facadePool.isCurrentConvId(convId)) {
            return;
        }
        SyncBoDescriptorFacade df = this.interMetaPackageManager.getSyncBoDescriptorFacade();
        if (df != null) {
            if (!this.facadePool.isAlreadyRegistered(convId)) {
                DeltaRequestFacadeImpl facade = new DeltaRequestFacadeImpl(df);
                this.facadePool.add(convId, facade);
            }
            this.facadePool.setCurrentConvId(convId);
        }
    }

    private static class FacadePool {
        private String currentConvIdAsString = "";
        private Hashtable pool = new Hashtable();

        private FacadePool() {
        }

        private SyncBoDeltaRequestFacade getCurrentFacade() {
            Object obj = this.pool.get(this.currentConvIdAsString);
            if (obj == null) {
                return null;
            }
            return (SyncBoDeltaRequestFacade)obj;
        }

        private boolean isAlreadyRegistered(ConversationId convId) {
            return this.pool.containsKey(convId.getId());
        }

        private void setCurrentConvId(ConversationId convId) {
            this.currentConvIdAsString = convId.getId();
        }

        private boolean isCurrentConvId(ConversationId convId) {
            return this.currentConvIdAsString.equals(convId.getId());
        }

        private void add(ConversationId convId, SyncBoDeltaRequestFacade facade) {
            if (facade == null) {
                return;
            }
            if (this.pool.containsKey(convId.getId())) {
                this.pool.remove(convId.getId());
            }
            this.pool.put(convId.getId(), facade);
        }
    }
}

