/*
 * Decompiled with CFR 0.152.
 */
package com.sap.ip.me.smartsync.data.sm;

import com.sap.ip.me.api.smartsync.FieldDescriptor;
import com.sap.ip.me.api.smartsync.FieldInputQualifyType;
import com.sap.ip.me.api.smartsync.ModificationNotAllowedException;
import com.sap.ip.me.api.smartsync.PositionStatusType;
import com.sap.ip.me.api.smartsync.ProcessingStatusType;
import com.sap.ip.me.api.smartsync.Row;
import com.sap.ip.me.api.smartsync.RowDescriptor;
import com.sap.ip.me.api.smartsync.StatusType;
import com.sap.ip.me.api.smartsync.SyncBo;
import com.sap.ip.me.api.smartsync.SyncBoChangeActionType;
import com.sap.ip.me.api.smartsync.SyncBoDescriptor;
import com.sap.ip.me.api.smartsync.SyncBoResponseType;
import com.sap.ip.me.api.smartsync.SyncProcessingType;
import com.sap.ip.me.api.smartsync.SyncReplyType;
import com.sap.ip.me.core.NestableRuntimeException;
import com.sap.ip.me.smartsync.data.sm.IllegalStateTransitionException;
import com.sap.ip.me.smartsync.data.sm.PositionState;
import com.sap.ip.me.smartsync.data.sm.ProcessingState;
import com.sap.ip.me.smartsync.data.sm.QuarantinedState;

public class SyncBoState {
    private PositionState mainPositionState;
    private PositionState subPositionState;
    private ProcessingState mainProcessingState;
    private ProcessingState subProcessingState;
    private final boolean isConflictInMain;
    private final boolean isErrorInMain;
    private boolean isSwapNeeded = false;

    public SyncBoState(PositionStatusType mainPositionStatus, ProcessingStatusType mainProcessingStatus, boolean isConflictInMain, boolean isErrorInMain) {
        this(PositionState.getPositionState(mainPositionStatus), ProcessingState.getProcessingState(mainProcessingStatus), PositionState.EMPTY, ProcessingState.EMPTY, isConflictInMain, isErrorInMain);
    }

    private SyncBoState(PositionState mainPositionState, ProcessingState mainProcessingState, PositionState subPositionState, ProcessingState subProcessingState, boolean isConflictInMain, boolean isErrorInMain) {
        this.mainPositionState = mainPositionState;
        this.mainProcessingState = mainProcessingState;
        this.subPositionState = subPositionState;
        this.subProcessingState = subProcessingState;
        this.isConflictInMain = isConflictInMain;
        this.isErrorInMain = isErrorInMain;
    }

    public SyncBoState(PositionStatusType mainPositionStatus, ProcessingStatusType mainProcessingStatus) {
        this(mainPositionStatus, mainProcessingStatus, false, false);
    }

    public SyncBoState(boolean isConflictInMain, boolean isErrorInMain) {
        this(PositionState.EMPTY, ProcessingState.EMPTY, PositionState.EMPTY, ProcessingState.EMPTY, isConflictInMain, isErrorInMain);
    }

    public SyncBoState() {
        this(false, false);
    }

    public SyncBoState(PositionStatusType mainPositionStatus, PositionStatusType subPositionStatus, SyncBoResponseType responseType, SyncBoChangeActionType actionType, boolean isConflictInMain, boolean isErrorInMain) {
        try {
            if (actionType == SyncBoChangeActionType.REPLACE) {
                actionType = SyncBoChangeActionType.MODIFY;
            }
            this.mainPositionState = mainPositionStatus == null ? PositionState.EMPTY : PositionState.getPositionState(mainPositionStatus);
            this.mainProcessingState = QuarantinedState.getQuarantindedState(actionType, responseType);
            this.subPositionState = PositionState.getPositionState(subPositionStatus);
            this.subProcessingState = ProcessingState.CONTRARYQUARANTINED;
        }
        catch (IllegalStateTransitionException ex) {
            throw new NestableRuntimeException(ex);
        }
        this.isConflictInMain = isConflictInMain;
        this.isErrorInMain = isErrorInMain;
    }

    public PositionStatusType getMainPositionStatus() {
        return this.mainPositionState.getPositionStatusType();
    }

    public ProcessingStatusType getMainProcessingStatus() {
        return this.mainProcessingState.getProcessingStatusType();
    }

    public PositionStatusType getSubPositionStatus() {
        return this.subPositionState.getPositionStatusType();
    }

    public ProcessingStatusType getSubProcessingStatus() {
        return this.subProcessingState.getProcessingStatusType();
    }

    public static void verifyInsert(SyncBo syncBo) throws ModificationNotAllowedException {
        if (syncBo.getProcessingStatus() == ProcessingStatusType.CONTRARY_QUARANTINED) {
            throw new ModificationNotAllowedException("Status is CONTRARY QUANRANTINED Insert not allowed");
        }
        if (syncBo.getProcessingStatus() == ProcessingStatusType.QUARANTINED) {
            throw new ModificationNotAllowedException("Status is QUANRANTINED Insert not allowed");
        }
        SyncBoDescriptor syncBoDesc = syncBo.getSyncBoDescriptor();
        SyncProcessingType syncType = syncBoDesc.getSyncProcessing();
        if (syncType == SyncProcessingType.DOWNLOAD) {
            throw new ModificationNotAllowedException("SyncProcessingType is DOWNLOAD insert not allowed ");
        }
        if (syncType == SyncProcessingType.UPLOAD && syncBo.getPositionStatus() == PositionStatusType.GLOBAL) {
            throw new ModificationNotAllowedException("SyncProcessingType is UPLOAD insert not allowed ");
        }
        if (syncBo.getPositionStatus() != PositionStatusType.INITIAL) {
            throw new ModificationNotAllowedException("Illegal Operation: Only SyncBo having an INITIAL status could be INSERTED.");
        }
        if (!(syncBo.getPositionStatus() != PositionStatusType.GLOBAL && syncBo.getProcessingStatus() != ProcessingStatusType.IN_SYNC || syncBo.getSyncBoDescriptor().isAllowedCreate())) {
            throw new ModificationNotAllowedException("Allow create is false");
        }
    }

    public static void verifyReplace(SyncBo original, SyncBo replace) throws ModificationNotAllowedException {
        if (original.getProcessingStatus() == ProcessingStatusType.CONTRARY_QUARANTINED) {
            throw new ModificationNotAllowedException("Status is CONTRARY QUANRANTINED Replace not allowed");
        }
        if (original.getProcessingStatus() == ProcessingStatusType.QUARANTINED) {
            throw new ModificationNotAllowedException("Status is QUANRANTINED Replace not allowed");
        }
        SyncProcessingType syncType = original.getSyncBoDescriptor().getSyncProcessing();
        if (syncType == SyncProcessingType.DOWNLOAD) {
            throw new ModificationNotAllowedException("SyncProcessingType is DOWNLOAD Replace not allowed ");
        }
        if (syncType == SyncProcessingType.UPLOAD && (original.getPositionStatus() == PositionStatusType.GLOBAL || original.getProcessingStatus() == ProcessingStatusType.IN_SYNC)) {
            throw new ModificationNotAllowedException("SyncProcessingType is UPLOAD Replace not allowed ");
        }
        if (replace.getPositionStatus() != PositionStatusType.UNLINKED) {
            throw new ModificationNotAllowedException("Illegal Operation: Only UNLINKED copy of the SyncBo could be REPLACED.");
        }
        if (!(original.getPositionStatus() != PositionStatusType.GLOBAL && original.getProcessingStatus() != ProcessingStatusType.IN_SYNC || original.getSyncBoDescriptor().isAllowedModify())) {
            throw new ModificationNotAllowedException("Allow modify is false");
        }
    }

    public static void verifyDelete(SyncBo syncBo) throws ModificationNotAllowedException {
        if (syncBo.getProcessingStatus() == ProcessingStatusType.CONTRARY_QUARANTINED) {
            throw new ModificationNotAllowedException("Status is CONTRARY QUANRANTINED Delete not allowed");
        }
        if (syncBo.getProcessingStatus() == ProcessingStatusType.QUARANTINED) {
            throw new ModificationNotAllowedException("Status is QUANRANTINED Delete not allowed");
        }
        SyncBoDescriptor syncBoDesc = syncBo.getSyncBoDescriptor();
        SyncProcessingType syncType = syncBoDesc.getSyncProcessing();
        if (syncType == SyncProcessingType.DOWNLOAD) {
            throw new ModificationNotAllowedException("SyncProcessingType is DOWNLOAD Delete not allowed ");
        }
        if (syncType == SyncProcessingType.UPLOAD && (syncBo.getPositionStatus() == PositionStatusType.GLOBAL || syncBo.getProcessingStatus() == ProcessingStatusType.IN_SYNC)) {
            throw new ModificationNotAllowedException("SyncProcessingType is UPLOAD Delete not allowed ");
        }
        if (syncBo.getPositionStatus() == PositionStatusType.UNLINKED || syncBo.getPositionStatus() == PositionStatusType.INITIAL) {
            throw new ModificationNotAllowedException("Illegal Operation:  Application tried to DELETE an UNLINKED SyncBo.");
        }
        if (!(syncBo.getPositionStatus() != PositionStatusType.GLOBAL && syncBo.getProcessingStatus() != ProcessingStatusType.IN_SYNC || syncBo.getSyncBoDescriptor().isAllowedDelete())) {
            throw new ModificationNotAllowedException("Allow delete is false");
        }
    }

    public static void verifyInsert(Row row, SyncBo syncBoParent) throws ModificationNotAllowedException {
        if (syncBoParent.getProcessingStatus() == ProcessingStatusType.CONTRARY_QUARANTINED) {
            throw new ModificationNotAllowedException("Status is CONTRARY QUANRANTINED row insert not allowed");
        }
        if (syncBoParent.getProcessingStatus() == ProcessingStatusType.QUARANTINED) {
            throw new ModificationNotAllowedException("Status is QUANRANTINED row insert not allowed");
        }
        SyncBoDescriptor syncBoDesc = syncBoParent.getSyncBoDescriptor();
        SyncProcessingType syncType = syncBoDesc.getSyncProcessing();
        if (syncType == SyncProcessingType.DOWNLOAD) {
            throw new ModificationNotAllowedException("SyncProcessingType is DOWNLOAD row insert not allowed ");
        }
        if (syncType == SyncProcessingType.UPLOAD && (syncBoParent.getPositionStatus() == PositionStatusType.GLOBAL || syncBoParent.getProcessingStatus() == ProcessingStatusType.IN_SYNC)) {
            throw new ModificationNotAllowedException("SyncProcessingType is UPLOAD row insert not allowed ");
        }
        RowDescriptor rowDescriptor = row.getRowDescriptor();
        if (rowDescriptor.isTop()) {
            throw new ModificationNotAllowedException("Illegal Operation: Application tried to INSERT a TOP Row.");
        }
        if (row.getStatus() != StatusType.INITIAL) {
            throw new ModificationNotAllowedException("Illegal Operation: Only Row having an INITIAL status could be INSERTED.");
        }
        if (rowDescriptor.getSyncBoDescriptor() != syncBoParent.getSyncBoDescriptor()) {
            throw new ModificationNotAllowedException("Row  is NOT a valid child structure of this SyncBo.");
        }
        SyncBoDescriptor syncDesc = rowDescriptor.getSyncBoDescriptor();
        if (!(syncBoParent.getPositionStatus() != PositionStatusType.GLOBAL && syncBoParent.getProcessingStatus() != ProcessingStatusType.IN_SYNC || syncDesc.isAllowedModify())) {
            throw new ModificationNotAllowedException("Modification to SyncBo {0} is FORBIDDEN!", new String[]{syncBoParent.getSyncKey()});
        }
    }

    public static void verifyReplace(Row row, SyncBo syncBoParent) throws ModificationNotAllowedException {
        if (syncBoParent.getProcessingStatus() == ProcessingStatusType.CONTRARY_QUARANTINED) {
            throw new ModificationNotAllowedException("Status is CONTRARY QUANRANTINED row replace/modify not allowed");
        }
        if (syncBoParent.getProcessingStatus() == ProcessingStatusType.QUARANTINED) {
            throw new ModificationNotAllowedException("Status is QUANRANTINED row replace/modify not allowed");
        }
        SyncBoDescriptor syncBoDesc = syncBoParent.getSyncBoDescriptor();
        SyncProcessingType syncType = syncBoDesc.getSyncProcessing();
        if (syncType == SyncProcessingType.DOWNLOAD) {
            throw new ModificationNotAllowedException("SyncProcessingType is DOWNLOAD row replace/modify not allowed ");
        }
        if (syncType == SyncProcessingType.UPLOAD && (syncBoParent.getPositionStatus() == PositionStatusType.GLOBAL || syncBoParent.getProcessingStatus() == ProcessingStatusType.IN_SYNC)) {
            throw new ModificationNotAllowedException("SyncProcessingType is UPLOAD row replace/modify not allowed ");
        }
        RowDescriptor rowDescriptor = row.getRowDescriptor();
        if (rowDescriptor.getSyncBoDescriptor() != syncBoParent.getSyncBoDescriptor()) {
            throw new ModificationNotAllowedException("Row  is NOT a valid child structure of this SyncBo.");
        }
        SyncBoDescriptor syncDesc = rowDescriptor.getSyncBoDescriptor();
        if (!(syncBoParent.getPositionStatus() != PositionStatusType.GLOBAL && syncBoParent.getProcessingStatus() != ProcessingStatusType.IN_SYNC || syncDesc.isAllowedModify())) {
            throw new ModificationNotAllowedException("Modification to SyncBo {0} is FORBIDDEN!", new String[]{syncBoParent.getSyncKey()});
        }
    }

    public static void verifyDelete(Row row, SyncBo syncBoParent) throws ModificationNotAllowedException {
        if (syncBoParent.getProcessingStatus() == ProcessingStatusType.CONTRARY_QUARANTINED) {
            throw new ModificationNotAllowedException("Status is CONTRARY QUANRANTINED row delete not allowed");
        }
        if (syncBoParent.getProcessingStatus() == ProcessingStatusType.QUARANTINED) {
            throw new ModificationNotAllowedException("Status is QUANRANTINED row delete not allowed");
        }
        SyncBoDescriptor syncBoDesc = syncBoParent.getSyncBoDescriptor();
        SyncProcessingType syncType = syncBoDesc.getSyncProcessing();
        if (syncType == SyncProcessingType.DOWNLOAD) {
            throw new ModificationNotAllowedException("SyncProcessingType is DOWNLOAD row delete not allowed ");
        }
        if (syncType == SyncProcessingType.UPLOAD && (syncBoParent.getPositionStatus() == PositionStatusType.GLOBAL || syncBoParent.getProcessingStatus() == ProcessingStatusType.IN_SYNC)) {
            throw new ModificationNotAllowedException("SyncProcessingType is UPLOAD row delete not allowed ");
        }
        RowDescriptor rowDescriptor = row.getRowDescriptor();
        if (rowDescriptor.getSyncBoDescriptor() != syncBoParent.getSyncBoDescriptor()) {
            throw new ModificationNotAllowedException("Row  is NOT a valid child structure of this SyncBo.");
        }
        SyncBoDescriptor syncDesc = rowDescriptor.getSyncBoDescriptor();
        if (!(syncBoParent.getPositionStatus() != PositionStatusType.GLOBAL && syncBoParent.getProcessingStatus() != ProcessingStatusType.IN_SYNC || syncDesc.isAllowedModify())) {
            throw new ModificationNotAllowedException("Modification to SyncBo {0} is FORBIDDEN!", new String[]{syncBoParent.getSyncKey()});
        }
    }

    public static void verifyModify(FieldDescriptor fieldDescriptor, Row parentRow) throws ModificationNotAllowedException {
        if (fieldDescriptor.getRowDescriptor() != parentRow.getRowDescriptor()) {
            throw new ModificationNotAllowedException("FieldDescriptor {0} does not match RowDescriptor {1}", new Object[]{fieldDescriptor.getFieldName(), parentRow.getRowDescriptor().getRowName()});
        }
        if (fieldDescriptor.isKey()) {
            throw new ModificationNotAllowedException("Modification of SyncKey is NOT allowed");
        }
        FieldInputQualifyType fieldInputType = fieldDescriptor.getModifyInputQualifyType();
        if (fieldInputType == FieldInputQualifyType.FORBIDDEN && parentRow.getStatus().isLinked()) {
            throw new ModificationNotAllowedException("Modification to field {0} is FORBIDDEN!");
        }
    }

    private boolean isErrorQuarantined() {
        return ((QuarantinedState)this.mainProcessingState).getSyncBoResponseType() == SyncBoResponseType.ERROR;
    }

    private boolean isConflictQuarantined() {
        return ((QuarantinedState)this.mainProcessingState).getSyncBoResponseType() == SyncBoResponseType.CONFLICT;
    }

    public boolean isSwapNeeded() {
        return this.isSwapNeeded;
    }

    private boolean isSwapNeeded(ProcessingState oldMainProcessingState, ProcessingState newMainProcessingState) throws IllegalStateTransitionException {
        if (!this.isQuarantined(oldMainProcessingState) && this.isQuarantined(newMainProcessingState)) {
            if (this.getSyncBoResponseType(newMainProcessingState) == SyncBoResponseType.CONFLICT) {
                return this.isConflictInMain;
            }
            return this.isErrorInMain;
        }
        return this.isQuarantined(oldMainProcessingState) && this.isQuarantined(newMainProcessingState) && this.isConflictInMain != this.isErrorInMain && this.getSyncBoResponseType(oldMainProcessingState) != this.getSyncBoResponseType(newMainProcessingState);
    }

    public SyncBoState newStateOfInsert() throws IllegalStateTransitionException {
        this.checkPossibleCombinationState();
        this.mainPositionState = this.mainPositionState.newStateOfInsert(this.isQuarantined(), this.isSvrDataInMain());
        this.mainProcessingState = this.mainProcessingState.newStateOfInsert();
        return this;
    }

    public SyncBoState newStateOfModify() throws IllegalStateTransitionException {
        this.checkPossibleCombinationState();
        this.mainPositionState = this.mainPositionState.newStateOfModify(this.isQuarantined());
        this.mainProcessingState = this.mainProcessingState.newStateOfModify();
        return this;
    }

    public SyncBoState newStateOfDelete() throws IllegalStateTransitionException {
        this.checkPossibleCombinationState();
        this.mainPositionState = this.mainPositionState.newStateOfDelete(this.isQuarantined());
        this.mainProcessingState = this.mainProcessingState.newStateOfDelete();
        return this;
    }

    public SyncBoState newStateOfReplace() throws IllegalStateTransitionException {
        this.checkPossibleCombinationState();
        this.mainPositionState = this.mainPositionState.newStateOfReplace(this.isQuarantined());
        this.mainProcessingState = this.mainProcessingState.newStateOfReplace();
        return this;
    }

    public SyncBoState newStateOfInboundInsert() throws IllegalStateTransitionException {
        this.checkPossibleCombinationState();
        boolean isSvrDataInMain = this.isSvrDataInMain();
        boolean isQuarantined = this.isQuarantined();
        ProcessingState oldMainProcessingState = this.mainProcessingState;
        this.mainPositionState = this.mainPositionState.newStateOfInboundInsert(isSvrDataInMain, isQuarantined);
        this.mainProcessingState = this.mainProcessingState.newStateOfInboundInsert(isQuarantined, isSvrDataInMain);
        this.subPositionState = this.subPositionState.newStateOfInboundInsert(isQuarantined, !isSvrDataInMain);
        this.subProcessingState = this.subProcessingState.newStateOfInboundInsert(isQuarantined, !isSvrDataInMain);
        this.checkSwap(oldMainProcessingState, this.mainProcessingState);
        return this;
    }

    private void checkSwap(ProcessingState oldMainProcessingState, ProcessingState mainProcessingState) throws IllegalStateTransitionException {
        this.isSwapNeeded = this.isSwapNeeded(oldMainProcessingState, mainProcessingState);
        if (this.isSwapNeeded) {
            PositionState temp = this.mainPositionState;
            this.mainPositionState = this.subPositionState;
            this.subPositionState = temp;
        }
    }

    public SyncBoState newStateOfInboundModify() throws IllegalStateTransitionException {
        this.checkPossibleCombinationState();
        boolean isSvrDataInMain = this.isSvrDataInMain();
        boolean isQuarantined = this.isQuarantined();
        ProcessingState oldMainProcessingState = this.mainProcessingState;
        this.mainPositionState = this.mainPositionState.newStateOfInboundModify(isQuarantined, isSvrDataInMain);
        this.mainProcessingState = this.mainProcessingState.newStateOfInboundModify(isQuarantined, isSvrDataInMain);
        this.subPositionState = this.subPositionState.newStateOfInboundModify(isQuarantined, !isSvrDataInMain);
        this.subProcessingState = this.subProcessingState.newStateOfInboundModify(isQuarantined, !isSvrDataInMain);
        this.checkSwap(oldMainProcessingState, this.mainProcessingState);
        return this;
    }

    private boolean isSvrDataInMain() throws IllegalStateTransitionException {
        if (this.isQuarantined()) {
            return this.getSyncBoResponseType() == SyncBoResponseType.CONFLICT && this.isConflictInMain || this.getSyncBoResponseType() == SyncBoResponseType.ERROR && this.isErrorInMain;
        }
        return false;
    }

    private boolean isQuarantined() {
        return this.isQuarantined(this.mainProcessingState);
    }

    private boolean isQuarantined(ProcessingState processingState) {
        return processingState instanceof QuarantinedState;
    }

    public SyncBoState newStateOfInboundDelete() throws IllegalStateTransitionException {
        this.checkPossibleCombinationState();
        boolean isSvrDataInMain = this.isSvrDataInMain();
        boolean isQuarantined = this.isQuarantined();
        ProcessingState oldMainProcessingState = this.mainProcessingState;
        this.mainPositionState = this.mainPositionState.newStateOfInboundDelete(isQuarantined);
        this.mainProcessingState = this.mainProcessingState.newStateOfInboundDelete(isQuarantined, isSvrDataInMain);
        this.subPositionState = this.subPositionState.newStateOfInboundDelete(isQuarantined);
        this.subProcessingState = this.subProcessingState.newStateOfInboundDelete(isQuarantined, !isSvrDataInMain);
        this.checkSwap(oldMainProcessingState, this.mainProcessingState);
        return this;
    }

    public SyncBoState newStateOfInboundReplace() throws IllegalStateTransitionException {
        this.checkPossibleCombinationState();
        boolean isSvrDataInMain = this.isSvrDataInMain();
        boolean isQuarantined = this.isQuarantined();
        ProcessingState oldMainProcessingState = this.mainProcessingState;
        this.mainPositionState = this.mainPositionState.newStateOfInboundReplace(isQuarantined, isSvrDataInMain);
        this.mainProcessingState = this.mainProcessingState.newStateOfInboundReplace(isQuarantined, isSvrDataInMain);
        this.subPositionState = this.subPositionState.newStateOfInboundReplace(isQuarantined, !isSvrDataInMain);
        this.subProcessingState = this.subProcessingState.newStateOfInboundReplace(isQuarantined, !isSvrDataInMain);
        this.checkSwap(oldMainProcessingState, this.mainProcessingState);
        return this;
    }

    public SyncBoState newStateOfInboundSuccessResponse(boolean isDeltaExiting, boolean forceMerge) throws IllegalStateTransitionException {
        this.checkPossibleCombinationState();
        boolean isSvrDataInMain = this.isSvrDataInMain();
        boolean isQuarantined = this.isQuarantined();
        ProcessingState oldMainProcessingState = this.mainProcessingState;
        this.mainPositionState = this.mainPositionState.newStateOfInboundResponse(isQuarantined, isSvrDataInMain, SyncReplyType.SUCCESS);
        this.mainProcessingState = this.mainProcessingState.newStateOfInboundResponse(isDeltaExiting, forceMerge, SyncReplyType.SUCCESS, null);
        if (this.mainProcessingState instanceof QuarantinedState) {
            this.subPositionState = PositionState.GLOBAL;
            this.subProcessingState = ProcessingState.CONTRARYQUARANTINED;
        }
        this.checkSwap(oldMainProcessingState, this.mainProcessingState);
        return this;
    }

    public SyncBoState newStateOfInboundErrorConflictResponse(SyncReplyType replyType, SyncBoChangeActionType action) throws IllegalStateTransitionException {
        this.checkPossibleCombinationState();
        boolean isSvrDataInMain = this.isSvrDataInMain();
        boolean isQuarantined = this.isQuarantined();
        ProcessingState oldMainProcessingState = this.mainProcessingState;
        this.mainPositionState = this.mainPositionState.newStateOfInboundResponse(isQuarantined, isSvrDataInMain, replyType);
        this.mainProcessingState = this.mainProcessingState.newStateOfInboundResponse(false, false, replyType, action);
        if (this.mainProcessingState instanceof QuarantinedState) {
            this.subPositionState = PositionState.GLOBAL;
            this.subProcessingState = ProcessingState.CONTRARYQUARANTINED;
        }
        this.checkSwap(oldMainProcessingState, this.mainProcessingState);
        return this;
    }

    public SyncBoState newStateOfInboundResponse(boolean isDeltaExisting, boolean forceMerge, SyncReplyType replyType, SyncBoChangeActionType actionType) throws IllegalStateTransitionException {
        this.checkPossibleCombinationState();
        boolean isSvrDataInMain = this.isSvrDataInMain();
        boolean isQuarantined = this.isQuarantined();
        ProcessingState oldMainProcessingState = this.mainProcessingState;
        this.mainPositionState = this.mainPositionState.newStateOfInboundResponse(isQuarantined, isSvrDataInMain, replyType);
        this.mainProcessingState = this.mainProcessingState.newStateOfInboundResponse(isDeltaExisting, forceMerge, replyType, actionType);
        if (this.mainProcessingState instanceof QuarantinedState) {
            this.subPositionState = PositionState.GLOBAL;
            this.subProcessingState = ProcessingState.CONTRARYQUARANTINED;
        }
        this.checkSwap(oldMainProcessingState, this.mainProcessingState);
        return this;
    }

    public SyncBoState newStateOfSyncOut() throws IllegalStateTransitionException {
        this.checkPossibleCombinationState();
        boolean isQuarantined = this.isQuarantined();
        ProcessingState oldMainProcessingState = this.mainProcessingState;
        this.mainPositionState = this.mainPositionState.newStateOfSyncOut(isQuarantined);
        this.mainProcessingState = this.mainProcessingState.newStateOfSyncOut();
        if (this.mainProcessingState instanceof QuarantinedState) {
            this.subPositionState = PositionState.GLOBAL;
            this.subProcessingState = ProcessingState.CONTRARYQUARANTINED;
        }
        this.checkSwap(oldMainProcessingState, this.mainProcessingState);
        return this;
    }

    private boolean isSvrDatInMain(SyncBoResponseType responseType) {
        if (responseType == SyncBoResponseType.CONFLICT) {
            return this.isConflictInMain;
        }
        if (responseType == SyncBoResponseType.ERROR) {
            return this.isErrorInMain;
        }
        throw new IllegalArgumentException("unsupported SyncBoResponseType " + responseType);
    }

    public final SyncBoState newStateOfResolveQuarantinedSyncBoByKeepClientData() throws IllegalStateTransitionException {
        boolean isSvrDatInMain = this.isSvrDatInMain(this.getSyncBoResponseType());
        if (!this.isQuarantined()) {
            throw new IllegalStateTransitionException("Invalid operation on state of processing:" + this.mainProcessingState);
        }
        return this.resolveQuarantinedSyncBo(((QuarantinedState)this.mainProcessingState).getSyncBoChangeActionType(), isSvrDatInMain, true);
    }

    public final SyncBoState newStateOfResolveQuarantinedSyncBoByRevertToServerData() throws IllegalStateTransitionException {
        if (!this.isQuarantined()) {
            throw new IllegalStateTransitionException("Invalid operation on state of processing:" + this.mainProcessingState);
        }
        return this.resolveQuarantinedSyncBo(((QuarantinedState)this.mainProcessingState).getSyncBoChangeActionType(), this.isSvrDatInMain(this.getSyncBoResponseType()), false);
    }

    public SyncBoResponseType getSyncBoResponseType(ProcessingState processingState) throws IllegalStateTransitionException {
        if (processingState instanceof QuarantinedState) {
            return ((QuarantinedState)processingState).getSyncBoResponseType();
        }
        throw new IllegalStateTransitionException("getSyncBoResponseType on a non Quarantined SyncBo is illegal");
    }

    public SyncBoResponseType getSyncBoResponseType() throws IllegalStateTransitionException {
        return this.getSyncBoResponseType(this.mainProcessingState);
    }

    private void checkPossibleCombinationState() throws IllegalStateTransitionException {
        this.checkPossibleCombinationState(this.mainPositionState.getPositionStatusType(), this.mainProcessingState.getProcessingStatusType());
        this.checkPossibleCombinationState(this.subPositionState.getPositionStatusType(), this.subProcessingState.getProcessingStatusType());
    }

    private void checkPossibleCombinationState(PositionStatusType position, ProcessingStatusType processing) throws IllegalStateTransitionException {
        if (!this.isPossibleCombinationState(position, processing)) {
            throw new IllegalStateTransitionException("Invalid state, position:" + this.mainPositionState + " processing:" + processing);
        }
    }

    private boolean isPossibleCombinationState(PositionStatusType position, ProcessingStatusType processing) throws IllegalStateTransitionException {
        if (position == null) {
            if (processing == null) {
                return true;
            }
            if (processing == ProcessingStatusType.QUARANTINED || processing == ProcessingStatusType.CONTRARY_QUARANTINED) {
                return true;
            }
        } else if (processing != null && (position == PositionStatusType.INITIAL || position == PositionStatusType.UNLINKED ? processing == ProcessingStatusType.CONTRARY_QUARANTINED || processing == ProcessingStatusType.QUARANTINED || processing == ProcessingStatusType.SYNCED || processing == ProcessingStatusType.IN_SYNC || processing == ProcessingStatusType.IN_SYNC_CONFLICT_WAITING : position == PositionStatusType.LOCAL && (processing == ProcessingStatusType.SYNCED || processing == ProcessingStatusType.IN_SYNC_CONFLICT_WAITING))) {
            return false;
        }
        return true;
    }

    private SyncBoState resolveQuarantinedSyncBo(SyncBoChangeActionType action, boolean isSvrDatInMain, boolean isKeepClientData) throws IllegalStateTransitionException {
        if (this.mainPositionState == PositionState.LOCAL && this.subPositionState == PositionState.EMPTY && action == SyncBoChangeActionType.DELETE && !isSvrDatInMain) {
            if (isKeepClientData) {
                return new SyncBoState(PositionStatusType.LOCAL, ProcessingStatusType.CHANGED, this.isConflictInMain, this.isErrorInMain);
            }
            return new SyncBoState(PositionStatusType.GLOBAL, ProcessingStatusType.SYNCED, this.isConflictInMain, this.isErrorInMain);
        }
        if (this.mainPositionState == PositionState.EMPTY && this.subPositionState == PositionState.LOCAL && action == SyncBoChangeActionType.DELETE && isSvrDatInMain) {
            if (isKeepClientData) {
                return new SyncBoState(PositionStatusType.LOCAL, ProcessingStatusType.CHANGED, this.isConflictInMain, this.isErrorInMain);
            }
            return new SyncBoState(PositionStatusType.GLOBAL, ProcessingStatusType.SYNCED, this.isConflictInMain, this.isErrorInMain);
        }
        if (this.mainPositionState == PositionState.EMPTY && this.subPositionState == PositionState.GLOBAL && action == SyncBoChangeActionType.INSERT && !isSvrDatInMain) {
            if (isKeepClientData) {
                return new SyncBoState(PositionStatusType.LOCAL, ProcessingStatusType.CHANGED, this.isConflictInMain, this.isErrorInMain);
            }
            return new SyncBoState(PositionStatusType.GLOBAL, ProcessingStatusType.SYNCED, this.isConflictInMain, this.isErrorInMain);
        }
        if (this.mainPositionState == PositionState.GLOBAL && this.subPositionState == PositionState.EMPTY && action == SyncBoChangeActionType.INSERT && isSvrDatInMain) {
            if (isKeepClientData) {
                return new SyncBoState(PositionStatusType.LOCAL, ProcessingStatusType.DESTROYED, this.isConflictInMain, this.isErrorInMain);
            }
            return new SyncBoState(PositionStatusType.GLOBAL, ProcessingStatusType.SYNCED, this.isConflictInMain, this.isErrorInMain);
        }
        if (this.mainPositionState == PositionState.GLOBAL && this.subPositionState == PositionState.GLOBAL && action == SyncBoChangeActionType.MODIFY) {
            if (isKeepClientData) {
                return new SyncBoState(PositionStatusType.GLOBAL, ProcessingStatusType.CHANGED, this.isConflictInMain, this.isErrorInMain);
            }
            return new SyncBoState(PositionStatusType.GLOBAL, ProcessingStatusType.SYNCED, this.isConflictInMain, this.isErrorInMain);
        }
        if (this.mainPositionState == PositionState.GLOBAL && this.subPositionState == PositionState.EMPTY && action == SyncBoChangeActionType.DELETE && !isSvrDatInMain) {
            if (isKeepClientData) {
                throw new IllegalStateTransitionException("It is an illegal operation to keep client data for resolving this quarantined SyncBo.");
            }
            return new SyncBoState(PositionStatusType.GLOBAL, ProcessingStatusType.DESTROYED, this.isConflictInMain, this.isErrorInMain);
        }
        if (this.mainPositionState == PositionState.EMPTY && this.subPositionState == PositionState.GLOBAL && action == SyncBoChangeActionType.DELETE && isSvrDatInMain) {
            if (isKeepClientData) {
                throw new IllegalStateTransitionException("It is an illegal operation to keep client data for resolving this quarantined SyncBo.");
            }
            return new SyncBoState(PositionStatusType.GLOBAL, ProcessingStatusType.DESTROYED, this.isConflictInMain, this.isErrorInMain);
        }
        throw new IllegalStateTransitionException("It is an illegal operation for resolving this quarantined SyncBo. In main=" + this.mainPositionState + "," + this.mainProcessingState + " sub=" + this.subPositionState + "," + this.subProcessingState + " server data in " + (isSvrDatInMain ? "main" : "sub") + " action=" + action);
    }
}

