/*
 * Decompiled with CFR 0.152.
 */
package com.sap.ip.me.smartsync.data.sm;

import com.sap.ip.me.api.smartsync.ProcessingStatusType;
import com.sap.ip.me.api.smartsync.SyncBoChangeActionType;
import com.sap.ip.me.api.smartsync.SyncBoResponseType;
import com.sap.ip.me.api.smartsync.SyncReplyType;
import com.sap.ip.me.smartsync.data.sm.ActionQuarantinedState;
import com.sap.ip.me.smartsync.data.sm.IllegalStateTransitionException;
import com.sap.ip.me.smartsync.data.sm.ProcessingState;
import com.sap.ip.me.smartsync.data.sm.ResponseQuarantinedState;

public class QuarantinedState
extends ProcessingState {
    private ActionQuarantinedState aState;
    private ResponseQuarantinedState rState;
    public static QuarantinedState INSERTION_CONFLICT = new QuarantinedState(ActionQuarantinedState.INSERTION_QUARANTINED, ResponseQuarantinedState.CONFLICT_QUARANTINED);
    public static QuarantinedState INSERTION_ERROR = new QuarantinedState(ActionQuarantinedState.INSERTION_QUARANTINED, ResponseQuarantinedState.ERROR_QUARANTINED);
    public static QuarantinedState MODIFICATION_CONFLICT = new QuarantinedState(ActionQuarantinedState.MODIFICATION_QUARANTINED, ResponseQuarantinedState.CONFLICT_QUARANTINED);
    public static QuarantinedState MODIFICATION_ERROR = new QuarantinedState(ActionQuarantinedState.MODIFICATION_QUARANTINED, ResponseQuarantinedState.ERROR_QUARANTINED);
    public static QuarantinedState DELETION_CONFLICT = new QuarantinedState(ActionQuarantinedState.DELETION_QUARANTINED, ResponseQuarantinedState.CONFLICT_QUARANTINED);
    public static QuarantinedState DELETION_ERROR = new QuarantinedState(ActionQuarantinedState.DELETION_QUARANTINED, ResponseQuarantinedState.ERROR_QUARANTINED);

    private QuarantinedState(ActionQuarantinedState aState, ResponseQuarantinedState rState) {
        this.aState = aState;
        this.rState = rState;
    }

    SyncBoChangeActionType getSyncBoChangeActionType() {
        return this.aState.getSyncBoChangeActionType();
    }

    SyncBoResponseType getSyncBoResponseType() {
        return this.rState.getSyncBoResponseType();
    }

    public ProcessingState newStateOfInsert() throws IllegalStateTransitionException {
        throw new IllegalStateTransitionException("Action INSERT on processing status Quarantined is illegal");
    }

    public ProcessingState newStateOfModify() throws IllegalStateTransitionException {
        throw new IllegalStateTransitionException("Action Modify on processing status Quarantined is illegal");
    }

    public ProcessingState newStateOfDelete() throws IllegalStateTransitionException {
        throw new IllegalStateTransitionException("Action Delete on processing status Quarantined is illegal");
    }

    public ProcessingState newStateOfReplace() throws IllegalStateTransitionException {
        throw new IllegalStateTransitionException("Action Replace on processing status Quarantined is illegal");
    }

    public ProcessingState newStateOfInboundDelete(boolean isQuarantined, boolean isSvrData) throws IllegalStateTransitionException {
        ActionQuarantinedState newAState = this.aState.newStateOfInboundDelete();
        if (newAState == null) {
            return ProcessingState.DESTROYED;
        }
        ResponseQuarantinedState newRState = this.rState.newStateOfInboundDelta();
        return QuarantinedState.getQuarantindedState(newAState.getSyncBoChangeActionType(), newRState.getSyncBoResponseType());
    }

    public ProcessingState newStateOfInboundModify(boolean isQuarantined, boolean isSvrData) throws IllegalStateTransitionException {
        ActionQuarantinedState newAState = this.aState.newStateOfInboundModify();
        ResponseQuarantinedState newRState = this.rState.newStateOfInboundDelta();
        return QuarantinedState.getQuarantindedState(newAState.getSyncBoChangeActionType(), newRState.getSyncBoResponseType());
    }

    public ProcessingStatusType getProcessingStatusType() {
        return ProcessingStatusType.QUARANTINED;
    }

    static QuarantinedState getQuarantindedState(SyncBoChangeActionType action, SyncBoResponseType response) throws IllegalStateTransitionException {
        if (action == SyncBoChangeActionType.INSERT) {
            if (response == SyncBoResponseType.CONFLICT) {
                return INSERTION_CONFLICT;
            }
            if (response == SyncBoResponseType.ERROR) {
                return INSERTION_ERROR;
            }
        } else if (action == SyncBoChangeActionType.MODIFY) {
            if (response == SyncBoResponseType.CONFLICT) {
                return MODIFICATION_CONFLICT;
            }
            if (response == SyncBoResponseType.ERROR) {
                return MODIFICATION_ERROR;
            }
        } else if (action == SyncBoChangeActionType.DELETE) {
            if (response == SyncBoResponseType.CONFLICT) {
                return DELETION_CONFLICT;
            }
            if (response == SyncBoResponseType.ERROR) {
                return DELETION_ERROR;
            }
        }
        throw new IllegalArgumentException(action + "," + response);
    }

    public ProcessingState newStateOfSyncOut() throws IllegalStateTransitionException {
        throw new IllegalStateTransitionException("Action SyncOut on processing status Quarantined is illegal");
    }

    public ProcessingState newStateOfInboundResponse(boolean isDeltaExiting, boolean forceMerge, SyncReplyType replyType, SyncBoChangeActionType action) throws IllegalStateTransitionException {
        throw new IllegalStateTransitionException("Action Inbound Response on processing status Quarantined is illegal");
    }

    public ProcessingState newStateOfInboundReplace(boolean isQuarantined, boolean isSvrData) throws IllegalStateTransitionException {
        throw new IllegalStateTransitionException("Action Inbound Replace on processing status Quarantined is illegal");
    }

    public ProcessingState newStateOfInboundInsert(boolean isQuarantined, boolean isSvrData) throws IllegalStateTransitionException {
        throw new IllegalStateTransitionException("Action Inbound Insert on processing status Quarantined is illegal");
    }
}

