/*
 * Decompiled with CFR 0.152.
 */
package com.sap.ip.me.smartsync.data.sm;

import com.sap.ip.me.api.smartsync.ProcessingStatusType;
import com.sap.ip.me.api.smartsync.SyncBoChangeActionType;
import com.sap.ip.me.api.smartsync.SyncReplyType;
import com.sap.ip.me.smartsync.data.sm.ChangedState;
import com.sap.ip.me.smartsync.data.sm.ContraryQuarantinedState;
import com.sap.ip.me.smartsync.data.sm.DestroyedProcessingState;
import com.sap.ip.me.smartsync.data.sm.EmptyProcessingState;
import com.sap.ip.me.smartsync.data.sm.IllegalStateTransitionException;
import com.sap.ip.me.smartsync.data.sm.InSyncCWState;
import com.sap.ip.me.smartsync.data.sm.InSyncState;
import com.sap.ip.me.smartsync.data.sm.SyncedState;

public abstract class ProcessingState {
    public static final ProcessingState CHANGED = new ChangedState();
    public static final ProcessingState SYNCED = new SyncedState();
    public static final ProcessingState IN_SYNC = new InSyncState();
    public static final ProcessingState CONFLICT_WAITING = new InSyncCWState(){};
    public static final ProcessingState CONTRARYQUARANTINED = new ContraryQuarantinedState();
    public static final ProcessingState DESTROYED = new DestroyedProcessingState();
    public static final ProcessingState EMPTY = new EmptyProcessingState();

    public abstract ProcessingState newStateOfInsert() throws IllegalStateTransitionException;

    public abstract ProcessingState newStateOfModify() throws IllegalStateTransitionException;

    public abstract ProcessingState newStateOfDelete() throws IllegalStateTransitionException;

    public abstract ProcessingState newStateOfReplace() throws IllegalStateTransitionException;

    public abstract ProcessingState newStateOfInboundInsert(boolean var1, boolean var2) throws IllegalStateTransitionException;

    public abstract ProcessingState newStateOfInboundModify(boolean var1, boolean var2) throws IllegalStateTransitionException;

    public abstract ProcessingState newStateOfInboundDelete(boolean var1, boolean var2) throws IllegalStateTransitionException;

    public abstract ProcessingState newStateOfInboundReplace(boolean var1, boolean var2) throws IllegalStateTransitionException;

    public ProcessingState newStateOfInboundResponse(boolean isDeltaExiting, boolean forceMerge, SyncReplyType replyType, SyncBoChangeActionType action) throws IllegalStateTransitionException {
        throw new IllegalStateTransitionException("Not allowed to call method method newStateOfInboundResponse via " + this);
    }

    public abstract ProcessingState newStateOfSyncOut() throws IllegalStateTransitionException;

    public abstract ProcessingStatusType getProcessingStatusType();

    static ProcessingState getProcessingState(ProcessingStatusType status) {
        if (status == null) {
            return EMPTY;
        }
        String sStatus = status.toString();
        if (sStatus.equals(ProcessingStatusType.IN_SYNC.toString())) {
            return IN_SYNC;
        }
        if (sStatus.equals(ProcessingStatusType.CHANGED.toString())) {
            return CHANGED;
        }
        if (sStatus.equals(ProcessingStatusType.IN_SYNC_CONFLICT_WAITING.toString())) {
            return CONFLICT_WAITING;
        }
        if (sStatus.equals(ProcessingStatusType.QUARANTINED.toString())) {
            throw new IllegalArgumentException("Invalid argument:Quarantined");
        }
        if (sStatus.equals(ProcessingStatusType.SYNCED.toString())) {
            return SYNCED;
        }
        if (sStatus.equals(ProcessingStatusType.DESTROYED.toString())) {
            return DESTROYED;
        }
        if (sStatus.equals(ProcessingStatusType.CONTRARY_QUARANTINED.toString())) {
            return CONTRARYQUARANTINED;
        }
        return null;
    }

    public String toString() {
        return this.getProcessingStatusType().toString();
    }
}

