/*
 * Decompiled with CFR 0.152.
 */
package com.sap.ip.me.smartsync.data.sm;

import com.sap.ip.me.api.smartsync.PositionStatusType;
import com.sap.ip.me.api.smartsync.SyncReplyType;
import com.sap.ip.me.smartsync.data.sm.EmptyPositionState;
import com.sap.ip.me.smartsync.data.sm.GlobalState;
import com.sap.ip.me.smartsync.data.sm.IllegalStateTransitionException;
import com.sap.ip.me.smartsync.data.sm.InitialState;
import com.sap.ip.me.smartsync.data.sm.LocalState;
import com.sap.ip.me.smartsync.data.sm.UnlinkedState;

public abstract class PositionState {
    static final PositionState INITIAL = new InitialState();
    static final PositionState LOCAL = new LocalState();
    static final PositionState GLOBAL = new GlobalState();
    static final PositionState UNLINKED = new UnlinkedState();
    static final PositionState EMPTY = new EmptyPositionState();

    abstract PositionStatusType getPositionStatusType();

    public abstract PositionState newStateOfInsert(boolean var1, boolean var2) throws IllegalStateTransitionException;

    public abstract PositionState newStateOfModify(boolean var1) throws IllegalStateTransitionException;

    public abstract PositionState newStateOfDelete(boolean var1) throws IllegalStateTransitionException;

    public abstract PositionState newStateOfReplace(boolean var1) throws IllegalStateTransitionException;

    public PositionState newStateOfInboundInsert(boolean isQuarantined, boolean isSvrData) throws IllegalStateTransitionException {
        throw new IllegalStateTransitionException("Action Inbound INSERT on position status " + this + " is illegal");
    }

    public PositionState newStateOfInboundModify(boolean isQuarantined, boolean isSvrData) throws IllegalStateTransitionException {
        throw new IllegalStateTransitionException("Action Inbound MODIFY on position status " + this + " is illegal");
    }

    public PositionState newStateOfInboundDelete(boolean isQuarantined) throws IllegalStateTransitionException {
        throw new IllegalStateTransitionException("Action Inbound DELETE on position status " + this + " is illegal");
    }

    public PositionState newStateOfInboundReplace(boolean isQuarantined, boolean isSvrData) throws IllegalStateTransitionException {
        throw new IllegalStateTransitionException("Action Inbound REPLACE on position status " + this + " is illegal");
    }

    public PositionState newStateOfInboundResponse(boolean isQuarantined, boolean isSvrData, SyncReplyType replyType) throws IllegalStateTransitionException {
        throw new IllegalStateTransitionException("Action Inbound Reponse on position status " + this + " is illegal");
    }

    public PositionState newStateOfSyncOut(boolean isQuarantined) throws IllegalStateTransitionException {
        throw new IllegalStateTransitionException("Action Sync Out on position status " + this + " is illegal");
    }

    static PositionState getPositionState(PositionStatusType status) {
        if (status == null) {
            return EMPTY;
        }
        String sStatus = status.toString();
        if (sStatus.equals(PositionStatusType.INITIAL.toString())) {
            return INITIAL;
        }
        if (sStatus.equals(PositionStatusType.GLOBAL.toString())) {
            return GLOBAL;
        }
        if (sStatus.equals(PositionStatusType.LOCAL.toString())) {
            return LOCAL;
        }
        if (sStatus.equals(PositionStatusType.UNLINKED.toString())) {
            return UNLINKED;
        }
        throw new IllegalArgumentException("unsupported PositionStatusType " + status);
    }

    public String toString() {
        PositionStatusType type = this.getPositionStatusType();
        if (type == null) {
            return "null";
        }
        return type.toString();
    }
}

