/*
 * Decompiled with CFR 0.152.
 */
package com.sap.ip.me.smartsync.data.sm;

import com.sap.ip.me.api.smartsync.ProcessingStatusType;
import com.sap.ip.me.api.smartsync.SyncBoChangeActionType;
import com.sap.ip.me.api.smartsync.SyncReplyType;
import com.sap.ip.me.smartsync.data.sm.IllegalStateTransitionException;
import com.sap.ip.me.smartsync.data.sm.ProcessingState;
import com.sap.ip.me.smartsync.data.sm.QuarantinedState;

public class EmptyProcessingState
extends ProcessingState {
    EmptyProcessingState() {
    }

    public ProcessingState newStateOfInsert() throws IllegalStateTransitionException {
        return ProcessingState.CHANGED;
    }

    public ProcessingState newStateOfModify() throws IllegalStateTransitionException {
        throw new IllegalStateTransitionException("Action Modify on processing status EMPTY is illegal");
    }

    public ProcessingState newStateOfDelete() throws IllegalStateTransitionException {
        throw new IllegalStateTransitionException("Action Delete on processing status EMPTY is illegal");
    }

    public ProcessingState newStateOfReplace() throws IllegalStateTransitionException {
        throw new IllegalStateTransitionException("Action Replace on processing status EMPTY is illegal");
    }

    public ProcessingState newStateOfInboundInsert(boolean isQuarantined, boolean isSvrData) throws IllegalStateTransitionException {
        if (isQuarantined) {
            throw new IllegalStateTransitionException("Action Inbound Insert on processing status EMPTY for Quarantined is illegal");
        }
        return ProcessingState.SYNCED;
    }

    public ProcessingState newStateOfInboundModify(boolean isQuarantined, boolean isSvrData) throws IllegalStateTransitionException {
        if (isQuarantined && isSvrData || !isQuarantined && !isSvrData) {
            throw new IllegalStateTransitionException("Action Inbound Modify on processing status EMPTY is illegal");
        }
        return this;
    }

    public ProcessingState newStateOfInboundDelete(boolean isQuarantined, boolean isSvrData) throws IllegalStateTransitionException {
        return ProcessingState.DESTROYED;
    }

    public ProcessingState newStateOfInboundReplace(boolean isQuarantined, boolean isSvrData) throws IllegalStateTransitionException {
        if (isQuarantined && isSvrData || !isQuarantined && !isSvrData) {
            throw new IllegalStateTransitionException("Action Inbound replace on processing status EMPTY is illegal");
        }
        return this;
    }

    public ProcessingState newStateOfInboundResponse(boolean isDeltaExiting, boolean forceMerge, SyncReplyType replyType, SyncBoChangeActionType action) throws IllegalStateTransitionException {
        if (forceMerge) {
            return this;
        }
        if (action == SyncBoChangeActionType.INSERT) {
            if (replyType == SyncReplyType.ERROR) {
                return QuarantinedState.INSERTION_ERROR;
            }
            if (replyType == SyncReplyType.CONFLICT) {
                return QuarantinedState.INSERTION_CONFLICT;
            }
        } else if (action == SyncBoChangeActionType.REPLACE || action == SyncBoChangeActionType.MODIFY) {
            if (replyType == SyncReplyType.ERROR) {
                return QuarantinedState.MODIFICATION_ERROR;
            }
            if (replyType == SyncReplyType.CONFLICT) {
                return QuarantinedState.MODIFICATION_CONFLICT;
            }
        }
        throw new IllegalArgumentException("EmptyProcessingState, action type " + action + " with reply type " + replyType + " is not allowed");
    }

    public ProcessingState newStateOfSyncOut() throws IllegalStateTransitionException {
        throw new IllegalStateTransitionException("Action sync out on processing status EMPTY is illegal");
    }

    public ProcessingState newStateOfResolveQuarantinedSyncBo() throws IllegalStateTransitionException {
        throw new IllegalStateTransitionException("Action Resolve quarantined on processing status EMPTY is illegal");
    }

    public ProcessingStatusType getProcessingStatusType() {
        return null;
    }
}

