/*
 * Decompiled with CFR 0.152.
 */
package com.sap.ip.me.smartsync.data.sm;

import com.sap.ip.me.api.smartsync.PositionStatusType;
import com.sap.ip.me.api.smartsync.SyncReplyType;
import com.sap.ip.me.smartsync.data.sm.IllegalStateTransitionException;
import com.sap.ip.me.smartsync.data.sm.PositionState;

public class EmptyPositionState
extends PositionState {
    EmptyPositionState() {
    }

    PositionStatusType getPositionStatusType() {
        return null;
    }

    public PositionState newStateOfInsert(boolean isQuarantined, boolean isSvrData) throws IllegalStateTransitionException {
        if (!isQuarantined) {
            if (!isSvrData) {
                return PositionState.LOCAL;
            }
            return PositionState.EMPTY;
        }
        throw new IllegalStateTransitionException("INSERT action on Quarantined Empty is not allowed");
    }

    public PositionState newStateOfModify(boolean isQuarantined) throws IllegalStateTransitionException {
        throw new IllegalStateTransitionException("Action MODIFY on position status EMPTY is illegal");
    }

    public PositionState newStateOfDelete(boolean isQuarantined) throws IllegalStateTransitionException {
        throw new IllegalStateTransitionException("Action DELETE on position status EMPTY is illegal");
    }

    public PositionState newStateOfReplace(boolean isQuarantined) throws IllegalStateTransitionException {
        throw new IllegalStateTransitionException("Action REPLACE on position status EMPTY is illegal");
    }

    public PositionState newStateOfInboundInsert(boolean isQuarantined, boolean isSvrData) throws IllegalStateTransitionException {
        if (isQuarantined && !isSvrData) {
            throw new IllegalStateTransitionException("Action INBOUND DELETE on position status Quarantined Client EMPTY is illegal");
        }
        if (!isQuarantined && isSvrData) {
            return PositionState.EMPTY;
        }
        return PositionState.GLOBAL;
    }

    public PositionState newStateOfInboundModify(boolean isQuarantined, boolean isSvrData) throws IllegalStateTransitionException {
        if (isQuarantined && isSvrData || !isQuarantined && !isSvrData) {
            throw new IllegalStateTransitionException("Action Inbound modify on position status EMPTY is illegal");
        }
        return this;
    }

    public PositionState newStateOfInboundDelete(boolean isQuarantined) throws IllegalStateTransitionException {
        return this;
    }

    public PositionState newStateOfInboundReplace(boolean isQuarantined, boolean isSvrData) throws IllegalStateTransitionException {
        if (isQuarantined) {
            return isSvrData ? PositionState.GLOBAL : PositionState.EMPTY;
        }
        throw new IllegalStateTransitionException("Action INbound replace on position status EMPTY is illegal");
    }

    public PositionState newStateOfInboundResponse(boolean isQuarantined, boolean isSvrData, SyncReplyType replyType) throws IllegalStateTransitionException {
        if (isQuarantined && isSvrData) {
            return PositionState.GLOBAL;
        }
        return PositionState.EMPTY;
    }
}

