/*
 * Decompiled with CFR 0.152.
 */
package com.sap.ip.me.smartsync.data.sm;

import com.sap.ip.me.api.smartsync.SyncBoChangeActionType;
import com.sap.ip.me.api.smartsync.SyncReplyType;
import com.sap.ip.me.smartsync.data.sm.IllegalStateTransitionException;
import com.sap.ip.me.smartsync.data.sm.ProcessingState;
import com.sap.ip.me.smartsync.data.sm.QuarantinedState;

public abstract class AbstractInSyncState
extends ProcessingState {
    public ProcessingState newStateOfInsert() throws IllegalStateTransitionException {
        throw new IllegalStateTransitionException("Action INSERT on processing status IN_SYNC is illegal");
    }

    public ProcessingState newStateOfSyncOut() {
        return this;
    }

    public ProcessingState newStateOfModify() throws IllegalStateTransitionException {
        return this;
    }

    public ProcessingState newStateOfDelete() throws IllegalStateTransitionException {
        return ProcessingState.DESTROYED;
    }

    public ProcessingState newStateOfReplace() throws IllegalStateTransitionException {
        return this;
    }

    public ProcessingState newStateOfInboundDelete(boolean isQuarantined, boolean isSvrData) throws IllegalStateTransitionException {
        return QuarantinedState.DELETION_CONFLICT;
    }

    public ProcessingState newStateOfInboundResponse(boolean isDeltaExisting, boolean forceMerge, SyncReplyType replyType, SyncBoChangeActionType action) throws IllegalStateTransitionException {
        if (action == SyncBoChangeActionType.REPLACE) {
            action = SyncBoChangeActionType.MODIFY;
        }
        if (replyType == SyncReplyType.SUCCESS) {
            if (isDeltaExisting) {
                return this;
            }
            return ProcessingState.SYNCED;
        }
        if (replyType == SyncReplyType.ERROR) {
            if (action == SyncBoChangeActionType.INSERT) {
                return QuarantinedState.INSERTION_ERROR;
            }
            if (action == SyncBoChangeActionType.MODIFY) {
                return QuarantinedState.MODIFICATION_ERROR;
            }
            if (action == SyncBoChangeActionType.DELETE) {
                return QuarantinedState.DELETION_ERROR;
            }
        } else if (replyType == SyncReplyType.CONFLICT) {
            if (action == SyncBoChangeActionType.INSERT) {
                return QuarantinedState.INSERTION_CONFLICT;
            }
            if (action == SyncBoChangeActionType.MODIFY) {
                return QuarantinedState.MODIFICATION_CONFLICT;
            }
            if (action == SyncBoChangeActionType.DELETE) {
                return QuarantinedState.DELETION_CONFLICT;
            }
        }
        throw new IllegalArgumentException(isDeltaExisting + "," + replyType);
    }

    public ProcessingState newStateOfResolveQuarantinedSyncBo() throws IllegalStateTransitionException {
        throw new IllegalStateTransitionException("This method can not be called on a IN_SYNC state");
    }

    public ProcessingState newStateOfInboundReplace(boolean isQuarantined, boolean isSvrData) throws IllegalStateTransitionException {
        return QuarantinedState.MODIFICATION_CONFLICT;
    }

    public ProcessingState newStateOfInboundInsert(boolean isQuarantined, boolean isSvrData) throws IllegalStateTransitionException {
        throw new IllegalStateTransitionException("This method can not be called on a IN_SYNC state");
    }

    public ProcessingState newStateOfInboundModify(boolean isQuarantined, boolean isSvrData) throws IllegalStateTransitionException {
        return ProcessingState.CONFLICT_WAITING;
    }
}

