/*
 * Decompiled with CFR 0.152.
 */
package com.sap.ip.me.smartsync.data;

import com.sap.ip.me.api.logging.Trace;
import com.sap.ip.me.api.persist.app.EntityFactory;
import com.sap.ip.me.api.persist.app.PackagePersistenceMaster;
import com.sap.ip.me.api.persist.app.PersistableEntity;
import com.sap.ip.me.api.persist.core.PersistenceContainer;
import com.sap.ip.me.api.persist.core.PersistenceException;
import com.sap.ip.me.api.persist.core.TreeOptionType;
import com.sap.ip.me.api.persist.meta.AttributeDescriptor;
import com.sap.ip.me.api.persist.meta.AttributeType;
import com.sap.ip.me.api.persist.meta.ClassDescriptor;
import com.sap.ip.me.api.persist.meta.DescriptorException;
import com.sap.ip.me.api.persist.meta.DescriptorRuntime;
import com.sap.ip.me.api.persist.meta.LinkDescriptor;
import com.sap.ip.me.smartsync.ipi.PersistenceAdapter;
import com.sap.ip.me.smartsync.ipi.PersistenceConstants;
import com.sap.ip.me.smartsync.ipi.SmartSyncEntityFactory;

final class SyncKeyManager
implements EntityFactory,
PackagePersistenceMaster {
    private static final Integer INITIAL_NO = new Integer(0);
    private static final String LEADING_ZEROS_STR = "0000000000";
    private static final String KEY = "smartsync.SyncKeyManager";
    private static final Trace TRACE = Trace.getInstance("MI/Smartsync");
    private final PersistenceAdapter dataPersistenceAdapter;
    private static final int SYNC_KEY_LENGTH = 10;
    private ClassDescriptor cdes;

    SyncKeyManager(PersistenceAdapter dataPersistenceAdapter, DescriptorRuntime descriptorRuntime) throws DescriptorException {
        if (dataPersistenceAdapter == null) {
            throw new NullPointerException("dataPersistenceAdapter");
        }
        if (descriptorRuntime == null) {
            throw new NullPointerException("descriptorRuntime");
        }
        this.dataPersistenceAdapter = dataPersistenceAdapter;
        AttributeDescriptor[] att = new AttributeDescriptor[]{descriptorRuntime.createAttributeDescriptor("SYNC_KEY", AttributeType.INTEGER, 1, 10)};
        this.cdes = descriptorRuntime.createClassDescriptor(PersistenceConstants.SYNC_KEY_MANAGER_CLASSTYPE, att, new LinkDescriptor[0], 10);
    }

    private SyncKey readSyncKeyObject() throws PersistenceException {
        SyncKey syncKey = (SyncKey)this.dataPersistenceAdapter.get(this.cdes, KEY, 2);
        if (syncKey == null) {
            PersistenceContainer o = this.dataPersistenceAdapter.getPersistedObjectFactory().createPersistedObject(this.cdes, KEY);
            syncKey = new SyncKey(o);
            syncKey.reset();
        }
        return syncKey;
    }

    public PersistableEntity createEntity(PersistenceContainer o) {
        return new SyncKey(o);
    }

    String createKey() throws PersistenceException {
        SyncKey key = this.readSyncKeyObject();
        String result = key.incrementAndGet();
        this.dataPersistenceAdapter.update(key, TreeOptionType.SKELETON, 2);
        return result;
    }

    public String[] getClasstypes() {
        return new String[]{PersistenceConstants.SYNC_KEY_MANAGER_CLASSTYPE};
    }

    public ClassDescriptor getClassDescriptor(String classtype) {
        return this.cdes;
    }

    boolean registerPersistenceMaster() {
        try {
            this.dataPersistenceAdapter.registerPersistenceMaster(this);
        }
        catch (PersistenceException e) {
            if (TRACE.isLogging(50)) {
                TRACE.log(50, "SyncKeyManager.registerPersistenceMaster: " + e.toString());
            }
            throw new RuntimeException(e.toString());
        }
        return true;
    }

    void registerEntityFactory(SmartSyncEntityFactory factory) {
        factory.registerMember(PersistenceConstants.SYNC_KEY_MANAGER_CLASSTYPE_PREFIX, (EntityFactory)this);
    }

    void deleteAllPersistedData() throws PersistenceException {
        this.dataPersistenceAdapter.deleteAll(this.cdes, TreeOptionType.COMPLETE, 2);
    }

    final class SyncKey
    implements PersistableEntity {
        private final PersistenceContainer o;

        SyncKey(PersistenceContainer o) {
            this.o = o;
        }

        String incrementAndGet() {
            int intVal = (Integer)this.o.getAttribute(0) + 1;
            this.o.setAttribute(0, new Integer(intVal));
            String keyCounterStr = Integer.toString(intVal);
            return SyncKeyManager.LEADING_ZEROS_STR.substring(keyCounterStr.length()) + keyCounterStr;
        }

        void reset() {
            this.o.setAttribute(0, INITIAL_NO);
        }

        public PersistenceContainer getPersistedObject() {
            return this.o;
        }
    }
}

