/*
 * Decompiled with CFR 0.152.
 */
package com.sap.ip.me.smartsync.data;

import com.sap.ip.me.api.persist.app.PersistableEntity;
import com.sap.ip.me.api.persist.core.PersistenceException;
import com.sap.ip.me.api.persist.core.TreeOptionType;
import com.sap.ip.me.api.persist.meta.ClassDescriptor;
import com.sap.ip.me.api.services.MeIterator;
import com.sap.ip.me.api.smartsync.SmartSyncException;
import com.sap.ip.me.api.smartsync.SyncBoDescriptor;
import com.sap.ip.me.api.smartsync.SyncBoDescriptorIterator;
import com.sap.ip.me.api.smartsync.SyncBoInDelta;
import com.sap.ip.me.api.smartsync.SyncBoResponse;
import com.sap.ip.me.api.smartsync.SyncBoResponseType;
import com.sap.ip.me.smartsync.data.DataClasstypeManager;
import com.sap.ip.me.smartsync.data.MessageManagerImpl;
import com.sap.ip.me.smartsync.data.SyncBoFactory;
import com.sap.ip.me.smartsync.data.SyncBoResponseFactory;
import com.sap.ip.me.smartsync.data.SyncBoResponseImpl;
import com.sap.ip.me.smartsync.ipi.InterMetaPackageManager;
import com.sap.ip.me.smartsync.ipi.PersistenceAdapter;
import com.sap.ip.me.smartsync.ipi.PersistenceConstants;
import java.util.NoSuchElementException;

class SyncBoResponseManager {
    private final SyncBoFactory syncBoFactory;
    private final DataClasstypeManager dataClasstypeManager;
    private final MessageManagerImpl messageManager;
    private final SyncBoResponseFactory syncBoResponseFactory;
    private final PersistenceAdapter dataPersistenceAdapter;
    private final InterMetaPackageManager interMetaPackageManager;
    private static final MeIterator EMPTY_ITR = new MeIterator(){

        public boolean hasNext() {
            return false;
        }

        public Object next() {
            throw new NoSuchElementException();
        }

        public int elementCount() {
            return 0;
        }

        public void reset() {
        }
    };

    SyncBoResponseManager(MessageManagerImpl messageManager, DataClasstypeManager dataClasstypeManager, SyncBoFactory syncBoFactory, SyncBoResponseFactory syncBoResponseFactory, PersistenceAdapter dataPersistenceAdapter, InterMetaPackageManager interMetaPackageManager) {
        if (messageManager == null) {
            throw new NullPointerException("messageManager");
        }
        if (dataClasstypeManager == null) {
            throw new NullPointerException("dataClasstypeManager");
        }
        if (syncBoFactory == null) {
            throw new NullPointerException("syncBoFactory");
        }
        if (syncBoResponseFactory == null) {
            throw new NullPointerException("syncBoResponseFactory");
        }
        if (dataPersistenceAdapter == null) {
            throw new NullPointerException("dataPersistenceAdapter");
        }
        if (interMetaPackageManager == null) {
            throw new NullPointerException("interMetaPackageManager");
        }
        this.dataClasstypeManager = dataClasstypeManager;
        this.messageManager = messageManager;
        this.messageManager.setSyncBoResponseManager(this);
        this.syncBoFactory = syncBoFactory;
        this.syncBoResponseFactory = syncBoResponseFactory;
        this.interMetaPackageManager = interMetaPackageManager;
        this.dataPersistenceAdapter = dataPersistenceAdapter;
    }

    void addSyncBoResponse(SyncBoResponse syncBoResponse) throws PersistenceException, SmartSyncException {
        if (this.getSyncBoResponse(syncBoResponse.getSyncBoDescriptor(), syncBoResponse.getSyncKey()) != null) {
            return;
        }
        this.dataPersistenceAdapter.insert((SyncBoResponseImpl)syncBoResponse, TreeOptionType.COMPLETE, 0);
    }

    SyncBoResponse addSyncBoResponse(SyncBoInDelta inDelta, SyncBoResponseType responseType) throws PersistenceException, SmartSyncException {
        SyncBoResponseImpl res = (SyncBoResponseImpl)this.syncBoResponseFactory.createSyncBoResponse(inDelta, responseType);
        this.addSyncBoResponse(res);
        return res;
    }

    void removeSyncBoResponse(SyncBoDescriptor syncBoDescriptor, String syncKey) throws PersistenceException, SmartSyncException {
        if (this.isAutoResolve()) {
            return;
        }
        SyncBoResponse res = this.getSyncBoResponse(syncBoDescriptor, syncKey);
        if (res == null) {
            return;
        }
        this.removeSyncBoResponse(res);
    }

    private void removeSyncBoResponse(SyncBoResponse syncBoResponse) throws PersistenceException, SmartSyncException {
        this.dataPersistenceAdapter.delete((PersistableEntity)((Object)syncBoResponse), TreeOptionType.COMPLETE, 0);
    }

    void removeAll() throws PersistenceException, SmartSyncException {
        if (this.isAutoResolve()) {
            return;
        }
        SyncBoDescriptorIterator it = this.interMetaPackageManager.getSyncBoDescriptorFacade().getAllSyncBoDescriptors();
        while (it.hasNext()) {
            String classType = DataClasstypeManager.createClasstype(it.next(), PersistenceConstants.SYNC_BO_RESPONSE_CLASSTYPE_PREFIX);
            ClassDescriptor cdes = this.dataClasstypeManager.getSyncBoResponseClassDescriptor(classType);
            this.dataPersistenceAdapter.deleteAll(cdes, TreeOptionType.COMPLETE, 2);
        }
    }

    SyncBoResponse getSyncBoResponse(SyncBoDescriptor syncBoDescriptor, String syncKey) throws PersistenceException, SmartSyncException {
        if (this.isAutoResolve()) {
            return null;
        }
        String classType = DataClasstypeManager.createClasstype(syncBoDescriptor, PersistenceConstants.SYNC_BO_RESPONSE_CLASSTYPE_PREFIX);
        ClassDescriptor cdes = this.dataClasstypeManager.getSyncBoResponseClassDescriptor(classType);
        return (SyncBoResponse)((Object)this.dataPersistenceAdapter.get(cdes, syncKey, 0));
    }

    MeIterator getSyncBoResponses(SyncBoDescriptor syncBoDescriptor) throws PersistenceException, SmartSyncException {
        if (this.isAutoResolve()) {
            return EMPTY_ITR;
        }
        String classType = DataClasstypeManager.createClasstype(syncBoDescriptor, PersistenceConstants.SYNC_BO_RESPONSE_CLASSTYPE_PREFIX);
        ClassDescriptor cdes = this.dataClasstypeManager.getSyncBoResponseClassDescriptor(classType);
        return this.dataPersistenceAdapter.getAll(cdes, 2);
    }

    void updateSyncBoResponse(SyncBoResponse response, SyncBoInDelta inDelta, SyncBoResponseType type) throws SmartSyncException, PersistenceException {
        if (this.isAutoResolve()) {
            return;
        }
        ((SyncBoResponseImpl)response).addResponseLog(this.syncBoResponseFactory.createSyncBoResponseLog(inDelta, type), inDelta.getAction());
        this.dataPersistenceAdapter.update((PersistableEntity)((Object)response), TreeOptionType.COMPLETE, 0);
    }

    private boolean isAutoResolve() {
        return this.messageManager.isAutoResolution(SyncBoResponseType.CONFLICT) && this.messageManager.isAutoResolution(SyncBoResponseType.ERROR);
    }
}

