/*
 * Decompiled with CFR 0.152.
 */
package com.sap.ip.me.smartsync.data;

import com.sap.ip.me.api.logging.Trace;
import com.sap.ip.me.api.persist.app.PersistableEntity;
import com.sap.ip.me.api.persist.core.PersistenceContainer;
import com.sap.ip.me.api.persist.core.PersistenceException;
import com.sap.ip.me.api.services.MeIterator;
import com.sap.ip.me.api.smartsync.SmartSyncException;
import com.sap.ip.me.api.smartsync.SyncBo;
import com.sap.ip.me.api.smartsync.SyncBoChangeActionType;
import com.sap.ip.me.api.smartsync.SyncBoDescriptor;
import com.sap.ip.me.api.smartsync.SyncBoResolver;
import com.sap.ip.me.api.smartsync.SyncBoResponse;
import com.sap.ip.me.api.smartsync.SyncBoResponseLog;
import com.sap.ip.me.api.smartsync.SyncBoResponseType;
import com.sap.ip.me.smartsync.data.SyncBoResponseLogImpl;
import com.sap.ip.me.smartsync.data.SyncBoResponseResolver;
import com.sap.ip.me.smartsync.ipi.PersistenceAdapter;
import com.sap.ip.me.smartsync.ipi.SmartSyncTransaction;

class SyncBoResponseImpl
implements SyncBoResponse,
SyncBoResolver,
PersistableEntity {
    private static final Trace TRACE = Trace.getInstance("MI/API/Smartsync");
    private static final int LINK_RESP_LOG_INDEX = 0;
    private PersistenceContainer persObject;
    private SyncBoResponseType responseType = null;
    private SyncBoDescriptor syncBoDescriptor = null;
    private SyncBoResponseLog currentLog = null;
    private SyncBoChangeActionType actionType = null;
    private final SyncBoResponseResolver resolver;
    private final PersistenceAdapter dataPersistenceAdapter;

    SyncBoResponseImpl(PersistenceAdapter dataPersistenceAdapter, SyncBoResponseResolver resolver, PersistenceContainer persObject, SyncBoDescriptor syncBoDescriptor) {
        if (dataPersistenceAdapter == null) {
            throw new NullPointerException("dataPersistenceAdapter");
        }
        if (resolver == null) {
            throw new NullPointerException("resolver");
        }
        if (persObject == null) {
            throw new NullPointerException("persObject");
        }
        if (syncBoDescriptor == null) {
            throw new NullPointerException("syncBoDescriptor");
        }
        this.dataPersistenceAdapter = dataPersistenceAdapter;
        this.resolver = resolver;
        this.persObject = persObject;
        this.syncBoDescriptor = syncBoDescriptor;
    }

    void addResponseLog(SyncBoResponseLog responseLog, SyncBoChangeActionType action) {
        this.currentLog = responseLog;
        this.persObject.addMultipleLink(0, (SyncBoResponseLogImpl)responseLog);
        this.setActionType(action);
        this.setResponseType(responseLog.getResponseType());
    }

    public String getSyncKey() {
        return this.persObject.getKey();
    }

    public MeIterator getHistoryLog() {
        return this.persObject.getMultipleLink(0);
    }

    public SyncBoDescriptor getSyncBoDescriptor() {
        return this.syncBoDescriptor;
    }

    public SyncBoResolver getSyncBoResolver() {
        return this;
    }

    public SyncBoResponseType getResponseType() {
        if (this.responseType == null) {
            this.responseType = SyncBoResponseType.forInteger((Integer)this.persObject.getAttribute(0));
        }
        return this.responseType;
    }

    public SyncBoChangeActionType getActionType() {
        if (this.actionType == null) {
            this.actionType = SyncBoChangeActionType.forString((String)this.persObject.getAttribute(1));
        }
        return this.actionType;
    }

    void setActionType(SyncBoChangeActionType actionType) {
        this.persObject.setAttribute(1, actionType.toString());
        this.actionType = actionType;
    }

    void setResponseType(SyncBoResponseType responseType) {
        this.persObject.setAttribute(0, responseType.toInteger());
        this.responseType = responseType;
    }

    public PersistenceContainer getPersistedObject() {
        return this.persObject;
    }

    public SyncBoResponseLog getCurrentLog() {
        if (this.currentLog == null) {
            MeIterator logs = this.getHistoryLog();
            while (logs.hasNext()) {
                this.currentLog = (SyncBoResponseLog)logs.next();
            }
        }
        return this.currentLog;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public SyncBo getContrarySyncBo() throws SmartSyncException, PersistenceException {
        SyncBo syncBo;
        SmartSyncTransaction tx = null;
        try {
            tx = this.dataPersistenceAdapter.beginTransaction();
            SyncBo result = this.resolver.getContrarySyncBo(this);
            this.dataPersistenceAdapter.commit(tx);
            tx = null;
            syncBo = result;
            Object var5_4 = null;
            if (tx == null) return syncBo;
        }
        catch (Throwable throwable) {
            Object var5_5 = null;
            if (tx == null) throw throwable;
            this.dataPersistenceAdapter.rollback(tx);
            throw throwable;
        }
        this.dataPersistenceAdapter.rollback(tx);
        return syncBo;
    }

    public boolean isContrarySyncBoAServerSyncBo() {
        return this.resolver.isContrarySyncBoAServerSyncBo(this.getResponseType());
    }

    public void revertToServerData() throws SmartSyncException, PersistenceException {
        SmartSyncTransaction tx = this.dataPersistenceAdapter.beginTransaction();
        this.resolver.revertToServerData(this);
        this.dataPersistenceAdapter.commit(tx);
    }

    public void keepClientData() throws SmartSyncException, PersistenceException {
        SmartSyncTransaction tx = this.dataPersistenceAdapter.beginTransaction();
        this.resolver.keepClientData(this);
        this.dataPersistenceAdapter.commit(tx);
    }
}

