/*
 * Decompiled with CFR 0.152.
 */
package com.sap.ip.me.smartsync.data;

import com.sap.ip.me.api.persist.app.EntityFactory;
import com.sap.ip.me.api.persist.app.PersistableEntity;
import com.sap.ip.me.api.persist.core.PersistenceContainer;
import com.sap.ip.me.api.persist.core.PersistenceException;
import com.sap.ip.me.api.persist.meta.ClassDescriptor;
import com.sap.ip.me.api.smartsync.SyncBoDescriptor;
import com.sap.ip.me.api.smartsync.SyncBoInDelta;
import com.sap.ip.me.api.smartsync.SyncBoResponse;
import com.sap.ip.me.api.smartsync.SyncBoResponseLog;
import com.sap.ip.me.api.smartsync.SyncBoResponseType;
import com.sap.ip.me.smartsync.data.DataClasstypeManager;
import com.sap.ip.me.smartsync.data.SyncBoResponseImpl;
import com.sap.ip.me.smartsync.data.SyncBoResponseLogImpl;
import com.sap.ip.me.smartsync.data.SyncBoResponseResolver;
import com.sap.ip.me.smartsync.ipi.PersistenceAdapter;
import com.sap.ip.me.smartsync.ipi.PersistenceConstants;
import com.sap.ip.me.smartsync.ipi.SmartSyncEntityFactory;

public class SyncBoResponseFactory
implements EntityFactory {
    private final DataClasstypeManager dataClasstypeManager;
    private final SyncBoResponseResolver resolver;
    private final PersistenceAdapter dataPersistenceAdapter;

    SyncBoResponseFactory(DataClasstypeManager dataClasstypeManager, SyncBoResponseResolver resolver, PersistenceAdapter dataPersistenceAdapter) {
        if (dataClasstypeManager == null) {
            throw new NullPointerException("dataClasstypeManager");
        }
        if (resolver == null) {
            throw new NullPointerException("resolver");
        }
        if (dataPersistenceAdapter == null) {
            throw new NullPointerException("dataPersistenceAdapter");
        }
        this.dataClasstypeManager = dataClasstypeManager;
        this.resolver = resolver;
        this.dataPersistenceAdapter = dataPersistenceAdapter;
    }

    public PersistableEntity createEntity(PersistenceContainer o) {
        String classtype = o.getClasstype();
        SyncBoDescriptor boDesc = this.dataClasstypeManager.getSyncBoDescriptor(classtype);
        if (PersistenceConstants.SYNC_BO_RESPONSE_CLASSTYPE_PREFIX == classtype.charAt(0)) {
            return new SyncBoResponseImpl(this.dataPersistenceAdapter, this.resolver, o, boDesc);
        }
        if (PersistenceConstants.SYNC_BO_RESPONSE_LOG_CLASSTYPE_PREFIX == classtype.charAt(0)) {
            return new SyncBoResponseLogImpl(o);
        }
        throw new RuntimeException("unsupported classtype " + classtype);
    }

    public void registerEntityFactory(SmartSyncEntityFactory factory) {
        factory.registerMember(new char[]{PersistenceConstants.SYNC_BO_RESPONSE_CLASSTYPE_PREFIX, PersistenceConstants.SYNC_BO_RESPONSE_LOG_CLASSTYPE_PREFIX}, (EntityFactory)this);
    }

    SyncBoResponse createSyncBoResponse(SyncBoInDelta inDelta, SyncBoResponseType responseType) throws PersistenceException {
        String responseClassType = DataClasstypeManager.createClasstype(inDelta.getSyncBoDescriptor(), PersistenceConstants.SYNC_BO_RESPONSE_CLASSTYPE_PREFIX);
        ClassDescriptor responseClassDesc = this.dataClasstypeManager.getSyncBoResponseClassDescriptor(responseClassType);
        PersistenceContainer syncBoResponseObject = this.dataPersistenceAdapter.getPersistedObjectFactory().createPersistedObject(responseClassDesc, (String)inDelta.getSyncKey());
        SyncBoResponseImpl response = new SyncBoResponseImpl(this.dataPersistenceAdapter, this.resolver, syncBoResponseObject, inDelta.getSyncBoDescriptor());
        SyncBoResponseLog log = this.createSyncBoResponseLog(inDelta, responseType);
        response.addResponseLog(log, inDelta.getAction());
        return response;
    }

    SyncBoResponseLog createSyncBoResponseLog(SyncBoInDelta inDelta, SyncBoResponseType responseType) throws PersistenceException {
        String logClassType = DataClasstypeManager.createClasstype(inDelta.getSyncBoDescriptor(), PersistenceConstants.SYNC_BO_RESPONSE_LOG_CLASSTYPE_PREFIX);
        ClassDescriptor logClassDesc = this.dataClasstypeManager.getSyncBoResponseLogClassDescriptor(logClassType);
        PersistenceContainer logObject = this.dataPersistenceAdapter.getPersistedObjectFactory().createPersistedObject(logClassDesc, String.valueOf(inDelta.getSyncReply().getNumber()));
        SyncBoResponseLogImpl log = new SyncBoResponseLogImpl(logObject);
        log.setResponseType(responseType);
        log.setText(inDelta.getSyncReply().getText());
        log.setMessageClass(inDelta.getSyncReply().getMessageClass());
        log.setMessageNumber(inDelta.getSyncReply().getNumber());
        log.setTimeStamp(inDelta.getTimeStamp());
        return log;
    }
}

