/*
 * Decompiled with CFR 0.152.
 */
package com.sap.ip.me.smartsync.data;

import com.sap.ip.me.api.persist.core.PersistenceException;
import com.sap.ip.me.api.persist.core.TreeOptionType;
import com.sap.ip.me.api.persist.query.Query;
import com.sap.ip.me.api.services.MeIterator;
import com.sap.ip.me.api.smartsync.ModificationNotAllowedException;
import com.sap.ip.me.api.smartsync.Row;
import com.sap.ip.me.api.smartsync.StatusType;
import com.sap.ip.me.api.smartsync.SyncBo;
import com.sap.ip.me.api.smartsync.SyncBoList;
import com.sap.ip.me.core.MeIteratorVectorImpl;
import com.sap.ip.me.core.NestableRuntimeException;
import com.sap.ip.me.smartsync.data.AbstractSyncBoManager;
import com.sap.ip.me.smartsync.data.DataClasstypeManager;
import com.sap.ip.me.smartsync.data.SmartSyncQuery;
import com.sap.ip.me.smartsync.data.SyncBoImpl;
import com.sap.ip.me.smartsync.data.SyncBoListImpl;
import com.sap.ip.me.smartsync.data.sm.IllegalStateTransitionException;
import com.sap.ip.me.smartsync.data.sm.SyncBoState;
import com.sap.ip.me.smartsync.ipi.InterDeltaPackageManager;
import com.sap.ip.me.smartsync.ipi.InterMetaPackageManager;
import com.sap.ip.me.smartsync.ipi.PersistenceAdapter;
import java.util.Vector;

final class SyncBoManager
extends AbstractSyncBoManager {
    private final InterDeltaPackageManager interDeltaPackageManager;

    public SyncBoManager(DataClasstypeManager dataClasstypeManager, InterDeltaPackageManager interDeltaPackageManager, PersistenceAdapter dataPersistenceAdapter, InterMetaPackageManager interMetaPackageManager) {
        super(dataClasstypeManager, dataPersistenceAdapter, interMetaPackageManager);
        if (interDeltaPackageManager == null) {
            throw new NullPointerException("interDeltaPackageManager");
        }
        this.interDeltaPackageManager = interDeltaPackageManager;
    }

    boolean isQuarantinedManager() {
        return false;
    }

    SyncBoList getSyncBos(Query query) throws PersistenceException {
        if (query instanceof SmartSyncQuery && ((SmartSyncQuery)query).isSyncBoQuery()) {
            MeIterator topRowResult = this.dataPersistenceAdapter.get(query, 0);
            Vector<SyncBo> syncBoResult = new Vector<SyncBo>(topRowResult.elementCount());
            while (topRowResult.hasNext()) {
                syncBoResult.addElement(((Row)topRowResult.next()).getSyncBo());
            }
            SyncBoListImpl resultList = new SyncBoListImpl();
            resultList.set(new MeIteratorVectorImpl(syncBoResult));
            return resultList;
        }
        throw new RuntimeException("Invalid Query: A SyncBoQuery is expected.");
    }

    int size(Query query) throws PersistenceException {
        return this.dataPersistenceAdapter.getCount(query, 0);
    }

    void insertFromApplication(SyncBoImpl syncBo) throws PersistenceException, ModificationNotAllowedException {
        SyncBoState.verifyInsert(syncBo);
        syncBo.verify(syncBo.getVerificationFlag());
        this.createInsertDelta(syncBo);
        SyncBoState currState = new SyncBoState(syncBo.getPositionStatus(), syncBo.getProcessingStatus());
        try {
            SyncBoState nextState = currState.newStateOfInsert();
            syncBo.setPositionStatus(nextState.getMainPositionStatus());
            syncBo.setProcessingStatus(nextState.getMainProcessingStatus());
            syncBo.setStatusForAll(StatusType.LOCAL);
        }
        catch (IllegalStateTransitionException e) {
            throw new NestableRuntimeException(e);
        }
        this.insertFromInDelta(syncBo);
    }

    void createReplaceDelta(SyncBo orgBo, SyncBo syncBo) throws PersistenceException {
        this.interDeltaPackageManager.getInternalOutDeltaFacade().createDeltaForReplaceSyncBo(syncBo, orgBo);
    }

    void createDeleteDelta(SyncBo syncBo) throws PersistenceException {
        this.interDeltaPackageManager.getInternalOutDeltaFacade().createDeltaForDeleteSyncBo(syncBo);
    }

    void createInsertDelta(SyncBo syncBo) throws PersistenceException {
        this.interDeltaPackageManager.getInternalOutDeltaFacade().createDeltaForInsertSyncBo(syncBo);
    }

    void replaceFromApplication(SyncBoImpl original, SyncBoImpl syncBo) throws PersistenceException, ModificationNotAllowedException {
        SyncBoState.verifyReplace(original, (SyncBo)syncBo);
        syncBo.verify(original, original.getVerificationFlag());
        this.createReplaceDelta(original, syncBo);
        SyncBoState currState = new SyncBoState(original.getPositionStatus(), original.getProcessingStatus());
        try {
            SyncBoState nextState = currState.newStateOfReplace();
            syncBo.setPositionStatus(nextState.getMainPositionStatus());
            syncBo.setProcessingStatus(nextState.getMainProcessingStatus());
        }
        catch (IllegalStateTransitionException e) {
            throw new NestableRuntimeException(e);
        }
        super.replace(original, syncBo);
        syncBo.setStatusForAll(original.getStatus());
    }

    void deleteFromApplication(SyncBoImpl syncBo) throws PersistenceException, ModificationNotAllowedException {
        SyncBoState.verifyDelete(syncBo);
        this.createDeleteDelta(syncBo);
        SyncBoState currState = new SyncBoState(syncBo.getPositionStatus(), syncBo.getProcessingStatus());
        try {
            SyncBoState nextState = currState.newStateOfDelete();
            syncBo.setPositionStatus(nextState.getMainPositionStatus());
            syncBo.setProcessingStatus(nextState.getMainProcessingStatus());
        }
        catch (IllegalStateTransitionException e) {
            throw new NestableRuntimeException(e);
        }
        syncBo.setStatusForAll(StatusType.UNLINKED);
        this.dataPersistenceAdapter.delete(syncBo, TreeOptionType.COMPLETE, 0);
    }
}

