/*
 * Decompiled with CFR 0.152.
 */
package com.sap.ip.me.smartsync.data;

import com.sap.ip.me.api.persist.core.PersistenceException;
import com.sap.ip.me.api.persist.query.MultipleSortOrder;
import com.sap.ip.me.api.persist.query.Query;
import com.sap.ip.me.api.persist.query.SingleSortOrder;
import com.sap.ip.me.api.persist.query.SortOrder;
import com.sap.ip.me.api.services.MeComparator;
import com.sap.ip.me.api.services.MeIterator;
import com.sap.ip.me.api.smartsync.FieldDescriptor;
import com.sap.ip.me.api.smartsync.SyncBo;
import com.sap.ip.me.api.smartsync.SyncBoList;
import com.sap.ip.me.core.AbstractMeComparator;
import com.sap.ip.me.core.MeIteratorArrayImpl;
import com.sap.ip.me.core.MeIteratorVectorImpl;
import com.sap.ip.me.core.MeTreeSetImpl;
import com.sap.ip.me.smartsync.data.SmartSyncQuery;
import com.sap.ip.me.smartsync.data.SyncBoCollectionImpl;
import com.sap.ip.me.smartsync.data.SyncBoImpl;
import java.util.Vector;

class SyncBoListImpl
extends SyncBoCollectionImpl
implements SyncBoList {
    private SyncBo[] syncBosBySequence;

    SyncBoListImpl() {
    }

    public SyncBo get(int index) {
        return this.syncBosBySequence[index];
    }

    public SyncBoList getSyncBoList(Query query) {
        if (query instanceof SmartSyncQuery && ((SmartSyncQuery)query).isSyncBoQuery()) {
            try {
                Vector resultSet = ((SmartSyncQuery)query).execute(this.iterator());
                SyncBoListImpl resultList = new SyncBoListImpl();
                resultList.set((MeIterator)new MeIteratorVectorImpl(resultSet), query.getSortOrder());
                return resultList;
            }
            catch (PersistenceException e) {
                throw new RuntimeException(e.toString());
            }
        }
        throw new RuntimeException("Invalid Query: A SyncBoQuery is expected.");
    }

    public int size() {
        return this.syncBosBySequence.length;
    }

    public void sort(SortOrder sortOrder) {
        if (sortOrder == null) {
            return;
        }
        MeTreeSetImpl tmpSyncBos = new MeTreeSetImpl(new SyncBoComparator(sortOrder));
        int i = 0;
        while (i < this.syncBosBySequence.length) {
            tmpSyncBos.add(this.syncBosBySequence[i]);
            ++i;
        }
        this.set(tmpSyncBos.iterator());
    }

    void set(MeIterator syncBos) {
        super.set(syncBos);
        this.syncBosBySequence = new SyncBo[syncBos.elementCount()];
        syncBos.reset();
        int i = 0;
        while (syncBos.hasNext()) {
            this.syncBosBySequence[i] = (SyncBo)syncBos.next();
            ++i;
        }
    }

    void set(MeIterator syncBos, SortOrder sortOrder) {
        if (sortOrder == null) {
            this.set(syncBos);
            return;
        }
        this.set(syncBos, new SyncBoComparator(sortOrder));
    }

    private void set(MeIterator syncBos, MeComparator comparator) {
        super.set(syncBos);
        MeTreeSetImpl tmpSyncBos = new MeTreeSetImpl(comparator);
        syncBos.reset();
        while (syncBos.hasNext()) {
            tmpSyncBos.add(syncBos.next());
        }
        this.set(tmpSyncBos.iterator());
    }

    public MeIterator iterator() {
        return new MeIteratorArrayImpl(this.syncBosBySequence);
    }

    class SyncBoComparator
    extends AbstractMeComparator {
        private final SortOrder sortOrder;

        SyncBoComparator(SortOrder sortOrder) {
            this.sortOrder = sortOrder;
        }

        private int compare(Object o1, Object o2, SortOrder sortOrder) {
            if (!sortOrder.isMultiple()) {
                Object vo2;
                SingleSortOrder singleSortOrder = (SingleSortOrder)sortOrder;
                Object vo1 = o1 instanceof SyncBoImpl ? ((SyncBoImpl)o1).getTopRow().getFieldValue((FieldDescriptor)singleSortOrder.getAttributeDescriptor()) : o1;
                Object object = vo2 = o2 instanceof SyncBoImpl ? ((SyncBoImpl)o2).getTopRow().getFieldValue((FieldDescriptor)singleSortOrder.getAttributeDescriptor()) : o2;
                if (singleSortOrder.isAscending()) {
                    return this.compareTo(vo2, vo1);
                }
                return this.compareTo(vo1, vo2);
            }
            MultipleSortOrder multipleSortOrder = (MultipleSortOrder)sortOrder;
            MeIterator itr = multipleSortOrder.getSortOrders();
            while (itr.hasNext()) {
                SortOrder sub_sortOrder = (SortOrder)itr.next();
                int sub_ret = this.compare(o1, o2, sub_sortOrder);
                if (sub_ret == 0) continue;
                return sub_ret;
            }
            return 0;
        }

        public int compare(Object o1, Object o2) {
            return this.compare(o1, o2, this.sortOrder);
        }

        public boolean equals(Object obj) {
            return obj == this;
        }
    }
}

