/*
 * Decompiled with CFR 0.152.
 */
package com.sap.ip.me.smartsync.data;

import com.sap.ip.me.api.logging.Trace;
import com.sap.ip.me.api.persist.app.PersistableEntity;
import com.sap.ip.me.api.persist.core.PersistenceContainer;
import com.sap.ip.me.api.persist.core.PersistenceException;
import com.sap.ip.me.api.persist.query.Query;
import com.sap.ip.me.api.services.MeIterator;
import com.sap.ip.me.api.services.PerformanceLog;
import com.sap.ip.me.api.smartsync.InvalidDescriptorException;
import com.sap.ip.me.api.smartsync.ModificationNotAllowedException;
import com.sap.ip.me.api.smartsync.PositionStatusType;
import com.sap.ip.me.api.smartsync.ProcessingStatusType;
import com.sap.ip.me.api.smartsync.Row;
import com.sap.ip.me.api.smartsync.RowChangeActionType;
import com.sap.ip.me.api.smartsync.RowCollection;
import com.sap.ip.me.api.smartsync.RowDescriptor;
import com.sap.ip.me.api.smartsync.RowDescriptorIterator;
import com.sap.ip.me.api.smartsync.RowList;
import com.sap.ip.me.api.smartsync.StatusType;
import com.sap.ip.me.api.smartsync.SyncBo;
import com.sap.ip.me.api.smartsync.SyncBoDescriptor;
import com.sap.ip.me.api.smartsync.SyncBoInDelta;
import com.sap.ip.me.core.CompositeMeIteratorImpl;
import com.sap.ip.me.core.MeIteratorVectorImpl;
import com.sap.ip.me.core.NestableRuntimeException;
import com.sap.ip.me.smartsync.data.CompositeValueVerifier;
import com.sap.ip.me.smartsync.data.DataClasstypeManager;
import com.sap.ip.me.smartsync.data.IllegalInputValueException;
import com.sap.ip.me.smartsync.data.RowCollectionImpl;
import com.sap.ip.me.smartsync.data.RowFactory;
import com.sap.ip.me.smartsync.data.RowImpl;
import com.sap.ip.me.smartsync.data.RowListImpl;
import com.sap.ip.me.smartsync.data.RowManager;
import com.sap.ip.me.smartsync.data.SmartSyncQuery;
import com.sap.ip.me.smartsync.data.SyncBoFactory;
import com.sap.ip.me.smartsync.data.ValueVerifier;
import com.sap.ip.me.smartsync.data.sm.SyncBoState;
import com.sap.ip.me.smartsync.ipi.InternalRowChange;
import com.sap.ip.me.smartsync.ipi.PersistenceAdapter;
import com.sap.ip.me.smartsync.ipi.SmartSyncTransaction;
import java.math.BigInteger;
import java.util.Vector;

final class SyncBoImpl
extends CompositeValueVerifier
implements SyncBo,
PersistableEntity,
ValueVerifier {
    private final PersistenceContainer persistedObject;
    private SyncBoDescriptor descriptor;
    private PositionStatusType positionStatus;
    private ProcessingStatusType processingStatus;
    private String lastGenMsgId;
    private String stateId;
    private String syncKey;
    private final RowManager rowManager;
    private final SyncBoFactory syncBoFactory;
    private final RowFactory rowFactory;
    private final DataClasstypeManager dataClasstypeManager;
    private final PersistenceAdapter dataPersistenceAdapter;
    private static final Trace TRACE = Trace.getInstance("MI/Smartsync");
    private static final String INITIAL_SYNC_BO_TIMESTAMP = "000000000000000000000";

    SyncBoImpl(PersistenceAdapter dataPersistenceAdapter, DataClasstypeManager dataClasstypeManager, SyncBoFactory syncBoFactory, RowFactory rowFactory, RowManager rowManager, PersistenceContainer o, SyncBoDescriptor descriptor) {
        if (dataPersistenceAdapter == null) {
            throw new NullPointerException("dataPersistenceAdapter");
        }
        if (dataClasstypeManager == null) {
            throw new NullPointerException("dataClasstypeManager");
        }
        if (syncBoFactory == null) {
            throw new NullPointerException("syncBoFactory");
        }
        if (rowFactory == null) {
            throw new NullPointerException("rowFactory");
        }
        if (rowManager == null) {
            throw new NullPointerException("rowManager");
        }
        if (o == null) {
            throw new NullPointerException("o");
        }
        if (descriptor == null) {
            throw new NullPointerException("descriptor");
        }
        this.dataPersistenceAdapter = dataPersistenceAdapter;
        this.dataClasstypeManager = dataClasstypeManager;
        this.rowFactory = rowFactory;
        this.syncBoFactory = syncBoFactory;
        this.rowManager = rowManager;
        this.persistedObject = o;
        this.descriptor = descriptor;
        this.persistedObject.setAttribute(0, Boolean.FALSE);
    }

    public PersistenceContainer getPersistedObject() {
        return this.persistedObject;
    }

    public void insertRow(Row row) throws PersistenceException, ModificationNotAllowedException {
        Object perfLogTag = PerformanceLog.methodStarted(this);
        SmartSyncTransaction tx = null;
        try {
            this.verifyOperation(row, RowChangeActionType.INSERT);
            tx = this.dataPersistenceAdapter.beginTransaction();
            this.insertRowLocally((RowImpl)row);
            if (this.getStatus().isLinked()) {
                this.rowManager.insertRowFromApplication(this, (RowImpl)row, !this.isSub());
            }
            this.dataPersistenceAdapter.commit(tx);
            tx = null;
            Object var5_4 = null;
            this.tryRollback("insertRow(Row)", tx);
        }
        catch (Throwable throwable) {
            Object var5_5 = null;
            this.tryRollback("insertRow(Row)", tx);
            PerformanceLog.methodFinished(perfLogTag, "insertRow");
            throw throwable;
        }
        PerformanceLog.methodFinished(perfLogTag, "insertRow");
    }

    void modifyFromInDelta(SyncBoInDelta delta) {
        try {
            MeIterator it = delta.getRowChanges();
            while (it.hasNext()) {
                InternalRowChange rowDelta = (InternalRowChange)it.next();
                RowChangeActionType action = rowDelta.getAction();
                if (action == RowChangeActionType.INSERT) {
                    RowImpl row = this.rowFactory.createForInDelta(this, rowDelta);
                    this.insertRowLocally(row);
                    this.rowManager.insertFromInDelta(this, row, !this.isSub());
                    continue;
                }
                if (action == RowChangeActionType.MODIFY) {
                    String rowKey;
                    int linkPos = this.getPosition(rowDelta.getRowDescriptor());
                    RowImpl row = this.getRow(linkPos, rowKey = (String)rowDelta.getSyncKey());
                    if (row == null) {
                        throw new NullPointerException("Row with key " + rowKey + " for SyncBo " + delta.getSyncKey() + " not found for modify");
                    }
                    this.rowFactory.updateInDelta(row, rowDelta);
                    this.rowManager.modifyFromInDelta(this, row, !this.isSub());
                    continue;
                }
                if (action == RowChangeActionType.DELETE) {
                    String rowKey = (String)rowDelta.getSyncKey();
                    RowImpl row = (RowImpl)this.getRow(rowDelta.getRowDescriptor(), rowKey);
                    if (row != null) {
                        this.deleteRowLocally(row);
                        this.rowManager.deleteFromInDelta(this, row, !this.isSub());
                        continue;
                    }
                    TRACE.log(60, "SyncBo " + delta.getSyncKey() + " Row " + rowKey + " could not be found for deletion. Ignoring incoming message. ");
                    continue;
                }
                throw new RuntimeException("unsupported change action type " + action + " in SyncBo class");
            }
        }
        catch (PersistenceException e) {
            Trace.getInstance("MI/Persistence").logException(e, true);
            throw new RuntimeException(e.toString());
        }
    }

    void insertRowLocally(RowImpl row) throws PersistenceException {
        if (row.getRowDescriptor().isTop()) {
            this.persistedObject.setSingleLink(0, row);
        } else {
            int pos = this.getPosition(row.getRowDescriptor());
            this.persistedObject.addMultipleLink(pos, row);
        }
        row.setSyncBo(this);
    }

    private void deleteRowLocally(RowImpl row) throws PersistenceException {
        int linkPos = this.getPosition(row.getRowDescriptor());
        if (linkPos == 0) {
            this.persistedObject.removeSingleLink(linkPos);
        } else {
            int rowPos = this.getRowPositionInMultipleLink(linkPos, row);
            this.persistedObject.removeMultipleLink(linkPos, rowPos);
        }
        row.setSyncBo(null);
        row.setStatus(StatusType.UNLINKED);
    }

    public void deleteRow(Row row) throws PersistenceException, ModificationNotAllowedException {
        SmartSyncTransaction tx = null;
        try {
            tx = this.dataPersistenceAdapter.beginTransaction();
            this.deleteRowWithoutTx(row);
            this.dataPersistenceAdapter.commit(tx);
            tx = null;
            Object var4_3 = null;
            this.tryRollback("deleteRow(Row)", tx);
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            this.tryRollback("deleteRow(Row)", tx);
            throw throwable;
        }
    }

    public void deleteRow(String primaryKey) throws ModificationNotAllowedException, PersistenceException {
        Object perfLogTag = PerformanceLog.methodStarted(this);
        SmartSyncTransaction tx = null;
        try {
            tx = this.dataPersistenceAdapter.beginTransaction();
            Row row = this.getRow(primaryKey);
            this.deleteRowWithoutTx(row);
            this.dataPersistenceAdapter.commit(tx);
            tx = null;
            Object var6_5 = null;
            this.tryRollback("deleteRow(String)", tx);
        }
        catch (Throwable throwable) {
            Object var6_6 = null;
            this.tryRollback("deleteRow(String)", tx);
            PerformanceLog.methodFinished(perfLogTag, "Deprecated deleteRow(key)");
            throw throwable;
        }
        PerformanceLog.methodFinished(perfLogTag, "Deprecated deleteRow(key)");
    }

    public void replaceRow(Row row) throws ModificationNotAllowedException, PersistenceException {
        Object perfLogTag = PerformanceLog.methodStarted(this);
        SmartSyncTransaction tx = null;
        try {
            tx = this.dataPersistenceAdapter.beginTransaction();
            this.verifyOperation(row, RowChangeActionType.MODIFY);
            int linkPos = this.getPosition(row.getRowDescriptor());
            RowImpl prevRow = this.getRow(linkPos, row.getKey());
            if (prevRow == null) {
                throw new RuntimeException("No such row existing:" + prevRow);
            }
            this.replaceRowLocally(linkPos, prevRow, (RowImpl)row);
            if (this.getStatus().isLinked()) {
                this.rowManager.replaceRowFromApplication(this, (RowImpl)row, prevRow, !this.isSub());
            }
            this.dataPersistenceAdapter.commit(tx);
            tx = null;
            Object var7_6 = null;
            this.tryRollback("replaceRow(Row)", tx);
        }
        catch (Throwable throwable) {
            Object var7_7 = null;
            this.tryRollback("replaceRow(Row)", tx);
            PerformanceLog.methodFinished(perfLogTag, "replaceRow");
            throw throwable;
        }
        PerformanceLog.methodFinished(perfLogTag, "replaceRow");
    }

    private RowImpl replaceRowLocally(int linkPos, RowImpl prevRow, RowImpl row) throws PersistenceException {
        if (linkPos == 0) {
            this.persistedObject.removeSingleLink(linkPos);
            this.persistedObject.setSingleLink(linkPos, row);
        } else {
            int rowPos = this.getRowPositionInMultipleLink(linkPos, row);
            this.persistedObject.setMultipleLink(linkPos, rowPos, row);
        }
        prevRow.setSyncBo(null);
        row.setSyncBo(this);
        return prevRow;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Row getRow(String key) throws PersistenceException {
        Row row;
        SmartSyncTransaction tx;
        Object perfLogTag;
        block10: {
            Row row2;
            block11: {
                Row row3;
                block9: {
                    if (key == null) {
                        throw new NullPointerException();
                    }
                    perfLogTag = PerformanceLog.methodStarted(this);
                    tx = null;
                    try {
                        tx = this.dataPersistenceAdapter.beginTransaction();
                        if (key.equals(this.persistedObject.getKey())) {
                            Row result = (Row)((Object)this.persistedObject.getSingleLink(0));
                            this.dataPersistenceAdapter.commit(tx);
                            tx = null;
                            row3 = result;
                            Object var11_8 = null;
                            this.tryRollback("getRow(String)", tx);
                            break block9;
                        }
                        int linkCount = this.getLinkCount();
                        int x = 1;
                        block2: while (true) {
                            if (x >= linkCount) {
                                this.dataPersistenceAdapter.commit(tx);
                                tx = null;
                                row = null;
                                break block10;
                            }
                            int max = this.persistedObject.sizeLink(x);
                            int y = 0;
                            while (true) {
                                if (y >= max) {
                                    ++x;
                                    continue block2;
                                }
                                Row r = (Row)((Object)this.persistedObject.getMultipleLink(x, y));
                                if (r.getKey().equals(key)) {
                                    this.dataPersistenceAdapter.commit(tx);
                                    tx = null;
                                    row2 = r;
                                    break block11;
                                }
                                ++y;
                            }
                            break;
                        }
                    }
                    catch (Throwable throwable) {
                        Object var11_11 = null;
                        this.tryRollback("getRow(String)", tx);
                        PerformanceLog.methodFinished(perfLogTag, "Deprecated getRow(key)");
                        throw throwable;
                    }
                }
                PerformanceLog.methodFinished(perfLogTag, "Deprecated getRow(key)");
                return row3;
            }
            Object var11_9 = null;
            this.tryRollback("getRow(String)", tx);
            PerformanceLog.methodFinished(perfLogTag, "Deprecated getRow(key)");
            return row2;
        }
        Object var11_10 = null;
        this.tryRollback("getRow(String)", tx);
        PerformanceLog.methodFinished(perfLogTag, "Deprecated getRow(key)");
        return row;
    }

    public Row getRow(RowDescriptor rdes, String primaryKey) throws PersistenceException {
        RowImpl rowImpl;
        Object perfLogTag = PerformanceLog.methodStarted(this);
        SmartSyncTransaction tx = null;
        try {
            tx = this.dataPersistenceAdapter.beginTransaction();
            int linkPos = this.getPosition(rdes);
            RowImpl result = this.getRow(linkPos, primaryKey);
            this.dataPersistenceAdapter.commit(tx);
            tx = null;
            rowImpl = result;
            Object var9_8 = null;
            this.tryRollback("getRow(getRow, String)", tx);
        }
        catch (Throwable throwable) {
            Object var9_9 = null;
            this.tryRollback("getRow(getRow, String)", tx);
            PerformanceLog.methodFinished(perfLogTag, "getRow(desc,key)");
            throw throwable;
        }
        PerformanceLog.methodFinished(perfLogTag, "getRow(desc,key)");
        return rowImpl;
    }

    private int getRowPositionInMultipleLink(int linkPos, Row row) {
        int max = this.persistedObject.sizeLink(linkPos);
        String key = ((PersistableEntity)((Object)row)).getPersistedObject().getKey();
        int x = 0;
        while (x < max) {
            PersistableEntity cmpRow = this.persistedObject.getMultipleLink(linkPos, x);
            if (key.equals(cmpRow.getPersistedObject().getKey())) {
                return x;
            }
            ++x;
        }
        return -1;
    }

    private RowImpl getRow(int linkPos, String key) {
        if (linkPos == 0) {
            return (RowImpl)this.persistedObject.getSingleLink(linkPos);
        }
        int max = this.persistedObject.sizeLink(linkPos);
        int x = 0;
        while (x < max) {
            PersistableEntity row = this.persistedObject.getMultipleLink(linkPos, x);
            if (key.equals(row.getPersistedObject().getKey())) {
                return (RowImpl)row;
            }
            ++x;
        }
        return null;
    }

    private RowCollection getRowsWithoutTx(RowDescriptor r) {
        int pos = this.getPosition(r);
        MeIterator rows = this.persistedObject.getMultipleLink(pos);
        RowCollectionImpl coll = new RowCollectionImpl(r);
        coll.set(rows);
        return coll;
    }

    public RowCollection getRows(RowDescriptor r) throws PersistenceException {
        RowCollection rowCollection;
        Object perfLogTag = PerformanceLog.methodStarted(this);
        SmartSyncTransaction tx = null;
        try {
            tx = this.dataPersistenceAdapter.beginTransaction();
            RowCollection ret = this.getRowsWithoutTx(r);
            this.dataPersistenceAdapter.commit(tx);
            tx = null;
            rowCollection = ret;
            Object var7_6 = null;
            this.tryRollback("getRows(RowDescriptor)", tx);
        }
        catch (Throwable throwable) {
            Object var7_7 = null;
            this.tryRollback("getRows(RowDescriptor)", tx);
            PerformanceLog.methodFinished(perfLogTag, "getRows(desc)");
            throw throwable;
        }
        PerformanceLog.methodFinished(perfLogTag, "getRows(desc)");
        return rowCollection;
    }

    public RowList getRows(Query query) throws PersistenceException {
        Object perfLogTag = PerformanceLog.methodStarted(this);
        if (query instanceof SmartSyncQuery && !((SmartSyncQuery)query).isSyncBoQuery()) {
            RowListImpl rowListImpl;
            SmartSyncTransaction tx = null;
            try {
                tx = this.dataPersistenceAdapter.beginTransaction();
                RowDescriptor rd = this.dataClasstypeManager.getRowDescriptor(query.getClasstype());
                RowCollection rows = this.getRowsWithoutTx(rd);
                Vector resultSet = ((SmartSyncQuery)query).execute(rows.iterator());
                RowListImpl resultList = new RowListImpl(this.dataClasstypeManager, rd);
                resultList.set((MeIterator)new MeIteratorVectorImpl(resultSet), query.getSortOrder());
                this.dataPersistenceAdapter.commit(tx);
                tx = null;
                rowListImpl = resultList;
                Object var10_9 = null;
                this.tryRollback("getRows(Query)", tx);
            }
            catch (Throwable throwable) {
                Object var10_10 = null;
                this.tryRollback("getRows(Query)", tx);
                PerformanceLog.methodFinished(perfLogTag, "getRows(query)");
                throw throwable;
            }
            PerformanceLog.methodFinished(perfLogTag, "getRows(query)");
            return rowListImpl;
        }
        throw new RuntimeException("Invalid Query: A RowQuery is expected.");
    }

    public RowCollection[] getRows() throws PersistenceException {
        RowCollection[] rowCollectionArray;
        Object perfLogTag = PerformanceLog.methodStarted(this);
        SmartSyncTransaction tx = null;
        try {
            tx = this.dataPersistenceAdapter.beginTransaction();
            RowDescriptorIterator rowDescriptors = this.descriptor.getAllRowDescriptors();
            RowCollection[] collections = new RowCollection[rowDescriptors.size()];
            int x = 0;
            while (rowDescriptors.hasNext()) {
                collections[x++] = this.getRowsWithoutTx(rowDescriptors.next());
            }
            this.dataPersistenceAdapter.commit(tx);
            tx = null;
            rowCollectionArray = collections;
            Object var8_7 = null;
            this.tryRollback("getRows()", tx);
        }
        catch (Throwable throwable) {
            Object var8_8 = null;
            this.tryRollback("getRows()", tx);
            PerformanceLog.methodFinished(perfLogTag, "getRows()");
            throw throwable;
        }
        PerformanceLog.methodFinished(perfLogTag, "getRows()");
        return rowCollectionArray;
    }

    public SyncBoDescriptor getSyncBoDescriptor() {
        return this.descriptor;
    }

    private Row getTopRowWithoutTx() {
        return (Row)((Object)this.persistedObject.getSingleLink(0));
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Row getTopRow() {
        Row row;
        Object perfLogTag = PerformanceLog.methodStarted(this);
        SmartSyncTransaction tx = null;
        try {
            try {
                tx = this.dataPersistenceAdapter.beginTransaction();
                Row ret = this.getTopRowWithoutTx();
                this.dataPersistenceAdapter.commit(tx);
                tx = null;
                row = ret;
                Object var6_6 = null;
                this.tryRollback("getTopRow()", tx);
            }
            catch (PersistenceException e) {
                throw new NestableRuntimeException(e);
            }
        }
        catch (Throwable throwable) {
            Object var6_7 = null;
            this.tryRollback("getTopRow()", tx);
            PerformanceLog.methodFinished(perfLogTag, "getTopRow");
            throw throwable;
        }
        PerformanceLog.methodFinished(perfLogTag, "getTopRow");
        return row;
    }

    public SyncBo createUnlinkedCopy() throws PersistenceException {
        SyncBo syncBo;
        Object perfLogTag = PerformanceLog.methodStarted(this);
        SmartSyncTransaction tx = null;
        try {
            tx = this.dataPersistenceAdapter.beginTransaction();
            SyncBo result = this.syncBoFactory.createCopy(this, PositionStatusType.UNLINKED);
            this.dataPersistenceAdapter.commit(tx);
            tx = null;
            syncBo = result;
            Object var6_5 = null;
            this.tryRollback("createUnlinkedCopy()", tx);
        }
        catch (Throwable throwable) {
            Object var6_6 = null;
            this.tryRollback("createUnlinkedCopy()", tx);
            PerformanceLog.methodFinished(perfLogTag, "createUnlinkedCopy");
            throw throwable;
        }
        PerformanceLog.methodFinished(perfLogTag, "createUnlinkedCopy");
        return syncBo;
    }

    public SyncBo createInitialCopy() throws PersistenceException {
        SyncBo syncBo;
        Object perfLogTag = PerformanceLog.methodStarted(this);
        SmartSyncTransaction tx = null;
        try {
            tx = this.dataPersistenceAdapter.beginTransaction();
            SyncBo result = this.syncBoFactory.createCopy(this, PositionStatusType.INITIAL);
            this.dataPersistenceAdapter.commit(tx);
            tx = null;
            syncBo = result;
            Object var6_5 = null;
            this.tryRollback("createInitialCopy", tx);
        }
        catch (Throwable throwable) {
            Object var6_6 = null;
            this.tryRollback("createInitialCopy", tx);
            PerformanceLog.methodFinished(perfLogTag, "createInitialCopy");
            throw throwable;
        }
        PerformanceLog.methodFinished(perfLogTag, "createInitialCopy");
        return syncBo;
    }

    public StatusType getStatus() {
        if (this.getProcessingStatus() == ProcessingStatusType.IN_SYNC || this.getProcessingStatus() == ProcessingStatusType.IN_SYNC_CONFLICT_WAITING) {
            return StatusType.IN_SYNC;
        }
        if (this.getPositionStatus() == PositionStatusType.GLOBAL) {
            return StatusType.GLOBAL;
        }
        if (this.getPositionStatus() == PositionStatusType.INITIAL) {
            return StatusType.INITIAL;
        }
        if (this.getPositionStatus() == PositionStatusType.LOCAL) {
            return StatusType.LOCAL;
        }
        if (this.getPositionStatus() == PositionStatusType.UNLINKED) {
            return StatusType.UNLINKED;
        }
        throw new RuntimeException("unsupported position status / processing status (" + this.getPositionStatus() + "/" + this.getProcessingStatus());
    }

    void setStatusForAll(StatusType status) throws PersistenceException {
        this.setStatusForChildren(status);
    }

    void setStatusForChildren(StatusType status) throws PersistenceException {
        boolean area = this.isSub();
        RowImpl top = (RowImpl)this.getTopRowWithoutTx();
        top.setStatus(status);
        int lpos = 1;
        RowDescriptorIterator rit = this.descriptor.getAllRowDescriptors();
        while (rit.hasNext()) {
            RowDescriptor rd = rit.next();
            MeIterator rows = this.persistedObject.getMultipleLink(lpos);
            while (rows.hasNext()) {
                RowImpl row = (RowImpl)rows.next();
                row.setStatus(status);
            }
            ++lpos;
        }
    }

    void setStatusForChildren(SyncBo oldSyncBo) throws PersistenceException {
        ((RowImpl)this.getTopRow()).setStatus(oldSyncBo.getTopRow().getStatus());
        int lpos = 1;
        RowDescriptorIterator rit = this.descriptor.getAllRowDescriptors();
        while (rit.hasNext()) {
            rit.next();
            MeIterator rows = this.persistedObject.getMultipleLink(lpos);
            while (rows.hasNext()) {
                RowImpl row = (RowImpl)rows.next();
                RowImpl oldRow = (RowImpl)oldSyncBo.getRow(row.getRowDescriptor(), row.getKey());
                if (oldRow == null) {
                    row.setStatus(StatusType.LOCAL);
                    continue;
                }
                row.setStatus(oldRow.getStatus());
            }
            ++lpos;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Row createEmptyRow(RowDescriptor descriptor) throws InvalidDescriptorException {
        RowImpl rowImpl;
        Object perfLogTag = PerformanceLog.methodStarted(this);
        SmartSyncTransaction tx = null;
        try {
            try {
                tx = this.dataPersistenceAdapter.beginTransaction();
                RowImpl row = this.rowFactory.createInitial(descriptor);
                this.dataPersistenceAdapter.commit(tx);
                tx = null;
                rowImpl = row;
                Object var7_8 = null;
                this.tryRollback("createEmptyRow(RowDescriptor)", tx);
            }
            catch (PersistenceException e) {
                TRACE.logException(50, "Error while creating emtpty SyncBo. Rollback transction", e, true);
                Row row = null;
                Object var7_9 = null;
                this.tryRollback("createEmptyRow(RowDescriptor)", tx);
                PerformanceLog.methodFinished(perfLogTag, "createEmptyRow");
                return row;
            }
        }
        catch (Throwable throwable) {
            Object var7_10 = null;
            this.tryRollback("createEmptyRow(RowDescriptor)", tx);
            PerformanceLog.methodFinished(perfLogTag, "createEmptyRow");
            throw throwable;
        }
        PerformanceLog.methodFinished(perfLogTag, "createEmptyRow");
        return rowImpl;
    }

    public String getSyncKey() {
        if (this.syncKey == null) {
            BigInteger key = (BigInteger)this.persistedObject.getAttribute(2);
            this.syncKey = (String)this.getSyncBoDescriptor().getTopRowDescriptor().getKeyFieldDescriptor().convertTo21DataType(key);
        }
        return this.syncKey;
    }

    public String getTimeStamp() {
        return (String)this.persistedObject.getAttribute(4);
    }

    void setSub(Boolean isSub) {
        this.persistedObject.setAttribute(0, isSub);
    }

    boolean isSub() {
        return (Boolean)this.persistedObject.getAttribute(0);
    }

    void setSyncKey(String syncKey) {
        this.persistedObject.setAttribute(2, new BigInteger(syncKey));
    }

    void setTimeStamp(String timestamp) {
        this.persistedObject.setAttribute(4, timestamp);
    }

    void setInitialTimeStamp() {
        this.persistedObject.setAttribute(4, INITIAL_SYNC_BO_TIMESTAMP);
    }

    public void verifyOperation(Row row, RowChangeActionType action) throws ModificationNotAllowedException {
        RowDescriptor rowDescriptor = row.getRowDescriptor();
        if (action == RowChangeActionType.INSERT) {
            SyncBoState.verifyInsert(row, this);
        } else if (action == RowChangeActionType.MODIFY) {
            SyncBoState.verifyReplace(row, (SyncBo)this);
        } else if (action == RowChangeActionType.DELETE) {
            SyncBoState.verifyDelete(row, this);
        }
    }

    private int getPosition(RowDescriptor rd) {
        if (rd.isTop()) {
            return 0;
        }
        int pos = this.descriptor.getPosition(rd);
        if (pos < 0) {
            throw new RuntimeException(this.getSyncBoDescriptor().getSyncBoName() + " has no such row descriptor " + rd.getRowName());
        }
        return this.descriptor.getPosition(rd) + 1;
    }

    private int getLinkCount() {
        return this.descriptor.getRowDescriptorCount() + 1;
    }

    private void deleteRowWithoutTx(Row row) throws ModificationNotAllowedException, PersistenceException {
        Object perfLogTag = PerformanceLog.methodStarted(this);
        try {
            this.verifyOperation(row, RowChangeActionType.DELETE);
            this.deleteRowLocally((RowImpl)row);
            if (this.getStatus().isLinked()) {
                this.rowManager.deleteRowFromApplication(this, (RowImpl)row, !this.isSub());
            }
            Object var4_3 = null;
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            PerformanceLog.methodFinished(perfLogTag, "deleteRow(row)");
            throw throwable;
        }
        PerformanceLog.methodFinished(perfLogTag, "deleteRow(row)");
    }

    public void deleteRow(RowDescriptor rowDescriptor, String primaryKey) throws ModificationNotAllowedException, PersistenceException {
        SmartSyncTransaction tx = null;
        try {
            tx = this.dataPersistenceAdapter.beginTransaction();
            this.deleteRowWithoutTx(rowDescriptor, primaryKey);
            this.dataPersistenceAdapter.commit(tx);
            tx = null;
            Object var5_4 = null;
            this.tryRollback("deleteRow(RowDescriptor, String)", tx);
        }
        catch (Throwable throwable) {
            Object var5_5 = null;
            this.tryRollback("deleteRow(RowDescriptor, String)", tx);
            throw throwable;
        }
    }

    private void deleteRowWithoutTx(RowDescriptor rowDescriptor, String primaryKey) throws PersistenceException, ModificationNotAllowedException {
        Row row = this.getRow(rowDescriptor, primaryKey);
        this.deleteRowWithoutTx(row);
    }

    public void deleteRow(RowDescriptor rowDescriptor, BigInteger primaryKey) throws ModificationNotAllowedException, PersistenceException {
        String syncKey = (String)rowDescriptor.getKeyFieldDescriptor().convertTo21DataType(primaryKey);
        SmartSyncTransaction tx = null;
        try {
            tx = this.dataPersistenceAdapter.beginTransaction();
            this.deleteRowWithoutTx(rowDescriptor, syncKey);
            this.dataPersistenceAdapter.commit(tx);
            tx = null;
            Object var6_5 = null;
            this.tryRollback("deleteRow(RowDescriptor, BigInteger)", tx);
        }
        catch (Throwable throwable) {
            Object var6_6 = null;
            this.tryRollback("deleteRow(RowDescriptor, BigInteger)", tx);
            throw throwable;
        }
    }

    public Row getRow(RowDescriptor rowDescriptor, BigInteger primaryKey) throws PersistenceException {
        Row row;
        SmartSyncTransaction tx = null;
        try {
            tx = this.dataPersistenceAdapter.beginTransaction();
            String syncKey = (String)rowDescriptor.getKeyFieldDescriptor().convertTo21DataType(primaryKey);
            if (rowDescriptor.equals(this.getSyncBoDescriptor().getTopRowDescriptor()) && this.getSyncKey().equals(syncKey)) {
                tx = null;
                Row row2 = this.getTopRow();
                Object var8_7 = null;
                this.tryRollback("getRow(RowDescriptor, BigInteger)", tx);
                return row2;
            }
            Row result = this.getRowsWithoutTx(rowDescriptor).get(syncKey);
            this.dataPersistenceAdapter.commit(tx);
            tx = null;
            row = result;
        }
        catch (Throwable throwable) {
            Object var8_9 = null;
            this.tryRollback("getRow(RowDescriptor, BigInteger)", tx);
            throw throwable;
        }
        Object var8_8 = null;
        this.tryRollback("getRow(RowDescriptor, BigInteger)", tx);
        return row;
    }

    public PositionStatusType getPositionStatus() {
        if (this.positionStatus == null) {
            this.positionStatus = PositionStatusType.forString((String)this.persistedObject.getAttribute(1));
        }
        return this.positionStatus;
    }

    void setPositionStatus(PositionStatusType type) {
        this.persistedObject.setAttribute(1, type.toString());
        this.positionStatus = type;
    }

    public ProcessingStatusType getProcessingStatus() {
        if (this.processingStatus == null) {
            this.processingStatus = ProcessingStatusType.forInteger((Integer)this.persistedObject.getAttribute(3));
        }
        return this.processingStatus;
    }

    void setProcessingStatus(ProcessingStatusType type) {
        this.persistedObject.setAttribute(3, type.toInteger());
        this.processingStatus = type;
    }

    String getLastGeneratedMsgId() {
        if (this.lastGenMsgId == null) {
            this.lastGenMsgId = (String)this.persistedObject.getAttribute(6);
        }
        return this.lastGenMsgId;
    }

    void setLastGeneratedMsgId(String messageId) {
        this.persistedObject.setAttribute(6, messageId);
        this.lastGenMsgId = messageId;
    }

    public String getStateId() {
        if (this.stateId == null) {
            this.stateId = (String)this.persistedObject.getAttribute(5);
        }
        return this.stateId;
    }

    void setStateId(String sId) {
        this.persistedObject.setAttribute(5, sId);
        this.stateId = sId;
    }

    private void tryRollback(String message, SmartSyncTransaction tx) {
        block3: {
            if (tx != null) {
                try {
                    this.dataPersistenceAdapter.rollback(tx);
                }
                catch (PersistenceException e) {
                    if (!TRACE.isLogging(50)) break block3;
                    TRACE.logException(50, "Rollback failed at " + message, e, true);
                }
            }
        }
    }

    public void verify(ValueVerifier org, int flag) throws PersistenceException, IllegalInputValueException {
        if (!(org instanceof SyncBo)) {
            throw new IllegalArgumentException("expected SyncBo, but was " + org);
        }
        MeIterator itr = this.getSubValueVerifiers();
        while (itr.hasNext()) {
            Row row = (Row)itr.next();
            ((ValueVerifier)((Object)row)).verify((ValueVerifier)((Object)((SyncBo)((Object)org)).getRow(row.getRowDescriptor(), row.getKey())), flag);
        }
    }

    public MeIterator getSubValueVerifiers() throws PersistenceException {
        RowCollection[] rcs = this.getRows();
        final MeIterator[] itrs = new MeIterator[rcs.length];
        int i = 0;
        while (i < itrs.length) {
            itrs[i] = rcs[i].iterator();
            ++i;
        }
        return new MeIterator(){
            int index = -1;
            MeIterator itr = new CompositeMeIteratorImpl(itrs);

            public boolean hasNext() {
                if (this.index < 0) {
                    return true;
                }
                return this.itr.hasNext();
            }

            public Object next() {
                if (this.index < 0) {
                    ++this.index;
                    return SyncBoImpl.this.getTopRow();
                }
                return this.itr.next();
            }

            public int elementCount() {
                return this.itr.elementCount() + 1;
            }

            public void reset() {
                throw new RuntimeException("unsupported");
            }
        };
    }

    int getVerificationFlag() {
        if (this.getPositionStatus() == PositionStatusType.GLOBAL) {
            return 1;
        }
        if (this.getPositionStatus() == PositionStatusType.LOCAL || this.getPositionStatus() == PositionStatusType.INITIAL) {
            return 0;
        }
        throw new RuntimeException("UNLINKED SyncBo is not allowed to call this method");
    }

    public String toString() {
        try {
            StringBuffer sb = new StringBuffer("<SyncBo objectID=\"").append(this.getSyncKey()).append("\" objectType=\"").append(this.getSyncBoDescriptor().getSyncBoName()).append("\">");
            sb.append(this.getTopRow().toString());
            RowCollection[] colls = this.getRows();
            int i = 0;
            while (i < colls.length) {
                sb.append(colls[i].toString());
                ++i;
            }
            sb.append("</SyncBo>");
            return sb.toString();
        }
        catch (PersistenceException e) {
            e.printStackTrace();
            return "";
        }
    }

    public void modifyRow(Row row) {
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof SyncBoImpl)) {
            return false;
        }
        SyncBoImpl castedObj = (SyncBoImpl)obj;
        return this.persistedObject != null && castedObj.persistedObject != null && this.persistedObject.equals(castedObj.persistedObject) && this.getStateId() != null && castedObj.getStateId() != null && this.getStateId().equals(castedObj.getStateId());
    }
}

