/*
 * Decompiled with CFR 0.152.
 */
package com.sap.ip.me.smartsync.data;

import com.sap.ip.me.api.persist.app.EntityFactory;
import com.sap.ip.me.api.persist.app.PersistableEntity;
import com.sap.ip.me.api.persist.core.PersistenceContainer;
import com.sap.ip.me.api.persist.core.PersistenceException;
import com.sap.ip.me.api.persist.meta.ClassDescriptor;
import com.sap.ip.me.api.persist.meta.LinkDescriptor;
import com.sap.ip.me.api.persist.meta.MultiplicityType;
import com.sap.ip.me.api.services.MeIterator;
import com.sap.ip.me.api.smartsync.PositionStatusType;
import com.sap.ip.me.api.smartsync.ProcessingStatusType;
import com.sap.ip.me.api.smartsync.Row;
import com.sap.ip.me.api.smartsync.StatusType;
import com.sap.ip.me.api.smartsync.SyncBo;
import com.sap.ip.me.api.smartsync.SyncBoDescriptor;
import com.sap.ip.me.api.smartsync.SyncBoInDelta;
import com.sap.ip.me.smartsync.data.DataClasstypeManager;
import com.sap.ip.me.smartsync.data.RowFactory;
import com.sap.ip.me.smartsync.data.RowImpl;
import com.sap.ip.me.smartsync.data.RowManager;
import com.sap.ip.me.smartsync.data.SyncBoImpl;
import com.sap.ip.me.smartsync.data.SyncKeyManager;
import com.sap.ip.me.smartsync.ipi.InternalRowChange;
import com.sap.ip.me.smartsync.ipi.PersistenceAdapter;
import com.sap.ip.me.smartsync.ipi.PersistenceConstants;
import com.sap.ip.me.smartsync.ipi.SmartSyncEntityFactory;

final class SyncBoFactory
implements EntityFactory {
    private final DataClasstypeManager dataClasstypeManager;
    private final RowFactory rowFactory;
    private final SyncKeyManager syncKeyManager;
    private final RowManager rowManager;
    private final PersistenceAdapter dataPersistenceAdapter;

    SyncBoFactory(PersistenceAdapter dataPersistenceAdapter, DataClasstypeManager dataClasstypeManager, RowFactory rowFactory, RowManager rowManager, SyncKeyManager syncKeyManager) {
        if (dataPersistenceAdapter == null) {
            throw new NullPointerException("dataPersistenceAdapter");
        }
        if (dataClasstypeManager == null) {
            throw new NullPointerException("dataClasstypeManager");
        }
        if (rowFactory == null) {
            throw new NullPointerException("rowFactory");
        }
        if (rowManager == null) {
            throw new NullPointerException("rowManager");
        }
        if (syncKeyManager == null) {
            throw new NullPointerException("syncKeyManager");
        }
        this.dataPersistenceAdapter = dataPersistenceAdapter;
        this.dataClasstypeManager = dataClasstypeManager;
        this.rowManager = rowManager;
        this.rowFactory = rowFactory;
        this.syncKeyManager = syncKeyManager;
    }

    public PersistableEntity createEntity(PersistenceContainer o) {
        String classtype = o.getClasstype();
        SyncBoDescriptor boDesc = this.dataClasstypeManager.getSyncBoDescriptor(classtype);
        return new SyncBoImpl(this.dataPersistenceAdapter, this.dataClasstypeManager, this, this.rowFactory, this.rowManager, o, boDesc);
    }

    SyncBo createInitial(SyncBoDescriptor d) throws PersistenceException {
        RowImpl topRow = this.rowFactory.createInitial(d.getTopRowDescriptor());
        ClassDescriptor cdes = this.dataClasstypeManager.getClassDescriptor(d);
        String tmpSyncBoKey = topRow.getKey();
        PersistenceContainer o = this.dataPersistenceAdapter.getPersistedObjectFactory().createPersistedObject(cdes, tmpSyncBoKey);
        SyncBoImpl syncBo = new SyncBoImpl(this.dataPersistenceAdapter, this.dataClasstypeManager, this, this.rowFactory, this.rowManager, o, d);
        syncBo.insertRowLocally(topRow);
        syncBo.setInitialTimeStamp();
        syncBo.setPositionStatus(PositionStatusType.INITIAL);
        syncBo.setProcessingStatus(ProcessingStatusType.CHANGED);
        syncBo.setSyncKey(o.getKey());
        return syncBo;
    }

    SyncBo createCopy(SyncBo original, PositionStatusType status) throws PersistenceException {
        StatusType rowStatusType;
        PersistenceContainer oldSyncBoObj = ((PersistableEntity)((Object)original)).getPersistedObject();
        String newKey = status == PositionStatusType.INITIAL ? this.syncKeyManager.createKey() : oldSyncBoObj.getKey();
        PersistenceContainer newSyncBoObj = this.dataPersistenceAdapter.getPersistedObjectFactory().createPersistedObject(oldSyncBoObj, newKey);
        SyncBoImpl newSyncBo = new SyncBoImpl(this.dataPersistenceAdapter, this.dataClasstypeManager, this, this.rowFactory, this.rowManager, newSyncBoObj, original.getSyncBoDescriptor());
        if (status == PositionStatusType.INITIAL) {
            newSyncBo.setSyncKey(newKey);
            newSyncBo.setInitialTimeStamp();
        }
        newSyncBo.setPositionStatus(status);
        newSyncBo.setProcessingStatus(ProcessingStatusType.CHANGED);
        LinkDescriptor[] ldes = this.dataClasstypeManager.getSyncBoClassDescriptor(oldSyncBoObj.getClasstype()).getLinkDescriptorArray();
        if (status == PositionStatusType.INITIAL) {
            rowStatusType = StatusType.INITIAL;
        } else if (status == PositionStatusType.UNLINKED) {
            rowStatusType = StatusType.UNLINKED;
        } else {
            throw new IllegalArgumentException("not supported PositionStatusType " + status + " in createCopy");
        }
        int x = 0;
        while (x < ldes.length) {
            RowImpl newRowObject;
            if (ldes[x].getMultiplicity() == MultiplicityType.SINGLE) {
                newRowObject = this.rowFactory.createCopy((Row)((Object)oldSyncBoObj.getSingleLink(x)), rowStatusType);
                newRowObject.setSyncBo(newSyncBo);
                newSyncBoObj.setSingleLink(x, newRowObject);
            } else {
                MeIterator links = oldSyncBoObj.getMultipleLink(x);
                while (links.hasNext()) {
                    newRowObject = this.rowFactory.createCopy((Row)links.next(), rowStatusType);
                    newRowObject.setSyncBo(newSyncBo);
                    newSyncBoObj.addMultipleLink(x, newRowObject);
                }
            }
            ++x;
        }
        return newSyncBo;
    }

    SyncBo createForInDelta(SyncBoInDelta inDelta) throws PersistenceException {
        SyncBoDescriptor syncBoDescriptor = inDelta.getSyncBoDescriptor();
        ClassDescriptor cdes = this.dataClasstypeManager.getClassDescriptor(syncBoDescriptor);
        PersistenceContainer syncBoObject = this.dataPersistenceAdapter.getPersistedObjectFactory().createPersistedObject(cdes, (String)inDelta.getSyncKey());
        SyncBoImpl syncBo = new SyncBoImpl(this.dataPersistenceAdapter, this.dataClasstypeManager, this, this.rowFactory, this.rowManager, syncBoObject, syncBoDescriptor);
        syncBo.setSyncKey(syncBoObject.getKey());
        syncBo.setPositionStatus(PositionStatusType.GLOBAL);
        syncBo.setProcessingStatus(ProcessingStatusType.SYNCED);
        syncBo.setTimeStamp(inDelta.getTimeStamp());
        syncBo.setStateId(inDelta.getPostStateId());
        MeIterator rowsIt = inDelta.getRowChanges();
        while (rowsIt.hasNext()) {
            InternalRowChange rowChange = (InternalRowChange)rowsIt.next();
            RowImpl newRow = this.rowFactory.createForInDelta(syncBo, rowChange);
            syncBo.insertRowLocally(newRow);
        }
        return syncBo;
    }

    public void registerEntityFactory(SmartSyncEntityFactory factory) {
        factory.registerMember(PersistenceConstants.SYNC_BO_CLASSTYPE_PREFIX, (EntityFactory)this);
    }
}

