/*
 * Decompiled with CFR 0.152.
 */
package com.sap.ip.me.smartsync.data;

import com.sap.ip.me.api.logging.Trace;
import com.sap.ip.me.api.persist.core.PersistenceException;
import com.sap.ip.me.api.persist.query.JQuery;
import com.sap.ip.me.api.persist.query.JQueryParameterSet;
import com.sap.ip.me.api.persist.query.JQueryResult;
import com.sap.ip.me.api.persist.query.Query;
import com.sap.ip.me.api.services.PerformanceLog;
import com.sap.ip.me.api.smartsync.ModificationNotAllowedException;
import com.sap.ip.me.api.smartsync.Row;
import com.sap.ip.me.api.smartsync.RowCollection;
import com.sap.ip.me.api.smartsync.RowDescriptor;
import com.sap.ip.me.api.smartsync.RowList;
import com.sap.ip.me.api.smartsync.SmartSyncException;
import com.sap.ip.me.api.smartsync.SmartSyncTransactionManager;
import com.sap.ip.me.api.smartsync.SyncBo;
import com.sap.ip.me.api.smartsync.SyncBoCollection;
import com.sap.ip.me.api.smartsync.SyncBoDescriptor;
import com.sap.ip.me.api.smartsync.SyncBoInDelta;
import com.sap.ip.me.api.smartsync.SyncBoList;
import com.sap.ip.me.smartsync.data.RowImpl;
import com.sap.ip.me.smartsync.data.RowManager;
import com.sap.ip.me.smartsync.data.SyncBoFactory;
import com.sap.ip.me.smartsync.data.SyncBoImpl;
import com.sap.ip.me.smartsync.data.SyncBoManager;
import com.sap.ip.me.smartsync.ipi.InternalSyncBoDataFacade;
import com.sap.ip.me.smartsync.ipi.PersistenceAdapter;
import com.sap.ip.me.smartsync.ipi.SmartSyncTransaction;
import java.math.BigInteger;

class SyncBoDataFacadeImpl
implements InternalSyncBoDataFacade {
    private static Trace TRACE = Trace.getInstance("MI/Smartsync");
    private final SyncBoManager syncBoManager;
    private final RowManager rowManager;
    private final SyncBoFactory syncBoFactory;
    private final PersistenceAdapter PERSISTENCE_ADAPTER;

    SyncBoDataFacadeImpl(SyncBoManager syncBoManager, RowManager rowManager, SyncBoFactory syncBoFactory, PersistenceAdapter dataPersistenceAdapter) {
        if (syncBoManager == null) {
            throw new NullPointerException("syncBoManager");
        }
        if (rowManager == null) {
            throw new NullPointerException("rowManager");
        }
        if (syncBoFactory == null) {
            throw new NullPointerException("syncBoFactory");
        }
        if (dataPersistenceAdapter == null) {
            throw new NullPointerException("dataPersistenceAdapter");
        }
        this.syncBoManager = syncBoManager;
        this.rowManager = rowManager;
        this.syncBoFactory = syncBoFactory;
        this.PERSISTENCE_ADAPTER = dataPersistenceAdapter;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public SyncBo createEmptySyncBo(SyncBoDescriptor syncBoDescriptor) throws ModificationNotAllowedException {
        SyncBo syncBo;
        if (syncBoDescriptor == null) {
            throw new NullPointerException("SyncBoDescriptor may not be null");
        }
        Object perfLogTag = null;
        SmartSyncTransaction tx = null;
        try {
            try {
                perfLogTag = PerformanceLog.methodStarted(this);
                tx = this.PERSISTENCE_ADAPTER.beginTransaction();
                SyncBo result = this.syncBoFactory.createInitial(syncBoDescriptor);
                this.PERSISTENCE_ADAPTER.commit(tx);
                tx = null;
                syncBo = result;
                Object var7_8 = null;
                this.tryRollback(tx);
            }
            catch (PersistenceException e) {
                TRACE.logException(50, "createEmptySyncBo", e, true);
                SyncBo syncBo2 = null;
                Object var7_9 = null;
                this.tryRollback(tx);
                PerformanceLog.methodFinished(perfLogTag, "createEmptySyncBo");
                return syncBo2;
            }
        }
        catch (Throwable throwable) {
            Object var7_10 = null;
            this.tryRollback(tx);
            PerformanceLog.methodFinished(perfLogTag, "createEmptySyncBo");
            throw throwable;
        }
        PerformanceLog.methodFinished(perfLogTag, "createEmptySyncBo");
        return syncBo;
    }

    public void deleteSyncBo(SyncBo syncBo) throws PersistenceException, ModificationNotAllowedException {
        Object perfLogTag = null;
        if (syncBo == null) {
            throw new NullPointerException("SyncBo may not be null");
        }
        SmartSyncTransaction tx = null;
        try {
            perfLogTag = PerformanceLog.methodStarted(this);
            tx = this.PERSISTENCE_ADAPTER.beginTransaction();
            this.syncBoManager.deleteFromApplication((SyncBoImpl)syncBo);
            this.PERSISTENCE_ADAPTER.commit(tx);
            tx = null;
            Object var5_4 = null;
            this.tryRollback(tx);
        }
        catch (Throwable throwable) {
            Object var5_5 = null;
            this.tryRollback(tx);
            PerformanceLog.methodFinished(perfLogTag, "deleteSyncBo");
            throw throwable;
        }
        PerformanceLog.methodFinished(perfLogTag, "deleteSyncBo");
    }

    public SyncBo getSyncBo(String primaryKey) throws PersistenceException {
        SyncBoImpl syncBoImpl;
        if (primaryKey == null) {
            throw new NullPointerException("Key may not be null");
        }
        Object perfLogTag = null;
        SmartSyncTransaction tx = null;
        try {
            perfLogTag = PerformanceLog.methodStarted(this);
            tx = this.PERSISTENCE_ADAPTER.beginTransaction();
            SyncBoImpl result = this.syncBoManager.getSyncBo(primaryKey);
            this.PERSISTENCE_ADAPTER.commit(tx);
            tx = null;
            syncBoImpl = result;
            Object var7_6 = null;
            this.tryRollback(tx);
        }
        catch (Throwable throwable) {
            Object var7_7 = null;
            this.tryRollback(tx);
            PerformanceLog.methodFinished(perfLogTag, "Deprecated getSyncBo(key)");
            throw throwable;
        }
        PerformanceLog.methodFinished(perfLogTag, "Deprecated getSyncBo(key)");
        return syncBoImpl;
    }

    public SyncBo getSyncBo(SyncBoDescriptor syncBoDescriptor, String primaryKey) throws PersistenceException {
        SyncBo syncBo;
        if (syncBoDescriptor == null) {
            throw new NullPointerException("SyncBoDescriptor may not be null");
        }
        if (primaryKey == null) {
            throw new NullPointerException("Key may not be null");
        }
        Object perfLogTag = null;
        SmartSyncTransaction tx = null;
        try {
            perfLogTag = PerformanceLog.methodStarted(this);
            tx = this.PERSISTENCE_ADAPTER.beginTransaction();
            SyncBo result = this.syncBoManager.getSyncBo(syncBoDescriptor, primaryKey);
            this.PERSISTENCE_ADAPTER.commit(tx);
            tx = null;
            syncBo = result;
            Object var8_7 = null;
            this.tryRollback(tx);
        }
        catch (Throwable throwable) {
            Object var8_8 = null;
            this.tryRollback(tx);
            PerformanceLog.methodFinished(perfLogTag, "getSyncBo(desc,key)");
            throw throwable;
        }
        PerformanceLog.methodFinished(perfLogTag, "getSyncBo(desc,key)");
        return syncBo;
    }

    public SyncBo getSyncBo(SyncBoDescriptor syncBoDescriptor, BigInteger primaryKey) throws PersistenceException {
        if (syncBoDescriptor == null) {
            throw new NullPointerException("SyncBoDescriptor may not be null");
        }
        if (primaryKey == null) {
            throw new NullPointerException("Key may not be null");
        }
        String syncKey = (String)syncBoDescriptor.getTopRowDescriptor().getKeyFieldDescriptor().convertTo21DataType(primaryKey);
        SmartSyncTransaction tx = null;
        try {
            tx = this.PERSISTENCE_ADAPTER.beginTransaction();
            SyncBo result = this.getSyncBo(syncBoDescriptor, syncKey);
            this.PERSISTENCE_ADAPTER.commit(tx);
            tx = null;
            SyncBo syncBo = result;
            Object var8_7 = null;
            this.tryRollback(tx);
            return syncBo;
        }
        catch (Throwable throwable) {
            Object var8_8 = null;
            this.tryRollback(tx);
            throw throwable;
        }
    }

    public SyncBoCollection getSyncBos(SyncBoDescriptor d) throws PersistenceException {
        SyncBoCollection syncBoCollection;
        if (d == null) {
            throw new NullPointerException("SyncBoDescriptor may not be null");
        }
        Object perfLogTag = null;
        SmartSyncTransaction tx = null;
        try {
            perfLogTag = PerformanceLog.methodStarted(this);
            tx = this.PERSISTENCE_ADAPTER.beginTransaction();
            SyncBoCollection result = this.syncBoManager.getSyncBos(d);
            this.PERSISTENCE_ADAPTER.commit(tx);
            tx = null;
            syncBoCollection = result;
            Object var7_6 = null;
            this.tryRollback(tx);
        }
        catch (Throwable throwable) {
            Object var7_7 = null;
            this.tryRollback(tx);
            PerformanceLog.methodFinished(perfLogTag, "getSyncBos(desc)");
            throw throwable;
        }
        PerformanceLog.methodFinished(perfLogTag, "getSyncBos(desc)");
        return syncBoCollection;
    }

    public SyncBoList getSyncBos(Query q) throws PersistenceException {
        SyncBoList syncBoList;
        if (q == null) {
            throw new NullPointerException("Query may not be null");
        }
        Object perfLogTag = null;
        SmartSyncTransaction tx = null;
        try {
            perfLogTag = PerformanceLog.methodStarted(this);
            tx = this.PERSISTENCE_ADAPTER.beginTransaction();
            SyncBoList result = this.syncBoManager.getSyncBos(q);
            this.PERSISTENCE_ADAPTER.commit(tx);
            tx = null;
            syncBoList = result;
            Object var7_6 = null;
            this.tryRollback(tx);
        }
        catch (Throwable throwable) {
            Object var7_7 = null;
            this.tryRollback(tx);
            PerformanceLog.methodFinished(perfLogTag, "Deprecated getSyncBos(query)");
            throw throwable;
        }
        PerformanceLog.methodFinished(perfLogTag, "Deprecated getSyncBos(query)");
        return syncBoList;
    }

    public int size(Query q) throws PersistenceException {
        int n;
        if (q == null) {
            throw new NullPointerException("Query may not be null");
        }
        Object perfLogTag = null;
        SmartSyncTransaction tx = null;
        try {
            perfLogTag = PerformanceLog.methodStarted(this);
            tx = this.PERSISTENCE_ADAPTER.beginTransaction();
            int result = this.syncBoManager.size(q);
            this.PERSISTENCE_ADAPTER.commit(tx);
            tx = null;
            n = result;
            Object var7_6 = null;
            this.tryRollback(tx);
        }
        catch (Throwable throwable) {
            Object var7_7 = null;
            this.tryRollback(tx);
            PerformanceLog.methodFinished(perfLogTag, "size(query)");
            throw throwable;
        }
        PerformanceLog.methodFinished(perfLogTag, "size(query)");
        return n;
    }

    public Row getRow(String p) throws PersistenceException {
        Row row;
        if (p == null) {
            throw new NullPointerException("Key may not be null");
        }
        Object perfLogTag = null;
        SmartSyncTransaction tx = null;
        try {
            perfLogTag = PerformanceLog.methodStarted(this);
            tx = this.PERSISTENCE_ADAPTER.beginTransaction();
            Row result = this.rowManager.getRow(p, true);
            this.PERSISTENCE_ADAPTER.commit(tx);
            tx = null;
            row = result;
            Object var7_6 = null;
            this.tryRollback(tx);
        }
        catch (Throwable throwable) {
            Object var7_7 = null;
            this.tryRollback(tx);
            PerformanceLog.methodFinished(perfLogTag, "Deprecated getRow(key)");
            throw throwable;
        }
        PerformanceLog.methodFinished(perfLogTag, "Deprecated getRow(key)");
        return row;
    }

    public Row getRow(RowDescriptor rowDescriptor, String key) throws PersistenceException {
        RowImpl rowImpl;
        if (rowDescriptor == null) {
            throw new RuntimeException("RowDescriptor may not be null");
        }
        if (key == null) {
            throw new RuntimeException("Key may not be null");
        }
        Object perfLogTag = null;
        SmartSyncTransaction tx = null;
        try {
            tx = this.PERSISTENCE_ADAPTER.beginTransaction();
            perfLogTag = PerformanceLog.methodStarted(this);
            RowImpl result = this.rowManager.getRow(rowDescriptor, key, true);
            this.PERSISTENCE_ADAPTER.commit(tx);
            tx = null;
            rowImpl = result;
            Object var8_7 = null;
            this.tryRollback(tx);
        }
        catch (Throwable throwable) {
            Object var8_8 = null;
            this.tryRollback(tx);
            PerformanceLog.methodFinished(perfLogTag, "getRow(desc, key)");
            throw throwable;
        }
        PerformanceLog.methodFinished(perfLogTag, "getRow(desc, key)");
        return rowImpl;
    }

    public Row getRow(RowDescriptor rowDescriptor, BigInteger key) throws PersistenceException {
        if (rowDescriptor == null) {
            throw new RuntimeException("RowDescriptor may not be null");
        }
        if (key == null) {
            throw new RuntimeException("Key may not be null");
        }
        SmartSyncTransaction tx = null;
        try {
            tx = this.PERSISTENCE_ADAPTER.beginTransaction();
            String rowKey = (String)rowDescriptor.getKeyFieldDescriptor().convertTo21DataType(key);
            Row result = this.getRow(rowDescriptor, rowKey);
            this.PERSISTENCE_ADAPTER.commit(tx);
            tx = null;
            Row row = result;
            Object var8_7 = null;
            this.tryRollback(tx);
            return row;
        }
        catch (Throwable throwable) {
            Object var8_8 = null;
            this.tryRollback(tx);
            throw throwable;
        }
    }

    public RowCollection getRows(RowDescriptor d) throws PersistenceException {
        RowCollection rowCollection;
        if (d == null) {
            throw new NullPointerException("RowDescriptor may not be null");
        }
        Object perfLogTag = null;
        SmartSyncTransaction tx = null;
        try {
            perfLogTag = PerformanceLog.methodStarted(this);
            tx = this.PERSISTENCE_ADAPTER.beginTransaction();
            RowCollection result = this.rowManager.getRows(d, true);
            this.PERSISTENCE_ADAPTER.commit(tx);
            tx = null;
            rowCollection = result;
            Object var7_6 = null;
            this.tryRollback(tx);
        }
        catch (Throwable throwable) {
            Object var7_7 = null;
            this.tryRollback(tx);
            PerformanceLog.methodFinished(perfLogTag, "getRows(desc)");
            throw throwable;
        }
        PerformanceLog.methodFinished(perfLogTag, "getRows(desc)");
        return rowCollection;
    }

    public RowList getRows(Query q) throws PersistenceException {
        RowList rowList;
        if (q == null) {
            throw new RuntimeException("Query may not be null");
        }
        Object perfLogTag = null;
        SmartSyncTransaction tx = null;
        try {
            perfLogTag = PerformanceLog.methodStarted(this);
            tx = this.PERSISTENCE_ADAPTER.beginTransaction();
            RowList result = this.rowManager.getRows(q, true);
            this.PERSISTENCE_ADAPTER.commit(tx);
            tx = null;
            rowList = result;
            Object var7_6 = null;
            this.tryRollback(tx);
        }
        catch (Throwable throwable) {
            Object var7_7 = null;
            this.tryRollback(tx);
            PerformanceLog.methodFinished(perfLogTag, "getRows(query)");
            throw throwable;
        }
        PerformanceLog.methodFinished(perfLogTag, "getRows(query)");
        return rowList;
    }

    public JQueryResult executeQuery(JQuery query, JQueryParameterSet params, int startIdx, int maxCount) throws PersistenceException, SmartSyncException {
        JQueryResult jQueryResult;
        Object perfLogTag = null;
        SmartSyncTransaction tx = null;
        boolean inTrans = this.PERSISTENCE_ADAPTER.inManualCommitMode();
        try {
            perfLogTag = PerformanceLog.methodStarted(this);
            tx = this.PERSISTENCE_ADAPTER.beginTransaction();
            JQueryResult result = this.PERSISTENCE_ADAPTER.executeQuery(query, params, startIdx, maxCount);
            if (!inTrans) {
                result.prefetchAllRows();
            }
            this.PERSISTENCE_ADAPTER.commit(tx);
            tx = null;
            jQueryResult = result;
            Object var11_10 = null;
            this.tryRollback(tx);
        }
        catch (Throwable throwable) {
            Object var11_11 = null;
            this.tryRollback(tx);
            PerformanceLog.methodFinished(perfLogTag, "executeQuery");
            throw throwable;
        }
        PerformanceLog.methodFinished(perfLogTag, "executeQuery");
        return jQueryResult;
    }

    public JQueryResult executeQuery(JQuery query, JQueryParameterSet params) throws PersistenceException, SmartSyncException {
        return this.executeQuery(query, params, 0, -1);
    }

    public JQueryResult executeQuery(JQuery query, int startIdx, int maxCount) throws PersistenceException, SmartSyncException {
        return this.executeQuery(query, null, startIdx, maxCount);
    }

    public JQueryResult executeQuery(JQuery query) throws PersistenceException, SmartSyncException {
        return this.executeQuery(query, null, 0, -1);
    }

    public void insertSyncBo(SyncBo s) throws PersistenceException, ModificationNotAllowedException {
        if (s == null) {
            throw new RuntimeException("SyncBo may not be null");
        }
        Object perfLogTag = null;
        SmartSyncTransaction tx = null;
        try {
            perfLogTag = PerformanceLog.methodStarted(this);
            tx = this.PERSISTENCE_ADAPTER.beginTransaction();
            this.syncBoManager.insertFromApplication((SyncBoImpl)s);
            this.PERSISTENCE_ADAPTER.commit(tx);
            tx = null;
            Object var5_4 = null;
            this.tryRollback(tx);
        }
        catch (Throwable throwable) {
            Object var5_5 = null;
            this.tryRollback(tx);
            PerformanceLog.methodFinished(perfLogTag, "insertSyncBo");
            throw throwable;
        }
        PerformanceLog.methodFinished(perfLogTag, "insertSyncBo");
    }

    public void replaceSyncBo(SyncBo syncBo) throws PersistenceException, ModificationNotAllowedException {
        if (syncBo == null) {
            throw new RuntimeException("SyncBo may not be null");
        }
        Object perfLogTag = null;
        SmartSyncTransaction tx = null;
        try {
            perfLogTag = PerformanceLog.methodStarted(this);
            tx = this.PERSISTENCE_ADAPTER.beginTransaction();
            SyncBo original = this.syncBoManager.getSyncBo(syncBo.getSyncBoDescriptor(), syncBo.getSyncKey());
            this.syncBoManager.replaceFromApplication((SyncBoImpl)original, (SyncBoImpl)syncBo);
            this.PERSISTENCE_ADAPTER.commit(tx);
            tx = null;
            Object var6_5 = null;
            this.tryRollback(tx);
        }
        catch (Throwable throwable) {
            Object var6_6 = null;
            this.tryRollback(tx);
            PerformanceLog.methodFinished(perfLogTag, "replaceSyncBo");
            throw throwable;
        }
        PerformanceLog.methodFinished(perfLogTag, "replaceSyncBo");
    }

    public void setSyncBoInDelta(SyncBoInDelta inDelta) throws PersistenceException {
        if (inDelta == null || inDelta.getAction() == null) {
            if (TRACE.isLogging(90)) {
                TRACE.log(90, "inDelta of inDelta.getACtion is NULL. Skipping setSyncBoInDelta operation.");
            }
            return;
        }
        switch (inDelta.getAction().toInt()) {
            case 3: {
                SyncBo oldSyncBo = this.syncBoManager.getSyncBo(inDelta.getSyncBoDescriptor(), (String)inDelta.getSyncKey());
                if (oldSyncBo != null) {
                    this.syncBoManager.deleteFromInDelta((SyncBoImpl)oldSyncBo);
                }
            }
            case 0: {
                SyncBo newSyncBo = this.syncBoFactory.createForInDelta(inDelta);
                this.syncBoManager.insertFromInDelta((SyncBoImpl)newSyncBo);
                break;
            }
            case 1: {
                SyncBoImpl modSyncBo = (SyncBoImpl)this.syncBoManager.getSyncBo(inDelta.getSyncBoDescriptor(), (String)inDelta.getSyncKey());
                modSyncBo.modifyFromInDelta(inDelta);
                this.syncBoManager.modifyFromInDelta(modSyncBo);
                break;
            }
            case 2: {
                SyncBo delSyncBo = this.syncBoManager.getSyncBo(inDelta.getSyncBoDescriptor(), (String)inDelta.getSyncKey());
                if (delSyncBo == null) break;
                this.syncBoManager.deleteFromInDelta((SyncBoImpl)delSyncBo);
            }
        }
    }

    public SmartSyncTransactionManager getSmartSyncTransactionManager() throws SmartSyncException {
        return this.PERSISTENCE_ADAPTER.getSmartSyncTransactionManager();
    }

    public void releaseModificationLock() throws PersistenceException {
    }

    public void setModificationLock() throws PersistenceException {
    }

    private void tryRollback(SmartSyncTransaction tx) {
        if (tx != null) {
            try {
                this.PERSISTENCE_ADAPTER.rollback(tx);
            }
            catch (Exception e) {
                TRACE.logException(50, "Can not rollback transaction. ", e, true);
            }
        }
    }
}

