/*
 * Decompiled with CFR 0.152.
 */
package com.sap.ip.me.smartsync.data;

import com.sap.ip.me.api.persist.core.PersistenceException;
import com.sap.ip.me.api.persist.query.Condition;
import com.sap.ip.me.api.persist.query.Query;
import com.sap.ip.me.api.persist.query.SortOrder;
import com.sap.ip.me.api.services.MeIterator;
import com.sap.ip.me.api.smartsync.RowDescriptor;
import com.sap.ip.me.api.smartsync.SyncBoDescriptor;
import com.sap.ip.me.smartsync.data.RowImpl;
import com.sap.ip.me.smartsync.data.SmartSyncCondition;
import com.sap.ip.me.smartsync.data.SyncBoImpl;
import java.util.Vector;

abstract class SmartSyncQuery
implements Query {
    final Query q;
    SmartSyncCondition cond;

    SmartSyncQuery(Query q, SmartSyncCondition cond) {
        if (q == null) {
            throw new NullPointerException("Query must not be null.");
        }
        this.q = q;
        this.cond = cond;
    }

    public Query getQuery() {
        return this.q;
    }

    public Condition getCondition() {
        return this.q.getCondition();
    }

    public SortOrder getSortOrder() {
        return this.q.getSortOrder();
    }

    public String getClasstype() {
        return this.q.getClasstype();
    }

    public int getStartIndex() {
        return this.q.getStartIndex();
    }

    public int getMaxResults() {
        return this.q.getMaxResults();
    }

    public void prepareExecution() throws PersistenceException {
        this.q.prepareExecution();
    }

    abstract boolean isSyncBoQuery();

    abstract Vector execute(MeIterator var1) throws PersistenceException;

    public static RowQuery createRowQuery(Query query, SmartSyncCondition ssCondition, RowDescriptor descriptor) {
        return new RowQuery(query, ssCondition, descriptor);
    }

    public static SyncBoQuery createSyncBoQuery(Query query, SmartSyncCondition ssCondition, SyncBoDescriptor descriptor) {
        return new SyncBoQuery(query, ssCondition, descriptor);
    }

    static final class SyncBoQuery
    extends SmartSyncQuery {
        private final SyncBoDescriptor descriptor;

        SyncBoQuery(Query query, SmartSyncCondition cond, SyncBoDescriptor descriptor) {
            super(query, cond);
            this.descriptor = descriptor;
        }

        boolean isSyncBoQuery() {
            return true;
        }

        Vector execute(MeIterator baseSet) throws PersistenceException {
            Vector<SyncBoImpl> resultSet = new Vector<SyncBoImpl>();
            int x = 0;
            int maxResult = super.getMaxResults();
            baseSet.reset();
            while (baseSet.hasNext()) {
                SyncBoImpl syncBo = (SyncBoImpl)baseSet.next();
                if (syncBo.getSyncBoDescriptor() != this.descriptor || !this.cond.matches(syncBo) || maxResult >= 0 && maxResult <= x++) continue;
                resultSet.addElement(syncBo);
            }
            return resultSet;
        }
    }

    static final class RowQuery
    extends SmartSyncQuery {
        private RowDescriptor descriptor;

        RowQuery(Query query, SmartSyncCondition cond, RowDescriptor descriptor) {
            super(query, cond);
            this.descriptor = descriptor;
        }

        public String getClasstype() {
            return this.q.getClasstype();
        }

        boolean isSyncBoQuery() {
            return false;
        }

        Vector execute(MeIterator baseSet) throws PersistenceException {
            Vector<RowImpl> resultSet = new Vector<RowImpl>();
            RowDescriptor rd = null;
            int x = 0;
            int maxResult = super.getMaxResults();
            baseSet.reset();
            while (baseSet.hasNext()) {
                RowImpl row = (RowImpl)baseSet.next();
                rd = row.getRowDescriptor();
                if (rd != this.descriptor || this.cond == null || !this.cond.matches(row) || maxResult >= 0 && maxResult <= x++) continue;
                resultSet.addElement(row);
            }
            return resultSet;
        }
    }
}

