/*
 * Decompiled with CFR 0.152.
 */
package com.sap.ip.me.smartsync.data;

import com.sap.ip.me.api.persist.meta.AttributeDescriptor;
import com.sap.ip.me.api.persist.meta.ClassDescriptor;
import com.sap.ip.me.api.persist.query.AggregationOperatorType;
import com.sap.ip.me.api.persist.query.JQuery;
import com.sap.ip.me.api.persist.query.JQueryAttribute;
import com.sap.ip.me.api.persist.query.JQueryCondition;
import com.sap.ip.me.api.persist.query.JQueryFactory;
import com.sap.ip.me.api.persist.query.JQueryGroupBy;
import com.sap.ip.me.api.persist.query.JQueryParameter;
import com.sap.ip.me.api.persist.query.JQuerySortOrder;
import com.sap.ip.me.api.persist.query.LogicalOperatorType;
import com.sap.ip.me.api.persist.query.RelationalOperatorType;
import com.sap.ip.me.api.smartsync.FieldDescriptor;
import com.sap.ip.me.api.smartsync.FieldDescriptorIterator;
import com.sap.ip.me.api.smartsync.RelationDescriptor;
import com.sap.ip.me.api.smartsync.RowDescriptor;
import com.sap.ip.me.api.smartsync.SmartSyncJQueryFactory;
import com.sap.ip.me.smartsync.data.DataClasstypeManager;
import java.util.Vector;

public class SmartSyncJQueryFactoryImpl
extends SmartSyncJQueryFactory {
    private final JQueryFactory qf;
    private final DataClasstypeManager dataClasstypeManager;

    public SmartSyncJQueryFactoryImpl(DataClasstypeManager dataClasstypeManager) {
        if (dataClasstypeManager == null) {
            throw new NullPointerException("dataClasstypeManager");
        }
        this.dataClasstypeManager = dataClasstypeManager;
        this.qf = JQueryFactory.getInstance();
    }

    private ClassDescriptor getClassDescriptor(FieldDescriptor f) {
        ClassDescriptor cdesc = this.dataClasstypeManager.getClassDescriptor(f.getRowDescriptor());
        return cdesc;
    }

    private AttributeDescriptor getAttributeDescriptor(FieldDescriptor f, ClassDescriptor cdesc) {
        FieldDescriptor field = f;
        int idx = cdesc.getPosition(field);
        return cdesc.getAttributeDescriptor(idx);
    }

    public JQuery createQuery(JQueryAttribute[] attributes, JQueryCondition cond) throws IllegalArgumentException {
        cond = this.enhanceCondition(cond, attributes);
        return this.qf.createQuery(attributes, cond, false);
    }

    public JQuery createQuery(JQueryAttribute[] attributes, JQueryCondition cond, JQuerySortOrder[] sortOrders) throws IllegalArgumentException {
        cond = this.enhanceCondition(cond, attributes);
        return this.qf.createQuery(attributes, cond, false, sortOrders);
    }

    public JQuery createQuery(JQueryAttribute[] attributes, JQueryCondition cond, JQuerySortOrder sortOrder) throws IllegalArgumentException {
        cond = this.enhanceCondition(cond, attributes);
        return this.qf.createQuery(attributes, cond, false, sortOrder);
    }

    public JQuery createQuery(JQueryAttribute[] attributes, JQueryCondition cond, boolean distinct) throws IllegalArgumentException {
        cond = this.enhanceCondition(cond, attributes);
        return this.qf.createQuery(attributes, cond, distinct);
    }

    public JQuery createQuery(JQueryAttribute[] attributes, JQueryCondition cond, boolean distinct, JQuerySortOrder[] sortOrders) throws IllegalArgumentException {
        cond = this.enhanceCondition(cond, attributes);
        return this.qf.createQuery(attributes, cond, distinct, sortOrders);
    }

    public JQuery createQuery(JQueryAttribute[] attributes, JQueryCondition cond, boolean distinct, JQuerySortOrder sortOrder) throws IllegalArgumentException {
        cond = this.enhanceCondition(cond, attributes);
        return this.qf.createQuery(attributes, cond, distinct, sortOrder);
    }

    public JQuery createQuery(JQueryAttribute[] attributes, JQueryCondition cond, JQuerySortOrder[] sortOrders, JQueryGroupBy groupBy) throws IllegalArgumentException {
        cond = this.enhanceCondition(cond, attributes);
        return this.qf.createQuery(attributes, cond, false, sortOrders, groupBy);
    }

    public JQuery createQuery(JQueryAttribute[] attributes, JQueryCondition cond, boolean distinct, JQuerySortOrder[] sortOrders, JQueryGroupBy groupBy) throws IllegalArgumentException {
        cond = this.enhanceCondition(cond, attributes);
        return this.qf.createQuery(attributes, cond, distinct, sortOrders, groupBy);
    }

    private JQueryCondition enhanceCondition(JQueryCondition cond, JQueryAttribute[] attributes) {
        Vector<ClassDescriptor> classes = new Vector<ClassDescriptor>();
        int i = 0;
        while (i < attributes.length) {
            JQueryAttribute attr = attributes[i];
            ClassDescriptor cdesc = attr.getClassDescriptor();
            if (!classes.contains(cdesc)) {
                classes.addElement(cdesc);
            }
            ++i;
        }
        int size = classes.size();
        int i2 = 0;
        while (i2 < size) {
            ClassDescriptor cdesc = (ClassDescriptor)classes.elementAt(i2);
            JQueryCondition newCond = this.qf.createCondition(this.qf.createAttribute(cdesc, cdesc.getKeyAttributeDescriptor()), RelationalOperatorType.LOWER_THAN, this.qf.createParameter("9999999999"));
            cond = cond == null ? newCond : this.qf.createCondition(cond, LogicalOperatorType.AND, newCond);
            ++i2;
        }
        return cond;
    }

    public JQueryAttribute createAttribute(FieldDescriptor fieldName) {
        ClassDescriptor cdesc = this.getClassDescriptor(fieldName);
        return this.qf.createAttribute(cdesc, this.getAttributeDescriptor(fieldName, cdesc));
    }

    public JQueryAttribute createAttribute(FieldDescriptor fieldName, Object tag) {
        ClassDescriptor cdesc = this.getClassDescriptor(fieldName);
        return this.qf.createAttribute(cdesc, this.getAttributeDescriptor(fieldName, cdesc), tag);
    }

    public JQueryAttribute createAggregate(JQueryAttribute attr, AggregationOperatorType aggreg) {
        return this.qf.createAggregate(attr, aggreg);
    }

    public JQueryParameter createParameter(Object defaultValue) {
        return this.qf.createParameter(defaultValue);
    }

    public JQueryParameter createParameter(Object defaultValue, Object tag) {
        return this.qf.createParameter(defaultValue, tag);
    }

    public JQuerySortOrder createSortOrder(JQueryAttribute attribute) {
        return this.qf.createSortOrder(attribute);
    }

    public JQuerySortOrder createSortOrder(JQueryAttribute attribute, boolean ascending) {
        return this.qf.createSortOrder(attribute, ascending);
    }

    public JQuerySortOrder createSortOrder(JQuerySortOrder[] orders) {
        return this.qf.createSortOrder(orders);
    }

    public JQueryGroupBy createGroupBy(JQueryAttribute[] groupBy) {
        return this.qf.createGroupBy(groupBy);
    }

    public JQueryCondition createCondition(JQueryAttribute left, RelationalOperatorType operator, JQueryParameter right) throws IllegalArgumentException {
        return this.qf.createCondition(left, operator, right);
    }

    public JQueryCondition createCondition(JQueryAttribute left, RelationalOperatorType operator, JQueryAttribute right) throws IllegalArgumentException {
        return this.qf.createCondition(left, operator, right);
    }

    public JQueryCondition createCondition(JQueryAttribute left, RelationalOperatorType operator, Object right) throws IllegalArgumentException {
        return this.qf.createCondition(left, operator, right);
    }

    public JQueryCondition createCondition(JQueryAttribute left, Object[] right) throws IllegalArgumentException {
        return this.qf.createCondition(left, right);
    }

    public JQueryCondition createCondition(JQueryAttribute left, RelationalOperatorType operator, Object right, Object tag) throws IllegalArgumentException {
        return this.qf.createCondition(left, operator, right, tag);
    }

    public JQueryCondition createCondition(JQueryAttribute left, Object[] right, Object tag) throws IllegalArgumentException {
        return this.qf.createCondition(left, right, tag);
    }

    public JQueryCondition createLinkCondition(RowDescriptor topRow, RowDescriptor childRow) {
        ClassDescriptor top = this.dataClasstypeManager.getClassDescriptor(topRow);
        ClassDescriptor child = this.dataClasstypeManager.getClassDescriptor(childRow);
        if (topRow.getSyncBoDescriptor() == childRow.getSyncBoDescriptor()) {
            return this.qf.createCondition(this.qf.createLinkCondition(this.qf.createAttribute(top, top.getLinkDescriptor(0))), LogicalOperatorType.AND, this.qf.createLinkCondition(this.qf.createAttribute(child, child.getLinkDescriptor(0))));
        }
        FieldDescriptorIterator iter = topRow.getAllFieldDescriptors();
        while (iter.hasNext()) {
            FieldDescriptor fdesc = iter.next();
            RelationDescriptor r = fdesc.getRelatedRelation();
            if (r == null || r.getRelatedRowDescriptor() != childRow) continue;
            return this.qf.createCondition(this.qf.createAttribute(top, this.getAttributeDescriptor(fdesc, top)), RelationalOperatorType.EQUALS, this.qf.createAttribute(child, this.getAttributeDescriptor(childRow.getKeyFieldDescriptor(), child)));
        }
        throw new IllegalArgumentException("No relation from " + top.getClasstype() + " to " + child.getClasstype());
    }

    public JQueryCondition createCondition(JQueryCondition left, LogicalOperatorType operator, JQueryCondition right) throws IllegalArgumentException {
        return this.qf.createCondition(left, operator, right);
    }

    public JQueryCondition createCondition(JQueryCondition[] conditions, LogicalOperatorType operator) throws IllegalArgumentException {
        return this.qf.createCondition(conditions, operator);
    }

    public JQueryCondition createCondition(LogicalOperatorType operator, JQueryCondition right) throws IllegalArgumentException {
        return this.qf.createCondition(operator, right);
    }
}

