/*
 * Decompiled with CFR 0.152.
 */
package com.sap.ip.me.smartsync.data;

import com.sap.ip.me.api.persist.core.PersistedObject;
import com.sap.ip.me.api.persist.core.PersistenceException;
import com.sap.ip.me.api.persist.meta.AttributeDescriptor;
import com.sap.ip.me.api.persist.meta.ClassDescriptor;
import com.sap.ip.me.api.persist.query.Condition;
import com.sap.ip.me.api.persist.query.LogicalOperatorType;
import com.sap.ip.me.api.persist.query.RelationalOperatorType;
import com.sap.ip.me.api.services.MeIterator;
import com.sap.ip.me.api.smartsync.FieldDescriptor;
import com.sap.ip.me.api.smartsync.Row;
import com.sap.ip.me.api.smartsync.RowDescriptor;
import com.sap.ip.me.api.smartsync.SmartSyncException;
import com.sap.ip.me.api.smartsync.SyncBo;
import com.sap.ip.me.persist.core.CompositeConditionImpl;
import com.sap.ip.me.persist.core.PrioritizableCompositeCondition;
import com.sap.ip.me.persist.core.PrioritizableSingleCondition;
import com.sap.ip.me.persist.core.SingleConditionImpl;

abstract class SmartSyncCondition
implements Condition {
    SmartSyncCondition() {
    }

    public abstract boolean isComposite();

    public abstract boolean matches(PersistedObject var1) throws PersistenceException;

    public abstract void prepareExecution(ClassDescriptor var1) throws PersistenceException;

    abstract boolean matches(Row var1) throws PersistenceException;

    abstract boolean matches(SyncBo var1) throws PersistenceException;

    abstract boolean verifyConsistency(RowDescriptor var1);

    public static SmartSyncCondition createSingleCondition(SingleConditionImpl singleCondition) {
        return new SmartSyncSingleCondition(singleCondition);
    }

    public static SmartSyncCondition createCompositeCondition(CompositeConditionImpl compCondition) {
        return new SmartSyncCompositeCondition(compCondition);
    }

    static final class SmartSyncCompositeCondition
    extends SmartSyncCondition
    implements PrioritizableCompositeCondition {
        private final CompositeConditionImpl compCond;

        SmartSyncCompositeCondition(CompositeConditionImpl compCond) {
            this.compCond = compCond;
        }

        public MeIterator getComponents() {
            return this.compCond.getComponents();
        }

        public LogicalOperatorType getLogicalOperator() {
            return this.compCond.getLogicalOperator();
        }

        public boolean isComposite() {
            return true;
        }

        public boolean matches(PersistedObject obj) throws PersistenceException {
            return this.compCond.matches(obj);
        }

        public void prepareExecution(ClassDescriptor classDescriptor) throws PersistenceException {
            this.compCond.prepareExecution(classDescriptor);
        }

        public String toString() {
            return this.compCond.toString();
        }

        /*
         * Unable to fully structure code
         */
        boolean matches(Row row) throws PersistenceException {
            components = this.compCond.getComponents();
            if (this.compCond.getLogicalOperator() != LogicalOperatorType.AND) ** GOTO lbl9
            while (components.hasNext()) {
                if (((SmartSyncCondition)components.next()).matches(row)) continue;
                return false;
            }
            return true;
lbl-1000:
            // 1 sources

            {
                if (!((SmartSyncCondition)components.next()).matches(row)) continue;
                return true;
lbl9:
                // 2 sources

                ** while (components.hasNext())
            }
lbl10:
            // 1 sources

            return false;
        }

        /*
         * Unable to fully structure code
         */
        boolean matches(SyncBo syncBo) throws PersistenceException {
            components = this.compCond.getComponents();
            if (this.compCond.getLogicalOperator() != LogicalOperatorType.AND) ** GOTO lbl9
            while (components.hasNext()) {
                if (((SmartSyncCondition)components.next()).matches(syncBo)) continue;
                return false;
            }
            return true;
lbl-1000:
            // 1 sources

            {
                if (!((SmartSyncCondition)components.next()).matches(syncBo)) continue;
                return true;
lbl9:
                // 2 sources

                ** while (components.hasNext())
            }
lbl10:
            // 1 sources

            return false;
        }

        boolean verifyConsistency(RowDescriptor rdes) {
            MeIterator components = this.compCond.getComponents();
            while (components.hasNext()) {
                if (((SmartSyncCondition)components.next()).verifyConsistency(rdes)) continue;
                return false;
            }
            return true;
        }

        public int getPriority() {
            return this.compCond.getPriority();
        }

        public boolean isEmpty() {
            return this.compCond.isEmpty();
        }
    }

    static final class SmartSyncSingleCondition
    extends SmartSyncCondition
    implements PrioritizableSingleCondition {
        private final SingleConditionImpl singleCond;
        private final FieldDescriptor fd;

        SmartSyncSingleCondition(SingleConditionImpl singleCond) {
            this.fd = (FieldDescriptor)singleCond.getAttributeDescriptor();
            this.singleCond = singleCond;
        }

        public RelationalOperatorType getRelationalOperator() {
            return this.singleCond.getRelationalOperator();
        }

        public Object getValue() {
            return this.singleCond.getValue();
        }

        public boolean isComposite() {
            return false;
        }

        public AttributeDescriptor getAttributeDescriptor() {
            return this.singleCond.getAttributeDescriptor();
        }

        public boolean matches(PersistedObject obj) throws PersistenceException {
            return this.singleCond.matches(obj);
        }

        public void prepareExecution(ClassDescriptor classDescriptor) {
            this.singleCond.prepareExecution(classDescriptor);
        }

        public String toString() {
            return this.singleCond.toString();
        }

        boolean matches(Row row) throws PersistenceException {
            try {
                return this.singleCond.matches(row.getField(this.fd).getValue());
            }
            catch (SmartSyncException e) {
                throw new PersistenceException(e.toString());
            }
        }

        boolean matches(SyncBo syncBo) throws PersistenceException {
            RowDescriptor rd = this.fd.getRowDescriptor();
            if (rd.getSyncBoDescriptor().getTopRowDescriptor() == rd) {
                try {
                    return this.singleCond.matches(syncBo.getTopRow().getField(this.fd).getValue());
                }
                catch (SmartSyncException e) {
                    throw new PersistenceException(e.toString());
                }
            }
            return false;
        }

        boolean verifyConsistency(RowDescriptor rdes) {
            return this.fd.getRowDescriptor().equals(rdes);
        }

        public int getPriority() {
            return this.singleCond.getPriority();
        }
    }
}

