/*
 * Decompiled with CFR 0.152.
 */
package com.sap.ip.me.smartsync.data;

import com.sap.ip.me.api.logging.Trace;
import com.sap.ip.me.api.persist.core.PersistenceException;
import com.sap.ip.me.api.persist.core.TreeOptionType;
import com.sap.ip.me.api.persist.meta.ClassDescriptor;
import com.sap.ip.me.api.persist.query.Query;
import com.sap.ip.me.api.services.MeIterator;
import com.sap.ip.me.api.smartsync.ModificationNotAllowedException;
import com.sap.ip.me.api.smartsync.Row;
import com.sap.ip.me.api.smartsync.RowCollection;
import com.sap.ip.me.api.smartsync.RowDescriptor;
import com.sap.ip.me.api.smartsync.RowList;
import com.sap.ip.me.api.smartsync.StatusType;
import com.sap.ip.me.core.NestableRuntimeException;
import com.sap.ip.me.smartsync.data.DataClasstypeManager;
import com.sap.ip.me.smartsync.data.FieldImpl;
import com.sap.ip.me.smartsync.data.RowCollectionImpl;
import com.sap.ip.me.smartsync.data.RowImpl;
import com.sap.ip.me.smartsync.data.RowListImpl;
import com.sap.ip.me.smartsync.data.SmartSyncQuery;
import com.sap.ip.me.smartsync.data.SyncBoImpl;
import com.sap.ip.me.smartsync.data.sm.IllegalStateTransitionException;
import com.sap.ip.me.smartsync.data.sm.SyncBoState;
import com.sap.ip.me.smartsync.ipi.InterDeltaPackageManager;
import com.sap.ip.me.smartsync.ipi.PersistenceAdapter;
import java.math.BigInteger;

final class RowManager {
    private static final Trace TRACE = Trace.getInstance("MI/Smartsync");
    private final DataClasstypeManager dataClasstypeManager;
    private final InterDeltaPackageManager interDeltaPackageManager;
    private final PersistenceAdapter dataPersistenceAdapter;

    RowManager(DataClasstypeManager dataClasstypeManager, InterDeltaPackageManager interDeltaPackageManager, PersistenceAdapter dataPersistenceAdapter) {
        if (dataClasstypeManager == null) {
            throw new NullPointerException("dataClasstypeManager");
        }
        if (interDeltaPackageManager == null) {
            throw new NullPointerException("interDeltaPackageManager");
        }
        if (dataPersistenceAdapter == null) {
            throw new NullPointerException("dataPersistenceAdapter");
        }
        this.dataClasstypeManager = dataClasstypeManager;
        this.interDeltaPackageManager = interDeltaPackageManager;
        this.dataPersistenceAdapter = dataPersistenceAdapter;
    }

    Row getRow(String key, boolean isDefaultArea) throws PersistenceException {
        MeIterator cdesIt = this.dataClasstypeManager.getAllRowClassDescriptors();
        while (cdesIt.hasNext()) {
            Row returnRow = (Row)((Object)this.dataPersistenceAdapter.get((ClassDescriptor)cdesIt.next(), key, isDefaultArea ? 0 : 1));
            if (returnRow == null) continue;
            return returnRow;
        }
        if (TRACE.isLogging(50)) {
            TRACE.log(50, "RowManager.getRow returned NULL. Row of key " + key + " NOT FOUND!");
        }
        throw new PersistenceException("Row of key {0} is not found.", new Object[]{key});
    }

    RowImpl getRow(RowDescriptor rdes, String key, boolean isDefaultArea) throws PersistenceException {
        ClassDescriptor cdes = this.dataClasstypeManager.getClassDescriptor(rdes);
        RowImpl row = null;
        row = (RowImpl)this.dataPersistenceAdapter.get(cdes, key, isDefaultArea ? 0 : 1);
        if (row != null) {
            return row;
        }
        if (TRACE.isLogging(50)) {
            TRACE.log(50, "RowManager.getRow returned NULL. Row of key " + key + " NOT FOUND!");
        }
        throw new PersistenceException("Row of key {0} is not found.", new Object[]{key});
    }

    RowImpl getRow(RowDescriptor rdes, BigInteger key, boolean isDefaultArea) throws PersistenceException {
        String rowKey = (String)rdes.getKeyFieldDescriptor().convertTo21DataType(key);
        return this.getRow(rdes, rowKey, isDefaultArea);
    }

    public RowCollection getRows(RowDescriptor rdes, boolean isDefaultArea) throws PersistenceException {
        ClassDescriptor cdes = this.dataClasstypeManager.getClassDescriptor(rdes);
        MeIterator result = null;
        result = this.dataPersistenceAdapter.getAll(cdes, isDefaultArea ? 0 : 1);
        RowCollectionImpl collection = new RowCollectionImpl(rdes);
        collection.set(result);
        return collection;
    }

    public RowList getRows(Query query, boolean isDefaultArea) throws PersistenceException {
        if (query instanceof SmartSyncQuery) {
            RowDescriptor rd = this.dataClasstypeManager.getRowDescriptor(query.getClasstype());
            MeIterator result = this.dataPersistenceAdapter.get(query, isDefaultArea ? 0 : 1);
            return new RowListImpl(this.dataClasstypeManager, result, rd);
        }
        throw new RuntimeException("Invalid Query: A RowQuery is expected.");
    }

    void insertFromInDelta(SyncBoImpl syncBo, RowImpl row, boolean isDefaultArea) {
        try {
            row.setStatus(StatusType.GLOBAL);
            this.dataPersistenceAdapter.insert(row, TreeOptionType.SKELETON, isDefaultArea ? 0 : 1);
        }
        catch (PersistenceException e) {
            if (TRACE.isLogging(50)) {
                TRACE.logException(50, "Exception at RowManager.insertFromInDelta call.", e, true);
            }
            throw new RuntimeException(e.toString());
        }
    }

    void deleteFromInDelta(SyncBoImpl syncBo, RowImpl row, boolean isDefaultArea) {
        try {
            row.setStatus(StatusType.UNLINKED);
            this.dataPersistenceAdapter.delete(row, TreeOptionType.SKELETON, isDefaultArea ? 0 : 1);
        }
        catch (PersistenceException e) {
            if (TRACE.isLogging(50)) {
                TRACE.logException(50, "Exception at RowManager.deleteFromInDelta call.", e, true);
            }
            throw new RuntimeException(e.toString());
        }
    }

    void modifyFromInDelta(SyncBoImpl syncBo, RowImpl row, boolean isDefaultArea) {
        try {
            this.dataPersistenceAdapter.modify(row, TreeOptionType.SKELETON, isDefaultArea ? 0 : 1);
        }
        catch (PersistenceException e) {
            NestableRuntimeException re = new NestableRuntimeException("Exception at RowManager.modifyFromInDelta call.", e);
            if (TRACE.isLogging(50)) {
                TRACE.logException(50, (Throwable)re, true);
            }
            throw re;
        }
    }

    void insertRowFromApplication(SyncBoImpl syncBo, RowImpl row, boolean isDefaultArea) throws PersistenceException, ModificationNotAllowedException {
        SyncBoState currState = new SyncBoState(syncBo.getPositionStatus(), syncBo.getProcessingStatus());
        try {
            SyncBoState nextState = currState.newStateOfModify();
            syncBo.setPositionStatus(nextState.getMainPositionStatus());
            syncBo.setProcessingStatus(nextState.getMainProcessingStatus());
        }
        catch (IllegalStateTransitionException e) {
            throw new NestableRuntimeException(e);
        }
        row.verify(syncBo.getVerificationFlag());
        row.setStatus(StatusType.LOCAL);
        this.dataPersistenceAdapter.insert(row, TreeOptionType.SKELETON, isDefaultArea ? 0 : 1);
        this.dataPersistenceAdapter.modify(syncBo, TreeOptionType.SKELETON, isDefaultArea ? 0 : 1);
        this.interDeltaPackageManager.getInternalOutDeltaFacade().createDeltaForInsertRow(syncBo, row);
    }

    void deleteRowFromApplication(SyncBoImpl syncBo, RowImpl row, boolean isDefaultArea) throws PersistenceException, ModificationNotAllowedException {
        SyncBoState currState = new SyncBoState(syncBo.getPositionStatus(), syncBo.getProcessingStatus());
        try {
            SyncBoState nextState = currState.newStateOfModify();
            syncBo.setPositionStatus(nextState.getMainPositionStatus());
            syncBo.setProcessingStatus(nextState.getMainProcessingStatus());
        }
        catch (IllegalStateTransitionException e) {
            throw new NestableRuntimeException(e);
        }
        this.dataPersistenceAdapter.delete(row, TreeOptionType.SKELETON, isDefaultArea ? 0 : 1);
        this.dataPersistenceAdapter.modify(syncBo, TreeOptionType.SKELETON, isDefaultArea ? 0 : 1);
        this.interDeltaPackageManager.getInternalOutDeltaFacade().createDeltaForDeleteRow(syncBo, row);
        row.setStatus(StatusType.UNLINKED);
    }

    void replaceRowFromApplication(SyncBoImpl syncBo, RowImpl newRow, RowImpl oldRow, boolean isDefaultArea) throws PersistenceException, ModificationNotAllowedException {
        newRow.verify(syncBo.getVerificationFlag());
        newRow.setStatus(oldRow.getStatus());
        oldRow.setStatus(StatusType.UNLINKED);
        SyncBoState currState = new SyncBoState(syncBo.getPositionStatus(), syncBo.getProcessingStatus());
        try {
            SyncBoState nextState = currState.newStateOfModify();
            syncBo.setPositionStatus(nextState.getMainPositionStatus());
            syncBo.setProcessingStatus(nextState.getMainProcessingStatus());
        }
        catch (IllegalStateTransitionException e) {
            throw new NestableRuntimeException(e);
        }
        syncBo.deleteRow(oldRow);
        syncBo.insertRowLocally(newRow);
        this.insertRowFromApplication(syncBo, newRow, isDefaultArea);
        this.interDeltaPackageManager.getInternalOutDeltaFacade().createDeltaForReplaceRow(syncBo, newRow);
    }

    void modifyFieldFromApplication(SyncBoImpl syncBo, RowImpl row, FieldImpl field, boolean isDefaultArea) throws PersistenceException, ModificationNotAllowedException {
        SyncBoState currState = new SyncBoState(syncBo.getPositionStatus(), syncBo.getProcessingStatus());
        try {
            SyncBoState nextState = currState.newStateOfModify();
            syncBo.setPositionStatus(nextState.getMainPositionStatus());
            syncBo.setProcessingStatus(nextState.getMainProcessingStatus());
        }
        catch (IllegalStateTransitionException e) {
            throw new NestableRuntimeException(e);
        }
        field.verify(syncBo.getVerificationFlag());
        int DATA_AREA = isDefaultArea ? 0 : 1;
        this.dataPersistenceAdapter.modify(row, TreeOptionType.SKELETON, DATA_AREA);
        this.dataPersistenceAdapter.modify(syncBo, TreeOptionType.SKELETON, DATA_AREA);
        this.interDeltaPackageManager.getInternalOutDeltaFacade().createDeltaForModifyField(syncBo, row);
    }
}

