/*
 * Decompiled with CFR 0.152.
 */
package com.sap.ip.me.smartsync.data;

import com.sap.ip.me.api.persist.core.PersistenceException;
import com.sap.ip.me.api.persist.query.MultipleSortOrder;
import com.sap.ip.me.api.persist.query.Query;
import com.sap.ip.me.api.persist.query.SingleSortOrder;
import com.sap.ip.me.api.persist.query.SortOrder;
import com.sap.ip.me.api.services.MeComparator;
import com.sap.ip.me.api.services.MeIterator;
import com.sap.ip.me.api.smartsync.FieldDescriptor;
import com.sap.ip.me.api.smartsync.Row;
import com.sap.ip.me.api.smartsync.RowDescriptor;
import com.sap.ip.me.api.smartsync.RowList;
import com.sap.ip.me.core.AbstractMeComparator;
import com.sap.ip.me.core.MeIteratorArrayImpl;
import com.sap.ip.me.core.MeIteratorVectorImpl;
import com.sap.ip.me.core.MeTreeSetImpl;
import com.sap.ip.me.smartsync.data.DataClasstypeManager;
import com.sap.ip.me.smartsync.data.RowCollectionImpl;
import com.sap.ip.me.smartsync.data.RowImpl;
import com.sap.ip.me.smartsync.data.SmartSyncQuery;
import java.util.Vector;

final class RowListImpl
extends RowCollectionImpl
implements RowList {
    private Row[] rowsBySequence;
    private final DataClasstypeManager dataClasstypeManager;

    RowListImpl(DataClasstypeManager dataClasstypeManager, RowDescriptor rowDesc) {
        super(rowDesc);
        if (dataClasstypeManager == null) {
            throw new NullPointerException("dataClasstypeManager");
        }
        this.dataClasstypeManager = dataClasstypeManager;
    }

    RowListImpl(DataClasstypeManager dataClasstypeManager, MeIterator it, RowDescriptor rowDesc) {
        this(dataClasstypeManager, rowDesc);
        this.set(it);
    }

    public Row get(int index) {
        return this.rowsBySequence[index];
    }

    public RowList getRowList(Query query) {
        if (query instanceof SmartSyncQuery && !((SmartSyncQuery)query).isSyncBoQuery()) {
            try {
                Vector resultSet = ((SmartSyncQuery)query).execute(this.iterator());
                RowDescriptor rd = this.dataClasstypeManager.getRowDescriptor(query.getClasstype());
                RowListImpl resultList = new RowListImpl(this.dataClasstypeManager, rd);
                resultList.set((MeIterator)new MeIteratorVectorImpl(resultSet), query.getSortOrder());
                return resultList;
            }
            catch (PersistenceException e) {
                throw new RuntimeException(e.toString());
            }
        }
        throw new RuntimeException("Invalid Query: A RowQuery is expected.");
    }

    public int size() {
        return this.rowsBySequence.length;
    }

    public MeIterator iterator() {
        return new MeIteratorArrayImpl(this.rowsBySequence);
    }

    public void sort(SortOrder sortOrder) {
        if (sortOrder == null) {
            return;
        }
        MeTreeSetImpl tmpRowsByOrder = new MeTreeSetImpl(new RowComparator(sortOrder));
        int i = 0;
        while (i < this.rowsBySequence.length) {
            tmpRowsByOrder.add(this.rowsBySequence[i]);
            ++i;
        }
        this.set(tmpRowsByOrder.iterator());
    }

    void set(MeIterator rows) {
        super.set(rows);
        this.rowsBySequence = new Row[rows.elementCount()];
        rows.reset();
        int i = 0;
        while (rows.hasNext()) {
            this.rowsBySequence[i] = (Row)rows.next();
            ++i;
        }
    }

    void set(MeIterator rows, SortOrder sortOrder) {
        if (sortOrder == null) {
            this.set(rows);
            return;
        }
        this.set(rows, new RowComparator(sortOrder));
    }

    private void set(MeIterator rows, MeComparator comparator) {
        MeTreeSetImpl tmpRowsByOrder = new MeTreeSetImpl(comparator);
        rows.reset();
        while (rows.hasNext()) {
            tmpRowsByOrder.add(rows.next());
        }
        this.set(tmpRowsByOrder.iterator());
    }

    class RowComparator
    extends AbstractMeComparator {
        private final SortOrder sortOrder;

        RowComparator(SortOrder sortOrder) {
            this.sortOrder = sortOrder;
        }

        int compare(Object o1, Object o2, SortOrder sortOrder) {
            if (!sortOrder.isMultiple()) {
                Object vo2;
                SingleSortOrder singleSortOrder = (SingleSortOrder)sortOrder;
                Object vo1 = o1 instanceof RowImpl ? ((RowImpl)o1).getFieldValue((FieldDescriptor)singleSortOrder.getAttributeDescriptor()) : o1;
                Object object = vo2 = o2 instanceof RowImpl ? ((RowImpl)o2).getFieldValue((FieldDescriptor)singleSortOrder.getAttributeDescriptor()) : o2;
                if (singleSortOrder.isAscending()) {
                    return this.compareTo(vo2, vo1);
                }
                return this.compareTo(vo1, vo2);
            }
            MultipleSortOrder multipleSortOrder = (MultipleSortOrder)sortOrder;
            MeIterator itr = multipleSortOrder.getSortOrders();
            while (itr.hasNext()) {
                SortOrder sub_sortOrder = (SortOrder)itr.next();
                int sub_ret = this.compare(o1, o2, sub_sortOrder);
                if (sub_ret == 0) continue;
                return sub_ret;
            }
            return 0;
        }

        public int compare(Object o1, Object o2) {
            return this.compare(o1, o2, this.sortOrder);
        }

        public boolean equals(Object obj) {
            return obj == this;
        }
    }
}

