/*
 * Decompiled with CFR 0.152.
 */
package com.sap.ip.me.smartsync.data;

import com.sap.ip.me.api.logging.Trace;
import com.sap.ip.me.api.persist.app.PersistableEntity;
import com.sap.ip.me.api.persist.core.PersistenceContainer;
import com.sap.ip.me.api.persist.core.PersistenceException;
import com.sap.ip.me.api.persist.query.Condition;
import com.sap.ip.me.api.persist.query.LogicalOperatorType;
import com.sap.ip.me.api.persist.query.Query;
import com.sap.ip.me.api.persist.query.RelationalOperatorType;
import com.sap.ip.me.api.services.MeIterator;
import com.sap.ip.me.api.smartsync.BasisFieldType;
import com.sap.ip.me.api.smartsync.CharacterField;
import com.sap.ip.me.api.smartsync.DateField;
import com.sap.ip.me.api.smartsync.DecimalField;
import com.sap.ip.me.api.smartsync.Field;
import com.sap.ip.me.api.smartsync.FieldDescriptor;
import com.sap.ip.me.api.smartsync.FieldDescriptorIterator;
import com.sap.ip.me.api.smartsync.FieldGroupDescriptor;
import com.sap.ip.me.api.smartsync.InvalidDescriptorException;
import com.sap.ip.me.api.smartsync.ModificationNotAllowedException;
import com.sap.ip.me.api.smartsync.NumericField;
import com.sap.ip.me.api.smartsync.RelationDescriptor;
import com.sap.ip.me.api.smartsync.RelationDescriptorIterator;
import com.sap.ip.me.api.smartsync.Row;
import com.sap.ip.me.api.smartsync.RowChangeActionType;
import com.sap.ip.me.api.smartsync.RowDescriptor;
import com.sap.ip.me.api.smartsync.RowList;
import com.sap.ip.me.api.smartsync.SmartSyncException;
import com.sap.ip.me.api.smartsync.SmartSyncQueryFactory;
import com.sap.ip.me.api.smartsync.StatusType;
import com.sap.ip.me.api.smartsync.SyncBo;
import com.sap.ip.me.api.smartsync.TimeField;
import com.sap.ip.me.core.MeIteratorArrayImpl;
import com.sap.ip.me.core.NestableRuntimeException;
import com.sap.ip.me.smartsync.data.CompositeValueVerifier;
import com.sap.ip.me.smartsync.data.DataClasstypeManager;
import com.sap.ip.me.smartsync.data.FieldImpl;
import com.sap.ip.me.smartsync.data.RowFactory;
import com.sap.ip.me.smartsync.data.RowManager;
import com.sap.ip.me.smartsync.data.SmartSyncQuery;
import com.sap.ip.me.smartsync.data.SyncBoImpl;
import com.sap.ip.me.smartsync.data.ValueVerifier;
import com.sap.ip.me.smartsync.data.sm.SyncBoState;
import com.sap.ip.me.smartsync.ipi.PersistenceAdapter;
import com.sap.ip.me.smartsync.ipi.SmartSyncTransaction;
import java.math.BigInteger;

class RowImpl
extends CompositeValueVerifier
implements Row,
ValueVerifier,
PersistableEntity {
    private PersistenceContainer object;
    private RowDescriptor descriptor;
    private StatusType status;
    private FieldImpl[] fields;
    private String key;
    private final RowManager rowManager;
    private final RowFactory rowFactory;
    private final SmartSyncQueryFactory queryFactory;
    private final DataClasstypeManager dataClasstypeManager;
    private static final Trace TRACE = Trace.getInstance("MI/API/Smartsync");
    private final PersistenceAdapter dataPersistenceAdapter;

    RowImpl(PersistenceAdapter dataPersistenceAdapter, DataClasstypeManager dataClasstypeManager, RowFactory rowFactory, SmartSyncQueryFactory queryFactory, RowManager rowManager, PersistenceContainer object, RowDescriptor d) {
        if (dataPersistenceAdapter == null) {
            throw new NullPointerException("dataPersistenceAdapter");
        }
        if (dataClasstypeManager == null) {
            throw new NullPointerException("dataClasstypeManager");
        }
        if (rowFactory == null) {
            throw new NullPointerException("rowFactory");
        }
        if (queryFactory == null) {
            throw new NullPointerException("queryFactory");
        }
        if (rowManager == null) {
            throw new NullPointerException("rowManager");
        }
        if (object == null) {
            throw new NullPointerException("object");
        }
        if (d == null) {
            throw new NullPointerException("d");
        }
        this.rowFactory = rowFactory;
        this.rowManager = rowManager;
        this.queryFactory = queryFactory;
        this.dataClasstypeManager = dataClasstypeManager;
        this.object = object;
        this.descriptor = d;
        this.dataPersistenceAdapter = dataPersistenceAdapter;
        this.object.setAttribute(0, Boolean.FALSE);
        this.initializeFields();
    }

    RowImpl(PersistenceAdapter dataPersistenceAdapter, DataClasstypeManager dataClasstypeManager, RowFactory rowFactory, SmartSyncQueryFactory queryFactory, RowManager rowManager, PersistenceContainer object, RowDescriptor d, StatusType status) {
        block2: {
            this(dataPersistenceAdapter, dataClasstypeManager, rowFactory, queryFactory, rowManager, object, d);
            try {
                this.setStatus(status);
            }
            catch (PersistenceException e) {
                if (!TRACE.isLogging(50)) break block2;
                TRACE.logException(50, "Exception during RowImpl.setStatus call.", e, true);
            }
        }
    }

    private void initializeFields() {
        FieldDescriptorIterator fdi = this.descriptor.getAllFieldDescriptors();
        if (this.fields == null) {
            this.fields = new FieldImpl[fdi.size()];
        }
        int i = 0;
        while (i < this.fields.length) {
            FieldDescriptor fd = fdi.next();
            if (this.fields[i] == null) {
                this.fields[i] = FieldImpl.createField(fd, this, this.object.getAttribute(this.getPosition(fd)));
            } else {
                this.fields[i].setInternalFieldValue(this.object.getAttribute(this.getPosition(fd)));
            }
            ++i;
        }
    }

    void setAllNonKeyValuesToNull() {
        int i = 0;
        while (i < this.fields.length) {
            if (!this.fields[i].getFieldDescriptor().isKey()) {
                this.setObjectFieldValue(this.fields[i], null);
            }
            ++i;
        }
    }

    void setKey(String rowKey) {
        Object key = this.descriptor.getKeyFieldDescriptor().to25Object(rowKey);
        this.object.setAttribute(2, key);
        try {
            ((FieldImpl)this.getKeyField()).setInternalFieldValue(key);
        }
        catch (SmartSyncException e) {
            throw new NestableRuntimeException(e);
        }
    }

    void setObjectFieldValue(FieldDescriptor fieldDescriptor, Object value) {
        try {
            this.setObjectFieldValue(this.getField(fieldDescriptor), value);
        }
        catch (SmartSyncException e) {
            e.printStackTrace();
            throw new RuntimeException(e.toString());
        }
    }

    void setObjectFieldValue(Field field, Object value) {
        int attribPos = this.getPosition(field.getFieldDescriptor());
        this.object.setAttribute(attribPos, value);
        ((FieldImpl)field).setInternalFieldValue(value);
    }

    public void setFieldValue(FieldDescriptor fieldDescriptor, Object fieldValue) throws ModificationNotAllowedException, PersistenceException {
        this.verifyOperation(fieldDescriptor);
        Object convertedValue = fieldDescriptor.convertTo25DataType(fieldValue);
        int fdIndex = this.descriptor.getFieldIndex(fieldDescriptor);
        this.fields[fdIndex].setValue(convertedValue);
    }

    void setValue(FieldDescriptor fieldDescriptor, Object fieldValue) throws ModificationNotAllowedException, PersistenceException {
        block4: {
            int attribPos = this.getPosition(fieldDescriptor);
            Object prevValue = this.object.getAttribute(attribPos);
            this.object.setAttribute(attribPos, fieldValue);
            if (this.getStatus().isLinked()) {
                SmartSyncTransaction tx = null;
                try {
                    tx = this.dataPersistenceAdapter.beginTransaction();
                    this.rowManager.modifyFieldFromApplication((SyncBoImpl)this.getSyncBo(), this, this.fields[this.descriptor.getFieldIndex(fieldDescriptor)], !((SyncBoImpl)this.getSyncBo()).isSub());
                    this.dataPersistenceAdapter.commit(tx);
                    tx = null;
                    Object var7_6 = null;
                    if (tx == null) break block4;
                    this.object.setAttribute(attribPos, prevValue);
                }
                catch (Throwable throwable) {
                    Object var7_7 = null;
                    if (tx != null) {
                        this.object.setAttribute(attribPos, prevValue);
                        this.dataPersistenceAdapter.rollback(tx);
                    }
                    throw throwable;
                }
                this.dataPersistenceAdapter.rollback(tx);
                {
                }
            }
        }
    }

    void setObjectFieldValue(int index, Object fieldValue) throws PersistenceException {
        int attribPos = this.getPosition(index);
        this.object.setAttribute(attribPos, fieldValue);
        this.fields[index].setInternalFieldValue(fieldValue);
    }

    public void verifyOperation(FieldDescriptor fieldDescriptor) throws ModificationNotAllowedException, PersistenceException {
        SyncBoImpl thisSyncBo = (SyncBoImpl)this.getSyncBo();
        if (thisSyncBo != null) {
            thisSyncBo.verifyOperation(this, RowChangeActionType.MODIFY);
        }
        if (this.getStatus().isLinked() && thisSyncBo == null) {
            throw new RuntimeException("Row without SyncBo is unlinked.");
        }
        SyncBoState.verifyModify(fieldDescriptor, this);
    }

    public Object getFieldValue(FieldDescriptor fieldDescriptor) {
        try {
            return fieldDescriptor.convertTo21DataType(this.getField(fieldDescriptor).getValue());
        }
        catch (SmartSyncException e) {
            throw new NestableRuntimeException(e);
        }
    }

    public MeIterator getFieldValues() {
        return new MeIterator(){
            private final int allFieldCnt;
            private int currentPos;
            {
                this.allFieldCnt = RowImpl.this.fields.length;
                this.currentPos = 0;
            }

            public Object next() {
                return RowImpl.this.fields[this.currentPos++].getValue();
            }

            public boolean hasNext() {
                return this.currentPos < this.allFieldCnt;
            }

            public void reset() {
                this.currentPos = 0;
            }

            public int elementCount() {
                return this.allFieldCnt;
            }
        };
    }

    public Row createUnlinkedCopy() {
        SmartSyncTransaction tx = null;
        try {
            try {
                tx = this.dataPersistenceAdapter.beginTransaction();
                RowImpl result = this.rowFactory.createCopy(this, StatusType.UNLINKED);
                this.dataPersistenceAdapter.commit(tx);
                tx = null;
                RowImpl rowImpl = result;
                Object var5_6 = null;
                this.tryRollback("RowImpl.createUnlinkedCopy", tx);
                return rowImpl;
            }
            catch (PersistenceException e) {
                TRACE.logException(50, (Throwable)e, true);
                Row row = null;
                Object var5_7 = null;
                this.tryRollback("RowImpl.createUnlinkedCopy", tx);
                return row;
            }
        }
        catch (Throwable throwable) {
            Object var5_8 = null;
            this.tryRollback("RowImpl.createUnlinkedCopy", tx);
            throw throwable;
        }
    }

    public Row createInitialCopy() {
        SmartSyncTransaction tx = null;
        try {
            try {
                tx = this.dataPersistenceAdapter.beginTransaction();
                RowImpl result = this.rowFactory.createCopy(this, StatusType.INITIAL);
                this.dataPersistenceAdapter.commit(tx);
                tx = null;
                RowImpl rowImpl = result;
                Object var5_6 = null;
                this.tryRollback("RowImpl.createInitialCopy", tx);
                return rowImpl;
            }
            catch (PersistenceException e) {
                TRACE.logException(50, (Throwable)e, true);
                Row row = null;
                Object var5_7 = null;
                this.tryRollback("RowImpl.createInitialCopy", tx);
                return row;
            }
        }
        catch (Throwable throwable) {
            Object var5_8 = null;
            this.tryRollback("RowImpl.createInitialCopy", tx);
            throw throwable;
        }
    }

    public String getKey() {
        return this.getSyncKey();
    }

    public String getSyncKey() {
        if (this.key == null) {
            BigInteger syncKey = (BigInteger)this.fields[0].getValue();
            this.key = (String)this.descriptor.getKeyFieldDescriptor().convertTo21DataType(syncKey);
        }
        return this.key;
    }

    private SyncBo getSyncBoWithoutTx() throws PersistenceException {
        return (SyncBo)((Object)this.object.getSingleLink(0));
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public SyncBo getSyncBo() throws PersistenceException {
        SyncBo syncBo;
        SmartSyncTransaction tx = null;
        try {
            tx = this.dataPersistenceAdapter.beginTransaction();
            SyncBo ret = this.getSyncBoWithoutTx();
            this.dataPersistenceAdapter.commit(tx);
            tx = null;
            syncBo = ret;
            Object var5_4 = null;
            if (tx == null) return syncBo;
        }
        catch (Throwable throwable) {
            Object var5_5 = null;
            if (tx == null) throw throwable;
            this.dataPersistenceAdapter.rollback(tx);
            throw throwable;
        }
        this.dataPersistenceAdapter.rollback(tx);
        return syncBo;
    }

    void setSyncBo(SyncBo syncBo) throws PersistenceException {
        if (syncBo == null) {
            this.object.removeSingleLink(0);
        } else {
            this.object.setSingleLink(0, (PersistableEntity)((Object)syncBo));
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Row getRelatedRow(RowDescriptor relatedDescriptor) throws PersistenceException {
        Row row;
        SmartSyncTransaction tx;
        block5: {
            RowImpl rowImpl;
            if (!this.getStatus().isLinked()) {
                return null;
            }
            tx = null;
            try {
                FieldDescriptor f;
                RelationDescriptor r;
                tx = this.dataPersistenceAdapter.beginTransaction();
                FieldDescriptorIterator it = this.descriptor.getAllFieldDescriptors();
                do {
                    if (it.hasNext()) continue;
                    this.dataPersistenceAdapter.commit(tx);
                    tx = null;
                    row = null;
                    break block5;
                } while ((r = (f = it.next()).getRelatedRelation()) == null || r.getRelatedRowDescriptor() != relatedDescriptor);
                BigInteger key = (BigInteger)this.object.getAttribute(this.getPosition(f));
                RowImpl result = this.rowManager.getRow(relatedDescriptor, key, !((SyncBoImpl)this.getSyncBo()).isSub());
                this.dataPersistenceAdapter.commit(tx);
                tx = null;
                rowImpl = result;
                Object var10_9 = null;
                if (tx == null) return rowImpl;
            }
            catch (Throwable throwable) {
                Object var10_11 = null;
                if (tx != null) {
                    this.dataPersistenceAdapter.rollback(tx);
                }
                throw throwable;
            }
            this.dataPersistenceAdapter.rollback(tx);
            return rowImpl;
        }
        Object var10_10 = null;
        if (tx == null) return row;
        this.dataPersistenceAdapter.rollback(tx);
        return row;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public RowList getRelatingRows(RowDescriptor relatingRowDescriptor) throws PersistenceException {
        RowList rowList;
        SmartSyncTransaction tx = null;
        try {
            tx = this.dataPersistenceAdapter.beginTransaction();
            RowList result = this.getRelatingRows(relatingRowDescriptor, null, this.getKey());
            this.dataPersistenceAdapter.commit(tx);
            tx = null;
            rowList = result;
            Object var6_5 = null;
            if (tx == null) return rowList;
        }
        catch (Throwable throwable) {
            Object var6_6 = null;
            if (tx == null) throw throwable;
            this.dataPersistenceAdapter.rollback(tx);
            throw throwable;
        }
        this.dataPersistenceAdapter.rollback(tx);
        return rowList;
    }

    public RowList getRelatingRows(Query query) throws PersistenceException {
        if (query instanceof SmartSyncQuery && !((SmartSyncQuery)query).isSyncBoQuery()) {
            SmartSyncTransaction tx = null;
            try {
                tx = this.dataPersistenceAdapter.beginTransaction();
                RowDescriptor rDes = this.dataClasstypeManager.getRowDescriptor(query.getClasstype());
                RowList result = this.getRelatingRows(rDes, query, this.getKey());
                this.dataPersistenceAdapter.commit(tx);
                tx = null;
                RowList rowList = result;
                Object var7_6 = null;
                this.tryRollback("RowImpl.getRelatingRows", tx);
                return rowList;
            }
            catch (Throwable throwable) {
                Object var7_7 = null;
                this.tryRollback("RowImpl.getRelatingRows", tx);
                throw throwable;
            }
        }
        throw new RuntimeException("Invalid Query: A RowQuery is expected.");
    }

    private RowList getRelatingRows(RowDescriptor relatingRowDescriptor, Query query, String rowKey) throws PersistenceException {
        if (relatingRowDescriptor == null) {
            return null;
        }
        if (this.getStatus().isLinked()) {
            RelationDescriptorIterator it = this.descriptor.getRelatingRelations();
            while (it.hasNext()) {
                RelationDescriptor rd = it.next();
                this.validateInternalState(relatingRowDescriptor, rd);
                FieldDescriptor relatingFieldDescriptor = rd.getRelatingFieldDescriptor();
                RowDescriptor rowD = relatingFieldDescriptor.getRowDescriptor();
                if (!rowD.equals(relatingRowDescriptor)) continue;
                RowDescriptor relatingRowDes = relatingFieldDescriptor.getRowDescriptor();
                Condition cond = this.queryFactory.createCondition(relatingFieldDescriptor, RelationalOperatorType.EQUALS, rowKey);
                if (query == null) {
                    Query relQuery = this.queryFactory.createQuery(relatingRowDes, cond);
                    return this.rowManager.getRows(relQuery, !((SyncBoImpl)this.getSyncBo()).isSub());
                }
                Condition[] conditions = new Condition[]{cond, query.getCondition()};
                Condition concatCondition = this.queryFactory.createCondition(conditions, LogicalOperatorType.AND);
                Query relQuery = this.queryFactory.createQuery(relatingRowDes, concatCondition, query.getSortOrder(), query.getMaxResults());
                return this.rowManager.getRows(relQuery, !((SyncBoImpl)this.getSyncBo()).isSub());
            }
        }
        return null;
    }

    private void validateInternalState(RowDescriptor relatingRowDescriptor, RelationDescriptor rd) {
        String key1 = ((PersistableEntity)((Object)rd.getRelatingFieldDescriptor().getRowDescriptor())).getPersistedObject().getKey();
        String key2 = ((PersistableEntity)((Object)relatingRowDescriptor)).getPersistedObject().getKey();
        if (!rd.getRelatingFieldDescriptor().getRowDescriptor().equals(relatingRowDescriptor) && key1.equals(key2)) {
            throw new RuntimeException("Identical keys but different row descriptors !!!: " + key1);
        }
    }

    public RowDescriptor getRowDescriptor() {
        return this.descriptor;
    }

    public PersistenceContainer getPersistedObject() {
        return this.object;
    }

    public boolean equals(Object row) {
        if (this == row) {
            return true;
        }
        if (!(row instanceof RowImpl)) {
            return false;
        }
        RowImpl fd = (RowImpl)row;
        if (this.fields == fd.fields && this.object == fd.object && this.descriptor == fd.descriptor) {
            return true;
        }
        return this.object != null && fd.object != null && this.object.equals(fd.object);
    }

    public int hashCode() {
        return this.object.hashCode();
    }

    private StatusType getStatusWithoutTx() throws PersistenceException {
        StatusType boStatus;
        SyncBo thisSyncBo = this.getSyncBoWithoutTx();
        if (thisSyncBo != null && (boStatus = thisSyncBo.getStatus()) == StatusType.IN_SYNC) {
            return boStatus;
        }
        if (this.status == null) {
            StatusType isolatedRowStatus;
            this.status = isolatedRowStatus = StatusType.forString((String)this.object.getAttribute(1));
        }
        return this.status;
    }

    private void tryRollback(String message, SmartSyncTransaction tx) {
        block3: {
            if (tx != null) {
                try {
                    this.dataPersistenceAdapter.rollback(tx);
                }
                catch (PersistenceException e1) {
                    if (!TRACE.isLogging(50)) break block3;
                    TRACE.logException(50, "Rollback failed at " + message, e1, true);
                }
            }
        }
    }

    public StatusType getStatus() {
        SmartSyncTransaction tx = null;
        try {
            try {
                tx = this.dataPersistenceAdapter.beginTransaction();
                StatusType ret = this.getStatusWithoutTx();
                this.dataPersistenceAdapter.commit(tx);
                tx = null;
                StatusType statusType = ret;
                Object var5_5 = null;
                this.tryRollback("RowImpl.getStatus", tx);
                return statusType;
            }
            catch (PersistenceException e) {
                throw new NestableRuntimeException(e);
            }
        }
        catch (Throwable throwable) {
            Object var5_6 = null;
            this.tryRollback("RowImpl.getStatus", tx);
            throw throwable;
        }
    }

    void setStatus(StatusType status) throws PersistenceException {
        if (status != this.getStatusWithoutTx()) {
            if (status != StatusType.UNLINKED) {
                this.object.setAttribute(1, status.toString());
            }
            this.status = status;
        }
    }

    private int getPosition(FieldDescriptor fd) {
        return this.getPosition(this.descriptor.getFieldIndex(fd));
    }

    private int getPosition(int index) {
        return index + 2;
    }

    public Field getField(FieldDescriptor fieldDescriptor) throws SmartSyncException {
        int fdIndex = this.descriptor.getFieldIndex(fieldDescriptor);
        if (fdIndex < 0) {
            throw new InvalidDescriptorException("" + fieldDescriptor);
        }
        return this.fields[fdIndex];
    }

    public Field getKeyField() throws SmartSyncException {
        return this.fields[0];
    }

    public Field[] getFields() {
        return this.fields;
    }

    public DateField getDateField(FieldDescriptor fieldDescriptor) throws SmartSyncException {
        if (!fieldDescriptor.getFieldType().equals(BasisFieldType.D)) {
            throw new SmartSyncException("Incompatible field type: must be of BasisFieldType.D");
        }
        return (DateField)this.getField(fieldDescriptor);
    }

    public TimeField getTimeField(FieldDescriptor fieldDescriptor) throws SmartSyncException {
        if (!fieldDescriptor.getFieldType().equals(BasisFieldType.T)) {
            throw new SmartSyncException("Incompatible field type: must be of BasisFieldType.T");
        }
        return (TimeField)this.getField(fieldDescriptor);
    }

    public NumericField getNumericField(FieldDescriptor fieldDescriptor) throws SmartSyncException {
        if (!fieldDescriptor.getFieldType().equals(BasisFieldType.N)) {
            throw new SmartSyncException("Incompatible field type: must be of BasisFieldType.N");
        }
        return (NumericField)this.getField(fieldDescriptor);
    }

    public DecimalField getDecimalField(FieldDescriptor fieldDescriptor) throws SmartSyncException {
        if (!fieldDescriptor.getFieldType().equals(BasisFieldType.P)) {
            throw new SmartSyncException("Incompatible field type: must be of BasisFieldType.P");
        }
        return (DecimalField)this.getField(fieldDescriptor);
    }

    public CharacterField getCharacterField(FieldDescriptor fieldDescriptor) throws SmartSyncException {
        if (!fieldDescriptor.getFieldType().equals(BasisFieldType.C)) {
            throw new SmartSyncException("Incompatible field type: must be of BasisFieldType.C");
        }
        return (CharacterField)this.getField(fieldDescriptor);
    }

    public Field[] getGroupFields(FieldGroupDescriptor fieldGroupDescriptor) throws SmartSyncException {
        FieldDescriptorIterator fdi = fieldGroupDescriptor.getAllFieldDescriptors();
        int fldCount = fdi.size();
        if (fldCount <= 0) {
            return null;
        }
        Field[] gFields = new Field[fldCount];
        int i = 0;
        while (fdi.hasNext()) {
            gFields[i] = this.getField(fdi.next());
            ++i;
        }
        return gFields;
    }

    public MeIterator getSubValueVerifiers() {
        return new MeIteratorArrayImpl(this.fields);
    }

    public String toString() {
        StringBuffer sb = new StringBuffer(100);
        int i = 0;
        while (i < this.fields.length) {
            if (!this.fields[i].getFieldDescriptor().isKey()) {
                sb.append(this.fields[i].toString());
            }
            ++i;
        }
        return sb.toString();
    }
}

