/*
 * Decompiled with CFR 0.152.
 */
package com.sap.ip.me.smartsync.data;

import com.sap.ip.me.api.logging.Trace;
import com.sap.ip.me.api.persist.app.EntityFactory;
import com.sap.ip.me.api.persist.app.PersistableEntity;
import com.sap.ip.me.api.persist.core.PersistenceContainer;
import com.sap.ip.me.api.persist.core.PersistenceException;
import com.sap.ip.me.api.persist.meta.ClassDescriptor;
import com.sap.ip.me.api.services.MeIterator;
import com.sap.ip.me.api.smartsync.Field;
import com.sap.ip.me.api.smartsync.ModificationNotAllowedException;
import com.sap.ip.me.api.smartsync.Row;
import com.sap.ip.me.api.smartsync.RowDescriptor;
import com.sap.ip.me.api.smartsync.SmartSyncException;
import com.sap.ip.me.api.smartsync.SmartSyncQueryFactory;
import com.sap.ip.me.api.smartsync.StatusType;
import com.sap.ip.me.api.smartsync.SyncBo;
import com.sap.ip.me.core.ApplicationManager;
import com.sap.ip.me.smartsync.data.DataClasstypeManager;
import com.sap.ip.me.smartsync.data.RowImpl;
import com.sap.ip.me.smartsync.data.RowManager;
import com.sap.ip.me.smartsync.data.SyncKeyManager;
import com.sap.ip.me.smartsync.ipi.FieldChange;
import com.sap.ip.me.smartsync.ipi.InternalRowChange;
import com.sap.ip.me.smartsync.ipi.PersistenceAdapter;
import com.sap.ip.me.smartsync.ipi.PersistenceConstants;
import com.sap.ip.me.smartsync.ipi.SelectableRowChange;
import com.sap.ip.me.smartsync.ipi.SmartSyncEntityFactory;
import java.math.BigInteger;

final class RowFactory
implements EntityFactory {
    private static Trace TRACE = Trace.getInstance("MI/Smartsync");
    private final DataClasstypeManager dataClasstypeManager;
    private final SmartSyncQueryFactory queryFactory;
    private final RowManager rowManager;
    private final SyncKeyManager syncKeyManager;
    private final PersistenceAdapter dataPersistenceAdapter;

    RowFactory(PersistenceAdapter dataPersistenceAdapter, DataClasstypeManager dataClasstypeManager, RowManager rowManager, SmartSyncQueryFactory queryFactory, SyncKeyManager syncKeyManager) {
        if (dataPersistenceAdapter == null) {
            throw new NullPointerException("dataPersistenceAdapter");
        }
        if (dataClasstypeManager == null) {
            throw new NullPointerException("dataClasstypeManager");
        }
        if (rowManager == null) {
            throw new NullPointerException("rowManager");
        }
        if (queryFactory == null) {
            throw new NullPointerException("queryFactory");
        }
        if (syncKeyManager == null) {
            throw new NullPointerException("syncKeyManager");
        }
        this.dataPersistenceAdapter = dataPersistenceAdapter;
        this.queryFactory = queryFactory;
        this.rowManager = rowManager;
        this.dataClasstypeManager = dataClasstypeManager;
        this.syncKeyManager = syncKeyManager;
    }

    RowImpl createInitial(RowDescriptor d) throws PersistenceException {
        ClassDescriptor cdes = this.dataClasstypeManager.getClassDescriptor(d);
        String key = this.syncKeyManager.createKey();
        PersistenceContainer o = this.dataPersistenceAdapter.getPersistedObjectFactory().createPersistedObject(cdes, key);
        o.setAttribute(2, new BigInteger(key));
        boolean initFlag = ApplicationManager.getInstance().getCurrentMSD().initialDataValuesAccepted();
        RowImpl nRow = new RowImpl(this.dataPersistenceAdapter, this.dataClasstypeManager, this, this.queryFactory, this.rowManager, o, d, StatusType.INITIAL);
        nRow.setKey(o.getKey());
        if (!initFlag) {
            nRow.setAllNonKeyValuesToNull();
        }
        return nRow;
    }

    RowImpl createCopy(Row originalRow, StatusType status) throws PersistenceException {
        PersistenceContainer o = ((PersistableEntity)((Object)originalRow)).getPersistedObject();
        String newKey = status == StatusType.INITIAL ? this.syncKeyManager.createKey() : o.getKey();
        PersistenceContainer newO = this.dataPersistenceAdapter.getPersistedObjectFactory().createPersistedObject(o, newKey);
        RowImpl row = new RowImpl(this.dataPersistenceAdapter, this.dataClasstypeManager, this, this.queryFactory, this.rowManager, newO, originalRow.getRowDescriptor(), status);
        String newSyncKey = newKey.length() > 10 ? this.dataPersistenceAdapter.getCorrespondingDefaultKey(newKey) : newKey;
        row.setKey(newSyncKey);
        return row;
    }

    public PersistableEntity createEntity(PersistenceContainer o) {
        RowDescriptor d = this.dataClasstypeManager.getRowDescriptor(o.getClasstype());
        return new RowImpl(this.dataPersistenceAdapter, this.dataClasstypeManager, this, this.queryFactory, this.rowManager, o, d);
    }

    public void registerEntityFactory(SmartSyncEntityFactory factory) {
        factory.registerMember(PersistenceConstants.ROW_CLASSTYPE_PREFIX, (EntityFactory)this);
    }

    void updateInDelta(RowImpl row, InternalRowChange change) throws PersistenceException {
        if (!change.isSelectable()) {
            MeIterator fieldsIt = change.getChangedFieldValues();
            int i = 0;
            while (fieldsIt.hasNext()) {
                row.setObjectFieldValue(i, fieldsIt.next());
                ++i;
            }
        } else {
            SelectableRowChange sRow = (SelectableRowChange)change;
            MeIterator itr = sRow.getFieldChanges();
            while (itr.hasNext()) {
                FieldChange fc = (FieldChange)itr.next();
                row.setObjectFieldValue(fc.getFieldDescriptor(), fc.getValue());
            }
        }
    }

    private RowImpl createForInDelta(PersistenceContainer rowObject, InternalRowChange row) throws PersistenceException {
        RowDescriptor rowDescriptor = row.getRowDescriptor();
        RowImpl ret = new RowImpl(this.dataPersistenceAdapter, this.dataClasstypeManager, this, this.queryFactory, this.rowManager, rowObject, rowDescriptor, StatusType.GLOBAL);
        ret.setKey(rowObject.getKey());
        this.updateInDelta(ret, row);
        return ret;
    }

    RowImpl createForInDelta(SyncBo syncBo, InternalRowChange row) throws PersistenceException {
        RowDescriptor rowDescriptor = row.getRowDescriptor();
        ClassDescriptor cdes = this.dataClasstypeManager.getClassDescriptor(rowDescriptor);
        PersistenceContainer rowObject = this.dataPersistenceAdapter.getPersistedObjectFactory().createPersistedObject(cdes, (String)row.getSyncKey());
        rowObject.setSingleLink(0, (PersistableEntity)((Object)syncBo));
        return this.createForInDelta(rowObject, row);
    }

    RowImpl createRowCopy(Row row, SyncBo parentBo, RowDescriptor rowDescriptor) throws ModificationNotAllowedException, PersistenceException, SmartSyncException {
        ClassDescriptor cdes = this.dataClasstypeManager.getClassDescriptor(rowDescriptor);
        PersistenceContainer rowObject = this.dataPersistenceAdapter.getPersistedObjectFactory().createPersistedObject(cdes, row.getKey());
        rowObject.setSingleLink(0, (PersistableEntity)((Object)parentBo));
        RowImpl nRow = new RowImpl(this.dataPersistenceAdapter, this.dataClasstypeManager, this, this.queryFactory, this.rowManager, rowObject, rowDescriptor, StatusType.GLOBAL);
        nRow.setKey(rowObject.getKey());
        Field[] cFldValues = row.getFields();
        int i = 0;
        while (i < cFldValues.length) {
            nRow.setObjectFieldValue(cFldValues[i], cFldValues[i].getValue());
            ++i;
        }
        return nRow;
    }
}

