/*
 * Decompiled with CFR 0.152.
 */
package com.sap.ip.me.smartsync.data;

import com.sap.ip.me.api.services.MeIterator;
import com.sap.ip.me.api.smartsync.Row;
import com.sap.ip.me.api.smartsync.RowCollection;
import com.sap.ip.me.api.smartsync.RowDescriptor;
import com.sap.ip.me.core.MeIteratorHashImpl;
import com.sap.ip.me.smartsync.data.RowImpl;
import java.math.BigInteger;
import java.util.Enumeration;
import java.util.Hashtable;

class RowCollectionImpl
implements RowCollection {
    private Hashtable rowsByKey;
    private RowDescriptor descriptor;

    RowCollectionImpl(Hashtable rowsByKey, RowDescriptor descriptor) {
        if (rowsByKey == null) {
            throw new IllegalArgumentException("rowsByKey musn't be null");
        }
        if (descriptor == null) {
            throw new IllegalArgumentException("descriptor musn't be null");
        }
        this.rowsByKey = rowsByKey;
        this.descriptor = descriptor;
    }

    RowCollectionImpl(RowDescriptor descriptor) {
        this(new Hashtable(), descriptor);
    }

    public int size() {
        return this.rowsByKey.size();
    }

    public Row get(Object key) {
        if (key instanceof BigInteger && this.descriptor != null) {
            key = this.descriptor.getKeyFieldDescriptor().convertTo21DataType(key);
        }
        return (Row)this.rowsByKey.get(key);
    }

    public boolean contains(Object key) {
        if (key instanceof BigInteger && this.descriptor != null) {
            key = this.descriptor.getKeyFieldDescriptor().convertTo21DataType(key);
        }
        return this.rowsByKey.containsKey(key);
    }

    public MeIterator iterator() {
        return new MeIteratorHashImpl(this.rowsByKey);
    }

    protected Object clone() {
        return new RowCollectionImpl((Hashtable)this.rowsByKey.clone(), this.descriptor);
    }

    void set(MeIterator rows) {
        if (rows == null) {
            throw new IllegalArgumentException("rows mustn't be null");
        }
        rows.reset();
        this.rowsByKey.clear();
        while (rows.hasNext()) {
            RowImpl row = (RowImpl)rows.next();
            this.rowsByKey.put(row.getKey(), row);
        }
    }

    public String toString() {
        Enumeration keys = this.rowsByKey.keys();
        StringBuffer sb = new StringBuffer();
        while (keys.hasMoreElements()) {
            String key = (String)keys.nextElement();
            Row row = (Row)this.rowsByKey.get(key);
            sb.append("<Row objectID=\"").append(key).append("\" objectType=\"").append(row.getRowDescriptor().getRowName()).append("\">").append(row.toString());
            sb.append("</Row>");
        }
        return sb.toString();
    }
}

