/*
 * Decompiled with CFR 0.152.
 */
package com.sap.ip.me.smartsync.data;

import com.sap.ip.me.api.persist.core.PersistenceException;
import com.sap.ip.me.api.persist.query.Condition;
import com.sap.ip.me.api.persist.query.LogicalOperatorType;
import com.sap.ip.me.api.persist.query.Query;
import com.sap.ip.me.api.persist.query.QueryRuntime;
import com.sap.ip.me.api.persist.query.RelationalOperatorType;
import com.sap.ip.me.api.persist.query.SortOrder;
import com.sap.ip.me.api.smartsync.FieldDescriptor;
import com.sap.ip.me.api.smartsync.RowDescriptor;
import com.sap.ip.me.api.smartsync.SmartSyncQueryFactory;
import com.sap.ip.me.api.smartsync.SyncBoDescriptor;
import com.sap.ip.me.persist.core.CompositeConditionImpl;
import com.sap.ip.me.persist.core.SingleConditionImpl;
import com.sap.ip.me.smartsync.data.DataClasstypeManager;
import com.sap.ip.me.smartsync.data.SmartSyncCondition;
import com.sap.ip.me.smartsync.data.SmartSyncQuery;

final class QueryFactoryImpl
implements SmartSyncQueryFactory {
    private final DataClasstypeManager dataClasstypeManager;

    QueryFactoryImpl(DataClasstypeManager dataClasstypeManager) {
        if (dataClasstypeManager == null) {
            throw new NullPointerException("dataClasstypeManager");
        }
        this.dataClasstypeManager = dataClasstypeManager;
    }

    public Condition createCondition(FieldDescriptor fieldDescriptor, RelationalOperatorType relationalOperator, Object value) {
        Object convValue = fieldDescriptor.convertTo25DataType(value);
        return SmartSyncCondition.createSingleCondition((SingleConditionImpl)QueryRuntime.getInstance().createCondition(fieldDescriptor, relationalOperator, convValue));
    }

    public Condition createCondition(Condition[] conditions, LogicalOperatorType logicalOperator) {
        return SmartSyncCondition.createCompositeCondition((CompositeConditionImpl)QueryRuntime.getInstance().createCondition(conditions, logicalOperator));
    }

    public SortOrder createSortOrder(FieldDescriptor fieldDescriptor, boolean isAscending) {
        return QueryRuntime.getInstance().createSortOrder(fieldDescriptor, isAscending);
    }

    public SortOrder createSortOrder(SortOrder[] sortOrders) {
        return QueryRuntime.getInstance().createSortOrder(sortOrders);
    }

    public Query createQuery(RowDescriptor rdes, Condition uncastedCond, SortOrder sortOrder, int startIndex, int maxResults) throws PersistenceException {
        String classtype = this.dataClasstypeManager.getClasstype(rdes);
        Query query = QueryRuntime.getInstance().createQuery(classtype, uncastedCond, sortOrder, startIndex, maxResults);
        SmartSyncCondition cond = (SmartSyncCondition)uncastedCond;
        if (cond != null && !cond.verifyConsistency(rdes)) {
            throw new PersistenceException("Inconsistent query");
        }
        return SmartSyncQuery.createRowQuery(query, cond, rdes);
    }

    public Query createQuery(RowDescriptor rdes, Condition condition, SortOrder sortOrder, int maxResults) throws PersistenceException {
        return this.createQuery(rdes, condition, sortOrder, -1, maxResults);
    }

    public Query createQuery(RowDescriptor rdes, Condition condition) throws PersistenceException {
        return this.createQuery(rdes, condition, null, -1);
    }

    public Query createQuery(RowDescriptor rdes, Condition condition, SortOrder sortOrder) throws PersistenceException {
        return this.createQuery(rdes, condition, sortOrder, -1);
    }

    public Query createQuery(RowDescriptor rdes, Condition condition, int maxResults) throws PersistenceException {
        return this.createQuery(rdes, condition, null, maxResults);
    }

    public Query createQuery(SyncBoDescriptor sdes, SortOrder sortOrder, int startIdx, int maxResults) throws PersistenceException {
        return this.createQuery(sdes, null, sortOrder, startIdx, maxResults);
    }

    public Query createQuery(SyncBoDescriptor sdes, Condition uncastedCond, SortOrder sortOrder, int startIdx, int maxResults) throws PersistenceException {
        String classtype = this.dataClasstypeManager.getClasstype(sdes.getTopRowDescriptor());
        Query query = QueryRuntime.getInstance().createQuery(classtype, uncastedCond, sortOrder, startIdx, maxResults);
        SmartSyncCondition cond = (SmartSyncCondition)uncastedCond;
        if (cond != null && !cond.verifyConsistency(sdes.getTopRowDescriptor())) {
            throw new PersistenceException("Inconsistent query");
        }
        return SmartSyncQuery.createSyncBoQuery(query, cond, sdes);
    }

    public Query createQuery(SyncBoDescriptor sdes, Condition condition) throws PersistenceException {
        return this.createQuery(sdes, condition, null, -1, -1);
    }

    public Query createQuery(SyncBoDescriptor sdes, Condition condition, SortOrder sortOrder) throws PersistenceException {
        return this.createQuery(sdes, condition, sortOrder, -1, -1);
    }

    public Query createQuery(SyncBoDescriptor sdes, Condition condition, int maxResults) throws PersistenceException {
        return this.createQuery(sdes, condition, null, -1, maxResults);
    }

    public Query createQuery(SyncBoDescriptor sdes, Condition condition, SortOrder order, int maxResults) throws PersistenceException {
        return this.createQuery(sdes, condition, order, -1, maxResults);
    }
}

