/*
 * Decompiled with CFR 0.152.
 */
package com.sap.ip.me.smartsync.data;

import com.sap.ip.me.api.logging.Trace;
import com.sap.ip.me.api.persist.core.PersistenceException;
import com.sap.ip.me.api.services.MeIterator;
import com.sap.ip.me.api.smartsync.FieldDescriptor;
import com.sap.ip.me.api.smartsync.FieldDescriptorIterator;
import com.sap.ip.me.api.smartsync.PositionStatusType;
import com.sap.ip.me.api.smartsync.ProcessingStatusType;
import com.sap.ip.me.api.smartsync.SmartSyncException;
import com.sap.ip.me.api.smartsync.StatusType;
import com.sap.ip.me.api.smartsync.SyncBo;
import com.sap.ip.me.api.smartsync.SyncBoChange;
import com.sap.ip.me.api.smartsync.SyncBoChangeActionType;
import com.sap.ip.me.api.smartsync.SyncBoInDelta;
import com.sap.ip.me.api.smartsync.SyncBoOutDelta;
import com.sap.ip.me.api.smartsync.SyncBoResponse;
import com.sap.ip.me.api.smartsync.SyncBoResponseType;
import com.sap.ip.me.api.smartsync.SyncReplyType;
import com.sap.ip.me.core.ApplicationManager;
import com.sap.ip.me.smartsync.data.AbstractSyncBoManager;
import com.sap.ip.me.smartsync.data.FieldImpl;
import com.sap.ip.me.smartsync.data.QuarantinedSyncBoManager;
import com.sap.ip.me.smartsync.data.RowImpl;
import com.sap.ip.me.smartsync.data.SyncBoFactory;
import com.sap.ip.me.smartsync.data.SyncBoImpl;
import com.sap.ip.me.smartsync.data.SyncBoManager;
import com.sap.ip.me.smartsync.data.SyncBoResponseImpl;
import com.sap.ip.me.smartsync.data.SyncBoResponseManager;
import com.sap.ip.me.smartsync.data.SyncBoResponseResolver;
import com.sap.ip.me.smartsync.data.sm.IllegalStateTransitionException;
import com.sap.ip.me.smartsync.data.sm.SyncBoState;
import com.sap.ip.me.smartsync.ipi.FieldChange;
import com.sap.ip.me.smartsync.ipi.InternalRowChange;
import com.sap.ip.me.smartsync.ipi.MessageManager;
import com.sap.ip.me.smartsync.ipi.SelectableRowChange;

public class MessageManagerImpl
implements SyncBoResponseResolver,
MessageManager {
    private static final Trace TRACE = Trace.getInstance("MI/Smartsync");
    static final String ERROR_APPL_RESOLUTION = "E_APPLRESOLVE";
    static final String CONFLICT_APPL_RESOLUTION = "C_APPLRESOLVE";
    static final String ERROR_DATA_TO_SUB = "FACADE_E_CLIENT";
    static final String CONFLICT_DATA_TO_SUB = "FACADE_C_CLIENT";
    private final SyncBoFactory syncBoFactory;
    private final SyncBoManager syncBoManager;
    private final QuarantinedSyncBoManager quarantinedSyncBoManager;
    private SyncBoResponseManager syncBoResponseManager;

    MessageManagerImpl(SyncBoFactory syncBoFactory, SyncBoManager syncBoManager, QuarantinedSyncBoManager quarantinedSyncBoManager) {
        if (syncBoFactory == null) {
            throw new NullPointerException("syncBoFactory");
        }
        if (syncBoManager == null) {
            throw new NullPointerException("syncBoManager");
        }
        if (quarantinedSyncBoManager == null) {
            throw new NullPointerException("quarantinedSyncBoManager");
        }
        this.syncBoFactory = syncBoFactory;
        this.syncBoManager = syncBoManager;
        this.quarantinedSyncBoManager = quarantinedSyncBoManager;
    }

    void setSyncBoResponseManager(SyncBoResponseManager syncBoResponseManager) {
        this.syncBoResponseManager = syncBoResponseManager;
    }

    private boolean isDeltaExisting(String messageId, SyncBoImpl bo) {
        return !messageId.equals(bo.getLastGeneratedMsgId());
    }

    private boolean isForceMerge(String postStateId) {
        return postStateId == null;
    }

    private SyncBoState getQuarantinedSyncBoState(SyncBo mainBo, SyncBo subBo, SyncBoResponseType responseType, SyncBoChangeActionType actionType) {
        PositionStatusType subPositionStatusType;
        PositionStatusType mainPositionStatusType;
        if (mainBo != null) {
            mainPositionStatusType = mainBo.getPositionStatus();
            ProcessingStatusType mainProcessingStatusType = mainBo.getProcessingStatus();
        } else {
            mainPositionStatusType = null;
            Object mainProcessingStatusType = null;
        }
        if (subBo != null) {
            subPositionStatusType = subBo.getPositionStatus();
            ProcessingStatusType subProcessingStatusType = subBo.getProcessingStatus();
        } else {
            subPositionStatusType = null;
            Object subProcessingStatusType = null;
        }
        return new SyncBoState(mainPositionStatusType, subPositionStatusType, responseType, actionType, this.isConflictInMain(), this.isErrorInMain());
    }

    private SyncBoState getSyncBoState(SyncBo mainBo) {
        ProcessingStatusType mainProcessingStatusType;
        PositionStatusType mainPositionStatusType;
        if (mainBo != null) {
            mainPositionStatusType = mainBo.getPositionStatus();
            mainProcessingStatusType = mainBo.getProcessingStatus();
        } else {
            mainPositionStatusType = null;
            mainProcessingStatusType = null;
        }
        return new SyncBoState(mainPositionStatusType, mainProcessingStatusType, this.isConflictInMain(), this.isErrorInMain());
    }

    public void handleConflictAndErrorResponse(SyncBoInDelta delta, int type, String messageId) throws PersistenceException, SmartSyncException {
        if (TRACE.isLogging(90)) {
            TRACE.log(90, this.getClass().getName() + ".handleConflictAndErrorResponse: InDelta syncKey=" + delta.getSyncKey() + " action=" + delta.getAction().toString());
        }
        if (this.isAutoResolution(this.getSyncBoResponseType(type))) {
            this.handleInDeltaWithNoErrorConflictHandling(delta);
            return;
        }
        SyncBoResponse resp = this.syncBoResponseManager.getSyncBoResponse(delta.getSyncBoDescriptor(), (String)delta.getSyncKey());
        SyncBoImpl mainBo = (SyncBoImpl)this.getMainSyncBo(delta);
        SyncBoState nextState = null;
        SyncBoState currentState = this.getSyncBoState(mainBo);
        nextState = currentState.newStateOfInboundErrorConflictResponse(this.getSyncReplyType(type), delta.getAction());
        if (TRACE.isLogging(90)) {
            TRACE.log(90, "Next States: Position=" + nextState + " Processing=" + nextState);
        }
        this.handleErrorConflictInDelta(resp, delta, mainBo, null, nextState);
    }

    private SyncReplyType getSyncReplyType(int responseType) {
        if (responseType == 3) {
            return SyncReplyType.CONFLICT;
        }
        if (responseType == 4) {
            return SyncReplyType.ERROR;
        }
        throw new RuntimeException("unsupported " + responseType);
    }

    private SyncBoResponseType getSyncBoResponseType(int responseType) {
        if (responseType == 3) {
            return SyncBoResponseType.CONFLICT;
        }
        if (responseType == 4) {
            return SyncBoResponseType.ERROR;
        }
        throw new RuntimeException("unsupported " + responseType);
    }

    public void handleSuccessResponse(SyncBoInDelta delta, int type, String messageId) throws PersistenceException, SmartSyncException {
        boolean isForceMerge;
        SyncBoImpl originalBo = (SyncBoImpl)this.getMainSyncBo(delta);
        if (originalBo == null) {
            return;
        }
        SyncBoState currentState = this.getSyncBoState(originalBo);
        boolean isDeltaExisting = this.isDeltaExisting(messageId, originalBo);
        MeIterator itr = delta.getRowChanges();
        boolean bl = isForceMerge = itr.hasNext() ? ((InternalRowChange)itr.next()).isSelectable() : true;
        if (type == 2) {
            SyncBoState nextState = currentState.newStateOfInboundResponse(isDeltaExisting, isForceMerge, SyncReplyType.SUCCESS, delta.getAction());
            PositionStatusType nextPosition = nextState.getMainPositionStatus();
            ProcessingStatusType nextProcessing = nextState.getMainProcessingStatus();
            if (nextProcessing == ProcessingStatusType.QUARANTINED) {
                this.handleErrorConflictInDelta(null, delta, originalBo, null, nextState);
            } else if (delta.getAction() == SyncBoChangeActionType.DELETE) {
                this.syncBoManager.deleteFromInDelta(originalBo);
            } else {
                SyncBoImpl newSyncBo = (SyncBoImpl)this.syncBoFactory.createForInDelta(delta);
                this.syncBoManager.replaceFromInDelta(newSyncBo);
                this.setSyncBoAttrs(newSyncBo, nextProcessing, nextPosition, delta.getPostStateId());
                this.syncBoManager.modifyFromInDelta(newSyncBo);
            }
        } else {
            SyncBoState nextState = currentState.newStateOfInboundSuccessResponse(isDeltaExisting, isForceMerge);
            PositionStatusType nextPosition = nextState.getMainPositionStatus();
            ProcessingStatusType nextProcessing = nextState.getMainProcessingStatus();
            this.setSyncBoAttrs(originalBo, nextProcessing, nextPosition, delta.getPostStateId());
            this.syncBoManager.modifyFromInDelta(originalBo);
            if (type == 1) {
                this.modifySpecificFieldsFromInDelta(originalBo, delta);
            }
        }
    }

    private void handleDeleteDownload(SyncBoInDelta delta) throws PersistenceException, SmartSyncException {
        SyncBoImpl subBo;
        SyncBoState currentState;
        SyncBoResponse resp = this.syncBoResponseManager.getSyncBoResponse(delta.getSyncBoDescriptor(), (String)delta.getSyncKey());
        SyncBoImpl mainBo = (SyncBoImpl)this.getMainSyncBo(delta);
        if (resp == null) {
            if (mainBo == null) {
                TRACE.log(60, "SyncBo " + delta.getSyncKey() + " could not be found for deletion. Ignoring incoming message");
                return;
            }
            currentState = this.getSyncBoState(mainBo);
            subBo = null;
        } else {
            subBo = (SyncBoImpl)this.getSubSyncBo(delta);
            currentState = this.getQuarantinedSyncBoState(mainBo, subBo, resp.getResponseType(), resp.getActionType());
        }
        SyncBoState nextState = currentState.newStateOfInboundDelete();
        PositionStatusType nextPosition = nextState.getMainPositionStatus();
        ProcessingStatusType nextProcessing = nextState.getMainProcessingStatus();
        if (nextProcessing == ProcessingStatusType.QUARANTINED) {
            this.handleErrorConflictInDelta(resp, delta, mainBo, subBo, nextState);
            return;
        }
        if (nextProcessing == ProcessingStatusType.DESTROYED) {
            if (resp == null) {
                this.syncBoManager.deleteFromInDelta(mainBo);
            } else {
                if (mainBo != null) {
                    this.syncBoManager.deleteFromInDelta(mainBo);
                }
                if (subBo != null) {
                    this.quarantinedSyncBoManager.deleteFromInDelta(subBo);
                }
            }
        } else {
            throw new RuntimeException("bug");
        }
        this.syncBoResponseManager.removeSyncBoResponse(delta.getSyncBoDescriptor(), (String)delta.getSyncKey());
    }

    private void handleInsertDownload(SyncBoInDelta delta) throws PersistenceException, SmartSyncException {
        SyncBoState currentState = new SyncBoState(this.isConflictInMain(), this.isErrorInMain());
        SyncBoState nextState = currentState.newStateOfInboundInsert();
        PositionStatusType nextPosition = nextState.getMainPositionStatus();
        ProcessingStatusType nextProcessing = nextState.getMainProcessingStatus();
        SyncBoImpl newSyncBo = (SyncBoImpl)this.syncBoFactory.createForInDelta(delta);
        newSyncBo.setStatusForAll(StatusType.GLOBAL);
        this.setSyncBoAttrs(newSyncBo, nextProcessing, nextPosition, delta.getPostStateId());
        this.syncBoManager.insertFromInDelta(newSyncBo);
    }

    private void handleModifyDownload(SyncBoInDelta delta) throws PersistenceException, SmartSyncException {
        SyncBoImpl subBo;
        SyncBoState currentState;
        SyncBoResponse resp = this.syncBoResponseManager.getSyncBoResponse(delta.getSyncBoDescriptor(), (String)delta.getSyncKey());
        SyncBoImpl mainBo = (SyncBoImpl)this.getMainSyncBo(delta);
        if (resp == null) {
            if (mainBo == null) {
                TRACE.log(60, "SyncBo " + delta.getSyncKey() + " could not be found for modify. Ignoring incoming message. ");
                return;
            }
            currentState = this.getSyncBoState(mainBo);
            subBo = null;
        } else {
            subBo = (SyncBoImpl)this.getSubSyncBo(delta);
            currentState = this.getQuarantinedSyncBoState(mainBo, subBo, resp.getResponseType(), resp.getActionType());
        }
        SyncBoState nextState = currentState.newStateOfInboundModify();
        PositionStatusType nextPosition = nextState.getMainPositionStatus();
        ProcessingStatusType nextProcessing = nextState.getMainProcessingStatus();
        if (nextProcessing == ProcessingStatusType.IN_SYNC_CONFLICT_WAITING) {
            return;
        }
        if (nextProcessing == ProcessingStatusType.QUARANTINED) {
            this.handleErrorConflictInDelta(resp, delta, mainBo, subBo, nextState);
            return;
        }
        mainBo.modifyFromInDelta(delta);
        mainBo.setStatusForAll(StatusType.GLOBAL);
        this.setSyncBoAttrs(mainBo, nextProcessing, nextPosition, delta.getPostStateId());
        this.syncBoManager.modifyFromInDelta(mainBo);
    }

    private void handleReplaceDownload(SyncBoInDelta delta) throws PersistenceException, SmartSyncException {
        SyncBoImpl subBo;
        SyncBoState currentState;
        SyncBoResponse resp = this.syncBoResponseManager.getSyncBoResponse(delta.getSyncBoDescriptor(), (String)delta.getSyncKey());
        SyncBoImpl mainBo = (SyncBoImpl)this.getMainSyncBo(delta);
        if (resp == null) {
            if (mainBo == null) {
                TRACE.log(60, "SyncBo " + delta.getSyncKey() + " could not be found for replace. Ignoring incoming message. ");
                return;
            }
            currentState = this.getSyncBoState(mainBo);
            subBo = null;
        } else {
            subBo = (SyncBoImpl)this.getSubSyncBo(delta);
            currentState = this.getQuarantinedSyncBoState(mainBo, subBo, resp.getResponseType(), SyncBoChangeActionType.MODIFY);
        }
        SyncBoState nextState = currentState.newStateOfInboundReplace();
        PositionStatusType nextPosition = nextState.getMainPositionStatus();
        ProcessingStatusType nextProcessing = nextState.getMainProcessingStatus();
        if (nextProcessing == ProcessingStatusType.IN_SYNC_CONFLICT_WAITING) {
            return;
        }
        if (nextProcessing == ProcessingStatusType.QUARANTINED) {
            this.handleErrorConflictInDelta(resp, delta, mainBo, subBo, nextState);
        } else {
            this.syncBoManager.replaceFromInDelta((SyncBoImpl)this.syncBoFactory.createForInDelta(delta));
            mainBo.setStatusForAll(StatusType.GLOBAL);
            this.setSyncBoAttrs(mainBo, nextProcessing, nextPosition, delta.getPostStateId());
            this.syncBoManager.modifyFromInDelta(mainBo);
        }
    }

    public void handleDeltaDownload(SyncBoInDelta delta, int type) throws PersistenceException, SmartSyncException {
        if (type == 7) {
            this.handleDeleteDownload(delta);
        } else if (type == 10) {
            this.handleInsertDownload(delta);
        } else if (type == 8) {
            this.handleModifyDownload(delta);
        } else if (type == 9) {
            this.handleReplaceDownload(delta);
        } else {
            throw new RuntimeException("unsupported type: " + type);
        }
    }

    public void handleDeltaUpload(SyncBoOutDelta delta, String messageId, String newStateId) throws PersistenceException, SmartSyncException {
        if (SyncBoChangeActionType.DELETE == delta.getAction()) {
            return;
        }
        SyncBoImpl mainBo = (SyncBoImpl)this.getMainSyncBo(delta);
        SyncBoState currentState = this.getSyncBoState(mainBo);
        SyncBoState nextState = currentState.newStateOfSyncOut();
        PositionStatusType nextPosition = nextState.getMainPositionStatus();
        ProcessingStatusType nextProcessing = nextState.getMainProcessingStatus();
        this.setSyncBoAttrs(mainBo, nextProcessing, nextPosition, newStateId);
        mainBo.setLastGeneratedMsgId(messageId);
        this.syncBoManager.modifyFromInDelta(mainBo);
    }

    private void setSyncBoAttrs(SyncBoImpl syncBo, ProcessingStatusType processStatus, PositionStatusType positionStatus, String stateId) {
        if (processStatus != null) {
            syncBo.setProcessingStatus(processStatus);
        }
        if (positionStatus != null) {
            syncBo.setPositionStatus(positionStatus);
        }
        if (stateId != null) {
            syncBo.setStateId(stateId);
        }
    }

    private void modifySpecificFieldsFromInDelta(SyncBoImpl bo, SyncBoInDelta delta) throws PersistenceException, SmartSyncException {
        MeIterator rowIt = delta.getRowChanges();
        SyncBoImpl copy = (SyncBoImpl)bo.createUnlinkedCopy();
        while (rowIt.hasNext()) {
            InternalRowChange rowChg = (InternalRowChange)rowIt.next();
            RowImpl row = (RowImpl)copy.getRow(rowChg.getRowDescriptor(), (String)rowChg.getSyncKey());
            if (rowChg.isSelectable()) {
                MeIterator fldIt = ((SelectableRowChange)rowChg).getFieldChanges();
                while (fldIt.hasNext()) {
                    FieldChange fldChg = (FieldChange)fldIt.next();
                    FieldImpl curFld = (FieldImpl)row.getField(fldChg.getFieldDescriptor());
                    curFld.setInternalFieldValue(fldChg.getValue());
                    row.setObjectFieldValue(fldChg.getFieldDescriptor(), fldChg.getValue());
                }
                continue;
            }
            FieldDescriptorIterator fdi = rowChg.getRowDescriptor().getAllFieldDescriptors();
            MeIterator fldValIt = rowChg.getChangedFieldValues();
            while (fdi.hasNext()) {
                FieldDescriptor fd = fdi.next();
                FieldImpl curFld = (FieldImpl)row.getField(fd);
                if (!fldValIt.hasNext()) {
                    throw new SmartSyncException("RowChange field value size is inconsistent with the size of the RowDescriptor!");
                }
                Object fieldValue = fldValIt.next();
                curFld.setInternalFieldValue(fieldValue);
                row.setObjectFieldValue(fd, fieldValue);
            }
            if (!fldValIt.hasNext()) continue;
            throw new SmartSyncException("RowChange field value size is inconsistent with the size of the RowDescriptor!");
        }
        this.syncBoManager.replaceFromInDelta(bo, copy);
    }

    private boolean isErrorConflictDataToMain(SyncBoResponseType responseType) {
        if (responseType == SyncBoResponseType.ERROR) {
            return this.isErrorInMain();
        }
        if (responseType == SyncBoResponseType.CONFLICT) {
            return this.isConflictInMain();
        }
        return false;
    }

    private boolean getMSDProperty(String key) {
        String propValue = ApplicationManager.getInstance().getCurrentMSD().getPropertyValueForKey(key);
        if (propValue == null) {
            return false;
        }
        return "X".equals(propValue);
    }

    boolean isAutoResolution(SyncBoResponseType responseType) {
        if (responseType == SyncBoResponseType.ERROR) {
            return !this.getMSDProperty(ERROR_APPL_RESOLUTION);
        }
        if (responseType == SyncBoResponseType.CONFLICT) {
            return !this.getMSDProperty(CONFLICT_APPL_RESOLUTION);
        }
        return true;
    }

    private void handleErrorConflictInDelta(SyncBoResponse preResponse, SyncBoInDelta inDelta, SyncBoImpl mainBo, SyncBoImpl subBo, SyncBoState newState) throws PersistenceException, SmartSyncException {
        if (TRACE.isLogging(90)) {
            TRACE.log(90, this.getClass().getName() + ".handleErrorConflictInDelta: InDelta syncKey=" + inDelta.getSyncKey() + " action=" + inDelta.getAction().toString());
        }
        if (this.isAutoResolution(newState.getSyncBoResponseType())) {
            this.handleInDeltaWithNoErrorConflictHandling(inDelta);
            return;
        }
        if (preResponse != null) {
            this.syncBoResponseManager.updateSyncBoResponse(preResponse, inDelta, newState.getSyncBoResponseType());
        } else {
            this.syncBoResponseManager.addSyncBoResponse(inDelta, newState.getSyncBoResponseType());
        }
        this.manageRepositories(preResponse != null, inDelta, mainBo, subBo, this.syncBoManager, this.quarantinedSyncBoManager, newState);
    }

    private void handleInDeltaWithNoErrorConflictHandling(SyncBoInDelta inDelta) throws PersistenceException {
        if (inDelta == null || inDelta.getAction() == null) {
            return;
        }
        SyncBoFactory factory = this.syncBoFactory;
        SyncBoManager manager = this.syncBoManager;
        switch (inDelta.getAction().toInt()) {
            case 3: {
                SyncBo oldSyncBo = manager.getSyncBo(inDelta.getSyncBoDescriptor(), (String)inDelta.getSyncKey());
                if (oldSyncBo != null) {
                    manager.deleteFromInDelta((SyncBoImpl)oldSyncBo);
                }
            }
            case 0: {
                SyncBoImpl newSyncBo = (SyncBoImpl)factory.createForInDelta(inDelta);
                newSyncBo.setPositionStatus(PositionStatusType.GLOBAL);
                newSyncBo.setProcessingStatus(ProcessingStatusType.SYNCED);
                manager.insertFromInDelta(newSyncBo);
                break;
            }
            case 1: {
                SyncBoImpl modSyncBo = (SyncBoImpl)manager.getSyncBo(inDelta.getSyncBoDescriptor(), (String)inDelta.getSyncKey());
                modSyncBo.modifyFromInDelta(inDelta);
                modSyncBo.setPositionStatus(PositionStatusType.GLOBAL);
                modSyncBo.setProcessingStatus(ProcessingStatusType.SYNCED);
                manager.modifyFromInDelta(modSyncBo);
                break;
            }
            case 2: {
                SyncBo delSyncBo = manager.getSyncBo(inDelta.getSyncBoDescriptor(), (String)inDelta.getSyncKey());
                if (delSyncBo == null) break;
                manager.deleteFromInDelta((SyncBoImpl)delSyncBo);
            }
        }
    }

    private SyncBoImpl applySyncBoFromDelta(AbstractSyncBoManager syncBoManager, SyncBoImpl bo, SyncBoInDelta inDelta, PositionStatusType positionStatusType, ProcessingStatusType processingStatusType) throws PersistenceException {
        SyncBoChangeActionType action = inDelta.getAction();
        if (TRACE.isLogging(90)) {
            TRACE.log(90, this.getClass().getName() + ".applySyncBoFromDelta: InDelta syncKey=" + inDelta.getSyncKey() + " action=" + action);
        }
        if (action == SyncBoChangeActionType.DELETE) {
            if (bo != null) {
                syncBoManager.deleteFromInDelta(bo);
            }
            return null;
        }
        if (action == SyncBoChangeActionType.MODIFY) {
            bo.modifyFromInDelta(inDelta);
            bo.setPositionStatus(positionStatusType);
            bo.setProcessingStatus(processingStatusType);
            syncBoManager.modifyFromInDelta(bo);
            return bo;
        }
        if (action == SyncBoChangeActionType.INSERT) {
            if (bo != null) {
                throw new IllegalArgumentException("there musn't be syncbo when insert");
            }
            bo = (SyncBoImpl)this.syncBoFactory.createForInDelta(inDelta);
            bo.setPositionStatus(positionStatusType);
            bo.setProcessingStatus(processingStatusType);
            syncBoManager.insertFromInDelta(bo);
            return bo;
        }
        if (action == SyncBoChangeActionType.REPLACE) {
            bo = (SyncBoImpl)this.syncBoFactory.createForInDelta(inDelta);
            bo.setPositionStatus(positionStatusType);
            bo.setProcessingStatus(processingStatusType);
            syncBoManager.replaceFromInDelta(bo);
            return bo;
        }
        throw new RuntimeException("not supported change action type " + action);
    }

    private void manageRepositories(boolean isAlreadyQuarantined, SyncBoInDelta inDelta, SyncBoImpl mainBo, SyncBoImpl subBo, SyncBoManager mainBoManager, QuarantinedSyncBoManager subBoManager, SyncBoState newState) throws IllegalStateTransitionException, PersistenceException {
        if (newState.isSwapNeeded()) {
            this.swapMainSub(mainBoManager, subBoManager, mainBo, subBo, newState);
            mainBo = (SyncBoImpl)this.getMainSyncBo(inDelta);
            subBo = (SyncBoImpl)this.getSubSyncBo(inDelta);
        }
        if (this.isErrorConflictDataToMain(newState.getSyncBoResponseType())) {
            mainBo = this.applySyncBoFromDelta(mainBoManager, mainBo, inDelta, newState.getMainPositionStatus(), newState.getMainProcessingStatus());
            if (subBo != null) {
                subBo.setStateId(inDelta.getPostStateId());
                if (!newState.isSwapNeeded()) {
                    subBo.setPositionStatus(newState.getSubPositionStatus());
                    subBo.setProcessingStatus(newState.getSubProcessingStatus());
                }
                subBoManager.modifyFromInDelta(subBo);
            }
        } else {
            subBo = this.applySyncBoFromDelta(subBoManager, subBo, inDelta, newState.getSubPositionStatus(), newState.getSubProcessingStatus());
            if (mainBo != null) {
                mainBo.setStateId(inDelta.getPostStateId());
                if (!newState.isSwapNeeded()) {
                    mainBo.setPositionStatus(newState.getMainPositionStatus());
                    mainBo.setProcessingStatus(newState.getMainProcessingStatus());
                }
                mainBoManager.modifyFromInDelta(mainBo);
            }
        }
    }

    private void swapMainSub(SyncBoManager mainBoManager, QuarantinedSyncBoManager subBoManager, SyncBo mainBo, SyncBo subBo, SyncBoState newState) throws PersistenceException {
        SyncBoImpl subCopy;
        SyncBoImpl mainCopy;
        if (mainBo != null) {
            mainCopy = (SyncBoImpl)this.syncBoFactory.createCopy(mainBo, PositionStatusType.UNLINKED);
            mainCopy.setPositionStatus(newState.getSubPositionStatus());
            mainCopy.setProcessingStatus(newState.getSubProcessingStatus());
        } else {
            mainCopy = null;
        }
        if (subBo != null) {
            subCopy = (SyncBoImpl)this.syncBoFactory.createCopy(subBo, PositionStatusType.UNLINKED);
            subCopy.setPositionStatus(newState.getMainPositionStatus());
            subCopy.setProcessingStatus(newState.getMainProcessingStatus());
        } else {
            subCopy = null;
        }
        if (mainBo != null) {
            mainBoManager.deleteFromInDelta(mainBo);
        }
        if (subBo != null) {
            subBoManager.deleteFromInDelta(subBo);
        }
        if (mainCopy != null) {
            subBoManager.insertFromInDelta(mainCopy);
        }
        if (subCopy != null) {
            mainBoManager.insertFromInDelta(subCopy);
        }
    }

    public void revertToServerData(SyncBoResponse syncBoResponse) throws SmartSyncException, PersistenceException {
        if (TRACE.isLogging(90)) {
            TRACE.log(90, this.getClass().getName() + ".revertToServerData: Response syncKey=" + syncBoResponse.getSyncKey() + " action=" + syncBoResponse.getActionType());
        }
        SyncBoChangeActionType action = ((SyncBoResponseImpl)syncBoResponse).getActionType();
        SyncBoImpl mainBo = (SyncBoImpl)this.getMainSyncBo(syncBoResponse);
        SyncBoImpl subBo = (SyncBoImpl)this.getSubSyncBo(syncBoResponse);
        if (this.isContrarySyncBoAServerSyncBo(syncBoResponse.getResponseType())) {
            if (TRACE.isLogging(90)) {
                TRACE.log(90, "@revertToServerData: Replacing the mainBo with the subBo");
            }
            SyncBoState currentState = null;
            currentState = this.getQuarantinedSyncBoState(mainBo, subBo, syncBoResponse.getResponseType(), syncBoResponse.getActionType());
            if (mainBo != null) {
                this.syncBoManager.deleteFromInDelta(mainBo);
            }
            if (subBo != null) {
                SyncBoState nextState = currentState.newStateOfResolveQuarantinedSyncBoByRevertToServerData();
                subBo.setPositionStatus(nextState.getMainPositionStatus());
                subBo.setProcessingStatus(nextState.getMainProcessingStatus());
                this.syncBoManager.insertFromInDelta(subBo);
                this.quarantinedSyncBoManager.deleteFromInDelta(subBo);
            }
        } else {
            if (TRACE.isLogging(90)) {
                TRACE.log(90, "@revertToServerData: Delete subBo from CONTRARY Rep and change the mainBo's state. ");
            }
            if (mainBo != null) {
                SyncBoState currentState = this.getQuarantinedSyncBoState(mainBo, subBo, syncBoResponse.getResponseType(), syncBoResponse.getActionType());
                if (subBo == null) {
                    Object subPositionSatus = null;
                } else {
                    PositionStatusType subPositionSatus = subBo.getPositionStatus();
                }
                SyncBoState nextState = currentState.newStateOfResolveQuarantinedSyncBoByRevertToServerData();
                this.setSyncBoAttrs(mainBo, nextState.getMainProcessingStatus(), nextState.getMainPositionStatus(), null);
                this.syncBoManager.modifyFromInDelta(mainBo);
            }
            if (subBo != null) {
                this.quarantinedSyncBoManager.deleteFromInDelta(subBo);
            }
        }
        this.cleanUpResolvedResponse(syncBoResponse);
    }

    public void keepClientData(SyncBoResponse syncBoResponse) throws SmartSyncException, PersistenceException {
        SyncBoChangeActionType action = ((SyncBoResponseImpl)syncBoResponse).getActionType();
        SyncBoImpl mainBo = (SyncBoImpl)this.getMainSyncBo(syncBoResponse);
        SyncBoImpl subBo = (SyncBoImpl)this.getSubSyncBo(syncBoResponse);
        if (this.isContrarySyncBoAServerSyncBo(syncBoResponse.getResponseType())) {
            if (mainBo != null) {
                SyncBoImpl unlinkedCopy = (SyncBoImpl)mainBo.createUnlinkedCopy();
                if (subBo != null) {
                    SyncBoState cs = this.getQuarantinedSyncBoState(mainBo, subBo, syncBoResponse.getResponseType(), syncBoResponse.getActionType());
                    SyncBoState ns = cs.newStateOfResolveQuarantinedSyncBoByKeepClientData();
                    unlinkedCopy.setPositionStatus(ns.getMainPositionStatus());
                    unlinkedCopy.setProcessingStatus(ns.getMainProcessingStatus());
                    this.syncBoManager.createReplaceDelta(subBo, unlinkedCopy);
                    this.quarantinedSyncBoManager.deleteFromInDelta(subBo);
                    this.syncBoManager.replace(mainBo, unlinkedCopy);
                    unlinkedCopy.setStatusForAll(mainBo.getStatus());
                } else {
                    SyncBoState cs = this.getQuarantinedSyncBoState(mainBo, subBo, syncBoResponse.getResponseType(), syncBoResponse.getActionType());
                    SyncBoState ns = cs.newStateOfResolveQuarantinedSyncBoByKeepClientData();
                    unlinkedCopy.setPositionStatus(ns.getMainPositionStatus());
                    unlinkedCopy.setProcessingStatus(ns.getMainProcessingStatus());
                    this.syncBoManager.createInsertDelta(unlinkedCopy);
                    this.syncBoManager.replace(mainBo, unlinkedCopy);
                    unlinkedCopy.setStatusForAll(mainBo.getStatus());
                }
            } else if (subBo != null) {
                this.syncBoManager.createDeleteDelta(subBo);
                this.quarantinedSyncBoManager.deleteFromInDelta(subBo);
            }
        } else if (mainBo != null) {
            if (subBo != null) {
                SyncBoState cs = this.getQuarantinedSyncBoState(mainBo, subBo, syncBoResponse.getResponseType(), syncBoResponse.getActionType());
                SyncBoState ns = cs.newStateOfResolveQuarantinedSyncBoByKeepClientData();
                subBo.setPositionStatus(ns.getMainPositionStatus());
                subBo.setProcessingStatus(ns.getMainProcessingStatus());
                this.syncBoManager.createReplaceDelta(mainBo, subBo);
                this.syncBoManager.replace(mainBo, subBo);
                subBo.setStatusForAll(mainBo.getStatus());
                this.quarantinedSyncBoManager.deleteFromInDelta(subBo);
            } else {
                this.syncBoManager.createDeleteDelta(mainBo);
                this.syncBoManager.deleteFromInDelta(mainBo);
            }
        } else {
            if (subBo == null) {
                throw new RuntimeException("data inconsistent: main and sub all null with quarantined status");
            }
            SyncBoState cs = this.getQuarantinedSyncBoState(mainBo, subBo, syncBoResponse.getResponseType(), syncBoResponse.getActionType());
            SyncBoState ns = cs.newStateOfResolveQuarantinedSyncBoByKeepClientData();
            subBo.setPositionStatus(ns.getMainPositionStatus());
            subBo.setProcessingStatus(ns.getMainProcessingStatus());
            this.syncBoManager.createInsertDelta(subBo);
            this.syncBoManager.insertFromInDelta(subBo);
            this.quarantinedSyncBoManager.deleteFromInDelta(subBo);
        }
        this.cleanUpResolvedResponse(syncBoResponse);
    }

    private SyncBo getMainSyncBo(SyncBoResponse syncBoResponse) throws PersistenceException {
        return this.syncBoManager.getSyncBoWithoutCheck(syncBoResponse.getSyncBoDescriptor(), syncBoResponse.getSyncKey());
    }

    private SyncBo getSubSyncBo(SyncBoResponse syncBoResponse) throws PersistenceException {
        return this.quarantinedSyncBoManager.getSyncBoWithoutCheck(syncBoResponse.getSyncBoDescriptor(), syncBoResponse.getSyncKey());
    }

    private SyncBo getMainSyncBo(SyncBoChange inDelta) throws PersistenceException {
        return this.syncBoManager.getSyncBoWithoutCheck(inDelta.getSyncBoDescriptor(), (String)inDelta.getSyncKey());
    }

    private SyncBo getSubSyncBo(SyncBoChange inDelta) throws PersistenceException {
        return this.quarantinedSyncBoManager.getSyncBoWithoutCheck(inDelta.getSyncBoDescriptor(), (String)inDelta.getSyncKey());
    }

    public SyncBo getContrarySyncBo(SyncBoResponse syncBoResponse) throws SmartSyncException, PersistenceException {
        return this.getSubSyncBo(syncBoResponse);
    }

    public boolean isContrarySyncBoAServerSyncBo(SyncBoResponseType responseType) {
        return !this.isErrorConflictDataToMain(responseType);
    }

    private void cleanUpResolvedResponse(SyncBoResponse syncBoResponse) throws PersistenceException, SmartSyncException {
        if (TRACE.isLogging(90)) {
            TRACE.log(90, this.getClass().getName() + ".cleanUpResolvedResponse: Response syncKey=" + syncBoResponse.getSyncKey() + " action=" + syncBoResponse.getActionType());
        }
        this.syncBoResponseManager.removeSyncBoResponse(syncBoResponse.getSyncBoDescriptor(), syncBoResponse.getSyncKey());
    }

    private boolean isConflictInMain() {
        return !this.getMSDProperty(CONFLICT_DATA_TO_SUB);
    }

    private boolean isErrorInMain() {
        return !this.getMSDProperty(ERROR_DATA_TO_SUB);
    }
}

