/*
 * Decompiled with CFR 0.152.
 */
package com.sap.ip.me.smartsync.data;

import com.sap.ip.me.api.persist.core.PersistenceException;
import com.sap.ip.me.api.smartsync.BasisFieldType;
import com.sap.ip.me.api.smartsync.CharacterField;
import com.sap.ip.me.api.smartsync.DateField;
import com.sap.ip.me.api.smartsync.DecimalField;
import com.sap.ip.me.api.smartsync.Field;
import com.sap.ip.me.api.smartsync.FieldDescriptor;
import com.sap.ip.me.api.smartsync.FieldDescriptorIterator;
import com.sap.ip.me.api.smartsync.FieldGroupDescriptor;
import com.sap.ip.me.api.smartsync.FieldGroupType;
import com.sap.ip.me.api.smartsync.ModificationNotAllowedException;
import com.sap.ip.me.api.smartsync.NumericField;
import com.sap.ip.me.api.smartsync.Row;
import com.sap.ip.me.api.smartsync.RowChangeActionType;
import com.sap.ip.me.api.smartsync.SmartSyncException;
import com.sap.ip.me.api.smartsync.SyncBo;
import com.sap.ip.me.api.smartsync.TimeField;
import com.sap.ip.me.smartsync.data.IllegalInputValueException;
import com.sap.ip.me.smartsync.data.RowImpl;
import com.sap.ip.me.smartsync.data.ValueVerifier;
import com.sap.ip.me.smartsync.ipi.InternalFieldDescriptor;
import com.sap.ip.me.smartsync.util.SmartSyncUtil;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.sql.Date;
import java.sql.Time;
import java.util.NoSuchElementException;

abstract class FieldImpl
implements Field,
ValueVerifier {
    private FieldDescriptor fieldDescriptor = null;
    private RowImpl row = null;
    private Object fieldValue = null;

    FieldImpl(FieldDescriptor fieldDescriptor, RowImpl row) {
        if (fieldDescriptor == null) {
            throw new NullPointerException("fieldDescriptor");
        }
        if (row == null) {
            throw new NullPointerException("row");
        }
        this.fieldDescriptor = fieldDescriptor;
        this.row = row;
    }

    FieldImpl(Object fieldValue, FieldDescriptor fieldDescriptor, RowImpl row) {
        this.fieldValue = fieldValue;
        this.fieldDescriptor = fieldDescriptor;
        this.row = row;
    }

    public void setValue(Object fieldValue) throws ModificationNotAllowedException, PersistenceException {
        if (this.row != null) {
            int fieldIdx;
            SyncBo syncBo = this.row.getSyncBo();
            if (syncBo != null) {
                syncBo.verifyOperation(this.row, RowChangeActionType.MODIFY);
            }
            if ((fieldIdx = this.row.getRowDescriptor().getFieldIndex(this.fieldDescriptor)) < 0) {
                throw new ModificationNotAllowedException("FieldDescriptor {0} does not match RowDescriptor {1}", new Object[]{this.fieldDescriptor.getFieldName(), this.row.getRowDescriptor().getRowName()});
            }
            if (fieldIdx == 0) {
                throw new ModificationNotAllowedException("Modification of SyncKey is NOT allowed");
            }
            this.fieldValue = fieldValue;
            this.row.setValue(this.fieldDescriptor, fieldValue);
        }
    }

    public Row getRow() {
        return this.row;
    }

    public FieldDescriptor getFieldDescriptor() {
        return this.fieldDescriptor;
    }

    void setInternalFieldValue(Object object) {
        this.fieldValue = object;
    }

    public Field[] getGroupFields(FieldGroupType fieldGroupType) {
        FieldGroupDescriptor fgd = this.fieldDescriptor.getFieldGroupDescriptor(fieldGroupType);
        if (fgd == null) {
            return null;
        }
        try {
            return this.row.getGroupFields(new RelatedFieldGroupDescriptor(fgd, this.fieldDescriptor));
        }
        catch (SmartSyncException e) {
            return null;
        }
    }

    public Object getValue() {
        return this.fieldValue;
    }

    public static FieldImpl createField(FieldDescriptor fldDes, RowImpl row, Object fldValue) {
        if (fldDes.getFieldType() == BasisFieldType.C) {
            return new CharacterFieldImpl((String)fldValue, fldDes, row);
        }
        if (fldDes.getFieldType() == BasisFieldType.D) {
            return new DateFieldImpl((Date)fldValue, fldDes, row);
        }
        if (fldDes.getFieldType() == BasisFieldType.N) {
            return new NumericFieldImpl((BigInteger)fldValue, fldDes, row);
        }
        if (fldDes.getFieldType() == BasisFieldType.P) {
            return new DecimalFieldImpl((BigDecimal)fldValue, fldDes, row);
        }
        if (fldDes.getFieldType() == BasisFieldType.T) {
            return new TimeFieldImpl((Time)fldValue, fldDes, row);
        }
        throw new RuntimeException("Failed to create Field: Invalid FieldDescriptor type.");
    }

    public void verify(int flag) throws PersistenceException, IllegalInputValueException {
        if (this.getFieldDescriptor().isKey()) {
            return;
        }
        if (flag == 0) {
            if (!((InternalFieldDescriptor)this.getFieldDescriptor()).checkCreateFieldValue(this.fieldValue)) {
                throw new IllegalInputValueException(this.getFieldDescriptor().getCreateInputQualifyType(), this.getFieldDescriptor(), this.fieldValue);
            }
        } else if (flag == 1 && !((InternalFieldDescriptor)this.getFieldDescriptor()).checkModifyFieldValue(this.fieldValue)) {
            throw new IllegalInputValueException(this.getFieldDescriptor().getModifyInputQualifyType(), this.getFieldDescriptor(), this.fieldValue);
        }
    }

    public void verify(ValueVerifier org, int flag) throws PersistenceException, IllegalInputValueException {
        if (!(org instanceof Field)) {
            throw new IllegalArgumentException("illegal data type " + org + ", expect Field");
        }
        if (this.getFieldDescriptor().isKey()) {
            return;
        }
        if (flag == 0) {
            if (!((InternalFieldDescriptor)this.getFieldDescriptor()).checkCreateFieldValue(this.fieldValue)) {
                throw new IllegalInputValueException(this.getFieldDescriptor().getCreateInputQualifyType(), this.getFieldDescriptor(), this.fieldValue);
            }
        } else if (flag == 1 && (((Field)((Object)org)).getValue() == null && this.getValue() != null || ((Field)((Object)org)).getValue() != null && !((Field)((Object)org)).getValue().equals(this.getValue())) && !((InternalFieldDescriptor)this.getFieldDescriptor()).checkModifyFieldValue(this.fieldValue)) {
            throw new IllegalInputValueException(this.getFieldDescriptor().getModifyInputQualifyType(), this.getFieldDescriptor(), this.fieldValue);
        }
    }

    public String toString() {
        return "<Field>" + this.fieldValue + "</Field>";
    }

    static class TimeFieldImpl
    extends FieldImpl
    implements TimeField {
        TimeFieldImpl(Time fieldValue, FieldDescriptor fieldDescriptor, RowImpl row) {
            super(fieldValue, fieldDescriptor, row);
        }

        public void setValue(Time fieldValue) throws ModificationNotAllowedException, PersistenceException {
            super.setValue(fieldValue);
        }

        public Time getSqlTime() {
            return (Time)this.getValue();
        }

        public DateField getPairedDateField() {
            Field[] fields = super.getGroupFields(FieldGroupType.T);
            if (fields == null) {
                return null;
            }
            return (DateField)fields[0];
        }

        public void setValue(Object fieldValue) throws ModificationNotAllowedException, PersistenceException {
            if (!(fieldValue instanceof Time) && fieldValue != null) {
                throw new ModificationNotAllowedException("Incompatible type of object; {0} type is expected.", new String[]{"java.sql.Time"});
            }
            this.setValue((Time)fieldValue);
        }

        public Object getValue() {
            return super.getValue();
        }
    }

    static class NumericFieldImpl
    extends FieldImpl
    implements NumericField {
        NumericFieldImpl(BigInteger fieldValue, FieldDescriptor fieldDescriptor, RowImpl row) {
            super(fieldValue, fieldDescriptor, row);
        }

        public void setValue(BigInteger fieldValue) throws ModificationNotAllowedException, PersistenceException {
            super.setValue(fieldValue);
        }

        public BigInteger getBigInteger() {
            return (BigInteger)this.getValue();
        }

        public String getValueWithLeadingZeros() {
            BigInteger val = this.getBigInteger();
            return SmartSyncUtil.insertLeadingZeros(val == null ? "" : val.toString(), super.getFieldDescriptor().getLength());
        }

        public void setValue(Object fieldValue) throws ModificationNotAllowedException, PersistenceException {
            if (!(fieldValue instanceof BigInteger) && fieldValue != null) {
                throw new ModificationNotAllowedException("Incompatible type of object; {0} type is expected.", new String[]{"java.math.BigInteger"});
            }
            this.setValue((BigInteger)fieldValue);
        }

        public Object getValue() {
            return super.getValue();
        }
    }

    static class DecimalFieldImpl
    extends FieldImpl
    implements DecimalField {
        DecimalFieldImpl(BigDecimal fieldValue, FieldDescriptor fieldDescriptor, RowImpl row) {
            super(fieldValue, fieldDescriptor, row);
        }

        public void setValue(BigDecimal fieldValue) throws ModificationNotAllowedException, PersistenceException {
            super.setValue(fieldValue);
        }

        public BigDecimal getBigDecimal() {
            return (BigDecimal)this.getValue();
        }

        public void setValue(Object fieldValue) throws ModificationNotAllowedException, PersistenceException {
            if (!(fieldValue instanceof BigDecimal) && fieldValue != null) {
                throw new ModificationNotAllowedException("Incompatible type of object; {0} type is expected.", new String[]{"java.math.BigDecimal"});
            }
            this.setValue((BigDecimal)fieldValue);
        }

        public Object getValue() {
            return super.getValue();
        }
    }

    static class DateFieldImpl
    extends FieldImpl
    implements DateField {
        DateFieldImpl(Date fieldValue, FieldDescriptor fieldDescriptor, RowImpl row) {
            super(fieldValue, fieldDescriptor, row);
        }

        public void setValue(Date fieldValue) throws ModificationNotAllowedException, PersistenceException {
            super.setValue(fieldValue);
        }

        public Date getSqlDate() {
            return (Date)this.getValue();
        }

        public TimeField getPairedTimeField() {
            Field[] fields = super.getGroupFields(FieldGroupType.T);
            if (fields == null) {
                return null;
            }
            return (TimeField)fields[0];
        }

        public void setValue(Object fieldValue) throws ModificationNotAllowedException, PersistenceException {
            if (!(fieldValue instanceof Date) && fieldValue != null) {
                throw new ModificationNotAllowedException("Incompatible type of object; {0} type is expected.", new String[]{"java.sql.Date"});
            }
            this.setValue((Date)fieldValue);
        }

        public Object getValue() {
            return super.getValue();
        }
    }

    static class CharacterFieldImpl
    extends FieldImpl
    implements CharacterField {
        CharacterFieldImpl(String fieldValue, FieldDescriptor fieldDescriptor, RowImpl row) {
            super(fieldValue, fieldDescriptor, row);
        }

        public void setValue(String fieldValue) throws ModificationNotAllowedException, PersistenceException {
            super.setValue(fieldValue);
        }

        public String getCharacters() {
            return (String)this.getValue();
        }

        public void setValue(Object fieldValue) throws ModificationNotAllowedException, PersistenceException {
            if (!(fieldValue instanceof String) && fieldValue != null) {
                throw new ModificationNotAllowedException("Incompatible type of object; {0} type is expected.", new String[]{"String"});
            }
            this.setValue((String)fieldValue);
        }

        public Object getValue() {
            return super.getValue();
        }
    }

    private static class RelatedFieldGroupDescriptor
    implements FieldGroupDescriptor {
        private final FieldGroupDescriptor fgd;
        private final FieldDescriptor except;

        RelatedFieldGroupDescriptor(FieldGroupDescriptor fgd, FieldDescriptor except) {
            this.fgd = fgd;
            this.except = except;
        }

        public FieldDescriptorIterator getAllFieldDescriptors() {
            return new FieldDescriptorIterator(this){
                private FieldDescriptorIterator fdi;
                private FieldDescriptor current;
                private final /* synthetic */ RelatedFieldGroupDescriptor this$0;
                {
                    this.this$0 = this$0;
                    this.fdi = RelatedFieldGroupDescriptor.access$000(this.this$0).getAllFieldDescriptors();
                    this.current = null;
                }

                public boolean hasNext() {
                    if (this.current == null) {
                        while (this.fdi.hasNext()) {
                            FieldDescriptor next = this.fdi.next();
                            if (next == RelatedFieldGroupDescriptor.access$100(this.this$0)) continue;
                            this.current = next;
                            return true;
                        }
                        return false;
                    }
                    return true;
                }

                public FieldDescriptor next() {
                    if (this.hasNext()) {
                        FieldDescriptor ret = this.current;
                        this.current = null;
                        return ret;
                    }
                    throw new NoSuchElementException();
                }

                public Object nextElement() {
                    return this.next();
                }

                public int size() {
                    return this.fdi.size() - 1;
                }
            };
        }

        public FieldGroupType getFieldGroupType() {
            return this.fgd.getFieldGroupType();
        }

        public String getName() {
            return this.fgd.getName();
        }

        static /* synthetic */ FieldGroupDescriptor access$000(RelatedFieldGroupDescriptor x0) {
            return x0.fgd;
        }

        static /* synthetic */ FieldDescriptor access$100(RelatedFieldGroupDescriptor x0) {
            return x0.except;
        }
    }
}

