/*
 * Decompiled with CFR 0.152.
 */
package com.sap.ip.me.smartsync.data;

import com.sap.ip.me.api.persist.core.PersistenceException;
import com.sap.ip.me.api.services.MeIterator;
import com.sap.ip.me.api.smartsync.ErrorConflictInbox;
import com.sap.ip.me.api.smartsync.SmartSyncException;
import com.sap.ip.me.api.smartsync.SyncBoDescriptor;
import com.sap.ip.me.api.smartsync.SyncBoDescriptorIterator;
import com.sap.ip.me.api.smartsync.SyncBoResponse;
import com.sap.ip.me.api.smartsync.SyncBoResponseType;
import com.sap.ip.me.core.MeIteratorVectorImpl;
import com.sap.ip.me.smartsync.data.SyncBoResponseImpl;
import com.sap.ip.me.smartsync.data.SyncBoResponseManager;
import com.sap.ip.me.smartsync.ipi.InterMetaPackageManager;
import com.sap.ip.me.smartsync.ipi.PersistenceAdapter;
import com.sap.ip.me.smartsync.ipi.SmartSyncTransaction;
import java.util.Vector;

class ErrorConflictInboxImpl
implements ErrorConflictInbox {
    private final SyncBoResponseManager syncBoResponseManager;
    private final PersistenceAdapter dataPersistenceAdapter;
    private final InterMetaPackageManager interMetaPackageManager;

    ErrorConflictInboxImpl(InterMetaPackageManager interMetaPackageManager, SyncBoResponseManager syncBoResponseManager, PersistenceAdapter dataPersistenceAdapter) {
        if (interMetaPackageManager == null) {
            throw new NullPointerException("interMetaPackageManager");
        }
        if (syncBoResponseManager == null) {
            throw new NullPointerException("syncBoResponseManager");
        }
        if (dataPersistenceAdapter == null) {
            throw new NullPointerException("dataPersistenceAdapter");
        }
        this.interMetaPackageManager = interMetaPackageManager;
        this.syncBoResponseManager = syncBoResponseManager;
        this.dataPersistenceAdapter = dataPersistenceAdapter;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public SyncBoResponse getSyncBoResponse(SyncBoDescriptor syncBoDescriptor, String syncKey) throws PersistenceException, SmartSyncException {
        SyncBoResponseImpl syncBoResponseImpl;
        SmartSyncTransaction tx = this.dataPersistenceAdapter.beginTransaction();
        try {
            SyncBoResponseImpl res = (SyncBoResponseImpl)this.syncBoResponseManager.getSyncBoResponse(syncBoDescriptor, syncKey);
            this.dataPersistenceAdapter.commit(tx);
            tx = null;
            syncBoResponseImpl = res;
            Object var7_6 = null;
            if (tx == null) return syncBoResponseImpl;
        }
        catch (Throwable throwable) {
            Object var7_7 = null;
            if (tx == null) throw throwable;
            this.dataPersistenceAdapter.rollback(tx);
            throw throwable;
        }
        this.dataPersistenceAdapter.rollback(tx);
        return syncBoResponseImpl;
    }

    public MeIterator getAllSyncBoResponses() throws PersistenceException, SmartSyncException {
        SyncBoDescriptorIterator it = this.interMetaPackageManager.getSyncBoDescriptorFacade().getAllSyncBoDescriptors();
        Vector<Object> v = new Vector<Object>();
        while (it.hasNext()) {
            MeIterator res = this.getSyncBoResponses(it.next());
            while (res.hasNext()) {
                v.addElement(res.next());
            }
        }
        return new MeIteratorVectorImpl(v);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public MeIterator getSyncBoResponses(SyncBoDescriptor syncBoDescriptor) throws PersistenceException, SmartSyncException {
        MeIterator meIterator;
        SmartSyncTransaction tx = this.dataPersistenceAdapter.beginTransaction();
        try {
            MeIterator resList = this.syncBoResponseManager.getSyncBoResponses(syncBoDescriptor);
            this.dataPersistenceAdapter.commit(tx);
            tx = null;
            meIterator = resList;
            Object var6_5 = null;
            if (tx == null) return meIterator;
        }
        catch (Throwable throwable) {
            Object var6_6 = null;
            if (tx == null) throw throwable;
            this.dataPersistenceAdapter.rollback(tx);
            throw throwable;
        }
        this.dataPersistenceAdapter.rollback(tx);
        return meIterator;
    }

    public MeIterator getSyncBoResponses(SyncBoDescriptor syncBoDescriptor, SyncBoResponseType responseType) throws PersistenceException, SmartSyncException {
        MeIterator it = this.getSyncBoResponses(syncBoDescriptor);
        return this.getSyncBoResponses(it, responseType);
    }

    public MeIterator getSyncBoResponses(SyncBoResponseType responseType) throws PersistenceException, SmartSyncException {
        MeIterator it = this.getAllSyncBoResponses();
        return this.getSyncBoResponses(it, responseType);
    }

    private MeIterator getSyncBoResponses(MeIterator it, SyncBoResponseType responseType) {
        Vector<SyncBoResponse> v = new Vector<SyncBoResponse>();
        while (it.hasNext()) {
            SyncBoResponse res = (SyncBoResponse)it.next();
            if (res.getResponseType() != responseType) continue;
            v.addElement(res);
        }
        return new MeIteratorVectorImpl(v);
    }
}

