/*
 * Decompiled with CFR 0.152.
 */
package com.sap.ip.me.smartsync.data;

import com.sap.ip.me.api.persist.app.PackagePersistenceMaster;
import com.sap.ip.me.api.persist.meta.ClassDescriptor;
import com.sap.ip.me.api.smartsync.RowDescriptor;
import com.sap.ip.me.api.smartsync.RowDescriptorIterator;
import com.sap.ip.me.api.smartsync.SyncBoDescriptor;
import com.sap.ip.me.api.smartsync.SyncBoDescriptorIterator;
import com.sap.ip.me.smartsync.data.DataClasstypeManager;
import com.sap.ip.me.smartsync.ipi.PersistenceConstants;
import java.util.Enumeration;
import java.util.Vector;

final class DataPackagePersistenceMaster
implements PackagePersistenceMaster {
    private String[] classTypeArray;
    private final DataClasstypeManager dataClasstypeManager;

    DataPackagePersistenceMaster(SyncBoDescriptorIterator syncBoDescriptorIterator, DataClasstypeManager dataClasstypeManager, boolean isSyncBoResponseLogNeeded) {
        if (syncBoDescriptorIterator == null) {
            throw new NullPointerException("syncBoDescriptorIterator");
        }
        if (dataClasstypeManager == null) {
            throw new NullPointerException("dataClasstypeManager");
        }
        this.dataClasstypeManager = dataClasstypeManager;
        this.initializeClassTypes(syncBoDescriptorIterator, isSyncBoResponseLogNeeded);
    }

    private void initializeClassTypes(SyncBoDescriptorIterator syncBoDescriptorIterator, boolean isSyncBoResponseLogNeeded) {
        Vector<String> classtypes = new Vector<String>();
        while (syncBoDescriptorIterator.hasNext()) {
            SyncBoDescriptor syncBoDescriptor = syncBoDescriptorIterator.next();
            classtypes.addElement(this.dataClasstypeManager.getClasstype(syncBoDescriptor));
            RowDescriptor rowDescriptor = syncBoDescriptor.getTopRowDescriptor();
            classtypes.addElement(this.dataClasstypeManager.getClasstype(rowDescriptor));
            RowDescriptorIterator rowIt = syncBoDescriptor.getAllRowDescriptors();
            while (rowIt.hasNext()) {
                rowDescriptor = rowIt.next();
                classtypes.addElement(this.dataClasstypeManager.getClasstype(rowDescriptor));
            }
            if (!isSyncBoResponseLogNeeded) continue;
            classtypes.addElement(DataClasstypeManager.createClasstype(syncBoDescriptor, PersistenceConstants.SYNC_BO_RESPONSE_CLASSTYPE_PREFIX));
            classtypes.addElement(DataClasstypeManager.createClasstype(syncBoDescriptor, PersistenceConstants.SYNC_BO_RESPONSE_LOG_CLASSTYPE_PREFIX));
        }
        this.classTypeArray = new String[classtypes.size()];
        int x = 0;
        Enumeration cEnum = classtypes.elements();
        while (cEnum.hasMoreElements()) {
            this.classTypeArray[x] = (String)cEnum.nextElement();
            ++x;
        }
    }

    public String[] getClasstypes() {
        return this.classTypeArray;
    }

    public ClassDescriptor getClassDescriptor(String classtype) {
        if (classtype == null) {
            throw new NullPointerException("Parameter classType may not be null");
        }
        char firstChar = classtype.charAt(0);
        if (PersistenceConstants.SYNC_BO_CLASSTYPE_PREFIX == firstChar) {
            return this.dataClasstypeManager.getSyncBoClassDescriptor(classtype);
        }
        if (PersistenceConstants.ROW_CLASSTYPE_PREFIX == firstChar) {
            return this.dataClasstypeManager.getRowClassDescriptor(classtype);
        }
        if (PersistenceConstants.SYNC_BO_RESPONSE_CLASSTYPE_PREFIX == firstChar) {
            return this.dataClasstypeManager.getSyncBoResponseClassDescriptor(classtype);
        }
        if (PersistenceConstants.SYNC_BO_RESPONSE_LOG_CLASSTYPE_PREFIX == firstChar) {
            return this.dataClasstypeManager.getSyncBoResponseLogClassDescriptor(classtype);
        }
        throw new IllegalArgumentException("Unknown ClassType >" + classtype);
    }
}

