/*
 * Decompiled with CFR 0.152.
 */
package com.sap.ip.me.smartsync.data;

import com.sap.ip.me.api.logging.Trace;
import com.sap.ip.me.api.persist.core.PersistenceException;
import com.sap.ip.me.api.persist.meta.DescriptorException;
import com.sap.ip.me.api.persist.meta.DescriptorRuntime;
import com.sap.ip.me.api.smartsync.ErrorConflictInbox;
import com.sap.ip.me.api.smartsync.SmartSyncException;
import com.sap.ip.me.api.smartsync.SmartSyncJQueryFactory;
import com.sap.ip.me.api.smartsync.SmartSyncQueryFactory;
import com.sap.ip.me.api.smartsync.SyncBoDataFacade;
import com.sap.ip.me.api.smartsync.SyncBoDescriptorIterator;
import com.sap.ip.me.api.smartsync.SyncBoResponseType;
import com.sap.ip.me.core.ConversationIdHandler;
import com.sap.ip.me.core.NestableRuntimeException;
import com.sap.ip.me.smartsync.data.DataClasstypeManager;
import com.sap.ip.me.smartsync.data.DataPackagePersistenceMaster;
import com.sap.ip.me.smartsync.data.ErrorConflictInboxImpl;
import com.sap.ip.me.smartsync.data.MessageManagerImpl;
import com.sap.ip.me.smartsync.data.QuarantinedSyncBoManager;
import com.sap.ip.me.smartsync.data.QueryFactoryImpl;
import com.sap.ip.me.smartsync.data.RowFactory;
import com.sap.ip.me.smartsync.data.RowManager;
import com.sap.ip.me.smartsync.data.SmartSyncJQueryFactoryImpl;
import com.sap.ip.me.smartsync.data.SyncBoDataFacadeImpl;
import com.sap.ip.me.smartsync.data.SyncBoFactory;
import com.sap.ip.me.smartsync.data.SyncBoManager;
import com.sap.ip.me.smartsync.data.SyncBoResponseFactory;
import com.sap.ip.me.smartsync.data.SyncBoResponseManager;
import com.sap.ip.me.smartsync.data.SyncKeyManager;
import com.sap.ip.me.smartsync.ipi.InterDataPackageManager;
import com.sap.ip.me.smartsync.ipi.InterDeltaPackageManager;
import com.sap.ip.me.smartsync.ipi.InterMetaPackageManager;
import com.sap.ip.me.smartsync.ipi.InternalSyncBoDataFacade;
import com.sap.ip.me.smartsync.ipi.MessageManager;
import com.sap.ip.me.smartsync.ipi.PersistenceAdapter;
import com.sap.ip.me.smartsync.ipi.SmartSyncEntityFactory;
import java.util.Hashtable;

public final class DataPackageManager
implements InterDataPackageManager {
    private SyncBoDataFacade dataFacade;
    private SmartSyncJQueryFactory jQueryFactory;
    private final SyncBoFactory syncBoFactory;
    private final SmartSyncQueryFactory queryFactory;
    private final RowFactory rowFactory;
    private final SyncKeyManager syncKeyManager;
    private final SyncBoManager syncBoManager;
    private final QuarantinedSyncBoManager quarantinedSyncBoManager;
    private final MessageManagerImpl messageManager;
    private final DataClasstypeManager dataClasstypeManager;
    private final RowManager rowManager;
    private final SyncBoResponseFactory syncBoResponseFactory;
    private final SyncBoResponseManager syncBoResponseManager;
    private final InterMetaPackageManager interMetaPackageManager;
    private final ErrorConflictInboxImpl errorConflictInbox;
    private final PersistenceAdapter dataPersistenceAdapter;
    private final Hashtable masters = new Hashtable();
    private static final Trace TRACE = Trace.getInstance("MI/Smartsync");

    public DataPackageManager(PersistenceAdapter dataPersistenceAdapter, InterMetaPackageManager interMetaPackageManager, InterDeltaPackageManager interDeltaPackageManager) {
        try {
            if (dataPersistenceAdapter == null) {
                throw new NullPointerException("dataPersistenceAdapter");
            }
            if (interMetaPackageManager == null) {
                throw new NullPointerException("interMetaPackageManager");
            }
            if (interDeltaPackageManager == null) {
                throw new NullPointerException("interDeltaPackageManager");
            }
            this.interMetaPackageManager = interMetaPackageManager;
            this.dataPersistenceAdapter = dataPersistenceAdapter;
            this.dataClasstypeManager = new DataClasstypeManager(interMetaPackageManager, DescriptorRuntime.getInstance());
            this.rowManager = new RowManager(this.dataClasstypeManager, interDeltaPackageManager, dataPersistenceAdapter);
            this.queryFactory = new QueryFactoryImpl(this.dataClasstypeManager);
            this.syncKeyManager = new SyncKeyManager(dataPersistenceAdapter, DescriptorRuntime.getInstance());
            this.rowFactory = new RowFactory(dataPersistenceAdapter, this.dataClasstypeManager, this.rowManager, this.queryFactory, this.syncKeyManager);
            this.syncBoFactory = new SyncBoFactory(dataPersistenceAdapter, this.dataClasstypeManager, this.rowFactory, this.rowManager, this.syncKeyManager);
            this.syncBoManager = new SyncBoManager(this.dataClasstypeManager, interDeltaPackageManager, dataPersistenceAdapter, interMetaPackageManager);
            this.quarantinedSyncBoManager = new QuarantinedSyncBoManager(this.dataClasstypeManager, dataPersistenceAdapter, interMetaPackageManager);
            this.messageManager = new MessageManagerImpl(this.syncBoFactory, this.syncBoManager, this.quarantinedSyncBoManager);
            this.syncBoResponseFactory = new SyncBoResponseFactory(this.dataClasstypeManager, this.messageManager, dataPersistenceAdapter);
            this.syncBoResponseManager = new SyncBoResponseManager(this.messageManager, this.dataClasstypeManager, this.syncBoFactory, this.syncBoResponseFactory, dataPersistenceAdapter, interMetaPackageManager);
            this.errorConflictInbox = new ErrorConflictInboxImpl(interMetaPackageManager, this.syncBoResponseManager, dataPersistenceAdapter);
            this.dataFacade = new SyncBoDataFacadeImpl(this.syncBoManager, this.rowManager, this.syncBoFactory, dataPersistenceAdapter);
        }
        catch (DescriptorException e) {
            throw new NestableRuntimeException(e);
        }
    }

    public InternalSyncBoDataFacade getInternalSyncBoDataFacade() {
        return (InternalSyncBoDataFacade)this.getSyncBoDataFacade();
    }

    public ErrorConflictInbox getErrorConflictInbox() {
        return this.errorConflictInbox;
    }

    public SyncBoDataFacade getSyncBoDataFacade() {
        return this.dataFacade;
    }

    public MessageManager getMessageManager() {
        return this.messageManager;
    }

    public SmartSyncQueryFactory getQueryFactory() {
        return this.queryFactory;
    }

    public boolean registerPersistenceMaster() {
        SyncBoDescriptorIterator syncBoDescriptorIterator;
        String convid = ConversationIdHandler.getInstance().getCurrentConversationId().getId();
        DataPackagePersistenceMaster master = (DataPackagePersistenceMaster)this.masters.get(convid);
        if (master == null && (syncBoDescriptorIterator = this.interMetaPackageManager.getSyncBoDescriptorFacade().getAllSyncBoDescriptors()) != null && syncBoDescriptorIterator.hasNext()) {
            master = new DataPackagePersistenceMaster(syncBoDescriptorIterator, this.dataClasstypeManager, !this.messageManager.isAutoResolution(SyncBoResponseType.CONFLICT) || !this.messageManager.isAutoResolution(SyncBoResponseType.ERROR));
            try {
                this.dataPersistenceAdapter.registerPersistenceMaster(master);
                this.masters.put(convid, master);
                this.syncKeyManager.registerPersistenceMaster();
            }
            catch (PersistenceException e) {
                throw new RuntimeException(e.toString());
            }
            return true;
        }
        return false;
    }

    public void registerEntityFactory() {
        SmartSyncEntityFactory smartSyncEntityFactory = this.dataPersistenceAdapter.getSmartSyncEntityFactory();
        this.rowFactory.registerEntityFactory(smartSyncEntityFactory);
        this.syncBoFactory.registerEntityFactory(smartSyncEntityFactory);
        this.syncKeyManager.registerEntityFactory(smartSyncEntityFactory);
        this.syncBoResponseFactory.registerEntityFactory(smartSyncEntityFactory);
    }

    public void onSwitchConversationId() {
    }

    public SmartSyncJQueryFactory getJQueryFactory() {
        if (this.jQueryFactory == null) {
            this.jQueryFactory = new SmartSyncJQueryFactoryImpl(this.dataClasstypeManager);
        }
        return this.jQueryFactory;
    }

    public void deleteAllPersistedData() {
        try {
            this.syncBoManager.deleteAllSyncBo();
            this.syncBoResponseManager.removeAll();
            this.syncKeyManager.deleteAllPersistedData();
        }
        catch (PersistenceException e) {
            throw new NestableRuntimeException(e);
        }
        catch (SmartSyncException e) {
            throw new NestableRuntimeException(e);
        }
    }
}

