/*
 * Decompiled with CFR 0.152.
 */
package com.sap.ip.me.smartsync.data;

import com.sap.ip.me.api.logging.Trace;
import com.sap.ip.me.api.persist.meta.AttributeDescriptor;
import com.sap.ip.me.api.persist.meta.AttributeType;
import com.sap.ip.me.api.persist.meta.ClassDescriptor;
import com.sap.ip.me.api.persist.meta.DescriptorException;
import com.sap.ip.me.api.persist.meta.DescriptorRuntime;
import com.sap.ip.me.api.persist.meta.LinkDescriptor;
import com.sap.ip.me.api.persist.meta.MultiplicityType;
import com.sap.ip.me.api.services.MeIterator;
import com.sap.ip.me.api.smartsync.FieldDescriptorIterator;
import com.sap.ip.me.api.smartsync.RowDescriptor;
import com.sap.ip.me.api.smartsync.RowDescriptorIterator;
import com.sap.ip.me.api.smartsync.SyncBoDescriptor;
import com.sap.ip.me.api.smartsync.SyncBoDescriptorIterator;
import com.sap.ip.me.core.MeIteratorVectorImpl;
import com.sap.ip.me.smartsync.ipi.InterMetaPackageManager;
import com.sap.ip.me.smartsync.ipi.PersistenceConstants;
import java.util.Hashtable;
import java.util.Vector;

class DataClasstypeManager {
    private final Trace TRACE = Trace.getInstance("MI/Smartsync");
    private static final String STATUS_NAME = "positionStatus";
    private static final int STATUS_LENGTH = 1;
    private static final String PROCSTATUS_NAME = "processingStatus";
    private static final int PROCSTATUS_LENGTH = 1;
    private static final String TIMESTAMP_NAME = "timestamp_";
    private static final int TIMESTAMP_LENGTH = 21;
    private static final String STATE_ID_NAME = "stateId";
    private static final int STATE_ID_LENGTH = 36;
    private static final String LSTGENMSGID_NAME = "lastGeneratedMsgId";
    private static final int LSTGENMSGID_LENGTH = 36;
    static final int ATTR_RESPTYPE_INDEX = 0;
    static final int ATTR_ACTTYPE_INDEX = 1;
    private static final String SYNCKEY_NAME = "SYNCKEY";
    private static final String ACTTYPE_NAME = "actionType";
    private static final String RESPTYPE_NAME = "responseType";
    private static final String RESPLOG_NAME = "responseLog";
    private static final String BORESP_NAME = "syncBoResponse";
    private static final int RESPTYPE_LENGTH = 1;
    private static final int ACTTYPE_LENGTH = 1;
    static final int LOG_ATTR_TEXT_INDEX = 1;
    static final int LOG_ATTR_MSGCLASS_INDEX = 2;
    static final int LOG_ATTR_MSGNUM_INDEX = 3;
    static final int LOG_ATTR_TIMESTAMP_INDEX = 4;
    private static final String MSGTEXT_NAME = "messageText";
    private static final String MSGCLASS_NAME = "messageClass";
    private static final String MSGNUMBER_NAME = "messageNumber";
    private static final int MSGTEXT_LENGTH = 220;
    private static final int MSGCLASS_LENGTH = 20;
    private static final int MSGNUMBER_LENGTH = 3;
    private final InterMetaPackageManager interMetaPackageManager;
    private final DescriptorRuntime descriptorRuntime;
    private Hashtable classtypesByDescriptor;

    DataClasstypeManager(InterMetaPackageManager interMetaPackageManager, DescriptorRuntime descriptorRuntime) {
        if (interMetaPackageManager == null) {
            throw new NullPointerException("interMetaPackageManager");
        }
        if (descriptorRuntime == null) {
            throw new NullPointerException("descriptorRuntime");
        }
        this.interMetaPackageManager = interMetaPackageManager;
        this.descriptorRuntime = descriptorRuntime;
        this.classtypesByDescriptor = new Hashtable();
    }

    void clearCache() {
        this.classtypesByDescriptor.clear();
    }

    private void addClasstype(SyncBoDescriptor syncBoDescriptor, String classType) {
        this.classtypesByDescriptor.put(syncBoDescriptor, classType);
    }

    private void addClasstype(RowDescriptor rowDescriptor, String classType) {
        this.classtypesByDescriptor.put(rowDescriptor, classType);
    }

    static String createClasstype(SyncBoDescriptor syncBoDescriptor, char prefix) {
        StringBuffer concatenator = new StringBuffer(64).append(prefix).append(PersistenceConstants.SEPARATOR).append(syncBoDescriptor.getSyncBoName());
        return concatenator.toString();
    }

    static String createClasstype(RowDescriptor rowDescriptor, char prefix) {
        StringBuffer concatenator = new StringBuffer(64).append(prefix).append(PersistenceConstants.SEPARATOR).append(rowDescriptor.getSyncBoDescriptor().getSyncBoName()).append(PersistenceConstants.SEPARATOR).append(rowDescriptor.getRowName());
        return concatenator.toString();
    }

    String getClasstype(SyncBoDescriptor syncBoDescriptor) {
        String clsType = (String)this.classtypesByDescriptor.get(syncBoDescriptor);
        if (clsType == null) {
            StringBuffer concatenator = new StringBuffer(64).append(PersistenceConstants.SYNC_BO_CLASSTYPE_PREFIX).append(PersistenceConstants.SEPARATOR).append(syncBoDescriptor.getSyncBoName());
            clsType = concatenator.toString();
            this.addClasstype(syncBoDescriptor, clsType);
        }
        return clsType;
    }

    String getClasstype(RowDescriptor rowDescriptor) {
        String clsType = (String)this.classtypesByDescriptor.get(rowDescriptor);
        if (clsType == null) {
            StringBuffer concatenator = new StringBuffer(64).append(PersistenceConstants.ROW_CLASSTYPE_PREFIX).append(PersistenceConstants.SEPARATOR).append(rowDescriptor.getSyncBoDescriptor().getSyncBoName()).append(PersistenceConstants.SEPARATOR).append(rowDescriptor.getRowName());
            clsType = concatenator.toString();
            this.addClasstype(rowDescriptor, clsType);
        }
        return clsType;
    }

    private String getSyncBoNameFromClasstype(String classtype) {
        String noPrefix = classtype.substring(2);
        int lastIndex = noPrefix.lastIndexOf(PersistenceConstants.SEPARATOR);
        if (lastIndex == -1) {
            return noPrefix;
        }
        return noPrefix.substring(0, lastIndex);
    }

    private String getRowNameFromClasstype(String classtype) {
        String noPrefix = classtype.substring(2);
        int lastIndex = noPrefix.lastIndexOf(PersistenceConstants.SEPARATOR);
        if (lastIndex == -1) {
            return null;
        }
        return noPrefix.substring(lastIndex + 1);
    }

    RowDescriptor getRowDescriptor(String classtype) {
        return this.getSyncBoDescriptor(classtype).getRowDescriptor(this.getRowNameFromClasstype(classtype));
    }

    SyncBoDescriptor getSyncBoDescriptor(String classtype) {
        String syncboName = this.getSyncBoNameFromClasstype(classtype);
        return this.interMetaPackageManager.getSyncBoDescriptorFacade().getSyncBoDescriptor(syncboName);
    }

    ClassDescriptor getClassDescriptor(SyncBoDescriptor syncBoDescriptor) {
        String boclassType = this.getClasstype(syncBoDescriptor);
        return this.getSyncBoClassDescriptor(boclassType);
    }

    ClassDescriptor getClassDescriptor(RowDescriptor rowDescriptor) {
        String rowClassType = this.getClasstype(rowDescriptor);
        return this.getRowClassDescriptor(rowClassType);
    }

    ClassDescriptor getSyncBoResponseClassDescriptor(String classtype) {
        ClassDescriptor cdes = this.descriptorRuntime.getClassDescriptor(classtype);
        if (cdes == null) {
            SyncBoDescriptor syncBoDescriptor = this.getSyncBoDescriptor(classtype);
            return this.addSynBoResponseClassDescriptor(syncBoDescriptor);
        }
        return cdes;
    }

    ClassDescriptor getSyncBoResponseLogClassDescriptor(String classtype) {
        ClassDescriptor cdes = this.descriptorRuntime.getClassDescriptor(classtype);
        if (cdes == null) {
            SyncBoDescriptor syncBoDescriptor = this.getSyncBoDescriptor(classtype);
            return this.addSynBoResponseLogClassDescriptor(syncBoDescriptor);
        }
        return cdes;
    }

    ClassDescriptor getSyncBoClassDescriptor(String classtype) {
        ClassDescriptor cdes = this.descriptorRuntime.getClassDescriptor(classtype);
        if (cdes == null) {
            SyncBoDescriptor syncBoDescriptor = this.getSyncBoDescriptor(classtype);
            try {
                AttributeDescriptor[] attrib = new AttributeDescriptor[]{PersistenceConstants.getSubAttributeDescriptor(), this.descriptorRuntime.createAttributeDescriptor(STATUS_NAME, AttributeType.STRING, 1, 1), syncBoDescriptor.getTopRowDescriptor().getKeyFieldDescriptor(), this.descriptorRuntime.createAttributeDescriptor(PROCSTATUS_NAME, AttributeType.INTEGER, 1, 1), this.descriptorRuntime.createAttributeDescriptor(TIMESTAMP_NAME, AttributeType.STRING, 1, 21), this.descriptorRuntime.createAttributeDescriptor(STATE_ID_NAME, AttributeType.STRING, 1, 36), this.descriptorRuntime.createAttributeDescriptor(LSTGENMSGID_NAME, AttributeType.STRING, 1, 36)};
                RowDescriptor topRowDesc = syncBoDescriptor.getTopRowDescriptor();
                RowDescriptorIterator rowDesIt = syncBoDescriptor.getAllRowDescriptors();
                LinkDescriptor[] link = new LinkDescriptor[1 + rowDesIt.size()];
                int linkIndex = 0;
                link[linkIndex] = this.descriptorRuntime.createLinkDescriptor(topRowDesc.getRowName(), this.getClasstype(topRowDesc), MultiplicityType.SINGLE, true);
                while (rowDesIt.hasNext()) {
                    RowDescriptor rowDescriptor = rowDesIt.next();
                    link[++linkIndex] = this.descriptorRuntime.createLinkDescriptor(rowDescriptor.getRowName(), this.getClasstype(rowDescriptor), MultiplicityType.MULTIPLE_VECTOR, false);
                }
                String classType = this.getClasstype(syncBoDescriptor);
                cdes = this.descriptorRuntime.createClassDescriptor(classType, attrib, link);
            }
            catch (DescriptorException e) {
                if (this.TRACE.isLogging(50)) {
                    this.TRACE.logException(50, "DescriptorException occurred. Returning a null object.", e, true);
                }
                return null;
            }
        }
        return cdes;
    }

    ClassDescriptor getRowClassDescriptor(String classtype) {
        ClassDescriptor cdes = this.descriptorRuntime.getClassDescriptor(classtype);
        if (cdes == null) {
            RowDescriptor rowDescriptor = this.getRowDescriptor(classtype);
            try {
                AttributeDescriptor[] attrib = new AttributeDescriptor[2 + rowDescriptor.getFieldCount()];
                attrib[0] = PersistenceConstants.getSubAttributeDescriptor();
                attrib[1] = this.descriptorRuntime.createAttributeDescriptor(STATUS_NAME, AttributeType.STRING, 1, 1);
                int attrIndex = 1;
                FieldDescriptorIterator fieldDesIt = rowDescriptor.getAllFieldDescriptors();
                while (fieldDesIt.hasNext()) {
                    attrib[++attrIndex] = fieldDesIt.next();
                }
                SyncBoDescriptor syncBoDescriptor = rowDescriptor.getSyncBoDescriptor();
                LinkDescriptor[] link = new LinkDescriptor[]{this.descriptorRuntime.createLinkDescriptor("syncBo", this.getClasstype(syncBoDescriptor), MultiplicityType.SINGLE, false)};
                String classType = this.getClasstype(rowDescriptor);
                cdes = this.descriptorRuntime.createClassDescriptor(classType, attrib, link);
            }
            catch (DescriptorException e) {
                if (this.TRACE.isLogging(50)) {
                    this.TRACE.logException(50, "DescriptorException occurred. Returning a null object.", e, true);
                }
                return null;
            }
        }
        return cdes;
    }

    MeIterator getAllRowClassDescriptors() {
        Vector<ClassDescriptor> rowDescs = new Vector<ClassDescriptor>();
        SyncBoDescriptorIterator sit = this.interMetaPackageManager.getSyncBoDescriptorFacade().getAllSyncBoDescriptors();
        while (sit.hasNext()) {
            SyncBoDescriptor boDesc = sit.next();
            ClassDescriptor cd = this.getClassDescriptor(boDesc.getTopRowDescriptor());
            rowDescs.addElement(cd);
            RowDescriptorIterator rit = boDesc.getAllRowDescriptors();
            while (rit.hasNext()) {
                cd = this.getClassDescriptor(rit.next());
                rowDescs.addElement(cd);
            }
        }
        return new MeIteratorVectorImpl(rowDescs);
    }

    private ClassDescriptor addSynBoResponseClassDescriptor(SyncBoDescriptor syncBoDescriptor) {
        try {
            AttributeDescriptor[] attrib = new AttributeDescriptor[]{this.descriptorRuntime.createAttributeDescriptor(RESPTYPE_NAME, AttributeType.INTEGER, 1, 1), this.descriptorRuntime.createAttributeDescriptor(ACTTYPE_NAME, AttributeType.STRING, 1, 1)};
            LinkDescriptor[] logLinks = new LinkDescriptor[]{this.descriptorRuntime.createLinkDescriptor(RESPLOG_NAME, DataClasstypeManager.createClasstype(syncBoDescriptor, PersistenceConstants.SYNC_BO_RESPONSE_LOG_CLASSTYPE_PREFIX), MultiplicityType.MULTIPLE_VECTOR, false)};
            String boResponseClassType = DataClasstypeManager.createClasstype(syncBoDescriptor, PersistenceConstants.SYNC_BO_RESPONSE_CLASSTYPE_PREFIX);
            ClassDescriptor cdes = this.descriptorRuntime.createClassDescriptor(boResponseClassType, attrib, logLinks);
            return cdes;
        }
        catch (DescriptorException e) {
            if (this.TRACE.isLogging(50)) {
                this.TRACE.logException(50, "DescriptorException occurred. Returning a null object.", e, true);
            }
            return null;
        }
    }

    private ClassDescriptor addSynBoResponseLogClassDescriptor(SyncBoDescriptor syncBoDescriptor) {
        try {
            AttributeDescriptor[] attrib = new AttributeDescriptor[]{this.descriptorRuntime.createAttributeDescriptor(RESPTYPE_NAME, AttributeType.INTEGER, 1, 1), this.descriptorRuntime.createAttributeDescriptor(MSGTEXT_NAME, AttributeType.STRING, 1, 220), this.descriptorRuntime.createAttributeDescriptor(MSGCLASS_NAME, AttributeType.STRING, 1, 20), this.descriptorRuntime.createAttributeDescriptor(MSGNUMBER_NAME, AttributeType.INTEGER, 1, 3), this.descriptorRuntime.createAttributeDescriptor(TIMESTAMP_NAME, AttributeType.STRING, 1, 21)};
            LinkDescriptor[] parentLink = new LinkDescriptor[]{this.descriptorRuntime.createLinkDescriptor(BORESP_NAME, DataClasstypeManager.createClasstype(syncBoDescriptor, PersistenceConstants.SYNC_BO_RESPONSE_CLASSTYPE_PREFIX), MultiplicityType.SINGLE, false)};
            String boResponseLogClassType = DataClasstypeManager.createClasstype(syncBoDescriptor, PersistenceConstants.SYNC_BO_RESPONSE_LOG_CLASSTYPE_PREFIX);
            ClassDescriptor cdes = this.descriptorRuntime.createClassDescriptor(boResponseLogClassType, attrib, parentLink);
            return cdes;
        }
        catch (DescriptorException e) {
            if (this.TRACE.isLogging(50)) {
                this.TRACE.logException(50, "DescriptorException occurred. Returning a null object.", e, true);
            }
            return null;
        }
    }
}

