/*
 * Decompiled with CFR 0.152.
 */
package com.sap.ip.me.smartsync.data;

import com.sap.ip.me.api.persist.core.PersistenceException;
import com.sap.ip.me.api.services.MeIterator;
import com.sap.ip.me.smartsync.data.IllegalInputValueException;
import com.sap.ip.me.smartsync.data.ValueVerifier;

public abstract class CompositeValueVerifier
implements ValueVerifier {
    public void verify(int flag) throws PersistenceException, IllegalInputValueException {
        MeIterator itr = this.getSubValueVerifiers();
        while (itr.hasNext()) {
            ((ValueVerifier)itr.next()).verify(flag);
        }
    }

    public void verify(ValueVerifier org, int flag) throws PersistenceException, IllegalInputValueException {
        if (org == null) {
            this.verify(flag);
            return;
        }
        if (!(org instanceof CompositeValueVerifier)) {
            throw new IllegalArgumentException("expected SyncBo, but was " + org);
        }
        MeIterator itr = this.getSubValueVerifiers();
        MeIterator itrOrg = ((CompositeValueVerifier)org).getSubValueVerifiers();
        while (itr.hasNext() && itrOrg.hasNext()) {
            ((ValueVerifier)itr.next()).verify((ValueVerifier)itrOrg.next(), flag);
        }
    }

    public abstract MeIterator getSubValueVerifiers() throws PersistenceException;
}

