/*
 * Decompiled with CFR 0.152.
 */
package com.sap.ip.me.smartsync.data;

import com.sap.ip.me.api.logging.Trace;
import com.sap.ip.me.api.persist.app.PersistableEntity;
import com.sap.ip.me.api.persist.core.PersistenceException;
import com.sap.ip.me.api.persist.core.TreeOptionType;
import com.sap.ip.me.api.persist.meta.ClassDescriptor;
import com.sap.ip.me.api.services.MeIterator;
import com.sap.ip.me.api.smartsync.SyncBo;
import com.sap.ip.me.api.smartsync.SyncBoChangeActionType;
import com.sap.ip.me.api.smartsync.SyncBoCollection;
import com.sap.ip.me.api.smartsync.SyncBoDescriptor;
import com.sap.ip.me.api.smartsync.SyncBoDescriptorIterator;
import com.sap.ip.me.smartsync.data.DataClasstypeManager;
import com.sap.ip.me.smartsync.data.SyncBoCollectionImpl;
import com.sap.ip.me.smartsync.data.SyncBoImpl;
import com.sap.ip.me.smartsync.ipi.InterMetaPackageManager;
import com.sap.ip.me.smartsync.ipi.PersistenceAdapter;

public abstract class AbstractSyncBoManager {
    protected final Trace TRACE = Trace.getInstance("MI/Smartsync");
    private final DataClasstypeManager dataClasstypeManager;
    protected final PersistenceAdapter dataPersistenceAdapter;
    protected final InterMetaPackageManager interMetaPackageManager;

    abstract boolean isQuarantinedManager();

    public AbstractSyncBoManager(DataClasstypeManager dataClasstypeManager, PersistenceAdapter dataPersistenceAdapter, InterMetaPackageManager interMetaPackageManager) {
        if (dataClasstypeManager == null) {
            throw new NullPointerException("dataClasstypeManager");
        }
        if (dataPersistenceAdapter == null) {
            throw new NullPointerException("dataPersistenceAdapter");
        }
        if (interMetaPackageManager == null) {
            throw new NullPointerException("interMetaPackageManager");
        }
        this.dataClasstypeManager = dataClasstypeManager;
        this.dataPersistenceAdapter = dataPersistenceAdapter;
        this.interMetaPackageManager = interMetaPackageManager;
    }

    SyncBoImpl getSyncBo(String syncKey) throws PersistenceException {
        if (this.TRACE.isLogging(90)) {
            this.TRACE.log(90, this.getClass().getName() + ".getSyncBo invoked. SyncKey=" + syncKey);
        }
        SyncBoDescriptorIterator descriptors = this.interMetaPackageManager.getSyncBoDescriptorFacade().getAllSyncBoDescriptors();
        while (descriptors.hasNext()) {
            SyncBoDescriptor bd = descriptors.next();
            ClassDescriptor cdes = this.dataClasstypeManager.getClassDescriptor(bd);
            SyncBoImpl syncbo = (SyncBoImpl)this.dataPersistenceAdapter.get(cdes, syncKey, this.isQuarantinedManager() ? 1 : 0);
            if (syncbo == null) continue;
            this.traceBo(syncbo);
            return syncbo;
        }
        if (this.TRACE.isLogging(50)) {
            this.TRACE.log(50, this.getClass().getName() + ".getSyncBo returned NULL. SyncBo of key " + syncKey + " NOT FOUND!");
        }
        throw new PersistenceException("SyncBo of key {0} is not found.", new Object[]{syncKey});
    }

    SyncBo getSyncBo(SyncBoDescriptor descr, String key) throws PersistenceException {
        SyncBo bo = this.getSyncBoWithoutCheck(descr, key);
        if (bo != null) {
            return bo;
        }
        if (this.TRACE.isLogging(50)) {
            this.TRACE.log(50, this.getClass().getName() + ".getSyncBo returned NULL. SyncBo of key " + key + " NOT FOUND!");
        }
        throw new PersistenceException("SyncBo of key {0} is not found.", new Object[]{key});
    }

    SyncBo getSyncBoWithoutCheck(SyncBoDescriptor descr, String key) throws PersistenceException {
        ClassDescriptor cdes;
        SyncBo syncbo;
        if (this.TRACE.isLogging(90)) {
            this.TRACE.log(90, this.getClass().getName() + ".getSyncBoWithoutCheck invoked. boDesc=" + descr.getSyncBoName() + " SyncKey=" + key);
        }
        if ((syncbo = (SyncBo)((Object)this.dataPersistenceAdapter.get(cdes = this.dataClasstypeManager.getClassDescriptor(descr), key, this.isQuarantinedManager() ? 1 : 0))) != null) {
            this.traceBo(syncbo);
        }
        return syncbo;
    }

    SyncBoCollection getSyncBos(SyncBoDescriptor descr) throws PersistenceException {
        ClassDescriptor cdes = this.dataClasstypeManager.getClassDescriptor(descr);
        MeIterator result = this.dataPersistenceAdapter.getAll(cdes, this.isQuarantinedManager() ? 1 : 0);
        SyncBoCollectionImpl collection = new SyncBoCollectionImpl();
        collection.set(result);
        return collection;
    }

    void insertFromInDelta(SyncBo syncBo) throws PersistenceException {
        if (this.TRACE.isLogging(90)) {
            this.TRACE.log(90, this.getClass().getName() + ".insertFromInDelta invoked. boDesc=" + syncBo.getSyncBoDescriptor().getSyncBoName() + " SyncKey=" + syncBo.getSyncKey());
        }
        this.traceBo(syncBo);
        this.dataPersistenceAdapter.insert((PersistableEntity)((Object)syncBo), TreeOptionType.COMPLETE, this.isQuarantinedManager() ? 1 : 0);
    }

    void replaceFromInDelta(SyncBo original, SyncBoImpl syncBo) throws PersistenceException {
        if (original != null) {
            syncBo.setPositionStatus(original.getPositionStatus());
            syncBo.setProcessingStatus(original.getProcessingStatus());
            syncBo.setStatusForAll(original.getStatus());
        }
        this.replace(original, syncBo);
    }

    void replaceFromInDelta(SyncBoImpl syncBo) throws PersistenceException {
        if (this.TRACE.isLogging(90)) {
            this.TRACE.log(90, this.getClass().getName() + ".replaceFromInDelta invoked. boDesc=" + syncBo.getSyncBoDescriptor().getSyncBoName() + " SyncKey=" + syncBo.getSyncKey());
        }
        this.traceBo(syncBo);
        SyncBo orgBo = this.getSyncBoWithoutCheck(syncBo.getSyncBoDescriptor(), syncBo.getSyncKey());
        this.replaceFromInDelta(orgBo, syncBo);
    }

    protected void replace(SyncBo orgBo, SyncBo syncBo) throws PersistenceException {
        if (orgBo != null) {
            this.dataPersistenceAdapter.delete((PersistableEntity)((Object)orgBo), TreeOptionType.COMPLETE, this.isQuarantinedManager() ? 1 : 0);
        }
        this.dataPersistenceAdapter.insert((PersistableEntity)((Object)syncBo), TreeOptionType.COMPLETE, this.isQuarantinedManager() ? 1 : 0);
    }

    void modifyFromInDelta(SyncBo syncBo) throws PersistenceException {
        if (this.TRACE.isLogging(90)) {
            this.TRACE.log(90, this.getClass().getName() + ".modifyFromInDelta invoked. boDesc=" + syncBo.getSyncBoDescriptor().getSyncBoName() + " SyncKey=" + syncBo.getSyncKey());
        }
        this.traceBo(syncBo);
        this.dataPersistenceAdapter.modify((PersistableEntity)((Object)syncBo), TreeOptionType.SKELETON, this.isQuarantinedManager() ? 1 : 0);
    }

    void deleteFromInDelta(SyncBo syncBo) throws PersistenceException {
        if (this.TRACE.isLogging(90)) {
            this.TRACE.log(90, this.getClass().getName() + ".deleteFromInDelta invoked. boDesc=" + syncBo.getSyncBoDescriptor().getSyncBoName() + " SyncKey=" + syncBo.getSyncKey());
        }
        this.traceBo(syncBo);
        this.dataPersistenceAdapter.delete((PersistableEntity)((Object)syncBo), TreeOptionType.COMPLETE, this.isQuarantinedManager() ? 1 : 0);
    }

    void deleteAllSyncBo() throws PersistenceException {
        SyncBoDescriptorIterator it = this.interMetaPackageManager.getSyncBoDescriptorFacade().getAllSyncBoDescriptors();
        while (it.hasNext()) {
            this.deleteAllSyncBo(it.next());
        }
    }

    private void deleteAllSyncBo(SyncBoDescriptor d) throws PersistenceException {
        if (this.TRACE.isLogging(90)) {
            this.TRACE.log(90, this.getClass().getName() + ".deleteAllSyncBo invoked. boDesc=" + d.getSyncBoName());
        }
        ClassDescriptor cdes = this.dataClasstypeManager.getClassDescriptor(d);
        this.dataPersistenceAdapter.deleteAll(cdes, TreeOptionType.COMPLETE, 2);
    }

    void processSyncBoOperationFromInDelta(SyncBoChangeActionType action, SyncBoImpl bo) throws PersistenceException {
        if (this.TRACE.isLogging(90)) {
            this.TRACE.log(90, this.getClass().getName() + ".processSyncBoOperationFromInDelta invoked. action=" + action.toString() + " boDesc=" + bo.getSyncBoDescriptor().getSyncBoName() + " syncKey=" + bo.getSyncKey());
            this.traceBo(bo);
        }
        switch (action.toInt()) {
            case 2: {
                this.deleteFromInDelta(bo);
                return;
            }
            case 1: {
                this.modifyFromInDelta(bo);
                return;
            }
            case 3: {
                this.replaceFromInDelta(bo);
                return;
            }
            case 0: {
                this.insertFromInDelta(bo);
                return;
            }
        }
    }

    private void traceBo(SyncBo bo) {
        if (this.TRACE.isLogging(90)) {
            this.TRACE.log(90, "--------- Start of SyncBo Details: syncKey=" + bo.getSyncKey() + " ---------");
            this.TRACE.log(90, bo.toString());
            this.TRACE.log(90, "--------- End of SyncBo Details: syncKey=" + bo.getSyncKey() + " ---------");
        }
    }
}

