/*
 * Decompiled with CFR 0.152.
 */
package com.sap.ip.me.smartsync.core;

import com.sap.ip.me.api.logging.Trace;
import com.sap.ip.me.api.smartsync.SmartSyncException;
import com.sap.ip.me.api.smartsync.SmartSyncRuntime;
import com.sap.ip.me.api.sync.InboundContainer;
import com.sap.ip.me.api.sync.InboundProcessor;
import com.sap.ip.me.api.sync.InboundProcessorRegistry;
import com.sap.ip.me.api.sync.SyncEvent;
import com.sap.ip.me.api.sync.SyncEventListener;
import com.sap.ip.me.api.sync.SyncEventRegistry;
import com.sap.ip.me.api.user.User;
import com.sap.ip.me.core.ConversationId;
import com.sap.ip.me.core.LogonListener;
import com.sap.ip.me.core.UserManagerImpl;
import com.sap.ip.me.smartsync.core.SmartSyncRuntimeImp;
import com.sap.ip.me.spi.smartsync.SmartSyncAdapter;
import com.sap.ip.me.spi.smartsync.SmartSyncDeplAdapter;
import com.sap.ip.me.sync.SyncEventRegistryImpl;
import java.io.File;
import java.io.Serializable;
import java.util.Hashtable;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;

public final class SmartSyncRuntimeManager
implements SmartSyncAdapter,
InboundProcessor,
SyncEventListener,
LogonListener,
SmartSyncDeplAdapter,
Serializable {
    private static transient SmartSyncRuntimeManager instance = null;
    private final transient Hashtable instance_pool = new Hashtable(2);
    private transient Thread background_thread = null;
    private static final transient Trace TRACE = Trace.getInstance("MI/Smartsync");
    private static final transient String KEY_FRONTAPP = "FRONT_APPLICATION";
    private static final transient String KEY_BACKGROUND = "BACKGROUND_SYNC";

    private SmartSyncRuntimeManager() {
    }

    public static synchronized SmartSyncRuntimeManager getInstance() {
        if (instance == null) {
            instance = new SmartSyncRuntimeManager();
        }
        return instance;
    }

    public static synchronized SmartSyncRuntime getSmartSyncRuntime() {
        return SmartSyncRuntimeManager.getInstance().getProperInstance();
    }

    public synchronized void applicationActivated() {
        TRACE.log(70, "Smart Sync framework: framework activated an application.");
        SmartSyncRuntime instance = this.getProperInstance();
        if (instance != null) {
            ((SmartSyncRuntimeImp)this.getProperInstance()).switchApplicationContext();
        }
        TRACE.log(70, "Smart Sync framework: framework activated an application, the smart sync repository has been switched.");
    }

    public synchronized void applicationDeactivated() {
        TRACE.log(70, "Smart Sync framework: framework de-activated an application.");
        SmartSyncRuntime instance = this.getProperInstance();
        if (instance != null) {
            ((SmartSyncRuntimeImp)this.getProperInstance()).switchApplicationContext();
        }
        TRACE.log(70, "Smart Sync framework: framework de- activated an application, the smart sync repository has been switched.");
    }

    public synchronized void applicationDestroyed() {
        TRACE.log(70, "Smart Sync framework: framework destroyed an application.");
    }

    public synchronized void userLoggedIn() {
        TRACE.log(70, "Smart Sync framework: user logged in.");
        SmartSyncRuntime instance = this.getProperInstance();
        if (instance != null) {
            ((SmartSyncRuntimeImp)this.getProperInstance()).switchApplicationContext();
        }
        TRACE.log(70, "Smart Sync framework: user logged in.");
    }

    public void initializeSmartSyncFramework() {
        SmartSyncRuntimeImp instance = new SmartSyncRuntimeImp();
        this.instance_pool.put(KEY_FRONTAPP, instance);
        InboundProcessorRegistry.getInstance().register(this);
        UserManagerImpl.getUserManagerImplInstance().addLogonListener(this);
    }

    public void initializeSmartSyncFrameworkForBackgroundSync() {
        if (this.instance_pool.get(KEY_BACKGROUND) == null) {
            this.instance_pool.put(KEY_BACKGROUND, new SmartSyncRuntimeImp());
        }
        this.background_thread = Thread.currentThread();
    }

    public synchronized void actionPerformed(SyncEvent event) {
        ((SmartSyncRuntimeImp)this.getProperInstance()).actionPerformed(event);
    }

    public synchronized void userLoggedOn(User user) {
        ((SyncEventRegistryImpl)SyncEventRegistry.getInstance()).addSyncEventListener(this);
    }

    public synchronized void process(InboundContainer inboundContainer) {
        ((SmartSyncRuntimeImp)this.getProperInstance()).process(inboundContainer);
    }

    public String getMethodName() {
        return ((SmartSyncRuntimeImp)this.getProperInstance()).getMethodName();
    }

    public synchronized void setMetaDataFile(String appliId, ZipFile zip, ZipEntry sourceEntry) {
        ((SmartSyncRuntimeImp)this.getProperInstance()).setMetaDataFile(appliId, zip, sourceEntry);
    }

    public synchronized void setMetaDataFile(String appliId, File f) {
        ((SmartSyncRuntimeImp)this.getProperInstance()).setMetaDataFile(appliId, f);
    }

    public synchronized void processMetaData(ConversationId convId) {
        ((SmartSyncRuntimeImp)this.getProperInstance()).processMetaData(convId);
    }

    private SmartSyncRuntime getProperInstance() {
        SmartSyncRuntime runtime = null;
        if (Thread.currentThread() == this.background_thread) {
            runtime = (SmartSyncRuntime)this.instance_pool.get(KEY_BACKGROUND);
            if (runtime == null) {
                this.initializeSmartSyncFrameworkForBackgroundSync();
                runtime = (SmartSyncRuntime)this.instance_pool.get(KEY_BACKGROUND);
            }
        } else {
            runtime = (SmartSyncRuntime)this.instance_pool.get(KEY_FRONTAPP);
            if (runtime == null) {
                this.initializeSmartSyncFramework();
                runtime = (SmartSyncRuntime)this.instance_pool.get(KEY_FRONTAPP);
            }
        }
        return runtime;
    }

    public boolean hasSyncBoOutDelta() throws SmartSyncException {
        return ((SmartSyncRuntimeImp)this.getProperInstance()).hasSyncBoOutDelta();
    }
}

