/*
 * Decompiled with CFR 0.152.
 */
package com.sap.ip.me.smartsync.core;

import com.sap.ip.me.api.conf.VisibilityType;
import com.sap.ip.me.api.logging.Trace;
import com.sap.ip.me.api.persist.core.PersistenceException;
import com.sap.ip.me.api.smartsync.InboxNotifier;
import com.sap.ip.me.api.smartsync.SmartSyncException;
import com.sap.ip.me.api.smartsync.SmartSyncJQueryFactory;
import com.sap.ip.me.api.smartsync.SmartSyncQueryFactory;
import com.sap.ip.me.api.smartsync.SyncBoDataFacade;
import com.sap.ip.me.api.smartsync.SyncBoDeltaRequestFacade;
import com.sap.ip.me.api.smartsync.SyncBoDescriptor;
import com.sap.ip.me.api.smartsync.SyncBoDescriptorFacade;
import com.sap.ip.me.api.smartsync.SyncBoOutDeltaFacade;
import com.sap.ip.me.api.smartsync.SyncBoOutDeltaNotifier;
import com.sap.ip.me.api.sync.InboundContainer;
import com.sap.ip.me.api.sync.InboundProcessor;
import com.sap.ip.me.api.sync.SyncEvent;
import com.sap.ip.me.api.sync.SyncEventListener;
import com.sap.ip.me.api.user.User;
import com.sap.ip.me.api.user.UserManager;
import com.sap.ip.me.core.ContextSwitch;
import com.sap.ip.me.core.ConversationId;
import com.sap.ip.me.core.ConversationIdHandler;
import com.sap.ip.me.core.MobileSolutionDescriptor;
import com.sap.ip.me.smartsync.data.DataPackageManager;
import com.sap.ip.me.smartsync.delta.DeltaPackageManager;
import com.sap.ip.me.smartsync.depladp.DeplAdapter;
import com.sap.ip.me.smartsync.ipi.InterDataPackageManager;
import com.sap.ip.me.smartsync.ipi.InterDeltaPackageManager;
import com.sap.ip.me.smartsync.ipi.InterMetaPackageManager;
import com.sap.ip.me.smartsync.ipi.InterSyncPackageManager;
import com.sap.ip.me.smartsync.ipi.InternalOutDeltaFacade;
import com.sap.ip.me.smartsync.ipi.InternalSmartSyncRuntime;
import com.sap.ip.me.smartsync.ipi.PersistenceAdapter;
import com.sap.ip.me.smartsync.meta.MetaPackageManager;
import com.sap.ip.me.smartsync.persadp.PersistenceAdapterImpl;
import com.sap.ip.me.smartsync.sync.SmartSynchronizationException;
import com.sap.ip.me.smartsync.sync.SyncPackageManager;
import com.sap.ip.me.spi.smartsync.SmartSyncDeplAdapter;
import java.io.File;
import java.io.InputStream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;

public final class SmartSyncRuntimeImp
extends InternalSmartSyncRuntime
implements InboundProcessor,
SyncEventListener,
SmartSyncDeplAdapter {
    private final PersistenceAdapter metaPersisAdpt = new PersistenceAdapterImpl(VisibilityType.USER_SHARED);
    private final PersistenceAdapter dataPersisAdpt = new PersistenceAdapterImpl(VisibilityType.SEPARATED);
    private final InterDataPackageManager data;
    private final InterDeltaPackageManager delta;
    private final InterMetaPackageManager meta = new MetaPackageManager(this.metaPersisAdpt);
    private final InterSyncPackageManager sync;
    private final SmartSyncDeplAdapter delpAdpt = new DeplAdapter(this.meta);
    private String conversation_id = null;
    private static final Trace TRACE = Trace.getInstance("MI/Smartsync");

    SmartSyncRuntimeImp() {
        this.delta = new DeltaPackageManager(this.dataPersisAdpt, this.meta);
        this.data = new DataPackageManager(this.dataPersisAdpt, this.meta, this.delta);
        this.delta.setInterDataPackageManager(this.data);
        this.sync = new SyncPackageManager(this.dataPersisAdpt, this.meta, this.data, this.delta);
    }

    void switchApplicationContext() {
        ConversationId cur_cnvId = null;
        if (UserManager.getInstance().getCurrentUser() == null) {
            TRACE.log(70, "There is no user logged on; use shared framework conversation id.");
            cur_cnvId = ConversationIdHandler.getSharedFrameworkConversationId();
        } else {
            cur_cnvId = ConversationIdHandler.getInstance().getCurrentConversationId();
        }
        if (cur_cnvId == null) {
            TRACE.log(90, "Smart Sync context switch not necessary for null conversation id. ");
            return;
        }
        if (cur_cnvId.getId().equals(this.conversation_id)) {
            TRACE.log(90, "Smart Sync context switch not necessary for same conversation id ");
            return;
        }
        MobileSolutionDescriptor msd = cur_cnvId.getMsd();
        if (!(msd != null && msd.isItASmartSyncApplication() || cur_cnvId.isFrameworkConversationId())) {
            TRACE.log(90, "Smart Sync context switch not necessary for Generic Sync App: " + msd);
            return;
        }
        TRACE.log(90, "Smart Sync context switch from " + this.conversation_id + " to " + cur_cnvId.getId());
        this.conversation_id = cur_cnvId.getId();
        this.metaPersisAdpt.onSwitchConversationId();
        this.dataPersisAdpt.onSwitchConversationId();
        this.meta.registerPersistenceMaster();
        this.meta.registerEntityFactory();
        this.meta.onSwitchConversationId();
        this.delta.registerPersistenceMaster();
        this.delta.registerEntityFactory();
        this.delta.onSwitchConversationId();
        this.data.registerPersistenceMaster();
        this.data.registerEntityFactory();
        this.data.onSwitchConversationId();
    }

    public SyncBoOutDeltaFacade getSyncBoOutDeltaFacade(VisibilityType visibility) {
        return this.delta.getSyncBoOutDeltaFacade();
    }

    public SyncBoDescriptorFacade getSyncBoDescriptorFacade() {
        return this.meta.getSyncBoDescriptorFacade();
    }

    public SmartSyncQueryFactory getQueryFactory() {
        return this.data.getQueryFactory();
    }

    public SmartSyncJQueryFactory getJQueryFactory() {
        return this.data.getJQueryFactory();
    }

    public SyncBoDeltaRequestFacade getSyncBoDeltaRequestFacade(VisibilityType visibility) {
        return this.delta.getSyncBoDeltaRequestFacade();
    }

    public SyncBoDataFacade getSyncBoDataFacade(VisibilityType visibility) {
        return this.data.getSyncBoDataFacade();
    }

    public InboxNotifier getInboxNotifier() {
        return this.sync.getInboxNotifier();
    }

    public SyncBoOutDeltaNotifier getSyncBoOutDeltaNotifier() {
        return this.sync.getSyncBoOutDeltaNotifier();
    }

    public SyncBoDeltaRequestFacade getSyncBoDeltaRequestFacade() {
        return this.delta.getSyncBoDeltaRequestFacade();
    }

    public SyncBoOutDeltaFacade getSyncBoOutDeltaFacade() {
        return this.delta.getSyncBoOutDeltaFacade();
    }

    public SyncBoDataFacade getSyncBoDataFacade() {
        return this.data.getSyncBoDataFacade();
    }

    public void actionPerformed(SyncEvent event) {
        ConversationId[] convIds;
        User currentUser = null;
        try {
            currentUser = UserManager.getInstance().getCurrentUser();
            convIds = ConversationIdHandler.getInstance().getAllConversationIdsForUser(currentUser);
        }
        catch (Exception e) {
            throw new SmartSynchronizationException("SmartSync fail to receive conversation ids: ", e);
        }
        ContextSwitch context = null;
        int i = 0;
        while (i < convIds.length) {
            if (convIds[i].isFrameworkConversationId() || convIds[i].getMsd().isItASmartSyncApplication()) {
                Object var7_7;
                if (convIds[i].isFrameworkConversationId() && !convIds[i].isGeneratedOnServer()) {
                    TRACE.log(90, "User has not been installed on MW, it is not ready for sync :" + currentUser);
                    return;
                }
                context = ContextSwitch.switchContextTo(convIds[i]);
                try {
                    this.switchApplicationContext();
                    this.sync.actionPerformed(event, convIds[i]);
                    var7_7 = null;
                }
                catch (Throwable throwable) {
                    var7_7 = null;
                    ContextSwitch.restoreLastContext(context);
                    throw throwable;
                }
                ContextSwitch.restoreLastContext(context);
                {
                }
            }
            ++i;
        }
        this.switchApplicationContext();
    }

    public boolean hasSyncBoOutDelta() throws SmartSyncException {
        ConversationId[] convIds;
        InternalOutDeltaFacade outDelta = this.delta.getInternalOutDeltaFacade();
        boolean hasDelta = false;
        User currentUser = null;
        try {
            currentUser = UserManager.getInstance().getCurrentUser();
            convIds = ConversationIdHandler.getInstance().getAllConversationIdsForUser(currentUser);
        }
        catch (Exception e) {
            throw new SmartSynchronizationException("SmartSync fail to receive conversation ids: ", e);
        }
        ContextSwitch context = null;
        int i = 0;
        while (i < convIds.length) {
            if (convIds[i].isFrameworkConversationId() || convIds[i].getMsd().isItASmartSyncApplication()) {
                Object var8_8;
                block6: {
                    context = ContextSwitch.switchContextTo(convIds[i]);
                    try {
                        this.switchApplicationContext();
                        if (!outDelta.hasDelta()) break block6;
                        hasDelta = true;
                        var8_8 = null;
                    }
                    catch (Throwable throwable) {
                        var8_8 = null;
                        ContextSwitch.restoreLastContext(context);
                        throw throwable;
                    }
                    ContextSwitch.restoreLastContext(context);
                    {
                        break;
                    }
                }
                var8_8 = null;
                ContextSwitch.restoreLastContext(context);
                {
                }
            }
            ++i;
        }
        this.switchApplicationContext();
        return hasDelta;
    }

    public void process(InboundContainer inboundContainer) {
        this.switchApplicationContext();
        this.sync.process(inboundContainer);
    }

    public String getMethodName() {
        return this.sync.getMethodName();
    }

    public void setMetaDataFile(String appliId, ZipFile zip, ZipEntry sourceEntry) {
        this.delpAdpt.setMetaDataFile(appliId, zip, sourceEntry);
    }

    public void setMetaDataFile(String appliId, File f) {
        this.delpAdpt.setMetaDataFile(appliId, f);
    }

    public void processMetaData(ConversationId convId) {
        if (!convId.isSharedConversationId()) {
            return;
        }
        ContextSwitch context = null;
        context = ContextSwitch.switchContextTo(convId);
        try {
            this.switchApplicationContext();
            this.delpAdpt.processMetaData(convId);
            Object var4_3 = null;
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            ContextSwitch.restoreLastContext(context);
            throw throwable;
        }
        ContextSwitch.restoreLastContext(context);
        this.switchApplicationContext();
    }

    public void importXmlMeta(InputStream xmlByteArray) throws PersistenceException {
        ((MetaPackageManager)this.meta).importXmlMeta(xmlByteArray);
    }

    public InterDataPackageManager _getInterDataPackageManager() {
        return this.data;
    }

    public InterDeltaPackageManager _getInterDeltaPackageManager() {
        return this.delta;
    }

    public InterMetaPackageManager _getInterMetaPackageManager() {
        return this.meta;
    }

    public InterSyncPackageManager _getInterSyncPackageManager() {
        return this.sync;
    }

    public PersistenceAdapter _getDataPersistenceAdapter() {
        return this.dataPersisAdpt;
    }

    public void _switchApplicationContext() {
        this.conversation_id = null;
        this.switchApplicationContext();
    }

    public void prepareSyncBoOutDeltaExcluding(SyncBoDescriptor[] excluding) {
        this.sync.ignoreSyncBosForDeltaUpload(excluding);
        try {
            this.sync.actionPerformed(new SyncEvent(this, 0), ConversationIdHandler.getInstance().getCurrentConversationId());
            Object var3_2 = null;
            this.sync.ignoreSyncBosForDeltaUpload(null);
        }
        catch (Throwable throwable) {
            Object var3_3 = null;
            this.sync.ignoreSyncBosForDeltaUpload(null);
            throw throwable;
        }
    }
}

