/*
 * Decompiled with CFR 0.152.
 */
package com.sap.ip.me.services.os;

import com.sap.ip.me.api.conf.Configuration;
import com.sap.ip.me.api.logging.Trace;
import com.sap.ip.me.api.services.HttpConnectionException;
import com.sap.ip.me.api.services.IOUtils;
import com.sap.ip.me.services.os.AbstractAgent;
import com.sap.ip.me.services.os.AgentPropertyValue;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.util.Calendar;
import java.util.Date;

public class TimeAgent
extends AbstractAgent {
    private static final String TIME_SYNCSERVLET_NAME = "GetServerTimeAndDate";
    private static final String AGENT_TIME = "TIME_AGENT";
    private long startDelay = 0L;
    private long endDelay = 0L;

    public String getName() {
        return AGENT_TIME;
    }

    public AgentPropertyValue[] getPropertyValues() {
        AgentPropertyValue[] values = AgentPropertyValue.nullArray;
        this.convertDate(this.convertString(this.getTimeFromServer()));
        return values;
    }

    void doSetProperty(String propertyName, String value) throws Throwable {
    }

    private void convertDate(Date serverDate) {
        Calendar calender = Calendar.getInstance();
        Date theDate = new Date(serverDate.getTime() + (long)calender.get(16));
        Trace.getInstance("MI/Services/Os").log(90, "Time from server: " + serverDate.getTime());
        Trace.getInstance("MI/Services/Os").log(90, "Calendar.ZONE_OFFSET: " + calender.get(15));
        Trace.getInstance("MI/Services/Os").log(90, "Calendar.DST_OFFSET: " + calender.get(16));
        calender.setTime(theDate);
        int year = calender.get(1);
        int month = calender.get(2) + 1;
        int dayOfWeek = calender.get(7) - 1;
        int day = calender.get(5);
        int hour = calender.get(11) - 1;
        int minute = calender.get(12);
        int second = calender.get(13);
        int milliseconds = calender.get(14);
        this.setSystemTime(year, month, dayOfWeek, day, hour, minute, second, 0);
    }

    private Date getServerTime() {
        Calendar calender = Calendar.getInstance();
        this.startDelay = System.currentTimeMillis();
        this.endDelay = System.currentTimeMillis();
        long delay = this.endDelay - this.startDelay;
        return calender.getTime();
    }

    private String getUrl() {
        String httpPrefix = "http://";
        String host = Configuration.getInstance().getProperty("MobileEngine.Sync.Gateway.Host");
        String delimitter = ":";
        String port = Configuration.getInstance().getProperty("MobileEngine.Sync.Gateway.Port");
        String servletFolder = "/meSync/";
        String paramPrefix = "?~sysid=";
        String sysId = Configuration.getInstance().getProperty("MobileEngine.Sync.Gateway.System");
        String mandantParamPrefix = "&~client=";
        String mandant = Configuration.getInstance().getProperty("MobileEngine.Sync.Client");
        String languagePrefix = "&~language=";
        String language = Configuration.getInstance().getProperty("MobileEngine.Sync.Language");
        String url = httpPrefix + host + delimitter + port + servletFolder + TIME_SYNCSERVLET_NAME + paramPrefix + sysId + mandantParamPrefix + mandant + languagePrefix + language + "&";
        return url;
    }

    public native void setSystemTime(int var1, int var2, int var3, int var4, int var5, int var6, int var7, int var8);

    private Date convertString(String serverTime) throws NumberFormatException {
        Calendar calender = Calendar.getInstance();
        String year = serverTime.substring(0, 4);
        String month = serverTime.substring(4, 6);
        String day = serverTime.substring(6, 8);
        String hour = serverTime.substring(8, 10);
        String minutes = serverTime.substring(10, 12);
        String second = serverTime.substring(12);
        calender.set(Integer.parseInt(year), Integer.parseInt(month) - 1, Integer.parseInt(day), Integer.parseInt(hour), Integer.parseInt(minutes), Integer.parseInt(second));
        return calender.getTime();
    }

    private String getTimeFromServer() {
        URL url = null;
        String serverUTCTime = null;
        try {
            url = new URL(this.getUrl());
            IOUtils.isConnectable(url);
            URLConnection connection = url.openConnection();
            connection.setRequestProperty("getServerTimeAndDate", "true");
            serverUTCTime = connection.getHeaderField("TimeandDate");
        }
        catch (MalformedURLException m) {
            Trace.getInstance("MI/Services/Os").log(90, "This is not a valid URL: " + m.getMessage());
        }
        catch (HttpConnectionException e) {
            Trace.getInstance("MI/Services/Os").log(90, "MI Server not reachable: " + e.getMessage());
        }
        catch (IOException io) {
            Trace.getInstance("MI/Services/Os").log(90, "IOException:  " + io.getMessage());
        }
        return serverUTCTime;
    }

    static {
        try {
            System.loadLibrary("TimeSync");
        }
        catch (UnsatisfiedLinkError e) {
            Trace.getInstance("MI/Services/Os").log(90, "Problems loading TimeSync.dll: " + e.getMessage());
        }
    }
}

