/*
 * Decompiled with CFR 0.152.
 */
package com.sap.ip.me.services.os;

import com.sap.ip.me.api.conf.Configuration;
import com.sap.ip.me.services.os.AbstractAgent;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.PrintWriter;
import java.io.StreamCorruptedException;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.NoSuchElementException;
import java.util.Properties;

public class SyncCount {
    long count = 0L;
    Properties info = new Properties();

    public SyncCount() {
        ((Hashtable)this.info).put("SYNC_COUNT", String.valueOf(this.count));
        File file = this.getSyncCounterFile();
        if (file.exists()) {
            this.initFromFile();
        } else {
            this.writeSyncCounterFile(file);
        }
    }

    private File getSyncCounterFile() {
        return new File(Configuration.getSettingsFolder() + ".syncCount");
    }

    /*
     * Loose catch block
     */
    private void initFromFile() {
        block29: {
            FileInputStream fileInputStream = null;
            ObjectInputStream objectInputStream = null;
            File file = this.getSyncCounterFile();
            fileInputStream = new FileInputStream(file);
            this.info.load(fileInputStream);
            this.count = Long.parseLong(this.info.getProperty("SYNC_COUNT"));
            Object var8_4 = null;
            try {
                if (objectInputStream != null) {
                    objectInputStream.close();
                }
            }
            catch (IOException e1) {
                e1.printStackTrace();
            }
            try {
                if (fileInputStream != null) {
                    fileInputStream.close();
                }
                break block29;
            }
            catch (IOException e2) {
                e2.printStackTrace();
            }
            break block29;
            {
                catch (StreamCorruptedException e) {
                    e.printStackTrace();
                    Object var8_5 = null;
                    try {
                        if (objectInputStream != null) {
                            objectInputStream.close();
                        }
                    }
                    catch (IOException e1) {
                        e1.printStackTrace();
                    }
                    try {
                        if (fileInputStream != null) {
                            fileInputStream.close();
                        }
                        break block29;
                    }
                    catch (IOException e2) {
                        e2.printStackTrace();
                    }
                    break block29;
                }
                catch (FileNotFoundException e) {
                    e.printStackTrace();
                    Object var8_6 = null;
                    try {
                        if (objectInputStream != null) {
                            objectInputStream.close();
                        }
                    }
                    catch (IOException e1) {
                        e1.printStackTrace();
                    }
                    try {
                        if (fileInputStream != null) {
                            fileInputStream.close();
                        }
                        break block29;
                    }
                    catch (IOException e2) {
                        e2.printStackTrace();
                    }
                    break block29;
                }
                catch (IOException e) {
                    e.printStackTrace();
                    Object var8_7 = null;
                    try {
                        if (objectInputStream != null) {
                            objectInputStream.close();
                        }
                    }
                    catch (IOException e1) {
                        e1.printStackTrace();
                    }
                    try {
                        if (fileInputStream != null) {
                            fileInputStream.close();
                        }
                        break block29;
                    }
                    catch (IOException e2) {
                        e2.printStackTrace();
                    }
                }
            }
            catch (Throwable throwable) {
                Object var8_8 = null;
                try {
                    if (objectInputStream != null) {
                        objectInputStream.close();
                    }
                }
                catch (IOException e1) {
                    e1.printStackTrace();
                }
                try {
                    if (fileInputStream != null) {
                        fileInputStream.close();
                    }
                }
                catch (IOException e2) {
                    e2.printStackTrace();
                }
                throw throwable;
            }
        }
    }

    private void writeSyncCounterFile() {
        File file = this.getSyncCounterFile();
        if (file.exists()) {
            file.delete();
        }
        this.writeSyncCounterFile(file);
    }

    /*
     * Loose catch block
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void writeSyncCounterFile(File file) {
        FileOutputStream fileOutputStream = null;
        Object outputStream = null;
        PrintWriter printWriter = null;
        String elem = null;
        fileOutputStream = new FileOutputStream(file);
        printWriter = new PrintWriter(fileOutputStream);
        Enumeration elements = ((Hashtable)this.info).keys();
        while (elements.hasMoreElements()) {
            elem = elements.nextElement().toString();
            printWriter.println(elem + "=" + this.info.getProperty(elem));
        }
        Object var9_7 = null;
        if (printWriter != null) {
            printWriter.close();
        }
        if (fileOutputStream == null) return;
        try {
            fileOutputStream.close();
            return;
        }
        catch (IOException e2) {
            e2.printStackTrace();
        }
        return;
        {
            catch (IOException e) {
                Object var9_8 = null;
                if (printWriter != null) {
                    printWriter.close();
                }
                if (fileOutputStream == null) return;
                try {
                    fileOutputStream.close();
                    return;
                }
                catch (IOException e2) {
                    e2.printStackTrace();
                }
                return;
            }
        }
        catch (Throwable throwable) {
            Object var9_9 = null;
            if (printWriter != null) {
                printWriter.close();
            }
            if (fileOutputStream == null) throw throwable;
            try {
                fileOutputStream.close();
                throw throwable;
            }
            catch (IOException e2) {
                e2.printStackTrace();
            }
            throw throwable;
        }
    }

    public void increment() {
        ++this.count;
        ((Hashtable)this.info).put("SYNC_COUNT", String.valueOf(this.count));
        this.writeSyncCounterFile();
    }

    public void increment(String agentName, String abapDate, String abapTime) {
        ((Hashtable)this.info).put(agentName + "LAST_SYNC_DATE", abapDate);
        ((Hashtable)this.info).put(agentName + "LAST_SYNC_TIME", abapTime);
    }

    public long toLong() {
        return this.count;
    }

    public Date getLastSync() {
        String lastSyncDateAndTimeAsString = "";
        lastSyncDateAndTimeAsString = this.info.getProperty("LAST_SYNC_DATE");
        lastSyncDateAndTimeAsString = lastSyncDateAndTimeAsString + this.info.getProperty("LAST_SYNC_TIME");
        try {
            if (null == lastSyncDateAndTimeAsString) {
                return this._toDate("19700101000000");
            }
            return this._toDate(lastSyncDateAndTimeAsString);
        }
        catch (ParseException e) {
            throw new NoSuchElementException("cannot retrieve last sync date");
        }
    }

    public Date getLastReportDateAndTime(AbstractAgent anAgent) {
        String agentName = anAgent.getName();
        String timeStamp = this.info.getProperty(agentName + "LAST_SYNC_DATE");
        timeStamp = timeStamp + this.info.getProperty(agentName + "LAST_SYNC_TIME");
        try {
            return this._toDate(timeStamp);
        }
        catch (ParseException e) {
            try {
                return this._toDate("19700101000000");
            }
            catch (ParseException e1) {
                throw new NoSuchElementException("cannot retrieve last sync date for agent " + agentName);
            }
        }
    }

    private Date _toDate(String aTimeAndDateString) throws ParseException {
        SimpleDateFormat dateFormatter = new SimpleDateFormat("yyyyMMddHHmmSS");
        dateFormatter.setCalendar(Calendar.getInstance());
        return dateFormatter.parse(aTimeAndDateString);
    }
}

