/*
 * Decompiled with CFR 0.152.
 */
package com.sap.ip.me.services.os;

import com.sap.ip.me.api.logging.Trace;
import com.sap.ip.me.ccms.Alert;
import com.sap.ip.me.ccms.AlertManager;
import com.sap.ip.me.services.os.AbstractAgent;
import com.sap.ip.me.services.os.AgentPropertyValue;
import com.sap.ip.me.services.os.MemoryInfo;
import com.sap.ip.me.services.os.StorageCardInfo;
import java.util.Hashtable;
import java.util.Properties;
import java.util.Vector;

public class StorageAgent
extends AbstractAgent
implements Alert {
    private static final int MEMORY_STATUS_ALERT_GREEN = 1;
    private static final int MEMORY_STATUS_ALERT_YELLOW = 2;
    private static final int MEMORY_STATUS_ALERT_RED = 3;
    private static final String INDEX_SEPARATOR = "_";
    private static final int NUM_OF_STORAGE_CARD_ATTRIBUTES = 3;
    private static final String AGENT_STORAGE = "STORAGE";
    private static final String ALERT_MEMORY_STATUS = "MEMORY_STATUS";
    private static final String MEMORY_CRITICAL = "MEMORY_CRITICAL";
    private static final String MEMORY_ALERT_YELLOW = "MEMORY_ALERT_YELLOW";
    public static final String TOTAL_DATA = "TOTAL_DATA";
    public static final String FREE_DATA = "FREE_DATA";
    public static final String TOTAL_SYSTEM_DATA = "TOTAL_SYSTEM_DATA";
    public static final String FREE_SYSTEM_DATA = "FREE_SYSTEM_DATA";
    public static final String STORAGE_CARD = "CARD";
    public static final String STORAGE_CARD_NAME = "NAME";
    public static final String STORAGE_CARD_TOTAL = "TOTAL";
    public static final String STORAGE_CARD_FREE = "FREE";
    public static final String AGENT_TRIGGER_ON_LOW_MEMORY = "AGENT_TRIGGER_ON_LOW_MEMORY";
    static /* synthetic */ Class class$com$sap$ip$me$services$os$StorageAgent;

    public StorageAgent() {
        AlertManager.getInstance().register(this);
    }

    public AgentPropertyValue[] getPropertyValues() {
        try {
            AgentPropertyValue[] values = this.readPropertyValues();
            long freeMemory = Long.parseLong(values[1].getValue());
            if (!this.reportOnLowMemory()) {
                return values;
            }
            long threshold = Math.max(this.getMemoryThresholdForYellowAlert(), this.getCriticalMemoryThreshold());
            Trace.getInstance("MI/Services/Os").log(90, "Storage agent - Free memory: " + freeMemory + ", memory threshold " + threshold);
            if (freeMemory < threshold) {
                return values;
            }
            return AgentPropertyValue.nullArray;
        }
        catch (UnsatisfiedLinkError e) {
            Trace.getInstance("MI/Services/Os").log(90, "Storage agent: access to native library failed. Cannot determine storage.");
            return AgentPropertyValue.nullArray;
        }
    }

    public String getName() {
        return AGENT_STORAGE;
    }

    public native boolean deviceHasStorageCards();

    public native MemoryInfo getTotalMemoryInfo();

    public native StorageCardInfo[] getStorageCardInfo();

    void doSetProperty(String propertyName, String value) throws Throwable {
        try {
            if (propertyName.equals(MEMORY_ALERT_YELLOW) || propertyName.equals(MEMORY_CRITICAL)) {
                Long.parseLong(value);
                this.getConfiguration().setAgentParameter(this, propertyName, value);
            } else if (propertyName.equals(AGENT_TRIGGER_ON_LOW_MEMORY)) {
                this.getConfiguration().setAgentParameter(this, propertyName, value.toUpperCase());
            }
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
    }

    public AgentPropertyValue[] readPropertyValues() {
        long totalAccumulated = 0L;
        long freeAccumulated = 0L;
        MemoryInfo memoryInfo = this.getTotalMemoryInfo();
        totalAccumulated = memoryInfo.getTotalMemoryStorage();
        freeAccumulated = memoryInfo.getFreeMemoryStorage();
        StorageCardInfo[] storageCardInfo = this.getStorageCardInfo();
        AgentPropertyValue[] result = new AgentPropertyValue[4 + storageCardInfo.length * 3];
        result[2] = new AgentPropertyValue(TOTAL_SYSTEM_DATA, String.valueOf(totalAccumulated));
        result[3] = new AgentPropertyValue(FREE_SYSTEM_DATA, String.valueOf(freeAccumulated));
        int j = 4;
        int i = 0;
        while (i < storageCardInfo.length) {
            totalAccumulated += storageCardInfo[i].getTotalMemoryStorage();
            freeAccumulated += storageCardInfo[i].getFreeMemoryStorage();
            this.toAgentPropertyValue(i, storageCardInfo[i], j, result);
            j += 3;
            ++i;
        }
        result[0] = new AgentPropertyValue(TOTAL_DATA, String.valueOf(totalAccumulated));
        result[1] = new AgentPropertyValue(FREE_DATA, String.valueOf(freeAccumulated));
        return result;
    }

    private void toAgentPropertyValue(int cardIndex, StorageCardInfo storageCardInfo, int propertyIndex, AgentPropertyValue[] propertyValues) {
        propertyValues[propertyIndex] = new AgentPropertyValue(this.propertyName(cardIndex, STORAGE_CARD_NAME), storageCardInfo.getCardName());
        propertyValues[propertyIndex + 1] = new AgentPropertyValue(this.propertyName(cardIndex, STORAGE_CARD_TOTAL), String.valueOf(storageCardInfo.getTotalMemoryStorage()));
        propertyValues[propertyIndex + 2] = new AgentPropertyValue(this.propertyName(cardIndex, STORAGE_CARD_FREE), String.valueOf(storageCardInfo.getFreeMemoryStorage()));
    }

    public static void main(String[] args) {
        StorageAgent agent = new StorageAgent();
        AgentPropertyValue[] values = agent.readPropertyValues();
        int i = 0;
        while (i < values.length) {
            System.out.println(values[i].toString());
            ++i;
        }
    }

    private String propertyName(int cardIndex, String innerName) {
        return "CARD_" + cardIndex + INDEX_SEPARATOR + innerName;
    }

    public void compare(int value) {
    }

    public int getAlertValue() {
        if (this.getFree() < this.getCriticalMemoryThreshold()) {
            return 3;
        }
        if (this.getFree() < this.getMemoryThresholdForYellowAlert()) {
            return 2;
        }
        return 1;
    }

    public void setAlertValue(int value) {
    }

    public String getAlertName() {
        return ALERT_MEMORY_STATUS;
    }

    public void setAlertName(String alertName) {
    }

    public long getCriticalMemoryThreshold() {
        return Long.parseLong(this.getAgentProperty(MEMORY_CRITICAL, "2000"));
    }

    private long getMemoryThresholdForYellowAlert() {
        return Long.parseLong(this.getAgentProperty(MEMORY_ALERT_YELLOW, "3000"));
    }

    public long getFree() {
        try {
            long free = this.getTotalMemoryInfo().getTotalMemoryStorage();
            StorageCardInfo[] storageCardInfo = this.getStorageCardInfo();
            int i = 0;
            while (i < storageCardInfo.length) {
                free += storageCardInfo[i].getFreeMemoryStorage();
                ++i;
            }
            return free;
        }
        catch (UnsatisfiedLinkError e) {
            AbstractAgent.errorNativeLibrary(this.getClass());
            return 999999999L;
        }
    }

    public Vector getDefaultGetParameters() {
        Vector parametersToReport = super.getDefaultGetParameters();
        parametersToReport.addElement(TOTAL_DATA);
        parametersToReport.addElement(FREE_DATA);
        parametersToReport.addElement(TOTAL_SYSTEM_DATA);
        parametersToReport.addElement(FREE_SYSTEM_DATA);
        parametersToReport.addElement("CARD_%1_NAME");
        parametersToReport.addElement("CARD_%1_TOTAL");
        parametersToReport.addElement("CARD_%1_FREE");
        return parametersToReport;
    }

    private boolean reportOnLowMemory() {
        return this.getAgentProperty(AGENT_TRIGGER_ON_LOW_MEMORY, "FALSE").equals("TRUE");
    }

    public Properties getDefaultParameters() {
        Properties properties = super.getDefaultParameters();
        ((Hashtable)properties).put(AGENT_TRIGGER_ON_LOW_MEMORY, "FALSE");
        ((Hashtable)properties).put(MEMORY_ALERT_YELLOW, "3000");
        ((Hashtable)properties).put(MEMORY_CRITICAL, "2000");
        return properties;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static {
        try {
            System.loadLibrary("agent");
        }
        catch (UnsatisfiedLinkError e) {
            AbstractAgent.errorNativeLibrary(class$com$sap$ip$me$services$os$StorageAgent == null ? (class$com$sap$ip$me$services$os$StorageAgent = StorageAgent.class$("com.sap.ip.me.services.os.StorageAgent")) : class$com$sap$ip$me$services$os$StorageAgent);
        }
    }
}

