/*
 * Decompiled with CFR 0.152.
 */
package com.sap.ip.me.services.os;

import com.sap.ip.me.api.logging.Trace;
import java.io.IOException;

public class ScriptThread
extends Thread {
    private static final String COMPONENTNAME = "MI/Services/Os";
    private static Trace trace = Trace.getInstance("MI/Services/Os");
    private String name;
    private String cmd;
    private long interval;

    public ScriptThread(String cmd, long interval) {
        super(cmd);
        this.cmd = cmd;
        this.name = cmd;
        this.interval = interval;
    }

    public void run() {
        while (true) {
            try {
                if (trace.isLogging(90)) {
                    trace.log(90, "Trying to execute timed script " + this.cmd);
                }
                Process p = Runtime.getRuntime().exec(this.cmd);
                p.waitFor();
                if (trace.isLogging(90)) {
                    trace.log(90, "Script Executed");
                }
                Thread.sleep(this.interval);
                continue;
            }
            catch (IOException e) {
                trace.logException(50, "Exception while executing Script", e, true);
                e.printStackTrace();
                continue;
            }
            catch (InterruptedException e) {
                trace.logException(50, "Exception while executing Script", e, true);
                e.printStackTrace();
                continue;
            }
            break;
        }
    }
}

