/*
 * Decompiled with CFR 0.152.
 */
package com.sap.ip.me.services.os;

import com.sap.ip.me.api.logging.Trace;
import com.sap.ip.me.api.sync.SyncEvent;
import com.sap.ip.me.api.sync.SyncEventListener;
import com.sap.ip.me.api.sync.SyncEventRegistry;
import com.sap.ip.me.services.os.AbstractAgent;
import com.sap.ip.me.services.os.AgentException;
import com.sap.ip.me.services.os.AgentPropertyValue;
import com.sap.ip.me.services.os.ScriptThread;
import java.io.IOException;
import java.io.Serializable;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Properties;
import java.util.Vector;

public class ScriptManager
extends AbstractAgent
implements SyncEventListener,
Serializable {
    private static final String DELIMETER = ";";
    private static final String SCRIPT_MANAGER = "SCRIPT";
    private static final String COMPONENTNAME = "MI/Services/Os";
    private static Trace trace = Trace.getInstance("MI/Services/Os");
    private Vector myConfiguration = new Vector();

    public ScriptManager() {
        Properties props = this.getConfiguration().getAgentParameters(this);
        if (trace.isLogging(70)) {
            trace.log("Found the following Script(s): " + props);
        }
        Enumeration keys = ((Hashtable)props).keys();
        int scriptCount = 0;
        int i = 0;
        while (i < ((Hashtable)props).size()) {
            String keyName = (String)keys.nextElement();
            String unparsedValue = props.getProperty(keyName);
            int indexOfDelimeter = unparsedValue.indexOf(DELIMETER);
            if (indexOfDelimeter > 0) {
                String typeOfScript = unparsedValue.substring(indexOfDelimeter + 1);
                String cmd = unparsedValue.substring(0, indexOfDelimeter);
                if (this.isValidScriptType(typeOfScript)) {
                    this.myConfiguration.addElement(new AgentPropertyValue(typeOfScript, cmd));
                    ++scriptCount;
                    if (typeOfScript.toLowerCase().equals("once")) {
                        try {
                            this.getConfiguration().setAgentParameter(this, keyName, cmd + ";ex" + typeOfScript);
                            this.getConfiguration().persistOnChange();
                        }
                        catch (AgentException e) {
                            trace.logException(50, "Exception while trying to change script type from once to exonce", e, true);
                        }
                    }
                } else {
                    trace.log(60, typeOfScript + " is not a valid script type, " + "check scripting configuration!");
                }
            }
            ++i;
        }
        this.startStartupScripts();
        this.startOnceScripts();
        this.startTimedScripts();
        SyncEventRegistry.getInstance().addSyncEventListener(this);
        String traceMessage = "New ScriptManager instance has been created, " + scriptCount + " script(s) loaded.";
        trace.log(80, traceMessage);
        if (scriptCount == 0) {
            trace.log(60, "ScriptManager found 0 scripts. Maybe script configuration is wrong?");
        }
    }

    private boolean isValidScriptType(String typeOfScript) {
        if (typeOfScript.toLowerCase().equals("startup") || typeOfScript.toLowerCase().equals("once") || typeOfScript.toLowerCase().equals("sync")) {
            return true;
        }
        try {
            Integer.parseInt(typeOfScript);
            return true;
        }
        catch (NumberFormatException e) {
            return false;
        }
    }

    public String getName() {
        return SCRIPT_MANAGER;
    }

    public AgentPropertyValue[] getPropertyValues() {
        return AgentPropertyValue.nullArray;
    }

    void doSetProperty(String propertyName, String value) throws Throwable {
        this.getConfiguration().setAgentParameter(this, propertyName, value);
    }

    public void actionPerformed(SyncEvent syncEvent) {
        if (syncEvent.getType() == 0) {
            this.startSyncScripts();
        }
    }

    private void startOnceScripts() {
        int i = 0;
        while (i < this.myConfiguration.size()) {
            block7: {
                AgentPropertyValue current = (AgentPropertyValue)this.myConfiguration.elementAt(i);
                if (current.getKey().toLowerCase().equals("once")) {
                    Object var7_6;
                    try {
                        try {
                            trace.log(90, "Trying to execute onceScript " + current.getValue());
                            Process p = Runtime.getRuntime().exec(current.getValue());
                            p.waitFor();
                            trace.log(90, "Script executed");
                        }
                        catch (IOException e) {
                            trace.logException(50, "Exception while executing Script", e, true);
                            e.printStackTrace();
                            var7_6 = null;
                            current.setKey("exonce");
                            break block7;
                        }
                        catch (InterruptedException e) {
                            trace.logException(50, "Exception while executing Script", e, true);
                            e.printStackTrace();
                            var7_6 = null;
                            current.setKey("exonce");
                        }
                        var7_6 = null;
                        current.setKey("exonce");
                    }
                    catch (Throwable throwable) {
                        var7_6 = null;
                        current.setKey("exonce");
                        throw throwable;
                    }
                }
            }
            ++i;
        }
    }

    private void startStartupScripts() {
        int i = 0;
        while (i < this.myConfiguration.size()) {
            AgentPropertyValue current = (AgentPropertyValue)this.myConfiguration.elementAt(i);
            if (current.getKey().toLowerCase().equals("startup")) {
                try {
                    trace.log(90, "Trying to execute startupScript " + current.getValue());
                    Process p = Runtime.getRuntime().exec(current.getValue());
                    p.waitFor();
                    trace.log(90, "Script executed");
                }
                catch (IOException e) {
                    trace.logException(50, "Exception while executing Script", e, true);
                    e.printStackTrace();
                }
                catch (InterruptedException e) {
                    trace.logException(50, "Exception while executing Script", e, true);
                    e.printStackTrace();
                }
            }
            ++i;
        }
    }

    private void startSyncScripts() {
        int i = 0;
        while (i < this.myConfiguration.size()) {
            AgentPropertyValue current = (AgentPropertyValue)this.myConfiguration.elementAt(i);
            if (current.getKey().toLowerCase().equals("sync")) {
                try {
                    trace.log(90, "Trying to execute syncScript " + current.getValue());
                    Process p = Runtime.getRuntime().exec(current.getValue());
                    p.waitFor();
                    trace.log(90, "Script executed");
                }
                catch (IOException e) {
                    trace.logException(50, "Exception while executing Script", e, true);
                    e.printStackTrace();
                }
                catch (InterruptedException e) {
                    trace.logException(50, "Exception while executing Script", e, true);
                    e.printStackTrace();
                }
            }
            ++i;
        }
    }

    private void startTimedScripts() {
        int i = 0;
        while (i < this.myConfiguration.size()) {
            AgentPropertyValue current = (AgentPropertyValue)this.myConfiguration.elementAt(i);
            try {
                int interval = Integer.parseInt(current.getKey());
                String cmd = current.getValue();
                ScriptThread scriptThread = new ScriptThread(cmd, interval);
                trace.log(90, "Starting Thread for Interval Execution of " + cmd);
                scriptThread.start();
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
            ++i;
        }
    }

    public Properties getDefaultParameters() {
        return new Properties();
    }
}

