/*
 * Decompiled with CFR 0.152.
 */
package com.sap.ip.me.services.os;

import com.sap.ip.me.api.logging.Trace;
import com.sap.ip.me.ccms.Alert;
import com.sap.ip.me.ccms.AlertManager;
import com.sap.ip.me.services.os.AbstractAgent;
import com.sap.ip.me.services.os.AgentPropertyValue;

public class BatteryAgent
extends AbstractAgent
implements Alert {
    private AgentPropertyValue[] batteryValues = null;
    private static final String AGENT_BATTERY = "BATTERY";
    private static final String BATTERY_VALUE = "BATTERYVALUE";
    private int agentValue = -1;

    public BatteryAgent() {
        AlertManager.getInstance().register(this, AGENT_BATTERY);
    }

    public void compare(int value) {
        if (value > this.getAlertValue()) {
            this.setAlertValue(value);
        }
    }

    public String getAlertName() {
        return AGENT_BATTERY;
    }

    public int getAlertValue() {
        return this.agentValue;
    }

    public void setAlertName(String alertName) {
    }

    public void setAlertValue(int value) {
        this.agentValue = 100 - value;
    }

    public AgentPropertyValue[] getPropertyValues() {
        try {
            int batteryState = this.getBatteryState();
            AgentPropertyValue value = new AgentPropertyValue(BATTERY_VALUE, Integer.toString(batteryState));
            AgentPropertyValue[] result = new AgentPropertyValue[]{value};
            return result;
        }
        catch (UnsatisfiedLinkError e) {
            Trace.getInstance("MI/Services/Os").log(60, "BatteryAgent cannot access battery state on device. error while accessing native library");
            return AgentPropertyValue.nullArray;
        }
    }

    public native int getBatteryState();

    public String getName() {
        return AGENT_BATTERY;
    }

    void doSetProperty(String propertyName, String value) throws Throwable {
    }

    static {
        try {
            System.loadLibrary("BatteryState");
        }
        catch (UnsatisfiedLinkError unsatisfiedLinkError) {
            // empty catch block
        }
    }
}

