/*
 * Decompiled with CFR 0.152.
 */
package com.sap.ip.me.services.os;

import com.sap.ip.me.api.services.DateFormatter;
import com.sap.ip.me.services.os.AbstractAgent;
import com.sap.ip.me.services.os.AbstractSchedule;
import com.sap.ip.me.services.os.AgentManager;
import com.sap.ip.me.services.os.AgentPropertyValue;
import com.sap.ip.me.services.os.SyncCount;
import java.util.Calendar;
import java.util.Date;

public class AgentScheduleTimed
extends AbstractSchedule {
    public AgentPropertyValue[] getPropertyValues(AbstractAgent agent) {
        long syncInterval = agent.getSyncTimeInterval();
        if (syncInterval <= 0L) {
            return AgentPropertyValue.nullArray;
        }
        SyncCount syncCount = AgentManager.getInstance().getSyncCount();
        long lastSync = syncCount.getLastReportDateAndTime(agent).getTime();
        Date _now = Calendar.getInstance().getTime();
        long now = _now.getTime();
        String frequence = agent.getSyncTimeIntervalType();
        if (this.agentMustReport(frequence, lastSync, now, syncInterval)) {
            syncCount.increment(agent.getName(), DateFormatter.getDateABAP(_now), DateFormatter.getTimeABAP(_now));
            return agent.getPropertyValues();
        }
        return AgentPropertyValue.nullArray;
    }

    private boolean agentMustReport(String frequence, long lastSync, long now, long syncInterval) {
        return frequence.equals("D") && (now - lastSync) / 86400000L >= syncInterval || frequence.equals("H") && (now - lastSync) / 3600000L >= syncInterval || frequence.equals("M") && (now - lastSync) / 60000L >= syncInterval;
    }
}

