/*
 * Decompiled with CFR 0.152.
 */
package com.sap.ip.me.services.os;

import com.sap.ip.me.api.conf.Configuration;
import com.sap.ip.me.api.conf.VisibilityType;
import com.sap.ip.me.api.logging.AppLog;
import com.sap.ip.me.api.logging.Trace;
import com.sap.ip.me.api.sync.InboundContainer;
import com.sap.ip.me.api.sync.InboundContainerElement;
import com.sap.ip.me.api.sync.InboundProcessor;
import com.sap.ip.me.api.sync.InboundProcessorRegistry;
import com.sap.ip.me.api.sync.OutboundContainer;
import com.sap.ip.me.api.sync.OutboundContainerFactory;
import com.sap.ip.me.api.sync.SyncEvent;
import com.sap.ip.me.api.sync.SyncEventListener;
import com.sap.ip.me.api.sync.SyncEventRegistry;
import com.sap.ip.me.api.sync.SyncException;
import com.sap.ip.me.api.sync.SyncManager;
import com.sap.ip.me.core.ConversationIdHandler;
import com.sap.ip.me.core.UserManagerImpl;
import com.sap.ip.me.services.os.AbstractAgent;
import com.sap.ip.me.services.os.AgentConfiguration;
import com.sap.ip.me.services.os.AgentException;
import com.sap.ip.me.services.os.AgentFilter;
import com.sap.ip.me.services.os.AgentPropertyValue;
import com.sap.ip.me.services.os.FilterFirstCycle;
import com.sap.ip.me.services.os.FilterSecondCycle;
import com.sap.ip.me.services.os.HistoryThread;
import com.sap.ip.me.services.os.ScheduledAgent;
import com.sap.ip.me.services.os.SyncCount;
import com.sap.ip.me.sync.SyncEventRegistryImpl;
import com.sap.ip.me.sync.SyncManagerImplNewProtocol;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Properties;

public class AgentManager
implements InboundProcessor,
SyncEventListener {
    private static AgentManager instance = null;
    protected static AgentConfiguration agentConfiguration;
    private static final String AGENT_HOME;
    private Hashtable agentRegistry;
    private transient SyncCount syncCount;
    protected transient Hashtable runningHistoryThreads;
    protected transient boolean exceptionOccured = false;

    protected static AgentConfiguration getConfiguration() {
        return agentConfiguration;
    }

    private AgentManager() {
        this.init();
    }

    private void init() {
        this.syncCount = new SyncCount();
        this.runningHistoryThreads = new Hashtable();
        agentConfiguration = new AgentConfiguration();
        Properties agentRegistryTmp = this.initializeAgentRegistry();
        String agentName = "";
        this.agentRegistry = new Hashtable();
        ((SyncEventRegistryImpl)SyncEventRegistry.getInstance()).addSyncEventListener(this);
        InboundProcessorRegistry.getInstance().register(this);
        Enumeration agentNames = ((Hashtable)agentRegistryTmp).keys();
        try {
            while (agentNames.hasMoreElements()) {
                agentName = (String)agentNames.nextElement();
                AbstractAgent agent = this.createAgent((String)((Hashtable)agentRegistryTmp).get(agentName));
                this.agentRegistry.put(agentName, agent);
            }
        }
        catch (AgentException agentException) {
            AppLog.getInstance("MI/Services/Os").log(agentName + " is not a valid class name");
        }
        if (SyncManager.getInstance() instanceof SyncManagerImplNewProtocol) {
            SyncManagerImplNewProtocol syncManager = (SyncManagerImplNewProtocol)SyncManager.getInstance();
            syncManager.setDoSecondSharedUserSync(true);
        }
    }

    public static AgentManager getInstance() {
        if (instance == null) {
            instance = new AgentManager();
        }
        return instance;
    }

    private Properties initializeAgentRegistry() {
        Properties props = new Properties();
        try {
            props.load(new FileInputStream(AGENT_HOME));
        }
        catch (FileNotFoundException exception) {
            AppLog.getInstance("MI/Services/Os").logException(50, exception);
        }
        catch (IOException exception) {
            AppLog.getInstance("MI/Services/Os").logException(50, exception);
        }
        return props;
    }

    public AbstractAgent getAgent(String agentName) {
        return (AbstractAgent)this.agentRegistry.get(agentName);
    }

    public void process(InboundContainer inboundContainer) {
        this.exceptionOccured = false;
        Enumeration agentsEnum = this.getAllAgents();
        try {
            while (agentsEnum.hasMoreElements()) {
                AbstractAgent agent = (AbstractAgent)agentsEnum.nextElement();
                InboundContainerElement[] elements = inboundContainer.getElementsWithFieldName(agent.getName());
                int i = 0;
                while (i < elements.length) {
                    String fieldValue = elements[i].getFieldValue();
                    String propertyName = fieldValue.substring(0, fieldValue.indexOf(";"));
                    String propertyValue = fieldValue.substring(fieldValue.indexOf(";") + 1, fieldValue.length());
                    this.setProperty(agent, propertyName, propertyValue);
                    ++i;
                }
            }
            if (!this.exceptionOccured) {
                agentConfiguration.setVersionStamp(inboundContainer.getElementsWithFieldName("TIMESTAMP")[0].getFieldValue());
            }
            agentConfiguration.persistOnChange();
            this.updateHistorySettings();
        }
        catch (AgentException e) {
            e.printStackTrace();
        }
    }

    private void updateHistorySettings() throws AgentException {
        Enumeration agents = this.getAllAgents();
        while (agents.hasMoreElements()) {
            AbstractAgent agent = (AbstractAgent)agents.nextElement();
            HistoryThread history = (HistoryThread)this.runningHistoryThreads().get(agent);
            if (history != null) {
                history.update();
                continue;
            }
            if (!agent.isHistoryEnabled()) continue;
            agent.updateHistory();
            this.createHistory(agent);
        }
    }

    private void createHistory(AbstractAgent anAgent) {
        if (anAgent.isHistoryEnabled() && anAgent.getHistoryInterval() > -1L) {
            Trace.getInstance("MI/Services/Os").log(90, "History is enabled for agent " + anAgent.getName());
            HistoryThread historyThread = new HistoryThread(anAgent);
            this.runningHistoryThreads().put(anAgent, historyThread);
            historyThread.start();
        } else {
            Trace.getInstance("MI/Services/Os").log(90, "History disabled for agent " + anAgent.getName());
        }
    }

    public String getMethodName() {
        return "AGENT_PARAMETERS";
    }

    public Enumeration getAllAgents() {
        return this.agentRegistry.elements();
    }

    public void actionPerformed(SyncEvent syncEvent) {
        if (syncEvent.getType() == 10) {
            this.report(new FilterSecondCycle());
        } else if (syncEvent.getType() == 2) {
            this.getSyncCount().increment();
        } else if (syncEvent.getType() == 0) {
            this.report(new FilterFirstCycle());
        }
    }

    private AbstractAgent createAgent(String agentName) throws AgentException {
        try {
            AbstractAgent agent = (AbstractAgent)Class.forName(agentName).newInstance();
            this.createHistory(agent);
            return agent;
        }
        catch (Exception excep) {
            AppLog.getInstance("MI/API/Services").logException(50, excep);
            throw new AgentException("agent configuration is wrong", excep);
        }
    }

    private void setProperty(AbstractAgent agent, String propertyName, String propertyValue) {
        if (propertyName.startsWith("SET.")) {
            try {
                agent.setProperty(propertyName.substring(4), propertyValue.trim());
            }
            catch (AgentException e) {
                this.exceptionOccured = true;
                Trace.getInstance("MI/Services/Os").logException(50, "set property " + propertyName.substring(4) + " in agent " + agent.getName() + " failed. Agent configuration timestamp will not be updated.", e, true);
            }
        } else if (propertyName.startsWith("GET.")) {
            agentConfiguration.addGetProperty(agent, propertyName.substring(4));
        }
    }

    private void report(AgentFilter filter) {
        String deviceId = ConversationIdHandler.getDeviceId();
        String user = UserManagerImpl.getUserManagerImplInstance().getCurrentLogonUser().getUniqueID();
        try {
            OutboundContainer cont = OutboundContainerFactory.getInstance().createOutboundContainer(VisibilityType.SEPARATED, "AGENT_PARAMETERS", "R");
            cont.addItem("TIMESTAMP", agentConfiguration.getVersionStamp());
            cont.addItem("DEVICEID", deviceId);
            cont.addItem("USER", user);
            Enumeration agents = this.agentRegistry.keys();
            while (agents.hasMoreElements()) {
                String nextAgentName = (String)agents.nextElement();
                AbstractAgent nextAgent = (AbstractAgent)this.agentRegistry.get(nextAgentName);
                if (!filter.agentReports(nextAgent)) continue;
                AgentPropertyValue[] agentPropertyValues = nextAgent.getHistoryValues();
                int i = 0;
                while (i < agentPropertyValues.length) {
                    cont.addItem(nextAgent.getName(), agentPropertyValues[i].toString());
                    ++i;
                }
                nextAgent = new ScheduledAgent(nextAgent);
                agentPropertyValues = nextAgent.getPropertyValues();
                int i2 = 0;
                while (i2 < agentPropertyValues.length) {
                    cont.addItem(nextAgent.getName(), agentPropertyValues[i2].toString());
                    ++i2;
                }
                nextAgent.clearHistory();
            }
            cont.close();
        }
        catch (SyncException s) {
            System.out.println("Log.ERROR" + s);
            AppLog.getInstance("MI/CCMS").logException(50, s);
        }
        catch (NumberFormatException nFex) {
            System.out.println("Log.ERROR" + nFex);
            AppLog.getInstance("MI/CCMS").logException(60, nFex);
        }
        catch (Exception ex) {
            System.out.println("Exception:.." + ex);
            AppLog.getInstance("MI/CCMS").logException(50, (Throwable)ex, true);
        }
        try {
            agentConfiguration.persistOnChange();
        }
        catch (AgentException e) {
            e.printStackTrace();
        }
    }

    public SyncCount getSyncCount() {
        if (null == this.syncCount) {
            this.syncCount = new SyncCount();
        }
        return this.syncCount;
    }

    public AgentConfiguration getAgentConfiguration() {
        return agentConfiguration;
    }

    private Hashtable runningHistoryThreads() {
        if (null == this.runningHistoryThreads) {
            this.runningHistoryThreads = new Hashtable();
        }
        return this.runningHistoryThreads;
    }

    static {
        AGENT_HOME = Configuration.getSettingsFolder() + ".agents";
        agentConfiguration = new AgentConfiguration();
    }
}

