/*
 * Decompiled with CFR 0.152.
 */
package com.sap.ip.me.services.os;

import com.sap.ip.me.api.conf.Configuration;
import com.sap.ip.me.services.os.AbstractAgent;
import com.sap.ip.me.services.os.AgentException;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Properties;
import java.util.Vector;

public class AgentConfiguration {
    private Hashtable configs = new Hashtable();
    private boolean changed;
    private String versionStamp;

    protected AgentConfiguration() {
        this.init();
    }

    private void init() {
        try {
            File configFile = this.agentsConfigFile();
            if (configFile.exists()) {
                this.loadAgentsConfigurationFromFile(configFile);
            }
        }
        catch (AgentException e) {
            e.printStackTrace();
        }
    }

    private void loadAgentsConfigurationFromFile(File configFile) throws AgentException {
        Properties props = new Properties();
        try {
            props.load(new FileInputStream(configFile));
            Enumeration propsEnum = ((Hashtable)props).keys();
            this.versionStamp = (String)((Hashtable)props).get("TIMESTAMP");
            while (propsEnum.hasMoreElements()) {
                String entryKey = (String)propsEnum.nextElement();
                int pos = entryKey.indexOf(35);
                if (pos <= -1) continue;
                String agentName = entryKey.substring(0, pos);
                String agentParameterName = entryKey.substring(pos + 1, entryKey.length());
                if (agentParameterName.equals("GET_PROPERTIES")) {
                    this.setAgentParameter(agentName, agentParameterName, this._getParameters((String)((Hashtable)props).get(entryKey)));
                    continue;
                }
                String agentParameterValue = (String)((Hashtable)props).get(entryKey);
                this.setAgentParameter(agentName, agentParameterName, (Object)agentParameterValue);
            }
        }
        catch (FileNotFoundException e) {
            throw new AgentException("agent config file does not exist", e);
        }
        catch (IOException e) {
            throw new AgentException("error while accessing agents config file", e);
        }
    }

    private Vector _getParameters(String aString) {
        Vector<String> listOfGetParameters = new Vector<String>();
        String postfix = aString;
        int index = postfix.indexOf(";");
        while (index >= 0) {
            listOfGetParameters.addElement(postfix.substring(0, index));
            postfix = postfix.substring(index + 1, postfix.length());
            index = postfix.indexOf(";");
        }
        if (postfix.length() > 0) {
            listOfGetParameters.addElement(postfix);
        }
        return listOfGetParameters;
    }

    private File agentsConfigFile() {
        return new File(Configuration.getSettingsFolder() + "agents.properties");
    }

    public void setAgentParameter(String agentName, String name, Object value) {
        this.changed = true;
        Properties props = (Properties)this.configs.get(agentName);
        if (props == null) {
            props = new Properties();
            this.configs.put(agentName, props);
        }
        ((Hashtable)props).put(name, value);
    }

    public void setAgentParameter(AbstractAgent agent, String name, String value) throws AgentException {
        this.setAgentParameter(agent.getName(), name, (Object)value);
    }

    public String getAgentParameterValue(AbstractAgent anAgent, String parameterName) {
        return this.getAgentParameters(anAgent).getProperty(parameterName);
    }

    public boolean getAgentParameterValue(AbstractAgent anAgent, String parameterName, boolean defaultValue) {
        String valueAsString = this.getAgentParameterValue(anAgent, parameterName);
        if (null == valueAsString) {
            return defaultValue;
        }
        return "TRUE".equals(valueAsString.toUpperCase());
    }

    public String getAgentParameterValue(AbstractAgent anAgent, String parameterName, String defaultValue) {
        String result = this.getAgentParameterValue(anAgent, parameterName);
        if (null == result) {
            return defaultValue;
        }
        return result;
    }

    public long getAgentParameterValue(AbstractAgent anAgent, String parameterName, long defaultValue) {
        long result = defaultValue;
        try {
            String valueAsString = this.getAgentParameterValue(anAgent, parameterName);
            if (null != valueAsString) {
                result = Long.parseLong(valueAsString);
            }
        }
        catch (NumberFormatException ex) {
            // empty catch block
        }
        return result;
    }

    public Vector getAgentGetProperties(AbstractAgent anAgent) {
        return (Vector)((Hashtable)this.getAgentParameters(anAgent)).get("GET_PROPERTIES");
    }

    public Properties getAgentParameters(AbstractAgent anAbstractAgent) {
        Properties properties = (Properties)this.configs.get(anAbstractAgent.getName());
        if (properties == null) {
            properties = anAbstractAgent.getDefaultParameters();
            this.configs.put(anAbstractAgent.getName(), properties);
            this.changed = true;
        }
        return properties;
    }

    /*
     * Loose catch block
     */
    protected void persistOnChange() throws AgentException {
        block15: {
            PrintWriter printWriter;
            FileOutputStream output;
            block14: {
                output = null;
                printWriter = null;
                if (!this.changed) break block14;
                File agentsConfigFile = this.agentsConfigFile();
                if (agentsConfigFile.exists()) {
                    agentsConfigFile.delete();
                }
                output = new FileOutputStream(agentsConfigFile);
                printWriter = new PrintWriter(output);
                printWriter.println("TIMESTAMP=" + this.getVersionStamp());
                Enumeration agentsEnum = this.configs.keys();
                while (agentsEnum.hasMoreElements()) {
                    String agentName = (String)agentsEnum.nextElement();
                    Properties agentProperties = (Properties)this.configs.get(agentName);
                    Enumeration propsEnum = ((Hashtable)agentProperties).keys();
                    while (propsEnum.hasMoreElements()) {
                        String propName = (String)propsEnum.nextElement();
                        String propValue = propName.equals("GET_PROPERTIES") ? this._getParametersToString((Vector)((Hashtable)agentProperties).get(propName)) : agentProperties.getProperty(propName);
                        printWriter.println(agentName + "#" + propName + "=" + propValue);
                    }
                }
            }
            Object var11_11 = null;
            this.changed = false;
            try {
                if (printWriter != null) {
                    printWriter.flush();
                    printWriter.close();
                }
                if (output != null) {
                    output.close();
                }
                break block15;
            }
            catch (IOException e1) {
                e1.printStackTrace();
            }
            break block15;
            {
                catch (IOException e) {
                    throw new AgentException("could not persist agents configuration");
                }
            }
            catch (Throwable throwable) {
                Object var11_12 = null;
                this.changed = false;
                try {
                    if (printWriter != null) {
                        printWriter.flush();
                        printWriter.close();
                    }
                    if (output != null) {
                        output.close();
                    }
                }
                catch (IOException e1) {
                    e1.printStackTrace();
                }
                throw throwable;
            }
        }
    }

    private String _getParametersToString(Vector listOfGetParameters) {
        StringBuffer buffer = new StringBuffer();
        int l = listOfGetParameters.size();
        int i = 0;
        while (i < l) {
            buffer.append(listOfGetParameters.elementAt(i).toString());
            if (i < l - 1) {
                buffer.append(";");
            }
            ++i;
        }
        return buffer.toString();
    }

    public String getVersionStamp() {
        if (this.versionStamp == null) {
            this.versionStamp = "000000;19700101";
        }
        return this.versionStamp;
    }

    protected void setVersionStamp(String aVersionStampString) {
        this.versionStamp = aVersionStampString;
        this.changed = true;
    }

    public void addGetProperty(AbstractAgent agent, String propertyName) {
        Vector vector = this.getAgentGetProperties(agent);
        if (vector.contains(propertyName)) {
            return;
        }
        vector.addElement(propertyName);
        this.changed = true;
    }
}

