/*
 * Decompiled with CFR 0.152.
 */
package com.sap.ip.me.services.os;

import com.sap.ip.me.api.logging.Trace;
import com.sap.ip.me.services.os.AgentConfiguration;
import com.sap.ip.me.services.os.AgentException;
import com.sap.ip.me.services.os.AgentHistory;
import com.sap.ip.me.services.os.AgentManager;
import com.sap.ip.me.services.os.AgentPropertyValue;
import java.io.Serializable;
import java.util.Hashtable;
import java.util.Properties;
import java.util.Vector;

public abstract class AbstractAgent
implements Serializable {
    protected static final String AGENT_HISTORY = "AGENT_HISTORY";
    protected static final String AGENT_HISTORY_INTERVAL = "AGENT_HISTORY_INTERVAL";
    protected static final String AGENT_MODE = "AGENT_MODE";
    protected static final String AGENT_TRIGGER_ON_SYNC_COUNT = "AGENT_TRIGGER_ON_SYNC_COUNT";
    protected static final String AGENT_TRIGGER_ON_SYNC_INTERVAL = "AGENT_TRIGGER_ON_SYNC_INTERVAL";
    protected static final String AGENT_TRIGGER_ON_SYNC_INTERVALTYPE = "AGENT_TRIGGER_ON_SYNC_INTERVALTYPE";
    protected static final String AGENT_REPORT_ON_FIRST_CYCLE = "AGENT_REPORT_ON_FIRST_CYCLE";
    protected static final String AGENT_REPORT_ON_SECOND_CYCLE = "AGENT_REPORT_ON_SECOND_CYCLE";
    private transient AgentHistory history = AgentHistory.nullObject;

    protected AbstractAgent() {
        this.updateHistory();
    }

    public static boolean isAgentParameter(String parameterName) {
        return AGENT_HISTORY.equals(parameterName) || AGENT_HISTORY_INTERVAL.equals(parameterName) || AGENT_MODE.equals(parameterName) || AGENT_TRIGGER_ON_SYNC_COUNT.equals(parameterName) || AGENT_TRIGGER_ON_SYNC_INTERVAL.equals(parameterName) || AGENT_TRIGGER_ON_SYNC_INTERVALTYPE.equals(parameterName) || AGENT_REPORT_ON_FIRST_CYCLE.equals(parameterName) || AGENT_REPORT_ON_SECOND_CYCLE.equals(parameterName);
    }

    protected AgentConfiguration getConfiguration() {
        return AgentManager.getConfiguration();
    }

    public abstract String getName();

    public abstract AgentPropertyValue[] getPropertyValues();

    public void setProperty(String propertyName, String value) throws AgentException {
        try {
            if (AbstractAgent.isAgentParameter(propertyName)) {
                this.getConfiguration().setAgentParameter(this, propertyName, value);
            } else if (this.isActive()) {
                this.doSetProperty(propertyName, value);
            }
        }
        catch (Throwable e) {
            throw new AgentException("Error while setting property " + propertyName + " in agent " + this.getName(), e);
        }
    }

    abstract void doSetProperty(String var1, String var2) throws Throwable;

    public AgentPropertyValue[] readPropertyValues() {
        return this.getPropertyValues();
    }

    public String getAgentProperty(String propertyName) {
        return this.getConfiguration().getAgentParameterValue(this, propertyName);
    }

    public long getAgentProperty(String propertyName, long defaultValue) {
        return this.getConfiguration().getAgentParameterValue(this, propertyName, defaultValue);
    }

    public boolean getAgentProperty(String propertyName, boolean defaultValue) {
        return this.getConfiguration().getAgentParameterValue(this, propertyName, defaultValue);
    }

    public String getAgentProperty(String propertyName, String defaultValue) {
        return this.getConfiguration().getAgentParameterValue(this, propertyName, defaultValue);
    }

    public Properties getDefaultParameters() {
        Properties properties = new Properties();
        ((Hashtable)properties).put("GET_PROPERTIES", this.getDefaultGetParameters());
        ((Hashtable)properties).put(AGENT_MODE, "ON");
        ((Hashtable)properties).put(AGENT_HISTORY, "FALSE");
        ((Hashtable)properties).put(AGENT_HISTORY_INTERVAL, "20");
        ((Hashtable)properties).put(AGENT_TRIGGER_ON_SYNC_COUNT, "0");
        ((Hashtable)properties).put(AGENT_REPORT_ON_FIRST_CYCLE, "FALSE");
        ((Hashtable)properties).put(AGENT_REPORT_ON_SECOND_CYCLE, "FALSE");
        ((Hashtable)properties).put(AGENT_TRIGGER_ON_SYNC_INTERVAL, "0");
        ((Hashtable)properties).put(AGENT_TRIGGER_ON_SYNC_INTERVALTYPE, "D");
        return properties;
    }

    public Vector getDefaultGetParameters() {
        return new Vector();
    }

    public boolean isHistoryEnabled() {
        return this.getAgentProperty(AGENT_HISTORY, false);
    }

    public long getHistoryInterval() {
        long result = -1L;
        if (!this.isHistoryEnabled()) {
            return result;
        }
        String historyInterval = this.getAgentProperty(AGENT_HISTORY_INTERVAL);
        if (null == historyInterval) {
            return result;
        }
        try {
            result = Long.parseLong(historyInterval) * 60000L;
        }
        catch (NumberFormatException e) {
            // empty catch block
        }
        return result;
    }

    public synchronized void createHistorySnapshot() throws AgentException {
        Trace.getInstance("MI/Services/Os").log(90, this.getName() + " creates snapshot for history.");
        AgentPropertyValue[] values = this.getPropertyValues();
        if (values.length > 0) {
            this.getHistory().addValue(this.getPropertyValues());
        }
    }

    public AgentPropertyValue[] getHistoryValues() throws AgentException {
        return this.getHistory().getValues();
    }

    public long getSyncInterval() {
        return this.getAgentProperty(AGENT_TRIGGER_ON_SYNC_COUNT, -1L);
    }

    public AgentHistory getHistory() {
        return this.history;
    }

    public void clearHistory() throws AgentException {
        this.getHistory().reset();
    }

    public boolean reportOnFirstCycle() {
        return this.getAgentProperty(AGENT_REPORT_ON_FIRST_CYCLE, false);
    }

    public boolean reportOnSecondCycle() {
        return this.getAgentProperty(AGENT_REPORT_ON_SECOND_CYCLE, false);
    }

    public boolean isActive() {
        String agentMode = this.getAgentProperty(AGENT_MODE);
        return null == agentMode || !"OFF".equals(agentMode.toUpperCase());
    }

    public long getSyncTimeInterval() {
        return this.getAgentProperty(AGENT_TRIGGER_ON_SYNC_INTERVAL, 0L);
    }

    public String getSyncTimeIntervalType() {
        return this.getAgentProperty(AGENT_TRIGGER_ON_SYNC_INTERVALTYPE, "D");
    }

    protected static void errorNativeLibrary(Class aClass) {
        Trace.getInstance("MI/Services/Os").log(50, aClass + " agent is active but no native library available. Remove agent from ./settings/.agents or check for native library");
    }

    public void log(String message) {
        Trace.getInstance("MI/Services/Os").log(90, message);
    }

    public void updateHistory() {
        if (this.isHistoryEnabled()) {
            this.history = new AgentHistory(this);
        }
    }
}

