/*
 * Decompiled with CFR 0.152.
 */
package com.sap.ip.me.services.localadm;

import com.sap.ip.me.api.security.Permission;
import com.sap.ip.me.api.user.User;
import com.sap.ip.me.api.user.UserManager;
import com.sap.ip.me.core.ApplicationManager;
import com.sap.ip.me.core.ConversationId;
import com.sap.ip.me.core.ConversationIdHandler;
import com.sap.ip.me.core.MobileSolutionDescriptor;
import com.sap.ip.me.core.UserImpl;
import com.sap.ip.me.core.UserManagerImpl;
import com.sap.ip.me.security.permission.Action;
import com.sap.ip.me.security.permission.AuthSyncBo;
import com.sap.ip.me.security.permission.Field;
import com.sap.ip.me.security.permission.SinglePermission;
import com.sap.ip.me.services.localadm.LocalAdmin;
import com.sap.ip.me.services.localadm.MCDDecorator;
import java.util.Enumeration;
import java.util.Vector;

public class LocalAdminImpl
implements LocalAdmin {
    static String LCLADM_PERM = "S_MILCLADM";
    static String LCLADM_ADMFUNC = "ADM_FUNC";
    static String LCLADM_ACTVT = "ACTVT";
    static String LCLADM_ADM_PWD = "ADM_PWD";
    static String LCLADM_ADM_USER = "ADM_USER";
    static String LCLADM_ADM_PERM = "ADM_PERM";
    static String LCLADM_ADM_MCD = "ADM_MCD";
    static String LCLADM_CREATE = "01";
    static String LCLADM_MODIFY = "02";
    static String LCLADM_DISPLAY = "03";
    static String LCLADM_DELETE = "06";
    static String LCLADM_UNLOCK = "95";
    static String LCLADM_CONVID_PREFIX = "LOCALADMIN_";
    SinglePermission perm;

    public Vector getUsersPermissions(User us) throws Exception {
        Permission perm = new Permission(LCLADM_PERM, LCLADM_ADMFUNC, LCLADM_ADM_PERM);
        perm.add(LCLADM_PERM, LCLADM_ACTVT, LCLADM_DISPLAY);
        UserManager um = UserManager.getInstance();
        User currentUser = um.getCurrentUser();
        currentUser.checkPermission(perm);
        AuthSyncBo authbo = new AuthSyncBo();
        Vector allPerm = authbo.createQuery(us.getUniqueID());
        return allPerm;
    }

    public void assignApplicationToUser(MCDDecorator mcd, User u) throws Exception {
        Permission perm = new Permission(LCLADM_PERM, LCLADM_ADMFUNC, LCLADM_ADM_MCD);
        perm.add(LCLADM_PERM, LCLADM_ACTVT, LCLADM_CREATE);
        UserManager um = UserManager.getInstance();
        User currentUser = um.getCurrentUser();
        currentUser.checkPermission(perm);
        Long l = new Long(System.currentTimeMillis());
        ConversationId ci = new ConversationId(LCLADM_CONVID_PREFIX.concat(l.toString()), mcd.getMCD(), u);
        ConversationIdHandler.getInstance().addConversationId(ci);
    }

    public void deleteUser(User u) throws Exception {
        boolean delUser = true;
        Permission perm = new Permission(LCLADM_PERM, LCLADM_ADMFUNC, LCLADM_ADM_USER);
        perm.add(LCLADM_PERM, LCLADM_ACTVT, LCLADM_DELETE);
        UserManager um = UserManager.getInstance();
        User currentUser = um.getCurrentUser();
        currentUser.checkPermission(perm);
        UserManagerImpl uimpl = (UserManagerImpl)UserManager.getInstance();
        if (!uimpl.checkIfShared(currentUser.getUniqueID())) {
            ApplicationManager appman = ApplicationManager.getInstance();
            MobileSolutionDescriptor framMsd = appman.getFrameworkMobileSolutionDescriptor();
            MobileSolutionDescriptor[] msd = ConversationIdHandler.getInstance().getAllMobileSolutionDescriptorsForUser(u);
            int i = 0;
            while (i < msd.length) {
                MobileSolutionDescriptor descriptor = msd[i];
                if (framMsd != descriptor) {
                    delUser = false;
                }
                ++i;
            }
        }
        delUser = true;
        if (true) {
            UserManagerImpl.getUserManagerImplInstance().deleteUser(u);
        }
    }

    public Vector getAllUser() throws Exception {
        Vector<UserImpl> userList = new Vector<UserImpl>();
        Permission perm = new Permission(LCLADM_PERM, LCLADM_ADMFUNC, LCLADM_ADM_USER);
        perm.add(LCLADM_PERM, LCLADM_ACTVT, LCLADM_DISPLAY);
        UserManager um = UserManager.getInstance();
        User currentUser = um.getCurrentUser();
        currentUser.checkPermission(perm);
        Enumeration allUser = UserManagerImpl.getUserManagerImplInstance().getAllUsers();
        while (allUser.hasMoreElements()) {
            UserImpl userImpl = (UserImpl)allUser.nextElement();
            userList.addElement(userImpl);
        }
        return userList;
    }

    public void resetLocalPwd(User u, String newPwd, String newPWDconf) throws Exception {
        Permission perm = new Permission(LCLADM_PERM, LCLADM_ADMFUNC, LCLADM_ADM_PWD);
        perm.add(LCLADM_PERM, LCLADM_ACTVT, LCLADM_MODIFY);
        UserManager um = UserManager.getInstance();
        User currentUser = um.getCurrentUser();
        currentUser.checkPermission(perm);
        UserManagerImpl userImpl = UserManagerImpl.getUserManagerImplInstance();
        userImpl.resetLocalPassword(u.getUniqueID(), newPwd, newPWDconf);
    }

    private SinglePermission CreatePermission(String Permobj, String PermField, String PermAction) {
        this.perm = new SinglePermission(Permobj);
        Field field = new Field(PermField);
        Action action = new Action(PermAction);
        field.addAction(action);
        this.perm.addField(field);
        return this.perm;
    }

    private SinglePermission addPermission(String Permobj, String PermField, String PermAction) {
        Field field = new Field(PermField);
        Action action = new Action(PermAction);
        field.addAction(action);
        this.perm.addField(field);
        return this.perm;
    }

    public Vector getAllApplications() {
        MobileSolutionDescriptor[] msds = ApplicationManager.getInstance().getMobileSolutionDescriptors();
        Vector<MCDDecorator> result = new Vector<MCDDecorator>(msds.length);
        int i = 0;
        while (i < msds.length) {
            MCDDecorator as = new MCDDecorator();
            as.setMSD(msds[i]);
            result.addElement(as);
            ++i;
        }
        return result;
    }

    public void unlockUser(User u) throws Exception {
        Permission perm = new Permission(LCLADM_PERM, LCLADM_ADMFUNC, LCLADM_ADM_USER);
        perm.add(LCLADM_PERM, LCLADM_ACTVT, LCLADM_UNLOCK);
        UserManager um = UserManager.getInstance();
        User currentUser = um.getCurrentUser();
        currentUser.checkPermission(perm);
        UserManagerImpl.getUserManagerImplInstance().unlockUser(u);
    }

    public boolean isUserLocked(User u) {
        return UserManagerImpl.getUserManagerImplInstance().isUserLocked(u);
    }
}

