/*
 * Decompiled with CFR 0.152.
 */
package com.sap.ip.me.security.permission;

import com.sap.ip.me.api.security.PermissionEntry;
import com.sap.ip.me.security.permission.Action;
import com.sap.ip.me.security.permission.Field;
import com.sap.ip.me.security.permission.SinglePermission;
import java.util.Vector;

public class PermissionList {
    private Vector userPermissions = new Vector();
    private String userName = "";

    public PermissionList(String user) {
        this.userName = user;
    }

    public void add(SinglePermission permission) {
        this.userPermissions.addElement(permission);
    }

    public Vector get() {
        return this.userPermissions;
    }

    public int size() {
        return this.userPermissions.size();
    }

    public static boolean check(PermissionList permissionList, PermissionEntry permissionEntry) {
        if (permissionList != null && permissionList.get() != null) {
            int permissionCount = permissionList.size();
            int i = 0;
            while (i < permissionCount) {
                SinglePermission singlePermission = (SinglePermission)permissionList.get().elementAt(i);
                System.out.println("Test for permission : " + singlePermission.getName());
                if (permissionEntry.name.equals(singlePermission.getName())) {
                    System.out.println("  Matching permission :" + singlePermission.getName());
                    if (PermissionList.checkFields(singlePermission.getFields(), permissionEntry)) {
                        return true;
                    }
                }
                ++i;
            }
        }
        return false;
    }

    private static boolean checkFields(Vector fields, PermissionEntry permissionEntry) {
        int fieldCount = fields.size();
        int i = 0;
        while (i < fieldCount) {
            Field field = (Field)fields.elementAt(i);
            if (field.getName().equals(permissionEntry.field)) {
                System.out.println("    Matching field :" + permissionEntry.field);
                if (PermissionList.checkAction(field.getActions(), permissionEntry)) {
                    return true;
                }
            }
            ++i;
        }
        return false;
    }

    private static boolean checkAction(Vector actions, PermissionEntry permissionEntry) {
        String fromValue = null;
        String toValue = null;
        String testValue = null;
        int actionCount = actions.size();
        int i = 0;
        while (i < actionCount) {
            Action action = (Action)actions.elementAt(i);
            fromValue = action.getFromValue();
            toValue = action.getToValue();
            testValue = permissionEntry.action;
            if (testValue != null) {
                if (fromValue.equals("*") || toValue.equals("*")) {
                    System.out.println("      Matching action value *");
                    return true;
                }
                int indexWildcartFrom = fromValue.indexOf("*");
                int indexWildcartTo = toValue.indexOf("*");
                if (indexWildcartFrom != -1 || indexWildcartTo != -1) {
                    if (testValue.length() < indexWildcartFrom || testValue.length() < indexWildcartTo) {
                        if (testValue.substring(0, testValue.length()).compareTo(fromValue.substring(0, testValue.length())) > 0 && testValue.substring(0, testValue.length()).compareTo(toValue.substring(0, testValue.length())) <= 0) {
                            return true;
                        }
                    } else {
                        if (fromValue.substring(0, indexWildcartFrom) == testValue.substring(0, indexWildcartFrom) || toValue.substring(0, indexWildcartTo) == testValue.substring(0, indexWildcartTo)) {
                            return true;
                        }
                        if (testValue.substring(0, indexWildcartFrom).compareTo(fromValue.substring(0, indexWildcartFrom)) > 0 && testValue.substring(0, indexWildcartTo).compareTo(toValue.substring(0, indexWildcartTo)) <= 0) {
                            return true;
                        }
                    }
                }
                if (testValue.equals(fromValue)) {
                    System.out.println("      Matching action fromValue " + fromValue);
                    return true;
                }
                if (testValue.equals(toValue)) {
                    System.out.println("      Matching action toValue " + toValue);
                    return true;
                }
                if (PermissionList.testRange(fromValue, toValue, testValue)) {
                    System.out.println("      Matching action range :" + fromValue + " <= " + testValue + " <= " + toValue);
                    return true;
                }
                if (testValue.compareTo(fromValue) > 0 && testValue.compareTo(toValue) <= 0) {
                    System.out.println("      Matching action range :" + fromValue + " <= " + testValue + " <= " + toValue);
                    return true;
                }
                System.out.println("      Action fromValue:" + action.getFromValue());
                System.out.println("      Action toValue:" + action.getToValue());
            }
            ++i;
        }
        return false;
    }

    private static boolean testRange(String fromValue, String toValue, String testValue) {
        try {
            int fromInt = new Integer(fromValue);
            int toInt = new Integer(toValue);
            int testInt = new Integer(testValue);
            if (fromInt <= testInt && testInt <= toInt) {
                return true;
            }
        }
        catch (NumberFormatException nfe) {
            return false;
        }
        return false;
    }
}

