/*
 * Decompiled with CFR 0.152.
 */
package com.sap.ip.me.security.permission;

import com.sap.ip.me.api.logging.AppLog;
import com.sap.ip.me.api.logging.Trace;
import com.sap.ip.me.api.persist.core.PersistenceException;
import com.sap.ip.me.api.persist.query.Condition;
import com.sap.ip.me.api.persist.query.Query;
import com.sap.ip.me.api.persist.query.RelationalOperatorType;
import com.sap.ip.me.api.persist.query.SortOrder;
import com.sap.ip.me.api.services.MeIterator;
import com.sap.ip.me.api.smartsync.FieldDescriptor;
import com.sap.ip.me.api.smartsync.FieldDescriptorIterator;
import com.sap.ip.me.api.smartsync.Row;
import com.sap.ip.me.api.smartsync.RowDescriptor;
import com.sap.ip.me.api.smartsync.RowList;
import com.sap.ip.me.api.smartsync.SmartSyncQueryFactory;
import com.sap.ip.me.api.smartsync.SmartSyncRuntime;
import com.sap.ip.me.api.smartsync.SyncBoDataFacade;
import com.sap.ip.me.api.smartsync.SyncBoDeltaRequestFacade;
import com.sap.ip.me.api.smartsync.SyncBoDeltaRequestType;
import com.sap.ip.me.api.smartsync.SyncBoDescriptor;
import com.sap.ip.me.api.smartsync.SyncBoDescriptorFacade;
import com.sap.ip.me.core.ApplicationManager;
import com.sap.ip.me.core.MobileSolutionDescriptor;
import java.util.Vector;

public class AuthSyncBo {
    private final Trace trace = Trace.getInstance("MI/Core");
    private SyncBoDeltaRequestFacade authBoDeltaRequestFacade;
    private SyncBoDescriptorFacade authBoDescriptorFacade;
    private SyncBoDataFacade authBoDataFacade;
    private SyncBoDescriptor authBoDescriptor = null;
    private String MIAUTH = "MIAUTH";
    private RowDescriptor posRowDescriptorAuth;
    private FieldDescriptor authFieldDescriptor;
    private SmartSyncQueryFactory qFactory;
    private SmartSyncRuntime ssRuntime;

    public AuthSyncBo() {
        this.trace.log(90, "Check if AuthSyncBo is already deployed");
        boolean app = this.checkisFrameworkApplication();
        if (!app) {
            this.trace.log(90, "AuthSyncBo is not deployed yet");
        } else {
            this.trace.log(90, "AuthSyncBo is deployed");
            this.trace.log(90, "Create AuthSyncBo instance");
            this.ssRuntime = SmartSyncRuntime.getInstance();
            if (this.ssRuntime == null) {
                AppLog.getInstance("MI/Security").log(60, "Error while creating MIAUTH sync bo (no Smart Sync runtime available); contact SAP support");
                return;
            }
            try {
                this.authBoDataFacade = this.ssRuntime.getSyncBoDataFacade();
                this.authBoDescriptorFacade = this.ssRuntime.getSyncBoDescriptorFacade();
                this.qFactory = this.ssRuntime.getQueryFactory();
                this.authBoDescriptor = this.authBoDescriptorFacade.getSyncBoDescriptor(this.MIAUTH);
                if (this.authBoDescriptor == null) {
                    AppLog.getInstance("MI/Security").log(60, "Error while creating MIAUTH sync bo (no SyncBoDescriptor for MIAUTH available); contact SAP support");
                } else {
                    this.posRowDescriptorAuth = this.authBoDescriptor.getRowDescriptor("010");
                    this.authFieldDescriptor = this.posRowDescriptorAuth.getFieldDescriptor("AUTH");
                    this.authBoDeltaRequestFacade = this.ssRuntime.getSyncBoDeltaRequestFacade();
                    MeIterator inter = this.authBoDeltaRequestFacade.getAllSyncBoDeltaRequests();
                    if (inter.hasNext()) {
                        this.authBoDeltaRequestFacade.getSyncBoDeltaRequest(this.authBoDescriptor).setProcessing(SyncBoDeltaRequestType.DIRECT_REQUEST);
                    }
                }
                this.qFactory = SmartSyncRuntime.getInstance().getQueryFactory();
            }
            catch (Exception ex) {
                AppLog.getInstance("MI/Security").logException(50, "Exception while creating MIAUTH sync bo instance", ex, true);
            }
        }
    }

    public SyncBoDescriptor getAuthBODescriptor() {
        return this.authBoDescriptor != null ? this.authBoDescriptor : (this.authBoDescriptor = this.getSyncBODescriptor(this.MIAUTH));
    }

    public Vector createQuery(String user) {
        Vector authval = this.queryRows(user);
        return authval;
    }

    public Condition createCondition(FieldDescriptor fieldDesc, RelationalOperatorType rot, Object val) {
        return this.qFactory.createCondition(fieldDesc, rot, val);
    }

    public String[] getAuthFieldNames() {
        RowDescriptor rd = this.getAuthDescriptor();
        return AuthSyncBo.iteratorToStringArray(rd.getAllFieldDescriptors(), rd.getFieldCount());
    }

    public boolean checkisFrameworkApplication() {
        MobileSolutionDescriptor msd = ApplicationManager.getInstance().getFrameworkMobileSolutionDescriptor();
        return msd.isItASmartSyncApplication();
    }

    private static String[] iteratorToStringArray(FieldDescriptorIterator fdi, int count) {
        if (fdi == null) {
            return null;
        }
        String[] res = new String[count];
        int cnt = 0;
        while (fdi.hasNext()) {
            FieldDescriptor fd = fdi.next();
            res[cnt] = new String(fd.getFieldName());
            ++cnt;
        }
        return res;
    }

    private Vector queryRows(Object user) {
        Vector<Row> res = new Vector<Row>();
        RowList rows = null;
        SortOrder sorder = null;
        SortOrder sauth = null;
        boolean app = this.checkisFrameworkApplication();
        if (this.authBoDescriptor == null) {
            if (app) {
                AppLog.getInstance("MI/Security").log(60, "Cannot start authority query for user because SyncBoDescriptor for MIAUTH is not available");
            }
            return new Vector(0);
        }
        MeIterator in = this.authBoDeltaRequestFacade.getAllSyncBoDeltaRequests();
        if (in.hasNext()) {
            FieldDescriptor fd = this.posRowDescriptorAuth.getFieldDescriptor("MEUSER");
            Condition qCond = this.createCondition(fd, RelationalOperatorType.EQUALS, user);
            sorder = this.qFactory.createSortOrder(fd, true);
            sauth = this.qFactory.createSortOrder(this.authFieldDescriptor, true);
            Query sQuery = null;
            try {
                sQuery = this.qFactory.createQuery(this.posRowDescriptorAuth, qCond, sorder);
                rows = this.authBoDataFacade.getRows(sQuery);
                rows.sort(sauth);
                int i = 0;
                while (i < rows.size()) {
                    res.addElement(rows.get(i));
                    ++i;
                }
            }
            catch (PersistenceException e1) {
                AppLog.getInstance("MI/Security").logException(50, (Throwable)e1, true);
            }
        }
        return res;
    }

    private RowDescriptor getAuthDescriptor() {
        return this.posRowDescriptorAuth != null ? this.posRowDescriptorAuth : (this.posRowDescriptorAuth = this.getAuthBODescriptor().getTopRowDescriptor());
    }

    private SyncBoDescriptor getSyncBODescriptor(String boName) {
        SyncBoDescriptor sbd = null;
        if (boName.equalsIgnoreCase(this.MIAUTH)) {
            sbd = this.authBoDescriptorFacade.getSyncBoDescriptor(this.MIAUTH);
        }
        return sbd;
    }
}

